/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.connection.HTTPConnection;
import com.jarbull.efw.connection.IErrorListener;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.io.RecordHandler;
import com.jarbull.efw.manager.AdXmlReader;
import com.jarbull.efw.manager.Advertisement;
import com.jarbull.efw.manager.EMidlet;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class GameModeHandler {
    public static final int DEMO = 0;
    public static final int FULL = 1;
    public static final int ADVERTISEMENT = 2;
    private static final Random RANDOM = new Random();
    int mode;
    int selected = 0;
    boolean focused = false;
    String region;
    Vector ads;
    String adXML;
    boolean loadingAds = false;
    String xml_url = "http://ad.jarbull.com/adrequest.jsp";

    public static GameModeHandler getInstance() {
        return GameModeHandlerHolder.INSTANCE;
    }

    private GameModeHandler() {
        RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
        KeyValuePair modePair = RecordHandler.getInstance().getRecord("Mode");
        RecordHandler.getInstance().closeRecordStore();
        this.mode = modePair != null && modePair.getValue().equals("f") ? 1 : (EMidlet.getInstance().getProperties().getMode() == null ? 2 : (EMidlet.getInstance().getProperties().getMode().equals("f") ? 1 : (EMidlet.getInstance().getProperties().getMode().equals("d") ? 0 : 2)));
        StringBuffer tempUrl = new StringBuffer(this.xml_url).append("?");
        if (EMidlet.getInstance().getProperties().getPlatform() == null || EMidlet.getInstance().getProperties().getPlatform().equals("j2me") || EMidlet.getInstance().getProperties().getPlatform().equals("J2ME")) {
            tempUrl.append("platform=j2me");
        } else {
            tempUrl.append("platform=").append(EMidlet.getInstance().getProperties().getPlatform());
        }
        String midp = EMidlet.getInstance().getAppProperty("MicroEdition-Profile");
        midp = midp.substring(midp.length() - 3, midp.length());
        tempUrl.append("&midp=").append(midp);
        String cldc = EMidlet.getInstance().getAppProperty("MicroEdition-Configuration");
        cldc = cldc.substring(cldc.length() - 3, cldc.length());
        tempUrl.append("&cldc=").append(cldc);
        tempUrl.append("&w=").append(ResolutionHandler.getInstance().getCurrentWidth());
        tempUrl.append("&h=").append(ResolutionHandler.getInstance().getCurrentHeight());
        if (EMidlet.getInstance().getProperties().getUserAgent() != null) {
            tempUrl.append("&ua=").append(EMidlet.getInstance().getProperties().getUserAgent());
        }
        if (EMidlet.getInstance().getProperties().getPartner() != null) {
            tempUrl.append("&partner=").append(EMidlet.getInstance().getProperties().getPartner());
        }
        if (EMidlet.getInstance().getProperties().getXxx() != null) {
            tempUrl.append("&xxx=").append(EMidlet.getInstance().getProperties().getXxx());
        }
        if (EMidlet.getInstance().getProperties().getLang() != null) {
            tempUrl.append("&lang=").append(EMidlet.getInstance().getProperties().getLang());
        }
        if (EMidlet.getInstance().getProperties().getIsOpera() != null) {
            tempUrl.append("&isopera=").append(EMidlet.getInstance().getProperties().getIsOpera());
        }
        tempUrl.append("&uid=JB").append(EMidlet.getInstance().gameId);
        this.xml_url = tempUrl.toString();
        this.ads = new Vector();
    }

    public boolean isLoadingAds() {
        return this.loadingAds;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    private Advertisement getAd(int id) {
        if (this.getSize() == 0) {
            return null;
        }
        return (Advertisement)this.ads.elementAt(id);
    }

    public void loadAds(String url) {
        this.ads.removeAllElements();
        this.ads = null;
        this.ads = new Vector();
        this.loadingAds = true;
        HTTPConnection con = new HTTPConnection(){

            public void onTextReceived(String text) {
                if (text == null || text.equals("")) {
                    GameModeHandler.this.loadingAds = false;
                } else {
                    GameModeHandler.this.adXML = text;
                    AdXmlReader.getInstance().readAdString(GameModeHandler.this.adXML);
                    GameModeHandler.this.loadingAds = false;
                }
            }

            public void onImageReceived(Image image) {
            }
        };
        IErrorListener errorListener = new IErrorListener(){

            public void errorRaised(Throwable throwable) {
                AdXmlReader.getInstance().parseTime = System.currentTimeMillis();
                Advertisement ad = new Advertisement();
                ad.setAdType(0);
                ad.setAliveTime(6000);
                ad.setAdData("More Games");
                ad.setAddress("http://www.jarbull.com");
                GameModeHandler.getInstance().addAdvertisement(ad);
            }
        };
        con.setErrorListener(errorListener);
        con.askRemoteText(url);
    }

    public Advertisement getAd() {
        if (this.getSize() == 0) {
            if (!this.loadingAds) {
                this.loadAds(this.xml_url);
                this.getAd();
            }
            return null;
        }
        int adIndex = 0;
        if (this.getSize() == 1) {
            adIndex = 0;
        } else {
            adIndex = (RANDOM.nextInt() >>> 1) % this.getSize();
            if (adIndex < 0) {
                adIndex = Math.abs(adIndex);
            }
        }
        long currentTime = System.currentTimeMillis();
        Advertisement tempAd = this.getAd(adIndex);
        if (currentTime - AdXmlReader.getInstance().parseTime > (long)(tempAd.getAliveTime() * 1000)) {
            this.removeAdvertisement(tempAd);
            if (this.getSize() != 0) {
                this.getAd();
            } else {
                this.loadAds(this.xml_url);
                this.getAd();
            }
        }
        return tempAd;
    }

    void addAdvertisement(Advertisement ad) {
        this.ads.addElement(ad);
    }

    void removeAdvertisement(Advertisement ad) {
        this.ads.removeElement(ad);
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public int getSize() {
        return this.ads.size();
    }

    public boolean isAlive(Advertisement advertisement, boolean cleanIfDead) {
        if (System.currentTimeMillis() - AdXmlReader.getInstance().parseTime < (long)(advertisement.getAliveTime() * 1000)) {
            return true;
        }
        this.removeAdvertisement(advertisement);
        return false;
    }

    private static class GameModeHandlerHolder {
        private static final GameModeHandler INSTANCE = new GameModeHandler();

        private GameModeHandlerHolder() {
        }
    }
}

