/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.util.ColorEx;
import javax.microedition.lcdui.Graphics;

public class ProgressBar
extends Component {
    public static final int ANIMATION = 10;
    public static final int BOX_FILL = 11;
    public static final int CIRCULAR_FILL = 12;
    public static final int CIRCULAR_LINE = 13;
    public static final int NORMAL = 100;
    public static final int FADE = 101;
    public static final int GRADIENT = 102;
    private int value = 0;
    private int type = 11;
    private int colorMode = 100;
    private int margin = 1;
    private int fillOffsetX = 0;
    private int fillOffsetY = 0;
    private int transColor;

    public ProgressBar(String id) {
        super(id);
        this.bgColor = 0;
        this.fgColor = 0xFFFFFF;
        this.borderColor = 0xFFFFFF;
        this.transColor = 0xCC0000;
        this.width = 100;
        this.height = 10;
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int colorMode) {
        if (this.type < 100 && this.type > 102) {
            throw new IllegalArgumentException();
        }
        this.colorMode = colorMode;
    }

    public int getFillOffsetX() {
        return this.fillOffsetX;
    }

    public int getFillOffsetY() {
        return this.fillOffsetY;
    }

    public void setFillOffset(int fillOffsetX, int fillOffsetY) {
        this.fillOffsetX = fillOffsetX;
        this.fillOffsetY = fillOffsetY;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public int getTransColor() {
        return this.transColor;
    }

    public void setTransColor(int transColor) {
        this.transColor = transColor;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < 10 && type > 13) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        if (type == 10 && this.fg != null) {
            this.width = this.fg.getWidth() + this.borderSize * 2;
            this.height = this.fg.getHeight() + this.borderSize * 2;
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void increaseValue(int delta) {
        this.value += delta;
    }

    public void setFg(EFLiteSprite fg) {
        super.setFg(fg);
        if (this.type == 10) {
            this.width = fg.getWidth() + this.borderSize * 2;
            this.height = fg.getHeight() + this.borderSize * 2;
        }
    }

    public void paint(Graphics g) {
        this.saveClip(g);
        int trX = g.getTranslateX();
        int trY = g.getTranslateY();
        g.translate(this.x, this.y);
        int internalWidth = this.width - (this.fillOffsetX + this.borderSize + this.margin) * 2;
        int internalHeight = this.height - this.fillOffsetY - (this.borderSize + this.margin) * 2;
        switch (this.type) {
            case 11: {
                if (this.bg != null) {
                    this.bg.setPosition(0, 0);
                    this.bg.paint(g);
                    g.translate(this.margin + this.fillOffsetX, this.margin + this.fillOffsetY);
                } else if (this.borderSize > 0) {
                    g.setColor(this.borderColor);
                    g.fillRect(0, 0, this.width, this.height);
                    g.setColor(this.bgColor);
                    g.fillRect(this.borderSize, this.borderSize, this.width - this.borderSize * 2, this.height - this.borderSize * 2);
                    g.translate(this.borderSize + this.margin + this.fillOffsetX, this.borderSize + this.margin + this.fillOffsetY);
                }
                if (this.fg != null) {
                    if (this.clipRegionActivated) {
                        g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
                    } else {
                        g.setClip(0, 0, internalWidth * this.value / 100, internalHeight);
                    }
                    this.fg.setPosition(0, 0);
                    while (this.fg.getX() < internalWidth * this.value / 100) {
                        this.fg.paint(g);
                        this.fg.move(this.fg.getWidth(), 0);
                    }
                    break;
                }
                switch (this.colorMode) {
                    case 100: {
                        g.setColor(this.fgColor);
                        g.fillRect(0, 0, internalWidth * this.value / 100, internalHeight);
                        break;
                    }
                    case 101: {
                        g.setColor(ColorEx.getMidColor(this.transColor, this.fgColor, this.value, 100));
                        g.fillRect(0, 0, internalWidth * this.value / 100, internalHeight);
                        break;
                    }
                    case 102: {
                        for (int i = this.value * internalWidth / 100 - 1; i >= 0; --i) {
                            g.setColor(ColorEx.getMidColor(this.transColor, this.fgColor, i, internalWidth));
                            g.drawLine(i, 0, i, internalHeight - 1);
                        }
                        break;
                    }
                }
                break;
            }
            case 12: {
                if (this.bg != null) {
                    this.bg.setPosition(0, 0);
                    this.bg.paint(g);
                    g.translate(this.margin + this.fillOffsetX, this.margin + this.fillOffsetY);
                } else if (this.borderSize > 0) {
                    g.setColor(this.borderColor);
                    g.fillArc(0, 0, this.width, this.height, 0, 360);
                    g.setColor(this.bgColor);
                    g.fillArc(this.borderSize, this.borderSize, this.width - this.borderSize * 2, this.height - this.borderSize * 2, 0, 360);
                    g.translate(this.borderSize + this.margin + this.fillOffsetX, this.borderSize + this.margin + this.fillOffsetY);
                }
                switch (this.colorMode) {
                    case 100: {
                        g.setColor(this.fgColor);
                        g.fillArc(0, 0, internalWidth, internalHeight, 450 - this.value * 360 / 100, this.value * 360 / 100);
                        break;
                    }
                    case 101: {
                        g.setColor(ColorEx.getMidColor(this.transColor, this.fgColor, this.value, 100));
                        g.fillArc(0, 0, internalWidth, internalHeight, 450 - this.value * 360 / 100, this.value * 360 / 100);
                        break;
                    }
                    case 102: {
                        for (int i = this.value * 360 / 100; i >= 0; --i) {
                            g.setColor(ColorEx.getMidColor(this.transColor, this.fgColor, this.value * 360 / 100 - i, 360));
                            g.fillArc(0, 0, internalWidth, internalHeight, 450 - (this.value * 360 / 100 - i), 1);
                        }
                        break;
                    }
                }
                break;
            }
            case 13: {
                if (this.bg != null) {
                    this.bg.setPosition(0, 0);
                    this.bg.paint(g);
                    g.translate(this.margin + this.fillOffsetX, this.margin + this.fillOffsetY);
                } else if (this.borderSize > 0) {
                    g.setColor(this.borderColor);
                    g.fillArc(0, 0, this.width, this.height, 0, 360);
                    g.setColor(this.bgColor);
                    g.fillArc(this.borderSize, this.borderSize, this.width - this.borderSize * 2, this.height - this.borderSize * 2, 0, 360);
                    g.translate(this.borderSize + this.margin + this.fillOffsetX, this.borderSize + this.margin + this.fillOffsetY);
                }
                switch (this.colorMode) {
                    case 100: {
                        g.setColor(this.fgColor);
                        g.drawArc(0, 0, internalWidth, internalHeight, 450 - this.value * 360 / 100, this.value * 360 / 100);
                        break;
                    }
                    case 101: {
                        g.setColor(ColorEx.getMidColor(this.transColor, this.fgColor, this.value, 100));
                        g.drawArc(0, 0, internalWidth, internalHeight, 450 - this.value * 360 / 100, this.value * 360 / 100);
                        break;
                    }
                    case 102: {
                        for (int i = this.value * 360 / 100; i >= 0; --i) {
                            g.setColor(ColorEx.getMidColor(this.transColor, this.fgColor, this.value * 360 / 100 - i, 360));
                            g.drawArc(0, 0, internalWidth, internalHeight, 450 - (this.value * 360 / 100 - i), 1);
                        }
                        break;
                    }
                }
                break;
            }
            case 10: {
                if (this.borderSize > 0) {
                    this.borderSize = 0;
                }
                if (this.bg != null) {
                    ImageHandler.getInstance().load(this.bg.getImageId());
                    this.setSize(this.bg.getWidth(), this.bg.getHeight());
                    this.bg.setFrame((this.bg.getFrameSequenceLength() - 1) * this.value / 100);
                    this.bg.paint(g);
                }
                if (this.fg == null) break;
                ImageHandler.getInstance().load(this.fg.getImageId());
                this.fg.setFrame((this.fg.getFrameSequenceLength() - 1) * this.value / 100);
                this.fg.paint(g);
            }
        }
        g.translate(trX - g.getTranslateX(), trY - g.getTranslateY());
        this.restoreClip(g);
    }
}

