/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.manager.IActionListener;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Button;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.IFocusable;
import com.jarbull.efw.ui.IScreen;
import com.jarbull.efw.ui.Layout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Screen
implements IScreen {
    private Hashtable components;
    private Vector componentsOrder;
    private boolean isPosSetted;
    protected final int width;
    protected final int height;
    String id;
    int selectedComponentId;
    Layout layout;
    int autoActionDelay;
    IActionListener actionListener;
    private String fontName;
    private int textOrientation;
    private int writerType;
    Timer autoTimer;
    int autoPosCompSize;
    boolean sliding;
    int slideRegionW;
    int slideRegionH;
    private int longRangeSpeed;
    private int closeRangeSpeed;
    static boolean touchSupported;

    public static void setTouchSupported(boolean touchSupported) {
        Screen.touchSupported = touchSupported;
    }

    public static boolean isTouchSupported() {
        return touchSupported;
    }

    public Screen(String id) {
        this(id, 0);
        this.longRangeSpeed = 10;
        this.closeRangeSpeed = 3;
    }

    public Screen(String id, int autoActionDelay) {
        this.id = id;
        this.width = ResolutionHandler.getInstance().getCurrentWidth();
        this.height = ResolutionHandler.getInstance().getCurrentHeight();
        this.components = new Hashtable();
        this.componentsOrder = new Vector();
        this.isPosSetted = false;
        this.layout = new Layout();
        this.layout.setType(2);
        this.selectedComponentId = 0;
        this.fontName = TextWriter.getInstance().getFont().getFontName();
        this.textOrientation = 0;
        this.writerType = TextWriter.getInstance().getWriterType();
        this.longRangeSpeed = 10;
        this.closeRangeSpeed = 3;
        this.autoActionDelay = autoActionDelay;
    }

    public void activateAutoAction() {
        if (this.autoActionDelay <= 0) {
            return;
        }
        this.autoTimer = new Timer();
        this.autoTimer.schedule(new TimerTask(){

            public void run() {
                if (Screen.this.actionListener != null) {
                    Screen.this.actionListener.actionPerformed();
                }
            }
        }, this.autoActionDelay);
    }

    public void cancelAutoAction() {
        if (this.autoTimer != null) {
            this.autoTimer.cancel();
        }
        this.autoTimer = null;
    }

    public IActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(IActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public String getId() {
        return this.id;
    }

    public int getWriterType() {
        return this.writerType;
    }

    public void setWriterType(int writerType) {
        this.writerType = writerType;
    }

    public int getTextOrientation() {
        return this.textOrientation;
    }

    public void setTextOrientation(int textOrientation) {
        this.textOrientation = textOrientation;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        TextWriter.getInstance().setFont(TextWriter.getInstance().getFont(fontName));
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void clear() {
        this.isPosSetted = false;
        this.components.clear();
        this.componentsOrder.removeAllElements();
    }

    private void initPositions() {
        Vector<Component> autoPosComponents = new Vector<Component>();
        int componentsOrderSize = this.componentsOrder.size();
        for (int i = 0; i < componentsOrderSize; ++i) {
            String compID = (String)this.componentsOrder.elementAt(i);
            Component comp = (Component)this.components.get(compID);
            if (!comp.autoPos) continue;
            autoPosComponents.addElement(comp);
        }
        this.autoPosCompSize = autoPosComponents.size();
        switch (this.layout.type) {
            case 11: {
                int rowCount = this.layout.getTableRowCount();
                int columnCount = this.layout.getTableColumnCount();
                int horizontalSpace = this.layout.areaWidth / columnCount;
                int verticalSpace = this.layout.areaHeigth / rowCount;
                int autoPosCompSize = autoPosComponents.size();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < columnCount; ++j) {
                        if (j + columnCount * i >= autoPosCompSize) continue;
                        int x = this.layout.areaX + j * horizontalSpace;
                        int y = this.layout.areaY + i * verticalSpace;
                        Component component = (Component)autoPosComponents.elementAt(j + columnCount * i);
                        component.setPosition(x, y);
                    }
                }
                for (int j = 0; j < columnCount; ++j) {
                    int maxWidth = 0;
                    for (int i = 0; i < rowCount; ++i) {
                        Component component = (Component)autoPosComponents.elementAt(j + i * columnCount);
                        int widthA = component.getWidth();
                        if (widthA <= maxWidth) continue;
                        maxWidth = widthA;
                    }
                    for (int k = j + 1; k < columnCount; ++k) {
                        for (int i = 0; i < rowCount; ++i) {
                            Component component = (Component)autoPosComponents.elementAt(k + i * columnCount);
                            component.move(maxWidth - horizontalSpace + TextWriter.getInstance().getTextWidth(" "), 0);
                        }
                    }
                }
                break;
            }
            case 6: {
                Component component;
                int i;
                int spaceY = 0;
                int totalHeight = 0;
                int autoPosCompSize = autoPosComponents.size();
                for (i = 0; i < autoPosCompSize; ++i) {
                    component = (Component)autoPosComponents.elementAt(i);
                    component.setPosition(this.layout.areaX, this.layout.areaY + totalHeight);
                    totalHeight = component.height + totalHeight;
                }
                if (autoPosCompSize <= 1) break;
                spaceY = (this.layout.areaHeigth - totalHeight) / (autoPosCompSize - 1);
                for (i = 0; i < autoPosCompSize; ++i) {
                    component = (Component)autoPosComponents.elementAt(i);
                    component.move(0, spaceY * i);
                }
                break;
            }
            case 7: {
                Component component;
                int i;
                int spaceY = 0;
                int totalHeight = 0;
                int autoPosCompSize = autoPosComponents.size();
                for (i = 0; i < autoPosCompSize; ++i) {
                    component = (Component)autoPosComponents.elementAt(i);
                    component.setPosition(this.layout.areaX + (this.layout.areaWidth - component.width) / 2, this.layout.areaY + totalHeight);
                    totalHeight = component.height + totalHeight;
                }
                if (autoPosCompSize <= 1) break;
                spaceY = (this.layout.areaHeigth - totalHeight) / (autoPosCompSize - 1);
                for (i = 0; i < autoPosCompSize; ++i) {
                    component = (Component)autoPosComponents.elementAt(i);
                    component.move(0, spaceY * i);
                }
                break;
            }
            case 8: {
                Component comp;
                int i;
                int spaceY = 0;
                int totalHeight = 0;
                int autoPosCompSize = autoPosComponents.size();
                for (i = 0; i < autoPosCompSize; ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.setPosition(this.layout.areaX + this.layout.areaWidth - comp.width, this.layout.areaY + totalHeight);
                    totalHeight = comp.getHeight() + totalHeight;
                }
                if (autoPosCompSize <= 1) break;
                spaceY = (this.layout.getAreaHeigth() - totalHeight) / (autoPosCompSize - 1);
                for (i = 0; i < autoPosCompSize; ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.move(0, spaceY * i);
                }
                break;
            }
            case 3: {
                Component comp;
                int i;
                int spaceX = 0;
                int totalWidth = 0;
                int autoPosCompSize = autoPosComponents.size();
                for (i = 0; i < autoPosCompSize; ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.setPosition(this.layout.areaX + totalWidth, this.layout.areaY);
                    totalWidth = comp.width + totalWidth;
                }
                if (autoPosCompSize <= 1) break;
                spaceX = (this.layout.areaWidth - totalWidth) / (autoPosCompSize - 1);
                for (i = 0; i < autoPosCompSize; ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.move(spaceX * i, 0);
                }
                break;
            }
            case 4: {
                Component comp;
                int i;
                int spaceX = 0;
                int totalWidth = 0;
                for (i = 0; i < autoPosComponents.size(); ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.setPosition(this.layout.getAreaX() + totalWidth, this.layout.getAreaY() + (this.layout.getAreaHeigth() - comp.getHeight()) / 2);
                    totalWidth = comp.getWidth() + totalWidth;
                }
                if (autoPosComponents.size() <= 1) break;
                spaceX = (this.layout.getAreaWidth() - totalWidth) / (autoPosComponents.size() - 1);
                for (i = 0; i < autoPosComponents.size(); ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.move(spaceX * i, 0);
                }
                break;
            }
            case 5: {
                Component comp;
                int i;
                int spaceX = 0;
                int totalWidth = 0;
                for (i = 0; i < autoPosComponents.size(); ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.setPosition(this.layout.getAreaX() + totalWidth, this.layout.getAreaY() + (this.layout.getAreaHeigth() - comp.getHeight()));
                    totalWidth = comp.getWidth() + totalWidth;
                }
                if (autoPosComponents.size() <= 1) break;
                spaceX = (this.layout.getAreaWidth() - totalWidth) / (autoPosComponents.size() - 1);
                for (i = 0; i < autoPosComponents.size(); ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.move(spaceX * i, 0);
                }
                break;
            }
            case 9: {
                Component comp;
                int totalWidth = 0;
                int totalHeight = 0;
                for (int i = 0; i < autoPosComponents.size(); ++i) {
                    comp = (Component)autoPosComponents.elementAt(i);
                    comp.setPosition(this.layout.getAreaX() + totalWidth, this.layout.getAreaY() + totalHeight);
                    totalWidth = comp.getWidth() + totalWidth;
                    totalHeight = comp.getHeight() + totalHeight;
                }
                Component compFirst = (Component)autoPosComponents.firstElement();
                compFirst.setPosition(this.layout.getAreaX(), this.layout.getAreaY());
                comp = (Component)autoPosComponents.lastElement();
                comp.setPosition(this.layout.getAreaWidth() + this.layout.getAreaX() - comp.getWidth(), this.layout.getAreaHeigth() + this.layout.getAreaY() - comp.getHeight());
                if (autoPosComponents.size() <= 1) break;
                int spX = (this.layout.getAreaWidth() - totalWidth) / (autoPosComponents.size() - 1);
                int spY = (this.layout.getAreaHeigth() - totalHeight) / (autoPosComponents.size() - 1);
                for (int i = 0; i < autoPosComponents.size() - 1; ++i) {
                    Component comp1 = (Component)autoPosComponents.elementAt(i);
                    comp1.move(spX * i, spY * i);
                }
                break;
            }
            case 10: {
                int totalWidth = 0;
                int totalHeight = 0;
                for (int i = 0; i < autoPosComponents.size(); ++i) {
                    Component comp1 = (Component)autoPosComponents.elementAt(i);
                    comp1.setPosition(this.layout.getAreaWidth() + this.layout.getAreaX() - comp1.getWidth() - totalWidth, this.layout.getAreaY() + totalHeight);
                    totalWidth = comp1.getWidth() + totalWidth;
                    totalHeight = comp1.getHeight() + totalHeight;
                }
                Component compLast = (Component)autoPosComponents.lastElement();
                compLast.setPosition(this.layout.getAreaX(), this.layout.getAreaHeigth() + this.layout.getAreaY() - compLast.getHeight());
                if (autoPosComponents.size() <= 1) break;
                int spX1 = (this.layout.getAreaWidth() - totalWidth) / (autoPosComponents.size() - 1);
                int spY1 = (this.layout.getAreaHeigth() - totalHeight) / (autoPosComponents.size() - 1);
                for (int i = 0; i < autoPosComponents.size() - 1; ++i) {
                    Component comp1 = (Component)autoPosComponents.elementAt(i);
                    comp1.move(-spX1 * i, spY1 * i);
                }
                break;
            }
            case 0: {
                if (autoPosComponents.size() <= 1) break;
                int angleSteps = (this.layout.endAngle - this.layout.startAngle) / (autoPosComponents.size() - 1);
                for (int i = 0; i < autoPosComponents.size(); ++i) {
                    Component component = (Component)autoPosComponents.elementAt(i);
                    if (this.layout.startAngle < this.layout.endAngle) {
                        component.setPosition(this.layout.ellipse.getX(this.layout.startAngle + i * angleSteps) - component.getWidth() / 2, this.layout.ellipse.getY(this.layout.startAngle + i * angleSteps) - component.getHeight() / 2);
                        continue;
                    }
                    component.setPosition(this.layout.ellipse.getX(this.layout.endAngle - (autoPosComponents.size() - i - 1) * angleSteps) - component.getWidth() / 2, this.layout.ellipse.getY(this.layout.endAngle - (autoPosComponents.size() - i - 1) * angleSteps) - component.getHeight() / 2);
                }
                break;
            }
            case 2: {
                int spaceX;
                int totalWidth2 = 0;
                for (int i = 0; i < autoPosComponents.size(); ++i) {
                    Component c = (Component)autoPosComponents.elementAt(i);
                    totalWidth2 = c.getWidth() + totalWidth2;
                }
                if (totalWidth2 <= this.layout.getAreaWidth()) {
                    Component c;
                    int i;
                    spaceX = this.layout.getAreaX();
                    int totalWidth = 0;
                    int totalHeight = 0;
                    for (i = 0; i < autoPosComponents.size(); ++i) {
                        c = (Component)autoPosComponents.elementAt(i);
                        if (autoPosComponents.size() < 2) {
                            c.setPosition(this.layout.getAreaX() + (this.layout.getAreaWidth() - c.getWidth()) / 2, this.layout.getAreaY() + (this.layout.getAreaHeigth() - c.getHeight()) / 2);
                        } else {
                            c.setPosition(this.layout.getAreaX() + totalWidth, this.layout.getAreaY() + (this.layout.getAreaHeigth() - c.getHeight()) / 2);
                        }
                        totalWidth = c.getWidth() + totalWidth;
                        totalHeight = c.getHeight() + totalHeight;
                    }
                    if (autoPosComponents.size() <= 1) break;
                    spaceX = (this.layout.getAreaWidth() - totalWidth) / (autoPosComponents.size() + 1);
                    for (i = 0; i < autoPosComponents.size(); ++i) {
                        c = (Component)autoPosComponents.elementAt(i);
                        c.move(spaceX * (i + 1), 0);
                    }
                } else {
                    spaceX = this.layout.getAreaX();
                    int spaceY = this.layout.getAreaY();
                    int totalWidth = 0;
                    int totalHeight = 0;
                    int maxHeightPerRow = 0;
                    int rowCount = 1;
                    Vector<Component> temp = new Vector<Component>();
                    for (int i = 0; i < autoPosComponents.size(); ++i) {
                        Component t;
                        int j;
                        int rowItemCount;
                        int j2;
                        int tempWidth;
                        Component c = (Component)autoPosComponents.elementAt(i);
                        c.setPosition(this.layout.getAreaX() + totalWidth, this.layout.getAreaY() + totalHeight);
                        if (c.getX() + c.getWidth() > this.layout.getAreaWidth() + this.layout.getAreaX()) {
                            if (temp != null) {
                                tempWidth = 0;
                                for (j2 = 0; j2 < temp.size(); ++j2) {
                                    Component t2 = (Component)temp.elementAt(j2);
                                    tempWidth += t2.getWidth();
                                }
                                spaceX = (this.layout.getAreaWidth() - tempWidth) / (temp.size() + 1);
                                rowItemCount = 0;
                                for (j = 0; j < temp.size(); ++j) {
                                    t = (Component)temp.elementAt(j);
                                    t.move(spaceX * ++rowItemCount, 0);
                                }
                                temp.removeAllElements();
                                temp.addElement(c);
                                spaceX = 0;
                                tempWidth = 0;
                            }
                            ++rowCount;
                            totalWidth = 0;
                            c.setPosition(this.layout.getAreaX() + totalWidth, this.layout.getAreaY() + (totalHeight += maxHeightPerRow));
                            maxHeightPerRow = 0;
                        } else {
                            temp.addElement(c);
                        }
                        if (maxHeightPerRow < c.getHeight()) {
                            maxHeightPerRow = c.getHeight();
                        }
                        totalWidth = c.getWidth() + totalWidth;
                        if (i != autoPosComponents.size() - 1 || temp == null) continue;
                        tempWidth = 0;
                        for (j2 = 0; j2 < temp.size(); ++j2) {
                            Component t3 = (Component)temp.elementAt(j2);
                            tempWidth += t3.getWidth();
                        }
                        spaceX = (this.layout.getAreaWidth() - tempWidth) / (temp.size() + 1);
                        rowItemCount = 0;
                        for (j = 0; j < temp.size(); ++j) {
                            t = (Component)temp.elementAt(j);
                            t.move(spaceX * ++rowItemCount, 0);
                        }
                        temp.removeAllElements();
                    }
                    if (autoPosComponents.size() <= 1) break;
                    spaceY = (this.layout.getAreaHeigth() - totalHeight - maxHeightPerRow) / (rowCount + 1);
                    rowCount = 1;
                    int currentHeight = this.layout.getAreaY();
                    for (int i = 0; i < autoPosComponents.size(); ++i) {
                        Component c = (Component)autoPosComponents.elementAt(i);
                        if (c.getY() > currentHeight) {
                            ++rowCount;
                            currentHeight = c.getY();
                        }
                        c.move(0, spaceY * rowCount);
                    }
                }
                break;
            }
        }
        this.isPosSetted = true;
    }

    public void paint(Graphics g) {
        TextWriter.getInstance().saveState();
        if (this.fontName != null) {
            TextWriter.getInstance().setFont(TextWriter.getInstance().getFont(this.fontName));
        }
        TextWriter.getInstance().setOrientation(this.textOrientation);
        TextWriter.getInstance().setWriterType(this.writerType);
        if (!this.isPosSetted) {
            this.initPositions();
        }
        if (this.sliding) {
            this.rePosComponents(g);
        }
        for (int i = this.componentsOrder.size() - 1; i >= 0; --i) {
            String compID = (String)this.componentsOrder.elementAt(i);
            Component component = (Component)this.components.get(compID);
            if (component.autoPos && this.getLayout().getType() != 1) {
                g.setClip(this.layout.areaX, this.layout.areaY, this.layout.areaWidth, this.layout.areaHeigth);
            }
            if (this.sliding && component.autoPos && this.getLayout().getType() != 1) {
                if (component.x < this.layout.areaX || component.y < this.layout.areaY || component.x + component.width > this.slideRegionW || component.y + component.height > this.slideRegionH) {
                    component.setClipRegion(component.x < this.layout.areaX ? this.layout.areaX - component.x : 0, component.y < this.layout.areaY ? this.layout.areaY - component.y : 0, component.width + component.x > this.slideRegionW ? this.slideRegionW - component.x : component.width, component.height + component.y > this.slideRegionH ? this.slideRegionH - component.y : component.height);
                } else {
                    component.setClipRegion(0, 0, component.width, component.height);
                }
            }
            component.paint(g);
            if (!component.autoPos) continue;
            g.setClip(0, 0, this.width, this.height);
        }
        TextWriter.getInstance().restoreState();
    }

    public void addChild(Component component) {
        if (this.components.containsKey(component.id)) {
            throw new RuntimeException("Another component with the same ID exists. screen id: " + this.id + " component ID: " + component.id);
        }
        this.components.put(component.id, component);
        this.componentsOrder.addElement(component.id);
        if (!touchSupported && component instanceof IFocusable) {
            this.selectedComponentId = this.components.size() - 1;
            ((IFocusable)((Object)component)).setSelected(true);
            this.selectNext();
        }
    }

    public Component getChild(String id) {
        return (Component)this.components.get(id);
    }

    public Component getChild(int index) {
        return (Component)this.components.get((String)this.componentsOrder.elementAt(index));
    }

    public void removeChild(String id) {
        this.components.remove(id);
        this.componentsOrder.removeElement(id);
    }

    public void removeChild(int index) {
        this.components.remove((String)this.componentsOrder.elementAt(index));
        this.componentsOrder.removeElementAt(index);
    }

    public int getChildrenCount() {
        return this.components.size();
    }

    public void setSelectedIndex(int index) {
        this.selectedComponentId = index;
    }

    public void selectNext() {
        IFocusable focusable;
        boolean exists = false;
        int componentsSize = this.components.size();
        for (int i = 0; i < componentsSize; ++i) {
            String compID = (String)this.componentsOrder.elementAt(i);
            if (!(this.components.get(compID) instanceof IFocusable)) continue;
            focusable = (IFocusable)this.components.get(compID);
            focusable.setSelected(true);
            if (focusable.isSelected()) {
                exists = true;
            }
            focusable.setSelected(false);
            if (exists) break;
        }
        if (!exists) {
            return;
        }
        String compID = (String)this.componentsOrder.elementAt(this.selectedComponentId);
        Object component = this.components.get(compID);
        if (component instanceof IFocusable) {
            ((IFocusable)component).setSelected(false);
        }
        ++this.selectedComponentId;
        this.selectedComponentId %= this.components.size();
        compID = (String)this.componentsOrder.elementAt(this.selectedComponentId);
        if (this.components.get(compID) instanceof IFocusable) {
            focusable = (IFocusable)this.components.get(compID);
            focusable.setSelected(true);
            if (!focusable.isSelected()) {
                this.selectNext();
            }
        } else {
            this.selectNext();
        }
    }

    public void selectPrevious() {
        IFocusable focusable;
        boolean exists = false;
        int componentsSize = this.components.size();
        for (int i = 0; i < componentsSize; ++i) {
            String compID = (String)this.componentsOrder.elementAt(i);
            if (!(this.components.get(compID) instanceof IFocusable)) continue;
            focusable = (IFocusable)this.components.get(compID);
            focusable.setSelected(true);
            if (focusable.isSelected()) {
                exists = true;
            }
            focusable.setSelected(false);
            if (exists) break;
        }
        if (!exists) {
            return;
        }
        String compID = (String)this.componentsOrder.elementAt(this.selectedComponentId);
        Object component = this.components.get(compID);
        if (component instanceof IFocusable) {
            ((IFocusable)component).setSelected(false);
        }
        this.selectedComponentId += --this.selectedComponentId < 0 ? this.components.size() - 1 : -1;
        compID = (String)this.componentsOrder.elementAt(this.selectedComponentId);
        if (this.components.get(compID) instanceof IFocusable) {
            focusable = (IFocusable)this.components.get(compID);
            focusable.setSelected(true);
            if (!focusable.isSelected()) {
                this.selectPrevious();
            }
        } else {
            this.selectPrevious();
        }
    }

    public void keyPressed(int keyCode) {
        IFocusable focusable = null;
        try {
            String compID = (String)this.componentsOrder.elementAt(this.selectedComponentId);
            focusable = (IFocusable)this.components.get(compID);
        }
        catch (ClassCastException ex) {
            return;
        }
        if (focusable.isFocused()) {
            focusable.keyPressed(keyCode);
            return;
        }
        block1 : switch (keyCode) {
            case -203: 
            case 205: 
            case 225: {
                focusable.setFocused(true);
                break;
            }
            case 204: 
            case 223: {
                switch (this.layout.type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: 
                    case 11: {
                        this.selectPrevious();
                        break;
                    }
                    case 10: {
                        this.selectNext();
                        break;
                    }
                    case 0: {
                        if (this.layout.startAngle > this.layout.endAngle) {
                            this.selectPrevious();
                            break;
                        }
                        this.selectNext();
                    }
                }
                break;
            }
            case 206: 
            case 224: {
                switch (this.layout.type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: 
                    case 11: {
                        this.selectNext();
                        break;
                    }
                    case 10: {
                        this.selectPrevious();
                        break;
                    }
                    case 0: {
                        if (this.layout.startAngle > this.layout.endAngle) {
                            this.selectNext();
                            break;
                        }
                        this.selectPrevious();
                    }
                }
                break;
            }
            case 202: 
            case 221: {
                switch (this.layout.type) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.selectPrevious();
                        break;
                    }
                    case 0: {
                        if (this.layout.startAngle > this.layout.endAngle) {
                            this.selectPrevious();
                            break;
                        }
                        this.selectNext();
                    }
                }
                break;
            }
            case 208: 
            case 222: {
                switch (this.layout.type) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.selectNext();
                        break block1;
                    }
                    case 0: {
                        if (this.layout.startAngle > this.layout.endAngle) {
                            this.selectNext();
                            break block1;
                        }
                        this.selectPrevious();
                    }
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    private IFocusable findFocusableAt(int x, int y) {
        IFocusable found = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!(component instanceof IFocusable)) continue;
            IFocusable item = (IFocusable)((Object)component);
            item.setSelected(false);
            if (!component.isInside(x, y)) continue;
            found = item;
        }
        return found;
    }

    public void pointerPressed(int x, int y) {
        IFocusable focusable = this.findFocusableAt(x, y);
        if (focusable != null) {
            focusable.setSelected(true);
        }
    }

    public void pointerDragged(int x, int y) {
        IFocusable focusable = this.findFocusableAt(x, y);
        if (focusable != null) {
            focusable.setSelected(true);
        }
    }

    public void pointerReleased(int x, int y) {
        IFocusable focusable = this.findFocusableAt(x, y);
        if (focusable != null) {
            focusable.setFocused(true);
        }
    }

    public boolean isSliding() {
        return this.sliding;
    }

    public void setSliding(boolean sliding, int slideRegionW, int slideRegionH) {
        this.sliding = sliding;
        this.slideRegionW = slideRegionW;
        this.slideRegionH = slideRegionH;
    }

    public void setSliding(boolean sliding, int slideRegionW, int slideRegionH, int longRangeSpeed, int closeRangeSpeed) {
        this.sliding = sliding;
        this.slideRegionW = slideRegionW;
        this.slideRegionH = slideRegionH;
        this.longRangeSpeed = longRangeSpeed;
        this.closeRangeSpeed = closeRangeSpeed;
    }

    private void rePosComponents(Graphics g) {
        String compID = (String)this.componentsOrder.elementAt(this.selectedComponentId);
        Component targetComp = (Component)this.components.get(compID);
        if (!(targetComp instanceof Button) || !targetComp.autoPos) {
            return;
        }
        int targetY = targetComp.y + targetComp.height - this.slideRegionH;
        int targetX = targetComp.x + targetComp.width - this.slideRegionW;
        int currentY = targetComp.y - this.layout.areaY;
        int currentX = targetComp.x - this.layout.areaX;
        int moveAmountY = 1;
        if (targetY > 0 || currentY < 0) {
            for (int i = 0; i < this.componentsOrder.size(); ++i) {
                compID = (String)this.componentsOrder.elementAt(i);
                Component component = (Component)this.components.get(compID);
                if (!component.autoPos || this.getLayout().getType() == 1) continue;
                moveAmountY = targetY > 0 ? targetY : currentY;
                component.move(0, -moveAmountY * this.layout.areaHeigth * (Math.abs(moveAmountY) > this.slideRegionH / 2 ? this.longRangeSpeed : this.closeRangeSpeed) / (this.slideRegionH * Math.abs(moveAmountY)));
            }
        }
        int moveAmountX = 1;
        if (targetX > 0 || currentX < 0) {
            for (int i = 0; i < this.componentsOrder.size(); ++i) {
                compID = (String)this.componentsOrder.elementAt(i);
                Component component = (Component)this.components.get(compID);
                if (!component.autoPos || this.getLayout().getType() == 1) continue;
                moveAmountX = targetX > 0 ? targetX : currentX;
                component.move(-moveAmountX * this.layout.areaWidth * (Math.abs(moveAmountX) > this.slideRegionW / 2 ? this.longRangeSpeed : this.closeRangeSpeed) / (this.slideRegionW * Math.abs(moveAmountX)), 0);
            }
        }
    }

    public int getCloseRangeSpeed() {
        return this.closeRangeSpeed;
    }

    public int getLongRangeSpeed() {
        return this.longRangeSpeed;
    }

    public void setCloseRangeSpeed(int closeRangeSpeed) {
        this.closeRangeSpeed = closeRangeSpeed;
    }

    public void setLongRangeSpeed(int longRangeSpeed) {
        this.longRangeSpeed = longRangeSpeed;
    }
}

