/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.migration.AbstractEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.JoinedStrategyEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.PerClassStrategyEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.SingleStrategyEnumerationImpl;
import net.sourceforge.floggy.persistence.migration.Enumeration;
import net.sourceforge.floggy.persistence.migration.MigrationManager;

public class MigrationManagerImpl
extends MigrationManager {
    protected Hashtable enumerations = new Hashtable();

    public MigrationManagerImpl() {
        PersistableManager.getInstance();
    }

    public void finish(Class object) {
        Utils.validatePersistableClassArgument((Class)object);
        object = (AbstractEnumerationImpl)this.enumerations.get(object);
        if (object != null) {
            ((AbstractEnumerationImpl)object).a();
        }
    }

    public String[] getNotMigratedClasses() {
        Vector vector = PersistableMetadataManager.getNotMigratedClasses();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void quickMigration(Class object) {
        Utils.validatePersistableClassArgument((Class)object);
        object = ((Class)object).getName();
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata((String)object);
        PersistableMetadata persistableMetadata2 = PersistableMetadataManager.getRMSBasedMetadata((String)object);
        if (persistableMetadata2 != null) {
            if (!persistableMetadata.equals(persistableMetadata2)) {
                throw new FloggyException("Class and RMS description doesn't match for class " + (String)object + ". Please execute a normal migration process.");
            }
        } else {
            try {
                PersistableMetadataManager.saveRMSStructure(persistableMetadata);
                return;
            }
            catch (Exception exception) {
                object = exception;
                throw Utils.handleException(exception);
            }
        }
    }

    public Enumeration start(Class clazz, Hashtable object) {
        RecordStore recordStore;
        Utils.validatePersistableClassArgument(clazz);
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(clazz.getName());
        if (persistableMetadata.isAbstract()) {
            throw new FloggyException("It is not possible migrate abstract classes. Instead migrate its subclasses");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object != null) {
            Object v2 = ((Hashtable)object).get("LAZY_LOAD");
            recordStore = (RecordStore)v2;
            if (v2 instanceof Boolean) {
                bl = (Boolean)recordStore;
            }
            Object v3 = ((Hashtable)object).get("MIGRATE_FROM_PREVIOUS_1_3_0_VERSION");
            recordStore = (RecordStore)v3;
            if (v3 instanceof Boolean) {
                bl2 = (Boolean)recordStore;
            }
            Object v4 = ((Hashtable)object).get("ITERATION_MODE");
            recordStore = (RecordStore)v4;
            if (v4 instanceof Boolean) {
                bl3 = (Boolean)recordStore;
            }
        }
        recordStore = null;
        object = null;
        PersistableMetadata persistableMetadata2 = null;
        try {
            persistableMetadata2 = PersistableMetadataManager.getRMSBasedMetadata(clazz.getName());
            if (persistableMetadata2 == null) {
                if (bl2) {
                    persistableMetadata2 = persistableMetadata;
                } else {
                    throw new FloggyException("Set the property MigrationManager.MIGRATE_FROM_PREVIOUS_1_3_0_VERSION to true to migrate from a version lower than 1.3.0.");
                }
            }
            if (persistableMetadata.getPersistableStrategy() == 4 && persistableMetadata2.getPersistableStrategy() == 1) {
                recordStore = RecordStoreManager.getRecordStore(persistableMetadata2.getRecordStoreName(), persistableMetadata2, true);
            } else {
                __Persistable __Persistable2 = Utils.createInstance(clazz);
                recordStore = RecordStoreManager.getRecordStore(__Persistable2.getRecordStoreName(), persistableMetadata, true);
            }
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            Object object2 = persistableMetadata2.getPersistableImplementations();
            if (!bl && object2 != null) {
                object2 = ((Hashtable)object2).elements();
                while (object2.hasMoreElements()) {
                    String string = (String)object2.nextElement();
                    if (string.endsWith("[]")) {
                        string = string.substring(0, string.length() - 2);
                    }
                    PersistableMetadata persistableMetadata3 = PersistableMetadataManager.getClassBasedMetadata(string);
                    PersistableMetadata persistableMetadata4 = PersistableMetadataManager.getRMSBasedMetadata(string);
                    if (persistableMetadata3 == null || persistableMetadata4 == null || persistableMetadata3.equals(persistableMetadata4)) continue;
                    throw new FloggyException("You first must migrate the class " + string + " than you can migrate " + clazz.getName());
                }
            }
            switch (persistableMetadata2.getPersistableStrategy()) {
                case 4: {
                    object = new SingleStrategyEnumerationImpl(persistableMetadata2, persistableMetadata, recordEnumeration, recordStore, bl, bl3);
                    break;
                }
                case 2: {
                    object = new PerClassStrategyEnumerationImpl(persistableMetadata2, persistableMetadata, recordEnumeration, recordStore, bl, bl3);
                    break;
                }
                case 1: {
                    object = new JoinedStrategyEnumerationImpl(persistableMetadata2, persistableMetadata, recordEnumeration, recordStore, bl, bl3);
                }
            }
            this.enumerations.put(clazz, object);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
        return object;
    }
}

