/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl.migration;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.migration.AbstractEnumerationImpl;
import net.sourceforge.floggy.persistence.impl.migration.HashtableValueNullable;

public class SingleStrategyEnumerationImpl
extends AbstractEnumerationImpl {
    protected Vector datas;
    protected Vector ids;
    protected int currentIndex = 0;

    public SingleStrategyEnumerationImpl(PersistableMetadata persistableMetadata, PersistableMetadata persistableMetadata2, RecordEnumeration recordEnumeration, RecordStore recordStore, boolean bl, boolean bl2) {
        super(persistableMetadata, persistableMetadata2, recordEnumeration, recordStore, bl, bl2);
        this.datas = new Vector(recordEnumeration.numRecords());
        this.ids = new Vector(this.datas.size());
        while (recordEnumeration.hasNextElement()) {
            int n2 = recordEnumeration.nextRecordId();
            byte[] byArray = recordStore.getRecord(n2);
            String string = Utils.readUTF8(byArray);
            if (!string.equals(persistableMetadata.getClassName())) continue;
            this.ids.addElement(new Integer(n2));
            this.datas.addElement(byArray);
        }
    }

    public int getSize() {
        return this.datas.size();
    }

    public boolean hasMoreElements() {
        return this.currentIndex < this.getSize();
    }

    public Hashtable nextElement() {
        if (this.recordId != -1 && !this.iterationMode) {
            throw new FloggyException("You should delete or update the current register before step into the next one.");
        }
        HashtableValueNullable hashtableValueNullable = new HashtableValueNullable();
        try {
            byte[] byArray = (byte[])this.datas.elementAt(this.currentIndex);
            this.recordId = (Integer)this.ids.elementAt(this.currentIndex);
            this.buildPersistable(this.rmsBasedMetadata, byArray, hashtableValueNullable);
            ++this.currentIndex;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
        return hashtableValueNullable;
    }

    protected void buildPersistable(PersistableMetadata object, byte[] object2, Hashtable hashtable) {
        String[] stringArray = ((PersistableMetadata)object).getFieldNames();
        object = ((PersistableMetadata)object).getFieldTypes();
        if (object2 != null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object2));
            object2 = dataInputStream;
            dataInputStream.readUTF();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Object object3;
                Object object4 = object[i2];
                if (this.lazy) {
                    Object object5;
                    if ((object4 & 0x400) == 1024) continue;
                    if ((object4 & 0x20000) == 131072) {
                        object4 = object4 & 0xFFFDFFFF;
                        object5 = this.readArray((int)object4, stringArray[i2], (DataInputStream)object2);
                    } else if ((object4 & 0x40000) == 262144) {
                        object4 = object4 & 0xFFFBFFFF;
                        object5 = this.readPrimitive((int)object4, (DataInputStream)object2);
                    } else {
                        object5 = this.readObject((int)object4, stringArray[i2], (DataInputStream)object2);
                    }
                    hashtable.put(stringArray[i2], object5);
                    continue;
                }
                if ((object4 & 0x20000) == 131072) {
                    object4 = object4 & 0xFFFDFFFF;
                    object3 = this.readArray((int)object4, stringArray[i2], (DataInputStream)object2);
                } else if ((object4 & 0x40000) == 262144) {
                    object4 = object4 & 0xFFFBFFFF;
                    object3 = this.readPrimitive((int)object4, (DataInputStream)object2);
                } else {
                    object3 = this.readObject((int)object4, stringArray[i2], (DataInputStream)object2);
                }
                hashtable.put(stringArray[i2], object3);
            }
        }
    }

    final void a() {
        if (!this.enumeration.hasNextElement()) {
            this.enumeration.destroy();
            RecordStoreManager.closeRecordStore(this.recordStore);
            if (this.rmsBasedMetadata != this.classBasedMetadata) {
                try {
                    this.classBasedMetadata.setRecordId(this.rmsBasedMetadata.getRecordId());
                    PersistableMetadataManager.saveRMSStructure(this.classBasedMetadata);
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    throw Utils.handleException(exception);
                }
            }
        } else {
            throw new FloggyException("The enumeration must be whole processed before finish the process!");
        }
    }
}

