/*
 * Decompiled with CFR 0.152.
 */
package Bubble;

import Bubble.AMenu;
import Bubble.PlumberTheBumber;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Pipe {
    private int x;
    private int y;
    private int gridX;
    private int gridY;
    private byte connections = 0;
    private boolean inConnectedSet = false;
    public static final int CONN_UP = 1;
    public static final int CONN_RIGHT = 2;
    public static final int CONN_DOWN = 4;
    public static final int CONN_LEFT = 8;
    private static final int CONN_OVERFLOW = 16;
    private static int size = 9;
    private static final int[] bitmapSizes = new int[]{42, 21, 15, 9};
    private static Image[] disconnectedBmps = null;
    private static Image[] connectedBmps = null;
    private static boolean bmpsLoaded = false;
    private static final int NUM_BMPS = 16;
    private static int sizePlusOne = size + 1;
    private static int size_2 = size / 2;
    private static int size_3 = size / 3;
    public static final int CONNECTED_COLOR = 8736808;
    public static final int DISCONNECTED_COLOR = 0x909090;
    public static final int DIM_CONNECTED_COLOR = 7619352;
    public static final int DIM_DISCONNECTED_COLOR = 0x585757;
    public AMenu mainmenu;
    public boolean pipeimage = true;

    public Pipe() {
    }

    public Pipe(AMenu mainmenu) {
        this.mainmenu = mainmenu;
    }

    public void paint(Graphics g, boolean bright) {
        if (bright) {
            this.paint(g, this.inConnectedSet ? 8736808 : 0x909090, true);
        } else {
            this.paint(g, this.inConnectedSet ? 7619352 : 0x585757, false);
        }
    }

    public void paint(Graphics g, int color, boolean preferBitmap) {
        if (preferBitmap && bmpsLoaded) {
            if (color == 8736808) {
                g.drawImage(connectedBmps[this.connections], this.x, this.y, 20);
            } else {
                g.drawImage(disconnectedBmps[this.connections], this.x, this.y, 20);
            }
            return;
        }
        g.setColor(5047560);
        g.fillRect(this.x, this.y, size, size);
        g.setColor(color);
        g.fillArc(this.x + size_3, this.y + size_3, size_3, size_3, 0, 360);
        if (this.isConnected(1)) {
            g.fillRect(this.x + size_3, this.y, size_3, size_2);
        }
        if (this.isConnected(4)) {
            g.fillRect(this.x + size_3, this.y + size_2, size_3, size_2 + 1);
        }
        if (this.isConnected(2)) {
            g.fillRect(this.x + size_2, this.y + size_3, size_2 + 1, size_3);
        }
        if (this.isConnected(8)) {
            g.fillRect(this.x, this.y + size_3, size_2, size_3);
        }
    }

    public void setConnected(int dir, boolean connected) {
        this.connections = connected ? (byte)(this.connections | dir) : (byte)(this.connections & ~dir);
    }

    public void rotate(boolean clockwise) {
        if (clockwise) {
            this.connections = (byte)(this.connections << 1);
            if (this.isConnected(16)) {
                this.setConnected(16, false);
                this.setConnected(1, true);
            }
        } else {
            if (this.isConnected(1)) {
                this.setConnected(16, true);
            }
            this.connections = (byte)(this.connections >> 1);
        }
    }

    private static int getBestBitmapSize(int preferredSize) {
        for (int i = 0; i < bitmapSizes.length; ++i) {
            if (bitmapSizes[i] > preferredSize) continue;
            return bitmapSizes[i];
        }
        return 0;
    }

    public static int loadBitmaps() {
        PlumberTheBumber.log("loadBitmaps()");
        if (size > 0) {
            try {
                Image allPipes = Image.createImage((String)("/" + size + ".png"));
                connectedBmps = new Image[16];
                disconnectedBmps = new Image[16];
                for (int n = 0; n < 16; ++n) {
                    Pipe.disconnectedBmps[n] = Pipe.extractImage(allPipes, n * size, 0, size, size);
                    Pipe.connectedBmps[n] = Pipe.extractImage(allPipes, n * size, size, size, size);
                }
                bmpsLoaded = true;
                return size;
            }
            catch (Exception e) {
                e.printStackTrace();
                bmpsLoaded = false;
                return 0;
            }
        }
        bmpsLoaded = false;
        return 0;
    }

    private static Image extractImage(Image source, int xOffset, int yOffset, int width, int height) {
        Image img = Image.createImage((int)width, (int)height);
        img.getGraphics().drawImage(source, -xOffset, -yOffset, 20);
        return img;
    }

    public boolean isConnected(int dir) {
        return (this.connections & dir) == dir;
    }

    public int getX() {
        return this.x;
    }

    public void setX() {
        this.setX(this.gridX * sizePlusOne + 1);
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY() {
        this.setY(this.gridY * sizePlusOne + 1);
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getGridX() {
        return this.gridX;
    }

    public void setGridX(int gridX) {
        this.gridX = gridX;
        this.setX();
    }

    public int getGridY() {
        return this.gridY;
    }

    public void setGridY(int gridY) {
        this.gridY = gridY;
        this.setY();
    }

    public byte getConnections() {
        return this.connections;
    }

    public void setConnections(byte connections) {
        this.connections = connections;
    }

    public static int getSize() {
        return size;
    }

    public static int setSize(int preferredSize) {
        if (preferredSize > 8) {
            size = preferredSize;
            int bestSize = Pipe.getBestBitmapSize(preferredSize);
            PlumberTheBumber.log("Best size: " + bestSize);
            if (bestSize > 0) {
                size = bestSize;
            }
            sizePlusOne = size + 1;
            size_2 = size / 2;
            size_3 = size / 3;
        }
        return size;
    }

    public static int incrementSize() {
        int bestSize = size;
        for (int i = 0; i < bitmapSizes.length; ++i) {
            if (bitmapSizes[i] <= size) continue;
            bestSize = bitmapSizes[i];
        }
        Pipe.setSize(bestSize);
        return size;
    }

    public static int decrementSize() {
        return Pipe.setSize(size - 1);
    }

    public boolean isInConnectedSet() {
        return this.inConnectedSet;
    }

    public void setInConnectedSet(boolean inConnectedSet) {
        this.inConnectedSet = inConnectedSet;
    }
}

