/*
 * Decompiled with CFR 0.152.
 */
package Bubble;

import Bubble.AMenu;
import Bubble.Pipe;
import Bubble.PlumberTheBumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

class PipesCanvas
extends Canvas
implements CommandListener {
    int pipeboardDECy = 0;
    int DecmaxwindoY = 50;
    int gridblock = 4;
    int cornerXgreter = 200;
    int cornerXless = 40;
    int cornerY = 350;
    int keyXPOZ = 70;
    int keyYPOZ = 225;
    int keyX = 60;
    int keyY = 215;
    int keyWDT = 70;
    int keyHGT = 70;
    int firekeyX = 144;
    int firekeyY = 300;
    int sizeoutkeyX = 0;
    int sizeoutkeyY = 30;
    int sizeinkeyX = 290;
    int sizeinkeyY = 30;
    private Pipe[][] pipes;
    private int cursorX;
    private int cursorY;
    private Image offscreenGraphics;
    private Image imgYouWin;
    private Random random = new Random();
    private Stack connectedPipes;
    public int mode;
    private Stack toBeChecked;
    private Command rotate;
    private Command quit;
    private Command reset;
    private Command resize;
    private Command ok;
    private Command about;
    private Command help;
    private Command back;
    private Command viewLog;
    private int rows = 8;
    private int cols = 8;
    private static int scrollX = 0;
    private static int scrollY = 0;
    private static final int MODE_GAME = 0;
    private static final int MODE_YOU_WIN = 1;
    private static final int MODE_RESIZE = 2;
    private static final int MODE_ABOUT = 3;
    private static final int MODE_GAME_OVER = 4;
    private static final String STORE_NAME = "PipesStore";
    private static final int STORE_SIZE_RECORD = 1;
    private static final int STORE_PIPES_RECORD = 2;
    private static final String MESSAGE_GAME_OVER = "You Win!";
    private static final Font FONT_GAME_OVER = Font.getFont((int)64, (int)3, (int)16);
    private static final int COLOR_GAME_OVER = 0xFF0000;
    private static final int COLOR_GAME_OVER_SHADOW = 0x666666;
    private static final long DISPLAY_YOU_WIN_MILLISECONDS = 2000L;
    private static final String HELP_ALERT_TITLE = "Pipes Help...";
    private static final String HELP_ALERT_TEXT = "Rules:\n * To win the game, you must connect all the pipe sections. Connected pipes will turn green.\n * There are no impossible puzzles; every game can be solved.\n * When the puzzle is solved, there will be no dangling sections of pipe. For example, if there is a straight piece along the bottom edge of the board, it MUST be turned so that it runs left-to-right.\n\nControls:\n * Joystick - Move cursor\n * OK/center button - Rotate clockwise\n * #/* buttons - Zoom in/out\n\nAlternate controls:\n * 2/4/6/8 - Move cursor\n  * 3/5 - Rotate clockwise\n * 1 - Rotate counter-clockwise";
    public static final int RESIZE_TEXT_COLOR = 0xFFFFFF;
    public static final int RESIZE_GRIDLINE_COLOR = 0xFFFFFF;
    public static final int CURSOR_COLOR = 0xFFFF00;
    public static final int GRIDLINE_COLOR = 0x646464;
    public static final int DIM_GRIDLINE_COLOR = 0x323232;
    public PlumberTheBumber midlet;
    public AMenu mainmenu;
    public Display display;
    private Image background = null;
    private Image selectbtn = null;
    private Image backbtn = null;
    private Image resetbtn = null;
    private Image key = null;
    private Image firekey = null;
    private Image sizeinkey = null;
    private Image sizeoutkey = null;
    private Image next = null;
    private Image gamebag = null;
    public Player mp1;
    public boolean sound1 = true;
    int paramInt;
    int x1;
    int y1;
    boolean pressFlag;
    boolean dragFlag;
    boolean showPlaySoundFlag;

    public PipesCanvas(PlumberTheBumber midlet) {
        this.setFullScreenMode(true);
        AMenu mainmenu = new AMenu(this);
        this.midlet = midlet;
        this.offscreenGraphics = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.rotate = new Command("Rotate", 1, 1);
        this.reset = new Command("Reset", 1, 2);
        this.resize = new Command("Resize", 1, 3);
        this.help = new Command("Help...", 1, 4);
        this.about = new Command("About...", 1, 5);
        this.quit = new Command("Quit", 1, 6);
        this.ok = new Command("OK", 4, 1);
        this.back = new Command("back", 2, 0);
        this.viewLog = new Command("View log", 1, 2);
        this.setCommandListener(this);
        this.imgYouWin = PipesCanvas.loadImage(new String[]{"/you_win_large.jpg", "/you_win_medium.jpg", "/you_win_small.jpg"}, this.getWidth(), this.getHeight());
    }

    public PipesCanvas(AMenu mainmenu) {
        this.mainmenu = mainmenu;
    }

    public void pointerPressed(int x, int y) {
        this.x1 = x;
        this.y1 = y;
        this.pressFlag = true;
        System.out.println("pipecanvas=ppointerPressed=x=" + x + " =y=" + y);
    }

    public void pointerDragged(int x, int y) {
        System.out.println("pipecanvas=pointerDragged=x=" + x + " =y=" + y);
    }

    public void pointerReleased(int x, int y) {
        System.out.println("pipecanvas=pointerReleased=x=" + x + " =y=" + y);
        if (this.mode == 0) {
            this.key(x, y);
            this.selectbutton(x, y);
            this.backbutton(x, y);
        }
        if (this.mode == 2) {
            this.resizekey(x, y);
            this.selectbutton(x, y);
            this.backbutton(x, y);
        }
        if (this.mode == 4 && x > 0 && x < this.cornerXless && y > this.cornerY) {
            this.keyPressedGameOver(-6);
        }
    }

    public void key(int x, int y) {
        if (x > this.keyX && x < this.keyX + this.keyWDT && y > this.keyY + this.keyHGT && y < this.keyY + this.keyHGT * 2) {
            this.keyPressedGame(-3);
        } else if (x > this.keyX + this.keyWDT * 2 && x < this.keyX + this.keyWDT * 3 && y > this.keyY + this.keyHGT && y < this.keyY + this.keyHGT * 2) {
            this.keyPressedGame(-4);
        } else if (x > this.keyX + this.keyWDT && x < this.keyX + this.keyWDT * 2 && y > this.keyY && y < this.keyY + this.keyHGT) {
            this.keyPressedGame(-1);
        } else if (x > this.keyX + this.keyWDT && x < this.keyX + this.keyWDT * 2 && y > this.keyY + this.keyHGT * 2 && y < this.keyY + this.keyHGT * 3) {
            this.keyPressedGame(-2);
        } else if (x > this.keyX + this.keyWDT && x < this.keyX + this.keyWDT * 2 && y > this.keyY + this.keyHGT && y < this.keyY + this.keyHGT * 2) {
            this.keyPressedGame(-5);
        } else if (x > this.sizeoutkeyX && x < this.sizeoutkeyX + this.keyWDT && y > this.sizeoutkeyY && y < this.sizeoutkeyY + this.keyHGT) {
            this.keyPressedGame(35);
        } else if (x > this.sizeinkeyX && x < this.sizeinkeyX + this.keyWDT && y > this.sizeinkeyY && y < this.sizeinkeyY + this.keyHGT) {
            this.keyPressedGame(42);
        }
    }

    public void resizekey(int x, int y) {
        if (x > this.keyX && x < this.keyX + this.keyWDT && y > this.keyY + this.keyHGT && y < this.keyY + this.keyHGT * 2) {
            this.keyPressedResize(-3);
        } else if (x > this.keyX + this.keyWDT * 2 && x < this.keyX + this.keyWDT * 3 && y > this.keyY + this.keyHGT && y < this.keyY + this.keyHGT * 2) {
            this.keyPressedResize(-4);
        } else if (x > this.keyX + this.keyWDT && x < this.keyX + this.keyWDT * 2 && y > this.keyY && y < this.keyY + this.keyHGT) {
            this.keyPressedResize(-1);
        } else if (x > this.keyX + this.keyWDT && x < this.keyX + this.keyWDT * 2 && y > this.keyY + this.keyHGT * 2 && y < this.keyY + this.keyHGT * 3) {
            this.keyPressedResize(-2);
        }
    }

    public void backbutton(int x, int y) {
        if (x > this.cornerXgreter && y > this.cornerY) {
            this.keyPressedGame(-7);
        }
    }

    public void selectbutton(int x, int y) {
        if (x > 0 && x < this.cornerXless && y > this.cornerY) {
            this.keyPressedGame(-6);
        }
    }

    public boolean isTouchDevice() {
        return this.hasPointerEvents() && this.hasPointerMotionEvents();
    }

    public void showNotify() {
        this.playSound1(this.paramInt);
    }

    public void hideNotify() {
        try {
            this.stopSound(this.paramInt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSound(int paramInt) {
        boolean flag = false;
        try {
            switch (paramInt) {
                case 0: {
                    try {
                        this.mp1 = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/sound/0.mid"), (String)"audio/midi");
                        this.mp1.setLoopCount(-1);
                    }
                    catch (Exception exe) {}
                    break;
                }
                case 1: {
                    try {
                        this.mp1 = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/sound/1.mid"), (String)"audio/midi");
                        this.mp1.setLoopCount(-1);
                    }
                    catch (Exception exe) {}
                    break;
                }
                case 2: {
                    try {
                        this.mp1 = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/sound/2.mid"), (String)"audio/midi");
                        this.mp1.setLoopCount(-1);
                    }
                    catch (Exception exe) {}
                    break;
                }
                case 6: {
                    try {
                        this.mp1 = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/sound/6.mid"), (String)"audio/midi");
                        break;
                    }
                    catch (Exception exe) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean playSound1(int paramInt) {
        boolean i = true;
        this.discardPlayer();
        this.initSound(paramInt);
        if (this.midlet.midletsound) {
            try {
                switch (paramInt) {
                    case 0: {
                        this.mp1.stop();
                        if (this.mp1.getState() == 400) break;
                        this.mp1.start();
                        break;
                    }
                    case 1: {
                        this.mp1.stop();
                        if (this.mp1.getState() == 400) break;
                        this.mp1.start();
                        break;
                    }
                    case 2: {
                        this.mp1.stop();
                        if (this.mp1.getState() == 400) break;
                        this.mp1.start();
                        break;
                    }
                    case 6: {
                        this.mp1.stop();
                        if (this.mp1.getState() == 400) break;
                        this.mp1.start();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return i;
    }

    public boolean stopSound(int paramInt) {
        boolean i = true;
        if (this.midlet.midletsound) {
            try {
                switch (paramInt) {
                    case 0: {
                        if (this.mp1.getState() != 400) break;
                        this.mp1.stop();
                        break;
                    }
                    case 1: {
                        if (this.mp1.getState() != 400) break;
                        this.mp1.stop();
                        break;
                    }
                    case 2: {
                        if (this.mp1.getState() != 400) break;
                        this.mp1.stop();
                        break;
                    }
                    case 6: {
                        if (this.mp1.getState() != 400) break;
                        this.mp1.stop();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return i;
    }

    private void discardPlayer() {
        try {
            try {
                this.mp1.close();
                this.mp1 = null;
            }
            catch (Exception localException1) {}
        }
        catch (Exception localException8) {
            this.mp1 = null;
        }
    }

    private static Image loadImage(String[] filenames, int maxWidth, int maxHeight) {
        if (filenames == null || filenames.length == 0) {
            return null;
        }
        for (int i = 0; i < filenames.length; ++i) {
            Image img = null;
            try {
                img = Image.createImage((String)filenames[i]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (img == null || img.getWidth() > maxWidth || img.getHeight() > maxHeight) continue;
            return img;
        }
        return null;
    }

    public void init() {
        this.initPipeSize();
        this.buildPipes();
        this.scramblePipes();
        this.checkConnections();
        if (this.mode != 0) {
            this.setMode(0);
        }
        Pipe.loadBitmaps();
    }

    private void assertValidCursor() {
        if (this.cursorX < 0) {
            this.cursorX = 0;
        }
        if (this.cursorX >= this.cols) {
            this.cursorX = this.cols - 1;
        }
        if (this.cursorY < 0) {
            this.cursorY = 0;
        }
        if (this.cursorY >= this.rows) {
            this.cursorY = this.rows - 1;
        }
    }

    public void initPipeSize() {
        int sizeX = (this.getWidth() - 1) / this.cols;
        int sizeY = (this.getHeight() - 1) / this.rows;
        while (sizeX % 3 != 1) {
            --sizeX;
        }
        while (sizeY % 3 != 1) {
            --sizeY;
        }
        int size = Math.min(sizeX, sizeY);
        Pipe.setSize(size - 1);
    }

    private void initPipes() {
        this.pipes = new Pipe[this.cols][this.rows];
        for (int x = 0; x < this.cols; ++x) {
            for (int y = 0; y < this.rows; ++y) {
                Pipe pipe = new Pipe();
                this.pipes[x][y] = pipe;
                Pipe b = pipe;
                b.setGridX(x);
                b.setGridY(y);
            }
        }
        this.connectedPipes = new Stack();
        this.toBeChecked = new Stack();
    }

    public void paint(Graphics g) {
        try {
            if (this.background == null) {
                this.background = Image.createImage((String)"/menuback.jpg");
            }
            if (this.selectbtn == null) {
                this.selectbtn = Image.createImage((String)"/select.png");
            }
            if (this.resetbtn == null) {
                this.resetbtn = Image.createImage((String)"/reset.png");
            }
            if (this.backbtn == null) {
                this.backbtn = Image.createImage((String)"/back.png");
            }
            if (this.next == null) {
                this.next = Image.createImage((String)"/next.png");
            }
            if (this.key == null) {
                this.key = Image.createImage((String)"/key.png");
            }
            if (this.sizeinkey == null) {
                this.sizeinkey = Image.createImage((String)"/sizeinkey.png");
            }
            if (this.sizeoutkey == null) {
                this.sizeoutkey = Image.createImage((String)"/sizeoutkey.png");
            }
            Graphics offscreen = this.offscreenGraphics.getGraphics();
            this.paintPipes(offscreen);
            if (this.mode == 3) {
                this.paintAbout(offscreen);
            } else if (this.mode == 1) {
                if (this.imgYouWin != null) {
                    this.backbtn = null;
                    this.stopSound(1);
                    offscreen.drawImage(this.imgYouWin, this.getWidth() / 2, this.getHeight() / 2, 3);
                } else {
                    int x = (this.getWidth() - FONT_GAME_OVER.stringWidth(MESSAGE_GAME_OVER)) / 2;
                    int y = (this.getHeight() - FONT_GAME_OVER.getHeight()) / 2;
                    offscreen.setFont(FONT_GAME_OVER);
                    offscreen.setColor(0x666666);
                    offscreen.drawString(MESSAGE_GAME_OVER, x + 1, y + 1, 20);
                    offscreen.setColor(0xFF0000);
                    offscreen.drawString(MESSAGE_GAME_OVER, x - 1, y - 1, 20);
                }
            }
            g.drawImage(this.offscreenGraphics, 0, 0, 20);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void paintPipes(Graphics g) {
        int i;
        int yOffset;
        int xOffset;
        g.setColor(5047560);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mode == 0) {
            g.drawImage(this.resetbtn, 0, this.midlet.height, 36);
            g.drawImage(this.backbtn, this.midlet.width, this.midlet.height, 40);
        }
        if (this.mode == 2) {
            g.drawImage(this.backbtn, this.midlet.width, this.midlet.height, 40);
            g.drawImage(this.selectbtn, 0, this.midlet.height, 36);
        }
        if (this.mode == 4) {
            this.stopSound(0);
            this.playSound1(2);
            g.drawImage(this.next, 0, this.midlet.height, 36);
        }
        int gridWidth = this.cols * (Pipe.getSize() + 1) + 1;
        int gridHeight = this.rows * (Pipe.getSize() + 1) + 1;
        if (gridWidth <= this.getWidth()) {
            xOffset = (this.getWidth() - gridWidth) / 2;
        } else {
            int cursorLeft = this.cursorX * (Pipe.getSize() + 1);
            xOffset = -(cursorLeft + Pipe.getSize() / 2 - this.getWidth() / 2);
            xOffset = Math.min(xOffset, 0);
            xOffset = Math.max(xOffset, this.getWidth() - gridWidth);
        }
        if (gridHeight + 43 * this.gridblock <= this.getHeight()) {
            yOffset = (this.getHeight() - gridHeight) / 2 - this.DecmaxwindoY;
        } else {
            int cursorTop = this.cursorY * (Pipe.getSize() + 1);
            yOffset = -(cursorTop + Pipe.getSize() / 2 - this.getHeight() / 2);
            yOffset = Math.min(yOffset, 0);
            yOffset = Math.max(yOffset, this.getHeight() - gridHeight - 43 * this.gridblock);
        }
        PlumberTheBumber.log("g.translate(" + xOffset + ", " + yOffset + ")");
        g.translate(xOffset, yOffset);
        if (this.mode != 2) {
            for (int x = 0; x < this.cols; ++x) {
                for (int y = 0; y < this.rows; ++y) {
                    this.pipes[x][y].paint(g, this.mode != 3);
                }
            }
            if (this.mode != 3) {
                g.setColor(0x646464);
            } else {
                g.setColor(0x323232);
            }
        } else {
            g.setColor(0xFFFFFF);
        }
        for (i = 0; i <= this.rows * (Pipe.getSize() + 1); i += Pipe.getSize() + 1) {
            g.drawLine(0, i, this.cols * (Pipe.getSize() + 1), i);
        }
        for (i = 0; i <= this.cols * (Pipe.getSize() + 1); i += Pipe.getSize() + 1) {
            g.drawLine(i, 0, i, this.rows * (Pipe.getSize() + 1));
        }
        if (this.mode == 0) {
            g.setColor(0xFFFF00);
            g.drawRect(this.cursorX * (Pipe.getSize() + 1), this.cursorY * (Pipe.getSize() + 1), Pipe.getSize() + 1, Pipe.getSize() + 1);
        }
        g.translate(-xOffset, -yOffset);
        if (this.mode == 2) {
            this.moderesize(g);
        }
        if (this.mode == 0 && this.isTouchDevice()) {
            g.drawImage(this.key, this.keyXPOZ, this.keyYPOZ, 0);
            g.drawImage(this.sizeinkey, this.sizeoutkeyX, this.sizeoutkeyY, 0);
            g.drawImage(this.sizeoutkey, this.sizeinkeyX, this.sizeinkeyY, 0);
        }
        if (this.mode == 2 && this.isTouchDevice()) {
            g.drawImage(this.key, this.keyXPOZ, this.keyYPOZ, 0);
        }
    }

    public void moderesize(Graphics g) {
        String msg = this.cols + " x " + this.rows;
        Font font = Font.getDefaultFont();
        g.setFont(font);
        int msgWidth = font.stringWidth(msg);
        int msgHeight = font.getHeight();
        int msgXOffset = (this.getWidth() - msgWidth) / 2;
        int msgYOffset = (this.getHeight() - msgHeight) / 2;
        g.setColor(0xFFFFFF);
        g.drawString(msg, this.getWidth() - msgWidth, 0, 20);
        String pixelSize = "Pipe size: " + Pipe.getSize() + "px";
        g.setColor(0xFFFFFF);
        g.drawString(pixelSize, 0, 0, 20);
    }

    private void paintAbout(Graphics g) {
        int y = 0;
        g.setColor(0xFFFFFF);
        for (int i = 0; i < PlumberTheBumber.aboutText.length; ++i) {
            String line;
            if (i == 0) {
                line = "Pipes " + PlumberTheBumber.getInstance().getAppProperty("MIDlet-Version");
                line = line + "d";
            } else {
                line = PlumberTheBumber.aboutText[i];
            }
            if (PlumberTheBumber.largeFont.stringWidth(line) < this.getWidth()) {
                g.setFont(PlumberTheBumber.largeFont);
            } else if (PlumberTheBumber.mediumFont.stringWidth(line) < this.getWidth()) {
                g.setFont(PlumberTheBumber.mediumFont);
            } else {
                g.setFont(PlumberTheBumber.smallFont);
            }
            g.drawString(line, this.getWidth() / 2, y, 17);
            y += g.getFont().getHeight();
        }
    }

    protected void keyRepeated(int i) {
        this.keyPressed(i);
    }

    protected void keyPressed(int i) {
        switch (this.mode) {
            case 0: {
                this.keyPressedGame(i);
                break;
            }
            case 1: {
                this.keyPressedYouWin(i);
                break;
            }
            case 4: {
                this.keyPressedGameOver(i);
                break;
            }
            case 2: {
                this.keyPressedResize(i);
                break;
            }
            case 3: {
                this.setMode(0);
                this.repaint();
            }
        }
    }

    private void keyPressedGame(int i) {
        switch (i) {
            case 42: {
                this.zoomOut();
                this.repaint();
                break;
            }
            case 35: {
                this.zoomIn();
                this.repaint();
                break;
            }
            case -1: 
            case 50: {
                --this.cursorY;
                if (this.cursorY < 0) {
                    this.cursorY = this.rows - 1;
                }
                this.repaint();
                break;
            }
            case -2: 
            case 56: {
                ++this.cursorY;
                if (this.cursorY >= this.rows) {
                    this.cursorY = 0;
                }
                this.repaint();
                break;
            }
            case -3: 
            case 52: {
                --this.cursorX;
                if (this.cursorX < 0) {
                    this.cursorX = this.cols - 1;
                }
                this.repaint();
                break;
            }
            case -4: 
            case 54: {
                ++this.cursorX;
                if (this.cursorX >= this.cols) {
                    this.cursorX = 0;
                }
                this.repaint();
                break;
            }
            case -5: 
            case 53: {
                this.pipes[this.cursorX][this.cursorY].rotate(true);
                this.checkConnections();
                this.repaint();
                break;
            }
            case -6: {
                this.init();
                this.repaint();
                break;
            }
            case -7: {
                this.resetbtn = null;
                this.backbtn = null;
                this.discardPlayer();
                this.midlet.set(1);
                this.repaint();
            }
        }
    }

    private void keyPressedYouWin(int i) {
        this.keyPressedGameOver(i);
    }

    private void keyPressedGameOver(int i) {
        switch (i) {
            case -6: {
                this.commandAction(this.reset, (Displayable)this);
            }
        }
    }

    public void keyPressedResize(int i) {
        switch (i) {
            case -1: 
            case 50: {
                if (this.rows < 30) {
                    ++this.rows;
                }
                this.initPipeSize();
                if (Pipe.getSize() < 3) {
                    --this.rows;
                    this.initPipeSize();
                }
                this.repaint();
                break;
            }
            case -3: 
            case 52: {
                if (this.cols <= 2) break;
                --this.cols;
                this.initPipeSize();
                this.repaint();
                break;
            }
            case -2: 
            case 56: {
                if (this.rows <= 2) break;
                --this.rows;
                this.initPipeSize();
                this.repaint();
                break;
            }
            case -4: 
            case 54: {
                if (this.cols < 30) {
                    ++this.cols;
                }
                this.initPipeSize();
                if (Pipe.getSize() < 3) {
                    --this.cols;
                    this.initPipeSize();
                }
                this.repaint();
                break;
            }
            case -6: 
            case -5: 
            case 53: {
                this.commandAction(this.ok, (Displayable)this);
                break;
            }
            case -7: {
                this.resetbtn = null;
                this.backbtn = null;
                this.discardPlayer();
                this.midlet.set(1);
            }
        }
    }

    private Pipe getPipe(int x, int y) {
        if (x < 0 || x >= this.cols || y < 0 || y >= this.rows) {
            return null;
        }
        return this.pipes[x][y];
    }

    private void buildPipes() {
        this.initPipes();
        Vector<Pipe> connected = new Vector<Pipe>(this.rows * this.cols);
        connected.addElement(this.pipes[Math.abs(this.random.nextInt()) % this.cols][Math.abs(this.random.nextInt()) % this.rows]);
        Pipe p2 = null;
        int reverseDirection = 0;
        while (connected.size() < connected.capacity()) {
            Pipe p = (Pipe)connected.elementAt(Math.abs(this.random.nextInt()) % connected.size());
            int direction = 1 << Math.abs(this.random.nextInt()) % 4;
            switch (direction) {
                case 1: {
                    p2 = this.getPipe(p.getGridX(), p.getGridY() - 1);
                    reverseDirection = 4;
                    break;
                }
                case 4: {
                    p2 = this.getPipe(p.getGridX(), p.getGridY() + 1);
                    reverseDirection = 1;
                    break;
                }
                case 8: {
                    p2 = this.getPipe(p.getGridX() - 1, p.getGridY());
                    reverseDirection = 2;
                    break;
                }
                case 2: {
                    p2 = this.getPipe(p.getGridX() + 1, p.getGridY());
                    reverseDirection = 8;
                }
            }
            if (p2 == null || p2.getConnections() != 0) continue;
            p.setConnected(direction, true);
            p2.setConnected(reverseDirection, true);
            connected.addElement(p2);
            this.repaint();
        }
    }

    private void scramblePipes() {
        for (int x = 0; x < this.cols; ++x) {
            for (int y = 0; y < this.rows; ++y) {
                Pipe p = this.pipes[x][y];
                int rotations = Math.abs(this.random.nextInt()) % 20;
                for (int i = 0; i < rotations; ++i) {
                    p.rotate(true);
                }
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.reset) {
            this.init();
        } else if (command == this.resize) {
            this.setMode(2);
            this.repaint();
        } else if (command == this.ok) {
            this.setMode(0);
            this.repaint();
        }
    }

    public void checkConnections() {
        while (this.connectedPipes.size() > 0) {
            ((Pipe)this.connectedPipes.pop()).setInConnectedSet(false);
        }
        Pipe p = this.pipes[this.cols / 2][this.rows / 2];
        this.connectedPipes.addElement(p);
        this.toBeChecked.addElement(p);
        p.setInConnectedSet(true);
        while (!this.toBeChecked.empty()) {
            Pipe p2;
            p = (Pipe)this.toBeChecked.pop();
            int x = p.getGridX();
            int y = p.getGridY();
            if (p.isConnected(1) && (p2 = this.getPipe(x, y - 1)) != null && p2.isConnected(4) && !p2.isInConnectedSet()) {
                this.connectedPipes.addElement(p2);
                this.toBeChecked.addElement(p2);
                p2.setInConnectedSet(true);
            }
            if (p.isConnected(4) && (p2 = this.getPipe(x, y + 1)) != null && p2.isConnected(1) && !p2.isInConnectedSet()) {
                this.connectedPipes.addElement(p2);
                this.toBeChecked.addElement(p2);
                p2.setInConnectedSet(true);
            }
            if (p.isConnected(8) && (p2 = this.getPipe(x - 1, y)) != null && p2.isConnected(2) && !p2.isInConnectedSet()) {
                this.connectedPipes.addElement(p2);
                this.toBeChecked.addElement(p2);
                p2.setInConnectedSet(true);
            }
            if (!p.isConnected(2) || (p2 = this.getPipe(x + 1, y)) == null || !p2.isConnected(8) || p2.isInConnectedSet()) continue;
            this.connectedPipes.addElement(p2);
            this.toBeChecked.addElement(p2);
            p2.setInConnectedSet(true);
        }
        if (this.connectedPipes.size() == this.rows * this.cols) {
            this.setMode(1);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.playSound1(0);
        this.paramInt = 0;
        int oldMode = this.mode;
        this.mode = mode;
        this.removeCommand(this.ok);
        this.removeCommand(this.rotate);
        this.removeCommand(this.reset);
        this.removeCommand(this.resize);
        this.removeCommand(this.quit);
        this.removeCommand(this.about);
        this.removeCommand(this.help);
        switch (mode) {
            case 0: {
                if (oldMode != 3 && oldMode != 0) {
                    this.stopSound(0);
                    this.playSound1(1);
                    this.paramInt = 1;
                    this.init();
                }
                this.checkConnections();
                break;
            }
            case 1: {
                this.initPipeSize();
                Pipe.loadBitmaps();
                this.repositionPipes();
                new Timer().schedule((TimerTask)new HideYouWinTask(), 2000L);
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                this.initPipeSize();
                break;
            }
            case 3: {
                this.addCommand(this.ok);
            }
        }
    }

    public void save() throws RecordStoreException {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            byte[] size = new byte[]{(byte)this.cols, (byte)this.rows};
            try {
                rs.setRecord(1, size, 0, size.length);
            }
            catch (InvalidRecordIDException e) {
                rs.addRecord(size, 0, size.length);
            }
            byte[] pipesBytes = new byte[this.rows * this.cols];
            int i = 0;
            for (int y = 0; y < this.rows; ++y) {
                for (int x = 0; x < this.cols; ++x) {
                    pipesBytes[i] = this.pipes[x][y].getConnections();
                    ++i;
                }
            }
            try {
                rs.setRecord(2, pipesBytes, 0, pipesBytes.length);
            }
            catch (InvalidRecordIDException e) {
                rs.addRecord(pipesBytes, 0, pipesBytes.length);
            }
            rs.closeRecordStore();
        }
        catch (Throwable t) {
            try {
                rs.closeRecordStore();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
            try {
                RecordStore.deleteRecordStore((String)STORE_NAME);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws RecordStoreException {
        boolean success;
        block24: {
            success = true;
            try {
                RecordStore rs = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
                try {
                    byte[] size = rs.getRecord(1);
                    this.cols = size[0];
                    this.rows = size[1];
                    if (this.cols > 0 && this.rows > 0) {
                        this.initPipeSize();
                        try {
                            byte[] pipesBytes = rs.getRecord(2);
                            this.initPipes();
                            int i = 0;
                            for (int y = 0; y < this.rows; ++y) {
                                for (int x = 0; x < this.cols; ++x) {
                                    this.pipes[x][y].setConnections(pipesBytes[i]);
                                    ++i;
                                    if (this.pipes[x][y].getConnections() != 0) continue;
                                    success = false;
                                }
                            }
                            if (success) {
                                this.checkConnections();
                            }
                            break block24;
                        }
                        catch (InvalidRecordIDException e) {
                            success = false;
                        }
                        break block24;
                    }
                    success = false;
                }
                catch (Exception e) {
                    try {
                        rs.closeRecordStore();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        RecordStore.deleteRecordStore((String)STORE_NAME);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                finally {
                    try {
                        rs.closeRecordStore();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (RecordStoreNotFoundException e) {
                success = false;
            }
        }
        if (!success) {
            this.rows = 8;
            this.cols = 8;
            this.init();
        }
    }

    public void showAbout(long time) {
        this.setMode(3);
        this.repaint();
        new Timer().schedule((TimerTask)new CloseAboutTask(), time);
    }

    private void zoomOut() {
        Pipe.decrementSize();
        Pipe.loadBitmaps();
        this.repositionPipes();
    }

    private void zoomIn() {
        Pipe.incrementSize();
        Pipe.loadBitmaps();
        this.repositionPipes();
    }

    private void repositionPipes() {
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                this.pipes[x][y].setX();
                this.pipes[x][y].setY();
            }
        }
    }

    private class HideYouWinTask
    extends TimerTask {
        private HideYouWinTask() {
        }

        public void run() {
            if (PipesCanvas.this.mode == 1) {
                PipesCanvas.this.setMode(4);
                PipesCanvas.this.repaint();
            }
        }
    }

    private class CloseAboutTask
    extends TimerTask {
        private CloseAboutTask() {
        }

        public void run() {
            if (PipesCanvas.this.mode == 3) {
                PipesCanvas.this.setMode(0);
                PipesCanvas.this.repaint();
            }
        }
    }
}

