/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame;

import com.pipogame.GameScreen;
import com.pipogame.ScreenManager;

public abstract class AbstractLoadingScreen
extends GameScreen {
    protected float percentLoaded;

    public void setPercentLoaded(float percentLoaded) {
        if (percentLoaded > this.percentLoaded) {
            this.percentLoaded = percentLoaded;
        }
    }

    public static void loadScreen(final ScreenManager screenManager, final AbstractLoadingScreen loadingScreen) {
        screenManager.removeAllScreens();
        screenManager.addScreen(loadingScreen);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    GameScreen loadedScreen = loadingScreen.getScreenToLoad();
                    loadedScreen.screenManager = screenManager;
                    if (!loadedScreen.initialized) {
                        loadedScreen.initialize();
                    }
                    loadedScreen.loadContent();
                    screenManager.removeAllScreens();
                    screenManager.addScreen(loadedScreen);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread loadThread = new Thread(runnable);
        loadThread.setPriority(1);
        loadThread.start();
    }

    public abstract GameScreen getScreenToLoad();
}

