/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame;

import com.pipogame.components.InitFromString;
import com.pipogame.util.Util;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;

public class Store {
    protected Hashtable settings;
    String recordName;
    public static String splitor = new String(new char[]{'\u0007'}, 0, 1);
    public static String partSplitor = new String(new char[]{'\u0000'}, 0, 1);
    public static final int splitorLeng = splitor.length();
    static final String subKey = "__sub";
    StringBuffer buffer = new StringBuffer(200);
    public static String ENC_UTF8 = "UTF-8";
    public static String EMPTY_STRING = "";
    public static String EXTENSION = "_REC_st";
    public static final int LOAD_FROM_RECORDSTORE = 1;
    public static final int LOAD_FROM_JAR = 2;
    private static final String hiscoKey = "hisco_XhVhQ";
    public static final int MAX_HIGH_SCORES = 10;
    private static final int[] HIGH_SCORE = new int[10];

    public Store(String recordName, int loadFrom) {
        this.settings = new Hashtable(10);
        this.recordName = recordName + EXTENSION;
        switch (loadFrom) {
            case 2: {
                this.loadFromJar();
                break;
            }
            case 1: {
                this.loadSetting();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported loader");
            }
        }
    }

    public static Store loadJar(String fullFilePath) {
        return new Store(fullFilePath, 2);
    }

    private void loadSetting() {
        block5: {
            RecordStore store = null;
            try {
                store = RecordStore.openRecordStore((String)this.recordName, (boolean)false);
                if (store == null) {
                    return;
                }
                byte[] record = store.getRecord(1);
                this.getAllSettings(new String(record, ENC_UTF8));
                store.closeRecordStore();
            }
            catch (Exception ex) {
                if (store == null) break block5;
                try {
                    store.closeRecordStore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.privateGetHighScore();
    }

    private void loadFromJar() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.recordName);
            byte[] buf = new byte[inputStream.available()];
            inputStream.read(buf);
            this.getAllSettings(new String(buf, ENC_UTF8));
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try {
            RecordStore.deleteRecordStore((String)this.recordName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)this.recordName, (boolean)true, (int)0, (boolean)true);
            if (store == null) {
                return;
            }
            byte[] record = this.prepairSettings();
            store.addRecord(record, 0, record.length);
            store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void set(String key, String value) {
        this.settings.put(key, value);
    }

    public String getString(String key) {
        Object o = this.settings.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public String getString(int keyNumber) {
        return this.getString(EMPTY_STRING + keyNumber);
    }

    private void getAllSettings(String s) {
        int nextLineIdx;
        this.settings.clear();
        int start = 0;
        while (start < s.length() && (nextLineIdx = s.indexOf(splitor, start)) > 0) {
            String key = s.substring(start, nextLineIdx);
            start = nextLineIdx + splitorLeng;
            nextLineIdx = s.indexOf(splitor, start);
            String value = s.substring(start, nextLineIdx);
            start = nextLineIdx + splitorLeng;
            this.settings.put(key, value);
        }
    }

    private byte[] prepairSettings() {
        try {
            this.clearBuffer();
            Enumeration e = this.settings.keys();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                this.buffer.append(o).append(splitor).append(this.settings.get(o)).append(splitor);
            }
            return this.buffer.toString().getBytes(ENC_UTF8);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void clearBuffer() {
        this.buffer.delete(0, this.buffer.length());
    }

    public void set(String key, int value) {
        this.settings.put(key, EMPTY_STRING + value);
    }

    public int getInt(String key) {
        String value = (String)this.settings.get(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public int changeInt(String key, int quantity) {
        int result = this.getInt(key);
        this.set(key, result += quantity);
        return result;
    }

    public void set(String key, boolean value) {
        this.settings.put(key, EMPTY_STRING + value);
    }

    public boolean getBoolean(String key) {
        String value = (String)this.settings.get(key);
        if (value != null) {
            return value.startsWith("true");
        }
        return false;
    }

    public boolean contains(String key) {
        return this.settings.containsKey(key);
    }

    public void set(String key, int[] array) {
        this.clearBuffer();
        for (int i = 0; i < array.length; ++i) {
            this.buffer.append(array[i]).append(partSplitor);
        }
        this.settings.put(key, this.buffer.toString());
    }

    public int[] getIntArray(String key) {
        String arrayInString = (String)this.settings.get(key);
        int[] array = null;
        if (arrayInString != null) {
            String[] strings2 = Util.splitString(arrayInString, partSplitor);
            array = new int[strings2.length];
            for (int i = 0; i < strings2.length; ++i) {
                array[i] = Integer.parseInt(strings2[i]);
            }
        }
        return array;
    }

    public void set(String key, int[][] value) {
        this.clearBuffer();
        int ii = value.length;
        int jj = value[0].length;
        this.buffer.append(ii).append(partSplitor).append(ii);
        this.settings.put(key + subKey, this.buffer.toString());
        this.clearBuffer();
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                this.buffer.append(value[i][j]).append(partSplitor);
            }
        }
        this.settings.put(key, this.buffer.toString());
    }

    public int[][] get2DArray(String key) {
        String[] array = Util.splitString((String)this.settings.get(key + subKey), partSplitor);
        int ii = Integer.parseInt(array[0]);
        int jj = Integer.parseInt(array[1]);
        int[][] result = new int[ii][jj];
        array = Util.splitString((String)this.settings.get(key), partSplitor);
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                result[i][j] = Integer.parseInt(array[i * jj + j]);
            }
        }
        return result;
    }

    public void set(String key, InitFromString[] array) {
        this.clearBuffer();
        for (int i = 0; i < array.length; ++i) {
            this.buffer.append(array[i].toString()).append(partSplitor);
        }
        this.settings.put(key, this.buffer.toString());
    }

    public void getArray(String key, InitFromString[] array) {
        String value = this.getString(key);
        if (value != null) {
            String[] values = Util.splitString(value, partSplitor);
            for (int i = 0; i < values.length; ++i) {
                array[i].init(values[i]);
            }
        }
    }

    public void delete(String key) {
        this.settings.remove(key);
    }

    private void privateGetHighScore() {
        String hisco = this.getString(hiscoKey);
        if (hisco != null) {
            String[] highScores = Util.splitString(hisco, partSplitor);
            for (int i = 0; i < highScores.length; ++i) {
                Store.HIGH_SCORE[i] = Integer.parseInt(highScores[i]);
            }
        }
    }

    public int[] getHighScores() {
        int[] hs = new int[HIGH_SCORE.length];
        System.arraycopy(HIGH_SCORE, 0, hs, 0, hs.length);
        return hs;
    }

    public int newHighScore(int newHS) {
        if (newHS > HIGH_SCORE[0]) {
            Store.HIGH_SCORE[0] = newHS;
            Util.sort(HIGH_SCORE);
        }
        this.set(hiscoKey, HIGH_SCORE);
        for (int i = 0; i < HIGH_SCORE.length; ++i) {
            if (HIGH_SCORE[i] != newHS) continue;
            return i;
        }
        return -1;
    }
}

