/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.Rect;
import com.pipogame.fad.GameplayScreen;
import com.pipogame.fad.SmsDecode;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import com.pipogame.util.PFont;
import com.pipogame.util.SMSender;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BagScreen
extends GameScreen {
    Image bgrImage;
    Image[] itemImages;
    Image onItemImage;
    Image onButtonImage;
    private SMSender smsSender;
    private int selectedItem;
    private int silver;
    private int gold;
    private int[] itemAvailable = new int[6];
    private boolean used;
    private byte[][][] descriptionText;
    private int textX = 15;
    private int textY = 115;
    private Rect exitRect;
    private Rect useRect;
    GameplayScreen gameplayScreen;
    public int bgr_x = 29;
    public int bgr_y = 67;
    private int menu_y = 179;
    private int[] menu_x = new int[3];
    private int menuClickTimeCouter;
    private static final int CLICK_TIME = 250;
    private int menuClicked = -1;
    public static final int[] X = new int[3];
    public static final int[] Y = new int[2];
    private Image exitBtnImage;
    private Image buyBtnImage;
    private Image useBtnImage;

    public BagScreen(GameplayScreen screen) {
        this.gameplayScreen = screen;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 350;
        this.silver = this.screenManager.store.getInt(strings.SILVER);
        this.gold = this.screenManager.store.getInt(strings.GOLD);
        this.setTimeCancelInput(300);
        this.smsSender = new SMSender();
        BagScreen.X[0] = 62;
        BagScreen.X[1] = 103;
        BagScreen.X[2] = 143;
        BagScreen.Y[0] = 57;
        BagScreen.Y[1] = 94;
        this.menu_x[0] = 17;
        this.menu_x[1] = 80;
        this.menu_x[2] = 144;
    }

    public void loadContent() throws Exception {
        int j;
        super.loadContent();
        this.asset = Store.loadJar("/res/desc/Shop3");
        this.descriptionText = new byte[6][][];
        this.bgrImage = ImageTool.createImage(_width, _height);
        Graphics g = this.bgrImage.getGraphics();
        g.drawImage(this.gameplayScreen.bgrImage, 0, 0, 0);
        Drawer.drawBg(g, 0, 0, _width, _height, -1728053248);
        Image i = this.loadImage(0);
        this.bgr_x = (_width - i.getWidth()) / 2;
        this.bgr_y = (_height - i.getHeight()) / 2;
        g.drawImage(i, this.bgr_x, this.bgr_y, 0);
        this.itemImages = new Image[6];
        this.itemImages[0] = this.loadImage(1);
        this.itemImages[1] = this.loadImage(2);
        this.itemImages[2] = this.loadImage(3);
        this.itemImages[3] = this.loadImage(4);
        this.itemImages[4] = this.loadImage(5);
        this.itemImages[5] = this.loadImage(6);
        Image itemTrayImage = this.loadImage(7);
        this.onItemImage = this.loadImage(8);
        this.onButtonImage = this.loadImage(9);
        this.exitBtnImage = this.loadImage(10);
        this.buyBtnImage = this.loadImage(11);
        this.useBtnImage = this.loadImage(12);
        Image goldImage = this.loadImage(13);
        Image silverImage = this.loadImage(14);
        int width = this.exitBtnImage.getWidth();
        int height = this.exitBtnImage.getHeight();
        this.exitRect = new Rect(this.bgr_x + this.menu_x[0], this.bgr_y + this.menu_y, width, height);
        this.useRect = new Rect(this.bgr_x + this.menu_x[1], this.bgr_y + this.menu_y, width, height);
        for (j = 0; j < 6; ++j) {
            Drawer.drawCenter(g, itemTrayImage, this.bgr_x + X[j % 3], this.bgr_y + Y[j / 3]);
            Drawer.drawCenter(g, this.itemImages[j], this.bgr_x + X[j % 3], this.bgr_y + Y[j / 3]);
        }
        g.drawImage(goldImage, this.bgr_x + 12, this.bgr_y + 27, 0);
        g.drawImage(silverImage, this.bgr_x + 172, this.bgr_y + 27, 0);
        for (j = 0; j < 6; ++j) {
            this.descriptionText[j] = PFont.breakString(this.asset.getString(15 + j), 170);
        }
        Store store = this.screenManager.store;
        this.itemAvailable[0] = store.getInt(strings.LIFE);
        this.itemAvailable[1] = store.getInt(strings.TIME);
        this.itemAvailable[2] = store.getInt(strings.EXCHANGE);
        this.itemAvailable[3] = store.getInt(strings.BOOM);
        this.itemAvailable[4] = store.getInt(strings.AXE);
        this.itemAvailable[5] = store.getInt(strings.THUNDERBOLT);
    }

    public void handleInput(Input input, int frameTime) {
        block9: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                if (!input.isUpPrd() && !input.isDownPrd()) break block8;
                                this.selectedItem = (this.selectedItem + 3) % 6;
                                break block9;
                            }
                            if (!input.isLeftPrd()) break block10;
                            this.selectedItem = (this.selectedItem + 5) % 6;
                            break block9;
                        }
                        if (!input.isRightPrd()) break block11;
                        this.selectedItem = (this.selectedItem + 1) % 6;
                        break block9;
                    }
                    if (!input.isSoftLeftPrd() && !input.touched(this.exitRect)) break block12;
                    this.screenManager.addScreen(this.gameplayScreen);
                    this.gameplayScreen.resume();
                    this.exitScreen();
                    this.menuClicked = 0;
                    break block9;
                }
                if (!input.isFirePrd() && !input.touched(this.useRect)) break block13;
                if (this.itemAvailable[this.selectedItem] > 0) {
                    this.useItem(this.selectedItem);
                    if (this.selectedItem > 1) {
                        this.screenManager.addScreen(this.gameplayScreen);
                        this.gameplayScreen.resume();
                        this.exitScreen();
                    }
                } else {
                    try {
                        if (SmsDecode.getNummerMobile(this.selectedItem) > 0 && this.smsSender.send(SmsDecode.getStringSms(this.selectedItem), SmsDecode.getNummerMobile(0))) {
                            int n = this.selectedItem;
                            this.itemAvailable[n] = this.itemAvailable[n] + 3;
                            this.save(this.selectedItem);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.selectedItem <= 0) break block9;
                this.menuClicked = 1;
                break block9;
            }
            if (input.isTouchUp()) {
                for (int i = 0; i < 6; ++i) {
                    if (!input.touched(this.bgr_x + X[i % 3] - 15, this.bgr_y + Y[i / 3] - 20, 33, 33)) continue;
                    this.selectedItem = i;
                    break;
                }
            }
        }
    }

    public void useDone() {
        this.used = false;
    }

    public void useItem(int selectedItem) {
        if (this.itemAvailable[selectedItem] <= 0) {
            return;
        }
        switch (selectedItem) {
            case 1: {
                if (!this.gameplayScreen.useTime()) break;
                int n = selectedItem;
                this.itemAvailable[n] = this.itemAvailable[n] - 1;
                break;
            }
            case 2: {
                if (this.used) break;
                this.gameplayScreen.useSpecialItem((byte)4);
                this.used = true;
                int n = selectedItem;
                this.itemAvailable[n] = this.itemAvailable[n] - 1;
                break;
            }
            case 3: {
                if (this.used) break;
                this.gameplayScreen.useSpecialItem((byte)1);
                this.used = true;
                int n = selectedItem;
                this.itemAvailable[n] = this.itemAvailable[n] - 1;
                break;
            }
            case 4: {
                if (this.used) break;
                this.gameplayScreen.useSpecialItem((byte)3);
                this.used = true;
                int n = selectedItem;
                this.itemAvailable[n] = this.itemAvailable[n] - 1;
                break;
            }
            case 5: {
                if (this.used) break;
                this.gameplayScreen.useSpecialItem((byte)2);
                this.used = true;
                int n = selectedItem;
                this.itemAvailable[n] = this.itemAvailable[n] - 1;
            }
        }
        if (selectedItem > 1) {
            this.gameplayScreen.noMove = false;
        }
        this.save(selectedItem);
    }

    public void save(int itemToSave) {
        String itemName = null;
        switch (itemToSave) {
            case 0: {
                itemName = strings.LIFE;
                break;
            }
            case 1: {
                itemName = strings.TIME;
                break;
            }
            case 2: {
                itemName = strings.EXCHANGE;
                break;
            }
            case 3: {
                itemName = strings.BOOM;
                break;
            }
            case 4: {
                itemName = strings.AXE;
                break;
            }
            case 5: {
                itemName = strings.THUNDERBOLT;
            }
        }
        this.screenManager.store.set(itemName, this.itemAvailable[itemToSave]);
    }

    public void update(int frameTime, boolean covered) {
        if (this.menuClicked >= 0) {
            this.menuClickTimeCouter += frameTime;
            if (this.menuClickTimeCouter > 250) {
                this.menuClickTimeCouter = 0;
                this.menuClicked = -1;
            }
        }
    }

    public void draw(Graphics g, int frameTime) {
        int i;
        g.setColor(0xF0F0F0);
        g.fillRect(0, 0, _width, _height);
        g.drawImage(this.bgrImage, 0, 0, 0);
        Drawer.drawCenter(g, this.onItemImage, this.bgr_x + X[this.selectedItem % 3], this.bgr_y + Y[this.selectedItem / 3]);
        PFont.drawNumber(g, this.gold, this.bgr_x + 30, this.bgr_y + 24, -256);
        PFont.drawNumberL(g, this.silver, this.bgr_x + 170, this.bgr_y + 24, -1);
        g.drawImage(this.exitBtnImage, this.bgr_x + this.menu_x[0], this.bgr_y + this.menu_y, 0);
        if (this.itemAvailable[this.selectedItem] > 0 && this.selectedItem > 0) {
            g.drawImage(this.useBtnImage, this.bgr_x + this.menu_x[1], this.bgr_y + this.menu_y, 0);
        } else if (this.itemAvailable[this.selectedItem] <= 0) {
            g.drawImage(this.buyBtnImage, this.bgr_x + this.menu_x[1], this.bgr_y + this.menu_y, 0);
        }
        if (this.menuClicked >= 0) {
            g.drawImage(this.onButtonImage, this.bgr_x + this.menu_x[this.menuClicked] - 1, this.bgr_y + this.menu_y - 1, 0);
        }
        for (i = 0; i < this.descriptionText[this.selectedItem].length; ++i) {
            PFont.drawString(g, this.bgr_x + this.textX, this.bgr_y + this.textY + i * 17, this.descriptionText[this.selectedItem][i], -1);
        }
        for (i = 0; i < this.itemAvailable.length; ++i) {
            PFont.drawNumber(g, this.itemAvailable[i], this.bgr_x + X[i % 3] - 15, this.bgr_y + Y[i / 3] - 20, -256);
        }
    }

    public void finalize() {
        this.bgrImage = null;
        this.itemImages = null;
        this.onItemImage = null;
        this.onButtonImage = null;
        this.descriptionText = null;
        this.useRect = null;
        this.exitRect = null;
        this.asset = null;
        super.finalize();
    }

    public void onExitGame() {
        this.gameplayScreen.save();
    }
}

