/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.components.Point;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.strings;
import com.pipogame.util.ImageTool;
import com.pipogame.util.MathExt;
import com.pipogame.util.Util;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CollectionScreen
extends GameScreen {
    private Image cupImage;
    private Image bgrImage;
    private Image[] imageItems;
    private Point[] positions;
    private int[] imageIndex;
    private int itemsPerLine;
    private int itemsPerPage;
    private int page;
    private int totalPage;
    private int bgr_y;
    private int dir;
    private int timeCounter = 300;
    private static final int TIME = 300;
    private GameSprite[] starringSprites;
    private boolean playStarring;
    private Point[] starPos;

    public void loadContent() throws Exception {
        super.loadContent();
        this.transitionOffTime = 100;
        this.setTimeCancelInput(500);
        this.asset = Store.loadJar(strings.ITEMS_FILE);
        this.imageItems = new Image[48];
        this.imageIndex = this.screenManager.store.getIntArray(strings.COLLECTION);
        this.positions = new Point[48];
        this.bgrImage = ImageTool.createImage(_width, _height);
        Graphics g = this.bgrImage.getGraphics();
        Image map = this.loadImage(110);
        g.drawImage(map, _width - map.getWidth(), 0, 0);
        this.drawFade(g, 0, 0.8f);
        this.cupImage = this.loadImage(111);
        int w = this.cupImage.getWidth();
        int h = this.cupImage.getHeight() + 5;
        this.itemsPerLine = _width / w;
        this.itemsPerPage = _height / h * this.itemsPerLine;
        int paddingX = _width % w / 2;
        int paddingY = _height % h / 2;
        for (int i = 0; i < this.imageItems.length; ++i) {
            if (this.imageIndex[i] >= 0) {
                this.imageItems[i] = this.loadImage(30 + this.imageIndex[i]);
            }
            this.positions[i] = new Point(paddingX + i % this.itemsPerLine * w, paddingY + i / this.itemsPerLine * h + i / this.itemsPerPage * paddingY * 2);
        }
        this.totalPage = this.imageItems.length / this.itemsPerPage + (this.imageItems.length % this.itemsPerPage > 0 ? 1 : 0);
        Point last = null;
        if (this.imageIndex[0] != -1) {
            for (int i = 0; i < this.imageIndex.length; ++i) {
                if (this.imageIndex[i] == -1) {
                    last = this.positions[i - 1];
                    break;
                }
                if (i != this.imageIndex.length - 1) continue;
                last = this.positions[i];
            }
        }
        if (last != null) {
            this.playStarring = true;
        }
        if (this.playStarring) {
            this.starringSprites = new GameSprite[5];
            this.starPos = new Point[this.starringSprites.length];
            GameSprite starSprite = new GameSprite(this.loadImage(112), 4, 1);
            starSprite.setFrameSequence(new int[]{0, 1, 2, 1, 0});
            for (int j = 0; j < this.starringSprites.length; ++j) {
                this.starPos[j] = new Point(last.getX() + Util.RANDOM.nextInt(24) + 7, last.getY() + Util.RANDOM.nextInt(24) + 3);
                this.starringSprites[j] = new GameSprite(starSprite);
                starSprite.nextFrame();
            }
        }
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isDownPrd()) {
            if (this.page < this.totalPage - 1) {
                this.dir = 1;
                ++this.page;
                this.timeCounter = 300;
            }
        } else if (input.isUpPrd()) {
            if (this.page > 0) {
                this.dir = -1;
                --this.page;
                this.timeCounter = 300;
            }
        } else if (input.isFirePrd() || input.isSoftLeftPrd() || input.isSoftRightPrd()) {
            this.screenManager.addScreen(new MenuScreen());
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
        if (this.timeCounter > 0) {
            this.timeCounter -= frameTime;
        } else if (this.timeCounter < 0) {
            this.timeCounter = 0;
        }
        this.bgr_y = this.page * _height + (int)((float)(this.dir * _height) * MathExt.sqr((float)this.timeCounter / 300.0f));
        if (this.playStarring) {
            for (int i = 0; i < this.starringSprites.length; ++i) {
                this.starringSprites[i].updateFrame(frameTime, true);
                this.starringSprites[i].setPosition(this.starPos[i].getX(), this.starPos[i].getY() - this.bgr_y);
            }
        }
    }

    public void draw(Graphics g, int frameTime) {
        int i;
        g.drawImage(this.bgrImage, 0, 0, 0);
        int tail = (1 + this.page) * this.itemsPerPage;
        if (tail > this.imageIndex.length) {
            tail = this.imageIndex.length;
        }
        for (i = tail - this.itemsPerPage; i < tail; ++i) {
            Point p = this.positions[i];
            g.drawImage(this.cupImage, (int)p.getX(), p.getY() - this.bgr_y, 0);
            if (this.imageIndex[i] < 0) continue;
            g.drawImage(this.imageItems[i], p.getX() + 17, p.getY() + 7 - this.bgr_y, 0);
        }
        if (this.playStarring) {
            for (i = 0; i < this.starringSprites.length; ++i) {
                this.starringSprites[i].paint(g);
            }
        }
    }
}

