/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.ScoreFly;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MissionScreen
extends GameScreen {
    protected byte[][] introText;
    private byte[] alertText;
    private byte[] specItemText;
    protected Image bgrImage;
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    private Image[] specItemsImages;
    protected int keyLand;
    protected int keyIntro;
    GameSprite leftArrowsSprite;
    GameSprite rightArrowsSprite;
    private final float TIME;
    private int time = 400;
    private float pos;
    private float posColorText = 1.0f;
    boolean pageChanged;
    protected int mission;
    private int totalPages;
    private int page;
    private int oldPage;
    public static final int LINES_PER_PAGE = 5;
    private ScoreFly missionScoreFly;
    private int phases;
    private int counter;
    private float transPos;
    byte[] t1 = null;
    byte[] t2 = null;
    protected int page_x;
    protected int page_y;
    protected int page_w = 180;
    protected int page_h;
    int bgr_x = 23;
    int bgr_y = 8;
    int missionWidth;
    int m1x;
    int m2x;
    int m3x;

    public MissionScreen(int missionTarget, int keyLand, int keyIntro) {
        this.TIME = 400.0f;
        this.mission = missionTarget;
        this.keyLand = keyLand;
        this.keyIntro = keyIntro;
    }

    public MissionScreen() {
        this.TIME = 400.0f;
        this.keyIntro = 1;
        this.keyLand = 1;
        this.mission = 51048;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 1000;
        this.transitionOnTime = 1000;
        this.setTimeCancelInput(400);
    }

    public void loadContent() throws Exception {
        super.loadContent();
        this.asset = Store.loadJar(strings.MISSIONS_FILE);
        this.specItemText = PFont.toBytesIndex(this.asset.getString(52), null);
        if (this.screenManager.store.getInt(strings.STAGE) <= 4) {
            this.alertText = PFont.toBytesIndex(this.asset.getString(55), null);
        }
        if (this.keyIntro > 0) {
            this.introText = PFont.breakString(this.asset.getString(this.keyIntro), this.page_w, Store.ENC_UTF8);
            this.totalPages = this.introText.length / 5 + (this.introText.length % 5 == 0 ? 0 : 1);
            if (this.totalPages > 1) {
                this.page = 0;
                this.oldPage = 1;
                this.pageChanged = true;
            }
        }
        Graphics g = null;
        try {
            this.bgrImage = ImageTool.createImage(_width, _height);
            g = this.bgrImage.getGraphics();
            Image i = Lands.getBgrImage(this.keyLand);
            g.setColor(0);
            g.fillRect(0, 0, _width, _height);
            g.drawImage(i, this.bgr_x, this.bgr_y, 0);
            if (this.keyIntro > 0) {
                this.rightArrowsSprite = new GameSprite(this.loadImage(63), 3, 1);
                this.leftArrowsSprite = new GameSprite(this.rightArrowsSprite);
                this.leftArrowsSprite.setTransform(2);
                this.leftArrowsSprite.setVisible(false);
                this.rightArrowsSprite.setVisible(this.totalPages > 1);
            }
            this.paperBotImage = this.loadImage(61);
            this.paperMidImage = this.loadImage(62);
            this.paperTopImage = this.loadImage(60);
            this.missionScoreFly = new ScoreFly(0, 0, this.loadImage(64));
            this.missionScoreFly.setFrame();
            this.missionScoreFly.score = this.mission;
            this.t1 = PFont.toBytesIndex(this.asset.getString(50), null);
            this.t2 = PFont.toBytesIndex(this.asset.getString(51), null);
            this.missionWidth = PFont.getStringWidth(this.t1) + this.missionScoreFly.getWidth() + PFont.getStringWidth(this.t2);
            this.m1x = (_width - this.missionWidth) / 2;
            this.m2x = this.m1x + PFont.getStringWidth(this.t1);
            this.m3x = this.m2x + this.missionScoreFly.getWidth();
            HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
            this.paperBotImage = null;
            this.paperMidImage = null;
            this.paperTopImage = null;
            this.specItemsImages = new Image[3];
            this.asset = Store.loadJar(strings.ITEMS_FILE);
            int start = this.keyLand == 1 ? 1 : this.keyLand * 3 + 24;
            this.specItemsImages[0] = this.loadImage(start);
            this.specItemsImages[1] = this.loadImage(start + 1);
            this.specItemsImages[2] = this.loadImage(start + 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.page_x = (_width - this.page_w) / 2;
        this.page_h = 85;
        this.page_y = (_height - this.page_h - 60) / 2 - 17;
        if (this.keyIntro > 0) {
            this.leftArrowsSprite.setPosition(this.page_x, this.page_y + this.page_h + 2);
            this.rightArrowsSprite.setPosition(this.page_x + this.page_w - this.rightArrowsSprite.getWidth(), this.page_y + this.page_h + 2);
            g.setColor(-1);
            g.drawRect(this.page_x - 1, this.page_y - 1, this.page_w + 1, this.page_h + 1);
            Drawer.drawBg(g, this.page_x, this.page_y, this.page_w, this.page_h, -2010963165);
        } else {
            this.page_y -= 30;
        }
    }

    public void handleInput(Input input, int frameTime) {
        if (this.keyIntro > 0) {
            if (input.isLeftPrd()) {
                --this.page;
                if (this.page < 0) {
                    this.page = 0;
                } else {
                    this.oldPage = this.page + 1;
                    this.pageChanged = true;
                    this.time = 400;
                }
                if (this.page == 0) {
                    this.leftArrowsSprite.setVisible(false);
                }
                if (this.page < this.totalPages - 1) {
                    this.rightArrowsSprite.setVisible(true);
                }
            } else if (input.isRightPrd()) {
                ++this.page;
                if (this.page == this.totalPages) {
                    this.page = this.totalPages - 1;
                } else {
                    this.pageChanged = true;
                    this.oldPage = this.page - 1;
                    this.time = 400;
                }
                if (this.page == this.totalPages - 1) {
                    this.rightArrowsSprite.setVisible(false);
                }
                if (this.page > 0) {
                    this.leftArrowsSprite.setVisible(true);
                }
            }
        }
        if (input.isFirePrd()) {
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
        if (this.keyIntro > 0) {
            this.leftArrowsSprite.updateFrame(frameTime, true);
            this.rightArrowsSprite.updateFrame(frameTime, true);
            if (this.pageChanged) {
                this.time -= frameTime;
                this.pos = (float)this.time / 400.0f;
                this.posColorText = MathExt.sqr(1.0f - this.pos);
                this.pos *= this.pos;
                if (this.time <= 0) {
                    this.pageChanged = false;
                    this.time = 400;
                    this.pos = 0.0f;
                    this.posColorText = 1.0f;
                }
            }
        }
        this.missionScoreFly.update(frameTime);
        if (this.screenState == 2) {
            if (this.phases == 0) {
                this.countPhase(800, frameTime);
            } else if (this.phases == 1) {
                this.countPhase(800, frameTime);
            } else if (this.phases == 2) {
                this.countPhase(1200, frameTime);
            } else if (this.phases == 3) {
                this.countPhase(600, frameTime);
            } else if (this.phases == 4) {
                this.countPhase(1200, frameTime);
            } else if (this.phases == 5) {
                this.countPhase(550, frameTime);
            }
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, 0, 0, 0);
        if (this.keyIntro > 0) {
            g.setClip(this.page_x - 1, this.page_y - 1, this.page_w + 2, this.page_h + 2);
            int textColor = 0xFFFFFF | (int)(this.posColorText * 255.0f) << 24;
            int head = this.page * 5;
            int tail = (this.page + 1) * 5;
            tail = tail < this.introText.length ? tail : this.introText.length;
            for (int i = head; i < tail; ++i) {
                PFont.drawString(g, this.page_x + (int)(this.pos * (float)this.page_w) * (this.page - this.oldPage), this.page_y + (i - head) * 17, this.introText[i], textColor);
            }
            if (this.pageChanged) {
                textColor = 0xFFFFFF | (int)(this.pos * 255.0f) << 24;
                head = this.oldPage * 5;
                tail = (this.oldPage + 1) * 5;
                tail = tail < this.introText.length ? tail : this.introText.length;
                int x = this.page_x + (this.oldPage - this.page) * this.page_w;
                x += (int)(this.pos * (float)this.page_w) * (this.page - this.oldPage);
                for (int i = head; i < tail; ++i) {
                    PFont.drawString(g, x, this.page_y + (i - head) * 17, this.introText[i], textColor);
                }
            }
            this.screenManager.restoreClipping();
            this.leftArrowsSprite.paint(g);
            this.rightArrowsSprite.paint(g);
        }
        switch (this.screenState) {
            case 1: {
                this.drawFade(g, 0);
                break;
            }
            case 2: 
            case 4: {
                switch (this.phases) {
                    case 5: 
                    case 6: {
                        if (this.phases == 6) {
                            this.transPos = 0.0f;
                        }
                        if (this.alertText != null) {
                            PFont.drawCenterString(g, _width / 2 - (int)(200.0f * this.transPos), this.page_y + this.page_h + 70, this.alertText, -1711320064, -855638017, 0, this.alertText.length);
                        }
                    }
                    case 4: {
                        if (this.phases == 5) {
                            this.transPos = 0.0f;
                        }
                    }
                    case 3: {
                        if (this.phases == 4) {
                            this.transPos = 0.0f;
                        }
                        int d = (int)(200.0f * this.transPos);
                        int yy = this.page_y + this.page_h + 10;
                        this.missionScoreFly.setPos(this.m2x + d, yy);
                        this.missionScoreFly.paint(g);
                        PFont.drawString(g, this.m1x + d, yy, this.t1, -1711320064, -1, 0, this.t1.length);
                        PFont.drawString(g, this.m3x + d, yy, this.t2, -1711320064, -1, 0, this.t2.length);
                    }
                    case 2: {
                        if (this.phases == 3) {
                            this.transPos = 0.0f;
                        }
                    }
                    case 1: {
                        if (this.phases == 2) {
                            this.transPos = 0.0f;
                        }
                        PFont.drawCenterString(g, _width / 2, this.page_y + this.page_h + 30 - (int)(280.0f * this.transPos), this.specItemText, -1711320064, -1, 0, this.specItemText.length);
                    }
                    case 0: {
                        if (this.phases == 1) {
                            this.transPos = 0.0f;
                        }
                        int y = this.page_y + this.page_h + 47;
                        Drawer.drawBg(g, _width / 2 - 45, y + (int)(this.transPos * 150.0f), 90, 27, -2010963165);
                        Drawer.drawAtCenterX(g, this.specItemsImages[0], _width / 2 - 30 + (int)(200.0f * this.transPos), y);
                        Drawer.drawAtCenterX(g, this.specItemsImages[1], _width / 2, y + (int)(200.0f * this.transPos));
                        Drawer.drawAtCenterX(g, this.specItemsImages[2], _width / 2 + 30 - (int)(200.0f * this.transPos), y);
                    }
                }
            }
        }
        if (this.screenState == 4) {
            this.drawFade(g, 0);
        }
    }

    private void countPhase(int time, int frameTime) {
        this.counter += frameTime;
        this.transPos = MathExt.sqr(1.0f - (float)this.counter / (float)time);
        if (this.counter > time) {
            this.counter = 0;
            this.transPos = 1.0f;
            ++this.phases;
        }
    }
}

