/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;

public class Page {
    protected byte[][] introText;
    private final float TIME;
    private int time = 400;
    private float pos;
    private float posColorText = 1.0f;
    boolean pageChanged;
    private int totalPages;
    private int page;
    private int oldPage;
    public final int LINES_PER_PAGE;
    protected int page_x;
    protected int page_y;
    protected int width = 180;
    protected int height;

    public Page(String filename, int linePrePage) {
        this.TIME = 400.0f;
        this.LINES_PER_PAGE = linePrePage;
        this.introText = PFont.breakString(filename, this.width, Store.ENC_UTF8);
        this.totalPages = this.introText.length / this.LINES_PER_PAGE + (this.introText.length % this.LINES_PER_PAGE == 0 ? 0 : 1);
        this.init();
    }

    public Page(byte[] text, int linePrePage) {
        this.TIME = 400.0f;
        this.LINES_PER_PAGE = linePrePage;
        this.introText = PFont.breakString(text, this.width);
        this.totalPages = this.introText.length / this.LINES_PER_PAGE + (this.introText.length % this.LINES_PER_PAGE == 0 ? 0 : 1);
        this.init();
    }

    private void init() {
        this.height = this.LINES_PER_PAGE * 17;
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isLeftPrd()) {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            } else {
                this.oldPage = this.page + 1;
                this.pageChanged = true;
                this.time = 400;
            }
        } else if (input.isRightPrd()) {
            ++this.page;
            if (this.page == this.totalPages) {
                this.page = this.totalPages - 1;
            } else {
                this.pageChanged = true;
                this.oldPage = this.page - 1;
                this.time = 400;
            }
        }
    }

    public void draw(Graphics g, int frameTime) {
        int i;
        if (this.pageChanged) {
            this.time -= frameTime;
            this.pos = (float)this.time / 400.0f;
            this.posColorText = MathExt.sqr(1.0f - this.pos);
            this.pos *= this.pos;
            if (this.time <= 0) {
                this.pageChanged = false;
                this.pos = 0.0f;
                this.posColorText = 1.0f;
            }
        }
        g.setClip(this.page_x - 1, this.page_y - 1, this.width + 2, this.height + 2);
        int textColor = 0xFFFFFF | (int)(this.posColorText * 255.0f) << 24;
        int head = this.page * this.LINES_PER_PAGE;
        int tail = (this.page + 1) * this.LINES_PER_PAGE;
        tail = tail < this.introText.length ? tail : this.introText.length;
        int x = (int)(this.pos * (float)this.width) * (this.page - this.oldPage);
        for (i = head; i < tail; ++i) {
            PFont.drawString(g, this.page_x + x, this.page_y + (i - head) * 17, this.introText[i], textColor);
        }
        if (this.pageChanged) {
            textColor = 0xFFFFFF | (int)(this.pos * 255.0f) << 24;
            head = this.oldPage * this.LINES_PER_PAGE;
            tail = (this.oldPage + 1) * this.LINES_PER_PAGE;
            tail = tail < this.introText.length ? tail : this.introText.length;
            x = this.page_x + (this.oldPage - this.page) * this.width;
            x += (int)(this.pos * (float)this.width) * (this.page - this.oldPage);
            for (i = head; i < tail; ++i) {
                PFont.drawString(g, x, this.page_y + (i - head) * 17, this.introText[i], textColor);
            }
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.page_x;
    }

    public int getY() {
        return this.page_y;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setX(int page_x) {
        this.page_x = page_x;
    }

    public void setY(int page_y) {
        this.page_y = page_y;
    }

    public boolean isLastPage() {
        return this.page == this.totalPages - 1;
    }

    public boolean isfirstPage() {
        return this.page == 0;
    }
}

