/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.ScreenManager;
import com.pipogame.util.PFont;
import com.pipogame.util.Util;
import javax.microedition.lcdui.Graphics;

public class Dialog {
    ScreenManager drawer;
    private final int x;
    private final int y;
    private int y2;
    public static final int TIME_SLIDE = 500;
    private float timeSlide;
    private int width;
    private int height;
    private int[] space_width;
    private int length;
    private int lengthDrawn;
    private int timeCounter;
    private byte[][] text;
    public static final int TIME_STOP = 1000;
    int timeStop;

    public Dialog(byte[][] text, int x, int y, int width, int height, ScreenManager drawer, boolean justify) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.y2 = y;
        this.width = width;
        this.height = height;
        this.drawer = drawer;
        this.space_width = new int[text.length];
        if (justify) {
            for (int k = 0; k < text.length - 1; ++k) {
                this.length += text[k].length;
                int numSpace = 0;
                for (int i = 0; i < text[k].length; ++i) {
                    if (text[k][i] != PFont.SPACE) continue;
                    ++numSpace;
                }
                if (numSpace == 0) {
                    numSpace = 1;
                }
                this.space_width[k] = (width - PFont.getStringWidth(text[k])) / numSpace + 3;
            }
        }
        this.length += text[text.length - 1].length;
        this.space_width[this.space_width.length - 1] = 3;
    }

    public Dialog(byte[] text, int x, int y, int width, int height, ScreenManager drawer, boolean justify) {
        this.text = PFont.breakString(text, width);
        this.x = x;
        this.y = y;
        this.y2 = y;
        this.width = width;
        this.height = height;
        this.drawer = drawer;
        this.space_width = new int[text.length];
        if (justify) {
            for (int k = 0; k < text.length - 1; ++k) {
                this.length += this.text[k].length;
                int numSpace = 0;
                for (int i = 0; i < this.text[k].length; ++i) {
                    if (this.text[k][i] != PFont.SPACE) continue;
                    ++numSpace;
                }
                if (numSpace == 0) {
                    numSpace = 1;
                }
                this.space_width[k] = (width - PFont.getStringWidth(this.text[k])) / numSpace + 3;
            }
        }
        this.length += this.text[text.length - 1].length;
        this.space_width[this.space_width.length - 1] = 3;
    }

    public boolean drawDialog(Graphics g, int frameTime, boolean cancelOutArea, boolean justify) {
        if (this.lengthDrawn < this.length) {
            this.timeCounter += frameTime;
            if (this.timeCounter >= 66) {
                this.timeCounter -= 66;
                ++this.lengthDrawn;
            }
        } else {
            this.lengthDrawn = this.length;
            this.timeCounter = 0;
        }
        int t_lines = 1;
        int t_lenDrawn = 0;
        for (int i = 0; i < this.text.length && (t_lenDrawn = (int)((short)(t_lenDrawn + this.text[i].length))) < this.lengthDrawn; ++i) {
            t_lines = (byte)(t_lines + 1);
        }
        if ((t_lines = (int)((byte)(t_lines - this.height / 17))) == 2) {
            t_lenDrawn = (short)(t_lenDrawn + 10);
        }
        if (t_lines > 0) {
            int t_height = this.y - t_lines * 17;
            if (this.y2 > t_height) {
                this.y2 = (int)(Util.sqr(1.0f - this.timeSlide / 500.0f) * 17.0f) + t_height;
                this.timeSlide += (float)frameTime;
                if (this.timeSlide > 500.0f) {
                    this.timeSlide = 500.0f;
                }
            } else {
                this.timeSlide = 0.0f;
            }
        }
        int drawn = 0;
        if (cancelOutArea) {
            g.setClip(this.x, this.y, this.width, this.height);
        }
        int y_draw = this.y2 - 17;
        for (int i = 0; i < this.text.length; ++i) {
            y_draw += 17;
            int spaceWidth = justify ? this.space_width[i] : 3;
            if (drawn + this.text[i].length <= this.lengthDrawn) {
                if (this.needDraw(y_draw)) {
                    PFont.drawString(g, this.x, y_draw, this.text[i], 0, -1, 0, this.text[i].length, spaceWidth);
                }
                drawn += this.text[i].length;
                continue;
            }
            if (drawn >= this.lengthDrawn) break;
            if (this.needDraw(y_draw)) {
                PFont.drawString(g, this.x, y_draw, this.text[i], 0, -1, 0, this.lengthDrawn - drawn, spaceWidth);
            }
            drawn = this.lengthDrawn;
        }
        if (cancelOutArea) {
            this.drawer.restoreClipping();
        }
        if (this.lengthDrawn >= this.length) {
            this.timeStop += frameTime;
            if (this.timeStop > 1000) {
                this.timeStop = 0;
                return true;
            }
        }
        return false;
    }

    private boolean needDraw(int y) {
        return y >= this.y - 17 && y <= this.y + this.height;
    }

    public void finishDraw() {
        if (this.lengthDrawn < this.length) {
            this.lengthDrawn = this.length - 1;
        }
    }
}

