/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import java.util.Random;
import java.util.Vector;

public class Util {
    public static final Random RANDOM = new Random();
    private static final int MAX_RUN_COUNT = 67;
    private static final int MAX_RUN_LENGTH = 33;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;

    public static int[] makeRandomSubarray(int imax, int numOfElements) {
        int pos1;
        int[] nums = new int[imax];
        for (int i = 1; i < imax; ++i) {
            nums[i] = i;
        }
        int loop = imax / 2;
        for (int i = 0; i < loop; ++i) {
            pos1 = RANDOM.nextInt(imax);
            int pos2 = RANDOM.nextInt(imax);
            int tmp = nums[pos1];
            nums[pos1] = nums[pos2];
            nums[pos2] = tmp;
        }
        pos1 = RANDOM.nextInt(imax - numOfElements + 1);
        int[] result = new int[numOfElements];
        System.arraycopy(nums, pos1, result, 0, numOfElements);
        return result;
    }

    public static byte[] intTo4Bytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return result;
    }

    public static int bytesToInt(byte[] bs) {
        int result = 0;
        for (int i = 0; i < bs.length; ++i) {
            int a = bs[i] >= 0 ? bs[i] : bs[i] + 256;
            result |= a << (bs.length - i - 1) * 8;
        }
        return result;
    }

    public static void copy4BytesToByteArray(byte[] source, byte[] des, int pos) {
        int length = source.length;
        if (length + pos > des.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(source, pos, des, 0, length);
    }

    public static void copyArrayTo4ByteArray(byte[] source, byte[] des, int pos) {
        for (int i = 0; i < 4; ++i) {
            des[i] = source[pos + i];
        }
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static float sqr(float d) {
        return d * d;
    }

    public static double pow(double a, int b) {
        double y;
        if (b < 0) {
            return 1.0 / Util.pow(a, -b);
        }
        if (b == 0) {
            return 1.0;
        }
        if (b == 1) {
            return a;
        }
        if (a == 0.0) {
            return 0.0;
        }
        if (a == 1.0) {
            return 1.0;
        }
        double d = y = b % 2 == 1 ? a : 1.0;
        while ((b >>= 1) > 0) {
            a *= a;
            if (b % 2 != 1) continue;
            y *= a;
        }
        return y;
    }

    public static float pow(float a, int b) {
        float y;
        if (b < 0) {
            return 1.0f / Util.pow(a, -b);
        }
        if (b == 0) {
            return 1.0f;
        }
        if (b == 1) {
            return a;
        }
        float f = y = b % 2 == 1 ? a : 1.0f;
        while ((b >>= 1) > 0) {
            a *= a;
            if (b % 2 != 1) continue;
            y *= a;
        }
        return y;
    }

    public static double fourthRoot(double d) {
        return Math.sqrt(Math.sqrt(d));
    }

    public static byte[] getSubArray(byte[] array, int offset, int length) {
        byte[] sub = new byte[length];
        System.arraycopy(array, offset, sub, 0, length);
        return sub;
    }

    public static boolean between(int low, int num, int hight) {
        return low <= num && num <= hight;
    }

    public static String[] splitString(String s, String splitor) {
        Vector<String> v = new Vector<String>(6, 6);
        int start = 0;
        int splitorLeng = splitor.length();
        while (start < s.length()) {
            int nextPartIdx = s.indexOf(splitor, start);
            if (nextPartIdx > 0) {
                String line = s.substring(start, nextPartIdx);
                start = nextPartIdx + splitorLeng;
                v.addElement(line);
                continue;
            }
            v.addElement(s.substring(start));
            break;
        }
        start = v.size();
        Object[] result = new String[start];
        v.copyInto(result);
        return result;
    }

    public static String getClassName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public static void resetArray(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
    }

    public static void sort(int[] a) {
        Util.sort(a, 0, a.length - 1);
    }

    public static void sort(int[] a, int left, int right) {
        int[] b;
        if (right - left < 286) {
            Util.sort(a, left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (a[k] < a[k + 1]) {
                while (++k <= right && a[k - 1] <= a[k]) {
                }
            } else if (a[k] > a[k + 1]) {
                while (++k <= right && a[k - 1] >= a[k]) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    int t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                }
            } else {
                int m = 33;
                while (++k <= right && a[k - 1] == a[k]) {
                    if (--m != 0) continue;
                    Util.sort(a, left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                Util.sort(a, left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = a;
            a = new int[b.length];
            int i = left - 1;
            while (++i < right) {
                a[i] = b[i];
            }
        } else {
            b = new int[a.length];
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    b[i] = q >= hi || p < mi && a[p] <= a[q] ? a[p++] : a[q++];
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b[i] = a[i];
                }
                run[++last] = right;
            }
            int[] t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    private static void sort(int[] a, int left, int right, boolean leftmost) {
        int t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    int ai = a[i + 1];
                    while (ai < a[j]) {
                        a[j + 1] = a[j];
                        if (j-- != left) continue;
                    }
                    a[j + 1] = ai;
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (a[++left] >= a[left - 1]);
                int k = left;
                while (++left <= right) {
                    int a1 = a[k];
                    int a2 = a[left];
                    if (a1 < a2) {
                        a2 = a1;
                        a1 = a[left];
                    }
                    while (a1 < a[--k]) {
                        a[k + 2] = a[k];
                    }
                    a[++k + 1] = a1;
                    while (a2 < a[--k]) {
                        a[k + 1] = a[k];
                    }
                    a[k + 1] = a2;
                    k = ++left;
                }
                int last = a[right];
                while (last < a[--right]) {
                    a[right + 1] = a[right];
                }
                a[right + 1] = last;
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (a[e2] < a[e1]) {
            t = a[e2];
            a[e2] = a[e1];
            a[e1] = t;
        }
        if (a[e3] < a[e2]) {
            t = a[e3];
            a[e3] = a[e2];
            a[e2] = t;
            if (t < a[e1]) {
                a[e2] = a[e1];
                a[e1] = t;
            }
        }
        if (a[e4] < a[e3]) {
            t = a[e4];
            a[e4] = a[e3];
            a[e3] = t;
            if (t < a[e2]) {
                a[e3] = a[e2];
                a[e2] = t;
                if (t < a[e1]) {
                    a[e2] = a[e1];
                    a[e1] = t;
                }
            }
        }
        if (a[e5] < a[e4]) {
            t = a[e5];
            a[e5] = a[e4];
            a[e4] = t;
            if (t < a[e3]) {
                a[e4] = a[e3];
                a[e3] = t;
                if (t < a[e2]) {
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (a[e1] != a[e2] && a[e2] != a[e3] && a[e3] != a[e4] && a[e4] != a[e5]) {
            int ak;
            int pivot1 = a[e2];
            int pivot2 = a[e4];
            a[e2] = a[left];
            a[e4] = a[right];
            while (a[++less] < pivot1) {
            }
            while (a[--great] > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = a[k];
                if (ak < pivot1) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (a[great] > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (a[great] < pivot1) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = a[great];
                }
                a[great] = ak;
                --great;
            }
            a[left] = a[less - 1];
            a[less - 1] = pivot1;
            a[right] = a[great + 1];
            a[great + 1] = pivot2;
            Util.sort(a, left, less - 2, leftmost);
            Util.sort(a, great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (a[less] == pivot1) {
                    ++less;
                }
                while (a[great] == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = a[k];
                    if (ak == pivot1) {
                        a[k] = a[less];
                        a[less] = ak;
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less] = pivot1;
                        ++less;
                    } else {
                        a[k] = a[great];
                    }
                    a[great] = ak;
                    --great;
                }
            }
            Util.sort(a, less, great, false);
        } else {
            int pivot = a[e3];
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot) continue;
                int ak = a[k];
                if (ak < pivot) {
                    a[k] = a[less];
                    a[less] = ak;
                    ++less;
                    continue;
                }
                while (a[great] > pivot) {
                    --great;
                }
                if (a[great] < pivot) {
                    a[k] = a[less];
                    a[less] = a[great];
                    ++less;
                } else {
                    a[k] = pivot;
                }
                a[great] = ak;
                --great;
            }
            Util.sort(a, left, less - 1, leftmost);
            Util.sort(a, great + 1, right, false);
        }
    }
}

