/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.progressBar;

import tv.ingames.j2dm.display.J2DM_GameObject;
import tv.ingames.j2dm.display.progressBar.J2DM_ProgressBarParameters;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_ProgressBar
extends J2DM_GameObject {
    protected J2DM_ProgressBarParameters _parameters;
    protected int _value;
    protected int _maxValue;

    public J2DM_ProgressBar(J2DM_ProgressBarParameters parameters, String name) {
        super(name);
        this.init(parameters);
    }

    public J2DM_ProgressBar(J2DM_ProgressBarParameters parameters) {
        this.init(parameters);
    }

    private void init(J2DM_ProgressBarParameters parameters) {
        this._parameters = parameters != null ? parameters : new J2DM_ProgressBarParameters(new J2DM_Rect(0, 0, 100, 5), 100, 0, 0xFF0000);
        this._value = 0;
        this._maxValue = this._parameters.getMaxValue();
        this.suscribeUpdate();
    }

    public J2DM_Rect getRect() {
        return this._parameters.getRect();
    }

    public boolean isMaxValue() {
        return this._value >= this._maxValue;
    }

    public boolean isMinValue() {
        return this._value == 0;
    }

    public int getType() {
        return this._parameters.getType();
    }

    public int getColor() {
        return this._parameters.getColor();
    }

    public int getMaxValue() {
        return this._maxValue;
    }

    public void setMaxValue(int value) {
        this._maxValue = value;
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int value) {
        this._value = value;
        if (this._value < 0) {
            this._value = 0;
        }
        if (this._value > this._maxValue) {
            this._value = this._maxValue;
        }
    }

    public void destroy() {
        super.destroy();
        this.unsuscribeUpdate();
    }

    public void draw(J2DM_Graphics g) {
        if (this._parameters == null) {
            return;
        }
        J2DM_Rect rect = this._parameters.getRect();
        g.setClip(rect._x, rect._y, rect._width, rect._height);
        g.setColor(this._parameters.getColor());
        if (this._enabled) {
            g.setGlobalAlpha(this._alpha);
        } else {
            g.setGlobalAlpha(this._alphaDisable);
        }
        switch (this._parameters.getType()) {
            case 0: {
                int pixels = this._value * rect._width / this._maxValue;
                if (this._flipH == 1) {
                    g.fillRect(rect._x, rect._y, pixels, rect._height);
                    break;
                }
                g.fillRect(rect._x + rect._width - pixels, rect._y, pixels, rect._height);
                break;
            }
            case 1: {
                int pixels = this._value * rect._height / this._maxValue;
                if (this._flipV == 1) {
                    g.fillRect(rect._x, rect._y, rect._width, pixels);
                    break;
                }
                g.fillRect(rect._x, rect._y + rect._height - pixels, rect._width, pixels);
            }
        }
    }
}

