/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.keyboardTouch;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextFieldArea {
    private int width;
    private int height;
    private int cursorPosition;
    private int cursorPositionX;
    private int cursorLine;
    private StringBuffer text;
    private int maxLines;
    private Font textFieldFont = Font.getDefaultFont();
    private int textFieldBkgColor = 0xEEEEEE;
    private int textFieldBorderColor = 0;
    private int cursorColor = 0xFF0000;
    private int textFieldFontColor = 0;
    private int horizontalPixelCounter;
    private int lineNumbers;
    private String CARRIAGE_RETURN = "\r";
    private int topLeftX;
    private int topLeftY;
    private int firstLineToDisplay;
    private int lastLineToDisplay;
    private boolean cursorVisible;
    private int maxSize = -1;

    public TextFieldArea(int width, int height) {
        this.width = width;
        this.height = height;
        this.init();
    }

    private void init() {
        this.cursorVisible = true;
        this.text = new StringBuffer();
        this.maxLines = this.height / this.textFieldFont.getHeight();
        this.initCursor();
    }

    private void initCursor() {
        this.cursorPosition = 0;
        this.cursorPositionX = 0;
        this.cursorLine = 1;
        this.firstLineToDisplay = 1;
        this.lastLineToDisplay = this.firstLineToDisplay + this.maxLines - 1;
    }

    public void deleteLastCharBeforeCursor() {
        if (this.cursorPosition > 0) {
            this.text.deleteCharAt(this.cursorPosition - 1);
            --this.cursorPosition;
        }
    }

    public void insertCharacterInCursorPosition(char aChar) {
        if ((this.maxSize > 0 && this.text.length() < this.maxSize || this.maxSize < 0) && aChar != '\u0000') {
            this.text.insert(this.cursorPosition, aChar);
            ++this.cursorPosition;
        }
    }

    public void insertAscii(int asciiCode) {
        if (asciiCode > 0) {
            if (asciiCode == 8) {
                this.deleteLastCharBeforeCursor();
            } else {
                this.insertCharacterInCursorPosition((char)asciiCode);
            }
        }
    }

    public void moveCursorLeft() {
        this.cursorPosition = Math.max(0, this.cursorPosition - 1);
    }

    public void moveCursorRight() {
        this.cursorPosition = Math.min(this.cursorPosition + 1, this.text.length());
    }

    public String getText() {
        return this.text.toString();
    }

    public void setText(String newText) {
        this.text = null;
        this.text = new StringBuffer(newText);
        this.cursorPosition = newText.length();
    }

    public void clearTextField() {
        this.text = null;
        this.text = new StringBuffer();
        this.initCursor();
    }

    public void paint(Graphics graphics, int topLeftX, int topLeftY) {
        this.topLeftX = topLeftX;
        this.topLeftY = topLeftY;
        this.reSetTextField(graphics);
        this.reorganizeTextField();
        this.calculateCursorPosition();
        this.detectLinesToDisplay();
        this.rePaintTextField(graphics);
    }

    private void reSetTextField(Graphics graphics) {
        graphics.setColor(this.textFieldBkgColor);
        graphics.fillRect(this.topLeftX, this.topLeftY, this.width, this.height);
        graphics.setColor(this.textFieldBorderColor);
        graphics.drawRect(this.topLeftX, this.topLeftY, this.width, this.height);
        this.horizontalPixelCounter = 0;
    }

    private void rePaintTextField(Graphics graphics) {
        int wordHeight = this.textFieldFont.getHeight();
        int verticalPixelCounter = 0;
        graphics.setFont(this.textFieldFont);
        graphics.setColor(this.textFieldFontColor);
        String st = String.valueOf(this.text.toString()) + this.CARRIAGE_RETURN;
        this.text = null;
        this.text = new StringBuffer();
        int currentLine = 1;
        while (currentLine <= this.lineNumbers) {
            String textPart = st.substring(0, st.indexOf(this.CARRIAGE_RETURN));
            this.text.append(textPart);
            if (currentLine >= this.firstLineToDisplay && currentLine <= this.lastLineToDisplay) {
                textPart = textPart.replace('\n', ' ');
                graphics.drawString(textPart, this.topLeftX, this.topLeftY + verticalPixelCounter, 20);
                verticalPixelCounter += wordHeight;
            }
            if (this.cursorVisible && currentLine == this.cursorLine) {
                graphics.setColor(this.cursorColor);
                graphics.drawLine(this.topLeftX + this.cursorPositionX, this.topLeftY + verticalPixelCounter - wordHeight, this.topLeftX + this.cursorPositionX, this.topLeftY + verticalPixelCounter);
                graphics.setColor(this.textFieldFontColor);
            }
            st = st.substring(st.indexOf(this.CARRIAGE_RETURN) + this.CARRIAGE_RETURN.length());
            ++currentLine;
        }
    }

    private void calculateCursorPosition() {
        int charCounter = 0;
        String st = String.valueOf(this.text.toString()) + this.CARRIAGE_RETURN;
        int currentLine = 1;
        while (currentLine <= this.lineNumbers) {
            String textPart = st.substring(0, st.indexOf(this.CARRIAGE_RETURN));
            if (charCounter + textPart.length() >= this.cursorPosition) {
                this.cursorLine = currentLine;
                int offset = this.cursorPosition - charCounter;
                if (this.lineNumbers > this.cursorLine && offset == textPart.length()) {
                    this.cursorPositionX = 0;
                    ++this.cursorLine;
                    break;
                }
                this.cursorPositionX = this.textFieldFont.stringWidth(textPart.substring(0, offset));
                break;
            }
            charCounter += textPart.length();
            st = st.substring(st.indexOf(this.CARRIAGE_RETURN) + this.CARRIAGE_RETURN.length());
            ++currentLine;
        }
    }

    private void detectLinesToDisplay() {
        if (this.cursorLine < this.firstLineToDisplay) {
            this.firstLineToDisplay = this.cursorLine;
            this.lastLineToDisplay = this.firstLineToDisplay + this.maxLines - 1;
        } else if (this.cursorLine > this.lastLineToDisplay) {
            this.lastLineToDisplay = this.cursorLine;
            this.firstLineToDisplay = this.lastLineToDisplay - this.maxLines + 1;
        }
    }

    private void reorganizeTextField() {
        this.lineNumbers = 1;
        String s = String.valueOf(this.text.toString()) + " ";
        this.text = null;
        this.text = new StringBuffer();
        while (s.indexOf(" ") != -1) {
            int spareSpaceInLine;
            String word = s.substring(0, s.indexOf(" ") + 1);
            int breakLineIndex = word.indexOf("\n");
            if (breakLineIndex != -1) {
                word = s.substring(0, breakLineIndex + 1);
            }
            s = s.substring(word.length());
            int wordWith = this.textFieldFont.stringWidth(word);
            if (breakLineIndex != -1) {
                wordWith -= this.textFieldFont.stringWidth("\n");
            }
            if (wordWith < (spareSpaceInLine = this.width - this.horizontalPixelCounter)) {
                this.appendString(word);
                this.horizontalPixelCounter += wordWith;
            } else {
                if (this.horizontalPixelCounter > 0) {
                    this.appendNewLine();
                    this.horizontalPixelCounter = 0;
                }
                if (wordWith > this.width) {
                    this.breakAndAttachBigWords(word);
                } else {
                    this.appendString(word);
                    this.horizontalPixelCounter += wordWith;
                }
            }
            if (breakLineIndex == -1) continue;
            this.appendNewLine();
            this.horizontalPixelCounter = 0;
        }
        if (this.text.charAt(this.text.length() - 1) == ' ') {
            this.text.deleteCharAt(this.text.length() - 1);
        }
    }

    private void breakAndAttachBigWords(String wordToBreak) {
        int wordWidth = this.textFieldFont.stringWidth(wordToBreak);
        int partitions = wordWidth / this.width;
        int index = partitions == 0 ? wordToBreak.length() : wordToBreak.length() / partitions;
        String part = wordToBreak.substring(0, index);
        while (this.textFieldFont.stringWidth(part) < this.width) {
            if ((index = Math.min(index + 1, wordToBreak.length() - 1)) == wordToBreak.length() - 1) break;
            part = null;
            part = wordToBreak.substring(0, index);
        }
        while (this.textFieldFont.stringWidth(part) > this.width) {
            part = null;
            part = wordToBreak.substring(0, --index);
        }
        this.appendString(part);
        if (partitions == 0) {
            this.horizontalPixelCounter += this.textFieldFont.stringWidth(part);
        } else {
            this.appendNewLine();
            this.horizontalPixelCounter = 0;
            this.breakAndAttachBigWords(wordToBreak.substring(index));
        }
    }

    private void appendString(String toAppend) {
        this.text.append(toAppend);
    }

    private void appendNewLine() {
        this.text.append(this.CARRIAGE_RETURN);
        ++this.lineNumbers;
    }

    public void setTextFieldFont(Font textFieldFont) {
        this.textFieldFont = textFieldFont;
    }

    public void setTextFieldBkgColor(int textFieldBkgColor) {
        this.textFieldBkgColor = textFieldBkgColor;
    }

    public void setTextFieldBorderColor(int textFieldBorderColor) {
        this.textFieldBorderColor = textFieldBorderColor;
    }

    public void setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
    }

    public void setTextFieldFontColor(int textFieldFontColor) {
        this.textFieldFontColor = textFieldFontColor;
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    public void setCursorVisible(boolean cursorVisible) {
        this.cursorVisible = cursorVisible;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

