/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.persistentData;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import tv.ingames.j2dm.persistentData.J2DM_RMSException;

public class J2DM_RecordManager {
    private static J2DM_RecordManager _instance;
    private RecordStore rs;

    private J2DM_RecordManager() {
    }

    public static J2DM_RecordManager getInstance() {
        if (_instance == null) {
            _instance = new J2DM_RecordManager();
        }
        return _instance;
    }

    public void saveData(String bd, String data) throws J2DM_RMSException {
        this.deleteRegisterZone(bd);
        try {
            this.openRegisterZone(bd, true);
            byte[] regBytes = data.getBytes();
            this.rs.addRecord(regBytes, 0, regBytes.length);
            this.closeRegisterZone();
        }
        catch (RecordStoreNotOpenException e) {
            throw new J2DM_RMSException(4, bd);
        }
        catch (RecordStoreFullException e) {
            throw new J2DM_RMSException(2, bd);
        }
        catch (RecordStoreException e) {
            throw new J2DM_RMSException(0, bd);
        }
    }

    public String readData(String bd) throws J2DM_RMSException {
        String dato = "";
        try {
            String strData;
            this.openRegisterZone(bd, false);
            byte[] data = new byte[this.rs.getRecordSize(1)];
            this.rs.getRecord(1, data, 0);
            dato = strData = new String(data, 0, data.length);
            this.closeRegisterZone();
        }
        catch (RecordStoreNotOpenException e) {
            throw new J2DM_RMSException(4, bd);
        }
        catch (InvalidRecordIDException e) {
            throw new J2DM_RMSException(4, bd);
        }
        catch (RecordStoreFullException e) {
            throw new J2DM_RMSException(2, bd);
        }
        catch (RecordStoreException e) {
            throw new J2DM_RMSException(0, bd);
        }
        return dato;
    }

    private void openRegisterZone(String nomBase, boolean flag) throws J2DM_RMSException {
        try {
            this.rs = RecordStore.openRecordStore((String)nomBase, (boolean)flag);
        }
        catch (RecordStoreFullException e) {
            throw new J2DM_RMSException(2, nomBase);
        }
        catch (RecordStoreNotFoundException e) {
            throw new J2DM_RMSException(1, nomBase);
        }
        catch (RecordStoreException e) {
            throw new J2DM_RMSException(0, nomBase);
        }
    }

    private void closeRegisterZone() throws J2DM_RMSException {
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
            throw new J2DM_RMSException(3);
        }
        catch (RecordStoreException e) {
            throw new J2DM_RMSException(0);
        }
    }

    public void deleteRegisterZone(String nomBase) throws J2DM_RMSException {
        try {
            this.openRegisterZone(nomBase, false);
            this.closeRegisterZone();
            RecordStore.deleteRecordStore((String)nomBase);
        }
        catch (RecordStoreNotFoundException e) {
            throw new J2DM_RMSException(4, nomBase);
        }
        catch (RecordStoreException e) {
            throw new J2DM_RMSException(0, nomBase);
        }
        catch (J2DM_RMSException j2DM_RMSException) {
            // empty catch block
        }
    }
}

