/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.cubeMatch.gamePlay.modes;

import java.util.Vector;
import tv.ingames.cubeMatch.application.ScreenParametersApplication;
import tv.ingames.cubeMatch.gamePlay.Ball;
import tv.ingames.cubeMatch.gamePlay.ExplodeBall;
import tv.ingames.cubeMatch.gamePlay.SettingsGamePlay;
import tv.ingames.cubeMatch.gamePlay.levels.AbstractLevel;
import tv.ingames.cubeMatch.gamePlay.levels.DataLevel;
import tv.ingames.cubeMatch.loaders.ExternalFiles;
import tv.ingames.j2dm.core.IPaused;
import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.display.J2DM_DisplayContainer;
import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.display.progressBar.IProgressTimeBar;
import tv.ingames.j2dm.display.progressBar.J2DM_ProgressBarParameters;
import tv.ingames.j2dm.display.progressBar.J2DM_ProgressTimeBar;
import tv.ingames.j2dm.display.textfield.J2DM_NumberField;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.display.ui.IButtonCallBack;
import tv.ingames.j2dm.display.ui.J2DM_GenericButton;
import tv.ingames.j2dm.display.ui.J2DM_GenericButtonWithText;
import tv.ingames.j2dm.display.ui.J2DM_SimpleMenu;
import tv.ingames.j2dm.gameplay.IStatePlaying;
import tv.ingames.j2dm.gameplay.J2DM_ManagerExplodeBalls;
import tv.ingames.j2dm.gameplay.J2DM_ManagerShowScore;
import tv.ingames.j2dm.loader.J2DM_Loader;
import tv.ingames.j2dm.matchLibrary.J2DM_MatrixManager;
import tv.ingames.j2dm.matchLibrary.J2DM_StructControlBalls;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_Ball;
import tv.ingames.j2dm.matchLibrary.misc.J2DM_CursorInMatrix;
import tv.ingames.j2dm.media.J2DM_SoundManager;
import tv.ingames.j2dm.media.languaje.J2DM_Language;
import tv.ingames.j2dm.platform.J2DM_CaptureIncomingsCalls;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.system.input.IListenKeyboard;
import tv.ingames.j2dm.system.input.IMouseCapture;
import tv.ingames.j2dm.utils.J2DM_Point;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class AbstractGamePlayMode
extends J2DM_MatrixManager
implements IListenKeyboard,
IProgressTimeBar,
IPaused,
IButtonCallBack,
IMouseCapture {
    public static final int POINT_PER_CRAHING_BALL = 10;
    public static final int ID_SLOW_MODE_BAR = 0;
    public static final int ID_ADD_ROW_BAR = 1;
    protected DataLevel _dataLevel;
    protected AbstractLevel _levelManager;
    protected int _stateLoop;
    protected Vector _ballsToControl;
    private boolean _flagMouseDown;
    private J2DM_NumberField _txScore;
    protected int _score;
    private J2DM_ManagerShowScore _managerShowScore;
    private J2DM_ManagerExplodeBalls _managerExplodeBalls;
    private J2DM_DisplayContainer _containerExplodeBalls;
    private J2DM_ProgressTimeBar _addRowBar;
    private boolean _tryAddRowToMatrix;
    protected IStatePlaying _statePlaying;
    private J2DM_Sprite _spBackGround;
    private J2DM_SimpleMenu _menuPause;
    protected String _pathSoundGlass;
    protected String _pathSoundFinLevel;
    protected String _pathSoundWinMagicHand;
    protected String _pathSoundUseMagicHand;
    private Ball _tempBall;
    private ExplodeBall _tempExplodeBall;
    private boolean _pause = false;
    private J2DM_CursorInMatrix _cursorGame;
    J2DM_GenericButton _btnIconPause;
    private J2DM_CaptureIncomingsCalls _captureIncamingCalls;
    protected J2DM_Graphics _graphicsBackGround;
    protected Vector _tfCubes;
    protected long _timeStart;
    protected long _timePause;
    protected long _initTimePause;
    protected J2DM_Ball[] _vectorOfAddRowBalls;
    private J2DM_Image _imagePopUp;

    public AbstractGamePlayMode(IStatePlaying statePlaying, J2DM_Image imageBackGround, J2DM_Graphics graphicsBackGround) {
        this._statePlaying = statePlaying;
        this._graphicsBackGround = graphicsBackGround;
        J2DM_Stage.getInstance().suscribeKeyboardElement(this);
        J2DM_Stage.getInstance().suscribeMouseElement(this);
        J2DM_AbstractGameLoop.suscribePauseElement(this);
        this._captureIncamingCalls = new J2DM_CaptureIncomingsCalls(this);
        this._spBackGround = new J2DM_Sprite(imageBackGround);
        this._pathSoundGlass = J2DM_Loader.getInstance().getPathById(ExternalFiles.SOUND_GLASS);
        this._pathSoundFinLevel = J2DM_Loader.getInstance().getPathById(ExternalFiles.SOUND_FIN_LEVEL);
        this._pathSoundWinMagicHand = J2DM_Loader.getInstance().getPathById(ExternalFiles.SOUND_ADD_MAGIC_HAND);
        this._pathSoundUseMagicHand = J2DM_Loader.getInstance().getPathById(ExternalFiles.SOUND_USE_MAGIC_HAND);
        if (J2DM_SoundManager.getInstance().getEnable()) {
            J2DM_SoundManager.getInstance().loadMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND), true);
            J2DM_SoundManager.getInstance().load(this._pathSoundGlass);
            J2DM_SoundManager.getInstance().load(this._pathSoundFinLevel);
            J2DM_SoundManager.getInstance().load(this._pathSoundWinMagicHand);
            J2DM_SoundManager.getInstance().load(this._pathSoundUseMagicHand);
        }
    }

    public void createLevel(int level) {
        this.callInitLevel_1();
        this._dataLevel = this._levelManager.getDataLevel(level);
        this.setCantMatch(this._dataLevel.cantMatch);
        this.setCantMatchDiagonal(1000);
        this.setX(-16 + this._dataLevel.offsetXMatrix * 16);
        this.setY(-16 + this._dataLevel.offsetYMatrix * 16);
        this.addChild(this._spBackGround);
        this._spBackGround.setXFromGlobalToLocal(0);
        this._spBackGround.setYFromGlobalToLocal(0);
        this.createMatrix(this._dataLevel.maxy, this._dataLevel.maxx);
        this._tempBall = new Ball(this, 16, 16, this._dataLevel.cantColors, 1, 1, this._dataLevel.velx, this._dataLevel.vely, null);
        this.createBufferBalls(this._tempBall, 250);
        this.onFillMatrix();
        this._flagMouseDown = false;
        this._score = SettingsGamePlay.getInstance().getCurrentScore();
        this._txScore = new J2DM_NumberField(ScreenParametersApplication.NUMBER_FONT_GAME, this._score);
        this._txScore.setAnchorX(1);
        this._txScore.setAnchorY(2);
        this.addChild(this._txScore);
        this._txScore.setXFromGlobalToLocal(ScreenParametersApplication.PLY_TXT_CURRENT_SCORE_X);
        this._txScore.setYFromGlobalToLocal(ScreenParametersApplication.PLY_TXT_CURRENT_SCORE_Y);
        this._managerShowScore = new J2DM_ManagerShowScore(ScreenParametersApplication.LENGTH_BUFFER_SHOW_SCORE, ScreenParametersApplication.FRAMES_TO_SHOW_SCORE, ScreenParametersApplication.NUMBER_FONT_GAME);
        this._containerExplodeBalls = new J2DM_DisplayContainer();
        J2DM_Stage.getInstance().addElement(this._containerExplodeBalls, 1);
        this._tempExplodeBall = new ExplodeBall(this, 16, 16, this._dataLevel.cantColors, null);
        this._managerExplodeBalls = new J2DM_ManagerExplodeBalls(ScreenParametersApplication.LENGTH_BUFFER_EXPLODE_BALLS, this._tempExplodeBall, this._containerExplodeBalls);
        if (this._dataLevel.cantTempAddRow > 0) {
            this._addRowBar = new J2DM_ProgressTimeBar(1, this, new J2DM_ProgressBarParameters(new J2DM_Rect(48, 212, 144, 8), this._dataLevel.cantTempAddRow, ScreenParametersApplication.TYPE_ADD_ROW, 0xFFFFFF));
            this._addRowBar.start();
            J2DM_Stage.getInstance().addElement(this._addRowBar, 1);
            this._vectorOfAddRowBalls = this.getRowOfNewBalls(this._tempBall, this._maxy);
            int i = 0;
            while (i < this._vectorOfAddRowBalls.length) {
                this.addChild(this._vectorOfAddRowBalls[i]);
                ++i;
            }
        }
        this.removeChild(this._ballsContainer);
        this.addChild(this._ballsContainer);
        J2DM_Image imageCursorGame = J2DM_Loader.getInstance().getImageById(ExternalFiles.CURSOR_GAME);
        this._cursorGame = new J2DM_CursorInMatrix(imageCursorGame);
        this._cursorGame.init(this._matrix, this._dataLevel.initGridX, this._dataLevel.initGridY, 16, 16, 0, 0);
        this._cursorGame.setLimitYInit(this._dataLevel.limitYEnd + 1);
        this.addChild(this._cursorGame);
        if (J2DM_Stage.getInstance().supportTouch()) {
            this._cursorGame.setVisible(false);
        }
        this._tryAddRowToMatrix = false;
        if (this.canPlayMusicOnDevice()) {
            J2DM_SoundManager.getInstance().playMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND));
        }
        if (ScreenParametersApplication.ICON_PAUSE || J2DM_Stage.getInstance().supportTouch()) {
            this._btnIconPause = new J2DM_GenericButton(J2DM_Loader.getInstance().getImageById(ExternalFiles.ICON_PAUSE), 47, this);
            J2DM_Stage.getInstance().addElement(this._btnIconPause, 3);
            this._btnIconPause.setX(ScreenParametersApplication.PLY_PAUSE_ICON_X - this._btnIconPause.getWidth() / 2);
            this._btnIconPause.setY(ScreenParametersApplication.PLY_PAUSE_ICON_Y - this._btnIconPause.getHeight() / 2);
        }
        this.callInitLevel_2();
        this.initTimesPause();
    }

    private boolean canPlayMusicOnDevice() {
        return true;
    }

    protected void initTimesPause() {
        this._timeStart = System.currentTimeMillis();
        this._timePause = 0L;
    }

    public void pauseOn() {
        if (!this._pause) {
            this._initTimePause = System.currentTimeMillis();
        }
        this._pause = true;
        if (this._addRowBar != null) {
            this._addRowBar.setPauseOn();
        }
        this.createMenuPause();
        if (this.canPlayMusicOnDevice()) {
            J2DM_SoundManager.getInstance().stopMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND));
        }
    }

    public void setPauseOff() {
        if (this._pause) {
            this._timePause += System.currentTimeMillis() - this._initTimePause;
        }
        this._pause = false;
        J2DM_AbstractGameLoop.setPauseOff();
        if (this._addRowBar != null) {
            this._addRowBar.setPauseOff();
        }
        if (this.canPlayMusicOnDevice()) {
            J2DM_SoundManager.getInstance().playMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND));
        }
    }

    public void pauseOff() {
    }

    private void createMenuPause() {
        J2DM_GenericButton[][] buttons;
        if (this._menuPause != null) {
            return;
        }
        this._flagMouseDown = false;
        J2DM_Image imagePause = new J2DM_Image(J2DM_Image.getDefaultType(), J2DM_Stage.getInstance().getWidth(), J2DM_Stage.getInstance().getHeight());
        J2DM_Graphics graphicsPause = new J2DM_Graphics(imagePause);
        this.takeScreenShot(graphicsPause);
        J2DM_Image imageButton = J2DM_Loader.getInstance().getImageById(ExternalFiles.BUTTON_MENU);
        if (ScreenParametersApplication.TYPE_MENU_PAUSE == 2) {
            buttons = new J2DM_GenericButton[2][1];
            buttons[0][0] = new J2DM_GenericButtonWithText(imageButton, 15, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(17), this);
            buttons[0][0].setX(ScreenParametersApplication.PLY_PAUSE_BTN1_X);
            buttons[0][0].setY(ScreenParametersApplication.PLY_PAUSE_BTN1_Y);
            buttons[1][0] = new J2DM_GenericButtonWithText(imageButton, 5, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(7), this);
            buttons[1][0].setX(ScreenParametersApplication.PLY_PAUSE_BTN2_X);
            buttons[1][0].setY(ScreenParametersApplication.PLY_PAUSE_BTN2_Y);
        } else {
            buttons = new J2DM_GenericButton[1][2];
            buttons[0][0] = new J2DM_GenericButtonWithText(imageButton, 15, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(17), this);
            buttons[0][0].setX(ScreenParametersApplication.PLY_PAUSE_BTN1_X);
            buttons[0][0].setY(ScreenParametersApplication.PLY_PAUSE_BTN1_Y);
            buttons[0][1] = new J2DM_GenericButtonWithText(imageButton, 5, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(7), this);
            buttons[0][1].setX(ScreenParametersApplication.PLY_PAUSE_BTN2_X);
            buttons[0][1].setY(ScreenParametersApplication.PLY_PAUSE_BTN2_Y);
        }
        this._imagePopUp = J2DM_Loader.getInstance().getImageById(ExternalFiles.POP_UP_WINDOW);
        graphicsPause.drawImage(ScreenParametersApplication.PAUSE_WINDOWS_X, ScreenParametersApplication.PAUSE_WINDOWS_Y, this._imagePopUp.getWidth(), this._imagePopUp.getHeight(), this._imagePopUp, 3);
        J2DM_TextField textField = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(32));
        textField.setX(ScreenParametersApplication.PAUSE_WINDOWS_TXT_X);
        textField.setY(ScreenParametersApplication.PAUSE_WINDOWS_TXT_Y);
        textField.setAnchorX(1);
        textField.setAnchorY(2);
        textField.draw(graphicsPause);
        textField.destroy();
        textField = null;
        this._menuPause = new J2DM_SimpleMenu(buttons, new J2DM_Sprite(imagePause, new J2DM_Point(0.0f, 0.0f)));
        this._menuPause.show();
    }

    public void buttonEvent(int event, J2DM_GenericButton button) {
        if (event == 0) {
            switch (button.getTypeButton()) {
                case 15: {
                    this.setPauseOff();
                    break;
                }
                case 5: {
                    this.setPauseOff();
                    this._statePlaying.gotoMenu();
                    break;
                }
                case 16: {
                    break;
                }
                case 47: {
                    J2DM_AbstractGameLoop.setPauseOn();
                    J2DM_AbstractGameLoop.setPauseOff();
                }
            }
        }
    }

    public void keyPressed(char key) {
        if (key == 'p') {
            J2DM_AbstractGameLoop.setPauseOn();
            J2DM_AbstractGameLoop.setPauseOff();
        }
    }

    public void keyReleased(char key) {
    }

    public void keyRepeated(char key) {
    }

    public void specialKeyPressed(int keyCode) {
        switch (keyCode) {
            case 0: {
                this._cursorGame.setVisible(true);
                this._cursorGame.keyPressedUp();
                break;
            }
            case 1: {
                this._cursorGame.setVisible(true);
                this._cursorGame.keyPressedDown();
                break;
            }
            case 2: {
                this._cursorGame.setVisible(true);
                this._cursorGame.keyPressedLeft();
                break;
            }
            case 3: {
                this._cursorGame.setVisible(true);
                this._cursorGame.keyPressedRight();
                break;
            }
            case 4: 
            case 32: {
                if (this._pause) break;
                this._flagMouseDown = true;
                break;
            }
            case -7: 
            case -6: 
            case 5: {
                J2DM_AbstractGameLoop.setPauseOn();
                J2DM_AbstractGameLoop.setPauseOff();
            }
        }
    }

    public void specialKeyReleased(int keyCode) {
    }

    public void specialKeyRepeated(int keyCode) {
    }

    protected boolean canClick() {
        return true;
    }

    protected void onFillMatrix() {
        this.fillMatrixFromDown(this._dataLevel.cantFill, 999);
    }

    protected boolean canMoveHorizontal() {
        return true;
    }

    protected boolean canAddNewBrickonExplode() {
        return false;
    }

    protected void callInitLevel_1() {
    }

    protected void callInitLevel_2() {
    }

    protected boolean canDestroyOneBall() {
        return false;
    }

    protected void callDestroyOneBall() {
    }

    protected void callDestroyBall(J2DM_Ball ball) {
    }

    protected void callDestroyVectorOfBalls(Vector balls) {
    }

    protected void callUpdate() {
    }

    protected boolean hasLevelFinished() {
        return false;
    }

    protected boolean isGameOver() {
        return false;
    }

    protected void callActualizeScore(int value) {
    }

    public void playSoundBlock() {
        J2DM_SoundManager.getInstance().play(this._pathSoundGlass);
    }

    public void playSoundEndLevel() {
        J2DM_SoundManager.getInstance().play(this._pathSoundFinLevel);
    }

    public void playSoundWinMagicHand() {
        J2DM_SoundManager.getInstance().play(this._pathSoundWinMagicHand);
    }

    public void playSoundUseMagicHand() {
        J2DM_SoundManager.getInstance().play(this._pathSoundUseMagicHand);
    }

    protected void checkHorizontalMove() {
        int indexColumn;
        if (this.canMoveHorizontal() && !this.checkIfThereIsAnyBallMoving() && (indexColumn = this.getEmptyMiddleColumn(this._matrix)) != -1) {
            if (indexColumn < this._dataLevel.maxx / 2) {
                this.shiftBallsRight(this._matrix, indexColumn, 5);
            } else {
                this.shiftBallsLeft(this._matrix, indexColumn, 5);
            }
        }
    }

    protected void commitMouseDown() {
        this._flagMouseDown = false;
        if (this.canClick() && this._cursorGame != null) {
            int gridX = this._cursorGame.getGridx();
            int gridY = this._cursorGame.getGridy();
            if (this._matrix[gridY][gridX] instanceof Ball) {
                J2DM_Ball stopBall = null;
                Vector ballsDestroyed = null;
                stopBall = (J2DM_Ball)this._matrix[gridY][gridX];
                J2DM_StructControlBalls structBalls = this.getMatchBallsDiagonalAndFree(this._matrix, stopBall.getGridy(), stopBall.getGridx(), stopBall.getColor());
                this.cleanStructBalls(this._typeControlNewBalls, structBalls);
                int cantBallsDestroy = structBalls.ballsFree.size();
                if (cantBallsDestroy > 0) {
                    ballsDestroyed = this.destroyBalls(structBalls);
                    this.playSoundBlock();
                    this.callDestroyVectorOfBalls(ballsDestroyed);
                    this._managerExplodeBalls.addBall(ballsDestroyed);
                    if (this.canAddNewBrickonExplode()) {
                        this.addNewBallsFromTopOnGridXFromVectorOfBalls(this._matrix, ballsDestroyed, this._dataLevel.limitYInit, this._dataLevel.limitYEnd);
                    }
                    this.manageScore(stopBall, cantBallsDestroy);
                } else if (this.canDestroyOneBall()) {
                    this.callDestroyOneBall();
                    this.callDestroyBall(stopBall);
                    this._managerExplodeBalls.addOneBall(stopBall);
                    if (this.canAddNewBrickonExplode()) {
                        this.addNewBallFromTopOnGridX(this._matrix, stopBall.getGridx(), this._dataLevel.limitYInit, this._dataLevel.limitYEnd);
                    }
                    this.removeBallFromMatrix(stopBall);
                }
            }
        }
    }

    public void update() {
        if (this._pause) {
            return;
        }
        if (this._menuPause != null) {
            this._menuPause.hide();
            this._menuPause.destroy();
            this._menuPause = null;
        }
        if (this._flagMouseDown) {
            this.commitMouseDown();
        }
        this._stateLoop = 0;
        this._ballsToControl = this.updateAllBallsFromMatrix();
        this.checkHorizontalMove();
        if (this._tryAddRowToMatrix) {
            this.addRowToMatrixAndRestart();
        }
        this.callUpdate();
        if (this.hasLevelFinished()) {
            this.playSoundEndLevel();
            this._stateLoop = 2;
        } else if (this.isGameOver()) {
            this._stateLoop = 1;
        }
        switch (this._stateLoop) {
            case 2: {
                if (this.canPlayMusicOnDevice()) {
                    J2DM_SoundManager.getInstance().stopMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND));
                }
                SettingsGamePlay.getInstance().setCurrentScore(this._score);
                this.saveImage();
                this._statePlaying.finishLevel();
                break;
            }
            case 1: {
                if (this.canPlayMusicOnDevice()) {
                    J2DM_SoundManager.getInstance().stopMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND));
                }
                SettingsGamePlay.getInstance().setCurrentScore(this._score);
                this.saveImage();
                this._statePlaying.gameOver();
            }
        }
    }

    protected void saveImage() {
        J2DM_Image newImage = new J2DM_Image(J2DM_Image.getDefaultType(), J2DM_Stage.getInstance().getWidth(), J2DM_Stage.getInstance().getHeight());
        J2DM_Graphics newGraphics = newImage.getGraphics();
        this.takeScreenShot(newGraphics);
        SettingsGamePlay.getInstance().setImage(newImage);
    }

    protected void takeScreenShot(J2DM_Graphics graphics) {
        this.draw(graphics);
        if (this._addRowBar != null) {
            this._addRowBar.draw(graphics);
        }
    }

    public void finishProgressTimeBar(int id) {
        switch (id) {
            case 1: {
                this._tryAddRowToMatrix = true;
                this.addRowToMatrixAndRestart();
            }
        }
    }

    private void addRowToMatrixAndRestart() {
        if (!this.checkIfThereIsAnyBallMoving()) {
            this._addRowBar.start();
            this.addRowFromLastLine(3, this._vectorOfAddRowBalls);
            J2DM_Ball[] vectorBalls = this.getRowOfNewBalls(this._tempBall, this._maxy);
            int i = 0;
            while (i < this._vectorOfAddRowBalls.length) {
                this._vectorOfAddRowBalls[i].setColor(vectorBalls[i].getColor());
                ++i;
            }
            i = 0;
            while (i < vectorBalls.length) {
                vectorBalls[i].destroy();
                vectorBalls[i] = null;
                ++i;
            }
            this._tryAddRowToMatrix = false;
        }
    }

    private void manageScore(J2DM_Ball stopBall, int cantMatch) {
        if (stopBall == null || cantMatch == 0) {
            return;
        }
        int scorePerBall = 10 + (cantMatch - this.getCantMatch());
        int scoreToSum = scorePerBall * cantMatch;
        this.callActualizeScore(scoreToSum);
        this._score += scoreToSum;
        this._txScore.setTextNumber(this._score);
    }

    protected void showCubesShape(int maxxCubes) {
        this._tfCubes = new Vector();
        J2DM_Image imageCubes = J2DM_Loader.getInstance().getImageById(ExternalFiles.BALLS);
        int i = 0;
        while (i < this._dataLevel.cantColors) {
            int xCube = ScreenParametersApplication.PLY_CUBES_LEFT_X0 + ScreenParametersApplication.PLY_CUBES_LEFT_DELTAX * (i % maxxCubes) - 8 + (int)((double)ScreenParametersApplication.PLY_CUBES_LEFT_DELTAX * 0.5);
            int yCube = ScreenParametersApplication.PLY_CUBES_LEFT_Y0 + ScreenParametersApplication.PLY_CUBES_LEFT_DELTAY * (i / maxxCubes) - 8;
            this._graphicsBackGround.drawImage(xCube, yCube, 16, 16, imageCubes, 16 * i, 0);
            J2DM_NumberField numberField = new J2DM_NumberField(ScreenParametersApplication.NUMBER_FONT_GAME, this._dataLevel.cantMatchColorBalls);
            this._tfCubes.addElement(numberField);
            J2DM_Stage.getInstance().addElement(numberField, 3);
            numberField.setAnchorX(1);
            numberField.setAnchorY(32);
            numberField.setX(xCube + 8);
            numberField.setY(yCube + ScreenParametersApplication.PLY_CUBES_LEFT_DELTAY / 2 + 8);
            ++i;
        }
    }

    public void destroy() {
        if (this._vectorOfAddRowBalls != null) {
            int i = 0;
            while (i < this._vectorOfAddRowBalls.length) {
                this.removeChild(this._vectorOfAddRowBalls[i]);
                this._vectorOfAddRowBalls[i].destroy();
                this._vectorOfAddRowBalls[i] = null;
                ++i;
            }
        }
        if (this._tfCubes != null) {
            int i = 0;
            while (i < this._tfCubes.size()) {
                J2DM_NumberField numberField = (J2DM_NumberField)this._tfCubes.elementAt(i);
                J2DM_Stage.getInstance().removeElement(numberField, 3);
                numberField.destroy();
                numberField = null;
                ++i;
            }
            this._tfCubes.removeAllElements();
            this._tfCubes = null;
        }
        if (this._tempBall != null) {
            this._tempBall.destroy();
            this._tempBall = null;
        }
        if (this._spBackGround != null) {
            this.removeChild(this._spBackGround);
            this._spBackGround.destroy();
            this._spBackGround = null;
        }
        this._dataLevel = null;
        this._levelManager = null;
        if (this._managerShowScore != null) {
            this._managerShowScore.destroy();
            this._managerShowScore = null;
        }
        if (this._tempExplodeBall != null) {
            this._tempExplodeBall.destroy();
            this._tempExplodeBall = null;
        }
        if (this._managerExplodeBalls != null) {
            this._managerExplodeBalls.destroy();
            this._managerExplodeBalls = null;
        }
        if (this._containerExplodeBalls != null) {
            J2DM_Stage.getInstance().removeElement(this._containerExplodeBalls, 1);
            this._containerExplodeBalls.destroy();
            this._containerExplodeBalls = null;
        }
        if (this._addRowBar != null) {
            J2DM_Stage.getInstance().removeElement(this._addRowBar, 1);
            this._addRowBar.destroy();
            this._addRowBar = null;
        }
        if (this._menuPause != null) {
            this._menuPause.destroy();
            this._menuPause = null;
        }
        if (this._captureIncamingCalls != null) {
            this._captureIncamingCalls.destroy();
            this._captureIncamingCalls = null;
        }
        if (this._btnIconPause != null) {
            J2DM_Stage.getInstance().removeElement(this._btnIconPause, 3);
            this._btnIconPause.destroy();
            this._btnIconPause = null;
        }
        if (this._txScore != null) {
            this.removeChild(this._txScore);
            this._txScore.destroy();
            this._txScore = null;
        }
        if (this._ballsToControl != null) {
            this._ballsToControl.removeAllElements();
            this._ballsToControl = null;
        }
        J2DM_Stage.getInstance().unsuscribeKeyboardElement(this);
        J2DM_AbstractGameLoop.unsuscribePauseElement(this);
        J2DM_Stage.getInstance().unsuscribeMouseElement(this);
        J2DM_SoundManager.getInstance().destroyMusic(J2DM_Loader.getInstance().getPathById(ExternalFiles.MUSIC_BACKGROUND));
        super.destroy();
    }

    public void onMouseDown(int x, int y) {
    }

    public void onMouseUp(int x, int y) {
    }

    public void onMouseMove(int x, int y) {
    }

    public void onMouseDownStage(int x, int y) {
        if (this._cursorGame != null) {
            this._cursorGame.setVisible(false);
            boolean flag = this._cursorGame.setGridXYFromPlotXY(x - this.getX(), y - this.getY());
            if (flag && !this._pause) {
                this._flagMouseDown = true;
            }
        }
    }

    public void onMouseUpStage(int x, int y) {
    }

    public J2DM_Rect getBounds() {
        return null;
    }

    public boolean isPressed() {
        return false;
    }

    public boolean getEnable() {
        return true;
    }

    public boolean getVisible() {
        return true;
    }
}

