/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display;

import java.util.Hashtable;
import tv.ingames.j2dm.display.IEndAnimationCallback;
import tv.ingames.j2dm.display.J2DM_AbstractSprite;
import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_SpriteAnimation;
import tv.ingames.j2dm.media.J2DM_AnimationLibrary;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class J2DM_AnimatedSprite
extends J2DM_AbstractSprite {
    protected Hashtable _buffer;
    protected IEndAnimationCallback _endAnimationCallBack;
    protected boolean _loop;
    protected boolean _isPlaying;
    protected int _frameStep;

    public J2DM_AnimatedSprite(IEndAnimationCallback endAnimationCallback, String name) {
        super(name);
        this.init(endAnimationCallback);
    }

    public J2DM_AnimatedSprite(IEndAnimationCallback endAnimationCallback) {
        this.init(endAnimationCallback);
    }

    private void init(IEndAnimationCallback endAnimationCallback) {
        this._endAnimationCallBack = endAnimationCallback;
        this._buffer = new Hashtable();
        this._frameStep = 1;
    }

    public boolean addAnimation(String animationName, J2DM_SpriteAnimation animation) {
        if (animation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::addAnimation", "The animation is null, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (!J2DM_StringTools.validateString(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::addAnimation", "Invalid Animation Name, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (this._buffer.containsKey(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::addAnimation", "The animation already exists, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._buffer.put(animationName, animation);
        return true;
    }

    public boolean addAnimationFromLibrary(String animationName, String key, String subkey) {
        if (!J2DM_StringTools.validateString(animationName) || !J2DM_StringTools.validateString(key) || !J2DM_StringTools.validateString(subkey) || this._buffer.containsKey(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::addAnimationFromLibrary", "One of the parameters is null or animationName already exist, animationName:" + animationName + " key=" + key + " subkey=" + subkey, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        J2DM_SpriteAnimation auxAnimation = J2DM_AnimationLibrary.getInstance().getAnimation(key, subkey);
        if (auxAnimation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::addAnimationFromLibrary", "Doesn't exists the animation key in the library, animationName:" + animationName + " key=" + key + " subkey=" + subkey, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this.addAnimation(animationName, auxAnimation);
        return true;
    }

    public J2DM_SpriteAnimation getAnimation(String animationName) {
        if (!J2DM_StringTools.validateString(animationName) || !this._buffer.containsKey(animationName)) {
            return null;
        }
        J2DM_SpriteAnimation animation = (J2DM_SpriteAnimation)this._buffer.get(animationName);
        return animation;
    }

    public boolean replaceAnimation(String animationName, J2DM_SpriteAnimation newAnimation) {
        if (!J2DM_StringTools.validateString(animationName) || newAnimation == null || !this._buffer.containsKey(animationName)) {
            return false;
        }
        this._buffer.remove(animationName);
        this._buffer.put(animationName, newAnimation);
        return true;
    }

    public boolean replaceAnimationFromLibrary(String animationName, String key, String subkey) {
        if (!(J2DM_StringTools.validateString(animationName) && J2DM_StringTools.validateString(key) && J2DM_StringTools.validateString(subkey) && this._buffer.containsKey(animationName))) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::replaceAnimationFromLibrary", "One of the parameters is null, animationName:" + animationName + " key=" + key + " subkey=" + subkey, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        J2DM_SpriteAnimation auxAnimation = J2DM_AnimationLibrary.getInstance().getAnimation(key, subkey);
        if (auxAnimation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::replaceAnimationFromLibrary", "Doesn't exists the animation key in the library, animationName:" + animationName + " key=" + key + " subkey=" + subkey, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this.replaceAnimation(animationName, auxAnimation);
        return true;
    }

    public boolean deleteAnimation(String animationName) {
        if (!J2DM_StringTools.validateString(animationName) || !this._buffer.containsKey(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::deleteAnimation", "The animation doesn't exists or is null, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (this._currentAnimation != null && this._currentAnimation.getName() == animationName) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::deleteAnimation", "The animation is playing, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._buffer.remove(animationName);
        return true;
    }

    public int getTotalFramesByAnimation(String animationName) {
        if (!J2DM_StringTools.validateString(animationName) || !this._buffer.containsKey(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::getTotalFramesByAnimation", "The animation doesn't exists or is null, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return 0;
        }
        J2DM_SpriteAnimation auxAnimation = (J2DM_SpriteAnimation)this._buffer.get(animationName);
        return auxAnimation.getFrameCount();
    }

    public int getTotalFramesOfCurrentAnimation() {
        if (this._currentAnimation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::getTotalFramesOfCurrentAnimation", "There isn't a current animation playing", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return 0;
        }
        return this._currentAnimation.getFrameCount();
    }

    public int getCurrentFrame() {
        return this._currentFrame;
    }

    public String getCurrentAnimationName() {
        if (this._currentAnimation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::getCurrentAnimationName", "There isn't a current animation playing", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        return this._currentAnimation.getName();
    }

    public boolean playAnimation(String animationName) {
        return this.playAnimation(animationName, true);
    }

    public boolean playAnimation(String animationName, boolean loop) {
        if (!J2DM_StringTools.validateString(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::playAnimation", "The parameter is null or empty, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (!this._buffer.containsKey(animationName)) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::playAnimation", "The animation doesn't exists, animationName:" + animationName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._loop = loop;
        this._currentAnimation = (J2DM_SpriteAnimation)this._buffer.get(animationName);
        this._currentFrame = 0;
        this._isPlaying = true;
        return true;
    }

    public boolean gotoAndStop(int frame) {
        if (this._currentAnimation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::gotoAndStop", "The current animation is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (frame < 0 || frame >= this._currentAnimation.getFrameCount()) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::gotoAndStop", "Invalid frame, frame:" + frame, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._currentFrame = frame;
        this._isPlaying = false;
        return true;
    }

    public boolean gotoAndPlay(int frame) {
        if (this._currentAnimation == null) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::gotoAndPlay", "The current animation is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        if (frame < 0 || frame >= this._currentAnimation.getFrameCount()) {
            J2DM_Console.getInstance().addLog("J2DM_AnimatedSprite::gotoAndStop", "Invalid frame, frame" + frame, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        this._currentFrame = frame;
        this._isPlaying = true;
        return true;
    }

    public void stop() {
        this._isPlaying = false;
    }

    public void destroy() {
        super.destroy();
        this.stop();
        if (this._buffer != null) {
            this._buffer.clear();
            this._buffer = null;
        }
    }

    public void update() {
        super.update();
        if (!this._isPlaying) {
            return;
        }
        this.updateCurrentFrame();
        if ((this._frameStep > 0 && this._currentFrame == this._currentAnimation.getFrameCount() - 1 || this._frameStep < 0 && this._currentFrame == 0) && this._endAnimationCallBack != null) {
            this._endAnimationCallBack.endAnimationCallBack();
        }
    }

    protected void updateCurrentFrame() {
        this._currentFrame += this._frameStep;
        if (this._frameStep > 0) {
            if (this._currentFrame >= this._currentAnimation.getFrameCount()) {
                if (!this._loop) {
                    this._isPlaying = false;
                    this._currentFrame = this._currentAnimation.getFrameCount() - 1;
                } else {
                    this._currentFrame = 0;
                }
            }
        } else if (this._currentFrame < 0) {
            if (!this._loop) {
                this._isPlaying = false;
                this._currentFrame = 0;
            } else {
                this._currentFrame = this._currentAnimation.getFrameCount() - 1;
            }
        }
    }

    protected int normalizeFrame(int frame) {
        if (this._currentAnimation == null) {
            return 0;
        }
        if (frame >= this._currentAnimation.getFrameCount()) {
            frame = this._currentAnimation.getFrameCount() - 1;
        }
        if (frame < 0) {
            frame = 0;
        }
        return frame;
    }

    public void playReverse() {
        this._frameStep *= -1;
    }

    public void playBackward() {
        this._frameStep = -1;
    }

    public void playForward() {
        this._frameStep = 1;
    }

    public void draw(J2DM_Graphics g) {
        super.draw(g);
    }
}

