/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.keyboardTouch;

import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import tv.ingames.j2dm.keyboardTouch.Button;
import tv.ingames.j2dm.keyboardTouch.MatrixButton;
import tv.ingames.j2dm.keyboardTouch.ModeButton;
import tv.ingames.j2dm.keyboardTouch.PushButton;
import tv.ingames.j2dm.keyboardTouch.TextFieldArea;
import tv.ingames.j2dm.keyboardTouch.VirtualKeyboardListener;

public class TouchKeyboard
extends GameCanvas {
    private final String SMALL_IMAGES_PATH;
    private final String BIG_IMAGES_PATH;
    private int keyWidth;
    private int keyHeight;
    private int keyBoardWidth;
    private int keyBoardHeight;
    public static final int KEYBOARD_SMALL = 0;
    public static final int KEYBOARD_BIG = 1;
    private int keyBoardType;
    private TextFieldArea textField;
    private Button[] allButtons;
    private Button lastSelectedButton;
    private int lastSelectedHashCode = -1;
    private MatrixButton charactersArea;
    private ModeButton modeCharactersButton;
    private ModeButton modeNumbersButton;
    private ModeButton modeSpecialCharactersButton;
    private PushButton shiftButton;
    private PushButton spaceButton;
    private PushButton enterButton;
    private PushButton backspaceButton;
    private PushButton moveLeftButton;
    private PushButton moveRightButton;
    private PushButton okButton;
    private ModeButton modePointerButton;
    private Sprite pointer;
    private boolean activatePointer;
    private String imagesPath;
    private final String SHIFT_IMAGE_PATH;
    private final String LETTERS_IMAGE_PATH;
    private final String NUMBERS_IMAGE_PATH;
    private final String SPECIAL_CHARACTERS_IMAGE_PATH;
    private final String SPACE_IMAGE_PATH;
    private final String ENTER_IMAGE_PATH;
    private final String BACKSPACE_IMAGE_PATH;
    private final String MOVE_LEFT_IMAGE_PATH;
    private final String MOVE_RIGHT_IMAGE_PATH;
    private final String OK_IMAGE_PATH;
    private final String POINTER_IMAGE_PATH;
    private final String POINTER_BUTTON_IMAGE_PATH;
    private String KEYS_IMAGE_PATH = "/keys.png";
    private Graphics graphics;
    private int charactersAreaUperLeftY;
    private int charactersAreaUperLeftX;
    private int TOP_LEFT_X = 0;
    private int TOP_LEFT_Y = 0;
    private LayerManager layerManager;
    char[][] lowerCaseAlphabeticalKeys = new char[][]{{'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', '\u00c3'}, {'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '?'}};
    char[][] upperCaseAlphabeticalKeys = new char[][]{{'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P'}, {'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', '\u00c3'}, {'Z', 'X', 'C', 'V', 'B', 'N', 'M', ',', '.', '?'}};
    char[][] numberKyes = new char[][]{{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'}, {'{', '}', '[', ']', '+', '-', '#', '*', '/', '\\'}, {'!', '|', '\"', '\'', '@', ':', ';', '.', '$', '%'}};
    char[][] specialCharacterKeys;
    private int textFieldWidth;
    private int textFieldHeight;
    private int textFieldUperLeftX;
    private int textFieldUperLeftY;
    private VirtualKeyboardListener invoker;
    private int transactionId;
    private Font textFieldAreaFont;
    private Font charactersAreaFont;
    private int backgroundColor;
    protected String abc;

    public TouchKeyboard(int keyBoardType, int posX, int posY, boolean activatePointer, String abc) {
        super(!activatePointer);
        this.SMALL_IMAGES_PATH = "/small";
        this.BIG_IMAGES_PATH = "/big";
        this.SHIFT_IMAGE_PATH = "/shift.png";
        this.LETTERS_IMAGE_PATH = "/letters.png";
        this.NUMBERS_IMAGE_PATH = "/numbers.png";
        this.SPECIAL_CHARACTERS_IMAGE_PATH = "/specialCharacters.png";
        this.SPACE_IMAGE_PATH = "/space.png";
        this.ENTER_IMAGE_PATH = "/enter.png";
        this.BACKSPACE_IMAGE_PATH = "/backspace.png";
        this.MOVE_LEFT_IMAGE_PATH = "/moveLeft.png";
        this.MOVE_RIGHT_IMAGE_PATH = "/moveRight.png";
        this.OK_IMAGE_PATH = "/ok.png";
        this.POINTER_IMAGE_PATH = "/pointer.png";
        this.POINTER_BUTTON_IMAGE_PATH = "/pointerButton.png";
        char[][] cArrayArray = new char[3][];
        cArrayArray[0] = new char[]{'\u00c3', '\u00c3', '\u00c3', '\u00c3', '\u00c3', '\u00c3', '\u00c3', '\u00c3', '\u00c3', '\u00c3'};
        char[] cArray = new char[10];
        cArray[0] = 95;
        cArray[1] = 126;
        cArray[2] = 38;
        cArray[3] = 60;
        cArray[4] = 62;
        cArray[5] = 61;
        cArray[6] = 63;
        cArrayArray[1] = cArray;
        cArrayArray[2] = new char[10];
        this.specialCharacterKeys = cArrayArray;
        this.backgroundColor = 0xFFFFFF;
        this.setFullScreenMode(true);
        this.TOP_LEFT_X = posX;
        this.TOP_LEFT_Y = posY;
        this.activatePointer = activatePointer;
        this.keyBoardType = keyBoardType;
        this.abc = abc;
        this.init();
    }

    public int resetKeyBoard() {
        this.textField.clearTextField();
        this.paintKeyBoard();
        this.transactionId = Math.abs(new Random().nextInt());
        return this.transactionId;
    }

    private void paintKeyBoard() {
        this.graphics.setColor(this.backgroundColor);
        this.graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.textField.paint(this.graphics, this.textFieldUperLeftX, this.textFieldUperLeftY);
        this.layerManager.paint(this.graphics, 0, 0);
        this.charactersArea.paint(this.graphics);
        this.pointer.paint(this.graphics);
        this.flushGraphics();
    }

    private void init() {
        this.allButtons = new Button[12];
        this.graphics = this.getGraphics();
        this.layerManager = new LayerManager();
        this.initKeyBoardSize();
        this.initTextField();
        this.initPointer();
        this.initCharactersArea();
        this.initButtons();
    }

    private void initKeyBoardSize() {
        switch (this.keyBoardType) {
            case 1: {
                this.imagesPath = "/big";
                this.textFieldAreaFont = Font.getFont((int)32, (int)0, (int)16);
                this.charactersAreaFont = Font.getFont((int)32, (int)0, (int)16);
                break;
            }
            default: {
                this.imagesPath = "/small";
                this.textFieldAreaFont = Font.getFont((int)32, (int)0, (int)0);
                this.charactersAreaFont = Font.getFont((int)32, (int)0, (int)8);
            }
        }
        Image keysImage = this.createImage(this.KEYS_IMAGE_PATH);
        this.keyWidth = keysImage.getWidth() / 3;
        this.keyHeight = keysImage.getHeight();
        keysImage = null;
        this.keyBoardWidth = this.keyWidth * this.lowerCaseAlphabeticalKeys[0].length;
        this.keyBoardHeight = this.keyHeight * 6;
    }

    private void initTextField() {
        this.textFieldHeight = this.keyHeight * 2;
        this.textFieldWidth = this.lowerCaseAlphabeticalKeys[0].length * this.keyWidth - this.keyWidth * 3;
        this.textFieldUperLeftX = this.TOP_LEFT_X + this.keyWidth;
        this.textFieldUperLeftY = this.TOP_LEFT_Y;
        this.textField = new TextFieldArea(this.textFieldWidth, this.textFieldHeight);
        this.textField.setTextFieldFont(this.textFieldAreaFont);
    }

    private void initCharactersArea() {
        Image charactersAreaTyledImage = this.createImage(this.KEYS_IMAGE_PATH);
        Sprite keyPreview = new Sprite(charactersAreaTyledImage, this.keyWidth, this.keyHeight);
        this.charactersAreaUperLeftY = this.TOP_LEFT_Y + this.textFieldHeight;
        this.charactersAreaUperLeftX = this.TOP_LEFT_X;
        this.charactersArea = new MatrixButton(this.lowerCaseAlphabeticalKeys, this.keyWidth, this.keyHeight, charactersAreaTyledImage, keyPreview){

            public void execute() {
                TouchKeyboard.this.charactersAreaActions();
            }
        };
        this.charactersArea.setPosition(this.charactersAreaUperLeftX, this.charactersAreaUperLeftY);
        this.charactersArea.setFont(this.charactersAreaFont);
        this.allButtons[0] = this.charactersArea;
    }

    private void initButtons() {
        int keyboardWith = this.lowerCaseAlphabeticalKeys[0].length * this.keyWidth;
        int posX = this.charactersAreaUperLeftX;
        int posY = this.charactersAreaUperLeftY + this.keyHeight * 3;
        this.shiftButton = new PushButton(new Sprite(this.createImage("/shift.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.shiftButtonActions();
            }
        };
        this.shiftButton.setPosition(posX, posY);
        this.layerManager.append(this.shiftButton.getLayer());
        this.allButtons[1] = this.shiftButton;
        this.modeCharactersButton = new ModeButton(new Sprite(this.createImage("/letters.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.modeCharactersButtonActions();
            }
        };
        this.modeCharactersButton.setPosition(posX += this.shiftButton.getLayer().getWidth(), posY);
        this.modeCharactersButton.setFrame(1);
        this.layerManager.append(this.modeCharactersButton.getLayer());
        this.allButtons[2] = this.modeCharactersButton;
        this.modeNumbersButton = new ModeButton(new Sprite(this.createImage("/numbers.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.modeNumbersButtonActions();
            }
        };
        this.modeNumbersButton.setPosition(posX += this.modeCharactersButton.getLayer().getWidth(), posY);
        this.layerManager.append(this.modeNumbersButton.getLayer());
        this.allButtons[3] = this.modeNumbersButton;
        this.modeSpecialCharactersButton = new ModeButton(new Sprite(this.createImage("/specialCharacters.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.modeSpecialCharacterButtonActions();
            }
        };
        this.modeSpecialCharactersButton.setPosition(posX += this.modeNumbersButton.getLayer().getWidth(), posY);
        this.layerManager.append(this.modeSpecialCharactersButton.getLayer());
        this.allButtons[4] = this.modeSpecialCharactersButton;
        this.spaceButton = new PushButton(new Sprite(this.createImage("/space.png"), 4 * this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.spaceButtonActions();
            }
        };
        this.spaceButton.setPosition(posX += this.modeSpecialCharactersButton.getLayer().getWidth(), posY);
        this.layerManager.append(this.spaceButton.getLayer());
        this.allButtons[5] = this.spaceButton;
        this.enterButton = new PushButton(new Sprite(this.createImage("/enter.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.enterButtonActions();
            }
        };
        this.enterButton.setPosition(posX += this.spaceButton.getLayer().getWidth(), posY);
        this.layerManager.append(this.enterButton.getLayer());
        this.allButtons[6] = this.enterButton;
        this.modePointerButton = new ModeButton(new Sprite(this.createImage("/pointerButton.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.modePointerButtonActions();
            }
        };
        this.modePointerButton.setPosition(posX += this.enterButton.getLayer().getWidth(), posY);
        this.layerManager.append(this.modePointerButton.getLayer());
        posX += this.modePointerButton.getLayer().getWidth();
        this.allButtons[7] = this.modePointerButton;
        if (!this.activatePointer) {
            this.modePointerButton.getLayer().setVisible(false);
        }
        this.okButton = new PushButton(new Sprite(this.createImage("/ok.png"), this.keyWidth, 2 * this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.okButtonActions();
            }
        };
        this.okButton.setPosition(this.TOP_LEFT_X, this.TOP_LEFT_Y);
        this.layerManager.append(this.okButton.getLayer());
        this.allButtons[8] = this.okButton;
        this.backspaceButton = new PushButton(new Sprite(this.createImage("/backspace.png"), 2 * this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.backspaceButtonActions();
            }
        };
        this.backspaceButton.setPosition(this.TOP_LEFT_X + keyboardWith - 2 * this.keyWidth, this.TOP_LEFT_Y);
        this.layerManager.append(this.backspaceButton.getLayer());
        this.allButtons[9] = this.backspaceButton;
        this.moveLeftButton = new PushButton(new Sprite(this.createImage("/moveLeft.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.moveLeftButtonActions();
            }
        };
        this.moveLeftButton.setPosition(this.TOP_LEFT_X + keyboardWith - 2 * this.keyWidth, this.TOP_LEFT_Y + this.keyHeight);
        this.layerManager.append(this.moveLeftButton.getLayer());
        this.allButtons[10] = this.moveLeftButton;
        this.moveRightButton = new PushButton(new Sprite(this.createImage("/moveRight.png"), this.keyWidth, this.keyHeight)){

            public void execute() {
                TouchKeyboard.this.moveRightButtonActions();
            }
        };
        this.moveRightButton.setPosition(this.TOP_LEFT_X + keyboardWith - this.keyWidth, this.TOP_LEFT_Y + this.keyHeight);
        this.layerManager.append(this.moveRightButton.getLayer());
        this.allButtons[11] = this.moveRightButton;
    }

    public void initPointer() {
        Image img = this.createImage("/pointer.png");
        this.pointer = new Sprite(img);
        this.pointer.setPosition(this.TOP_LEFT_X + this.keyWidth / 2 - this.pointer.getWidth() / 2, this.TOP_LEFT_Y + this.keyHeight / 2 - this.pointer.getHeight() / 2);
        this.pointer.setVisible(false);
    }

    protected void pointerPressed(int x, int y) {
        this.buttonPressed(x, y);
        this.paintKeyBoard();
    }

    protected void pointerReleased(int x, int y) {
        this.buttonReleased();
        this.paintKeyBoard();
    }

    protected void pointerDragged(int x, int y) {
        this.buttonPressed(x, y);
        this.paintKeyBoard();
    }

    protected void keyPressed(int key) {
        int leftLimit = this.TOP_LEFT_X + this.keyWidth / 2 - this.pointer.getWidth() / 2;
        int rightLimit = this.TOP_LEFT_X + this.keyBoardWidth - this.keyWidth / 2 - this.pointer.getWidth() / 2;
        int upLimit = this.TOP_LEFT_Y + this.keyHeight / 2 - this.pointer.getHeight() / 2;
        int downLimit = this.TOP_LEFT_Y + this.keyBoardHeight - this.keyHeight / 2 - this.pointer.getHeight() / 2;
        if (this.pointer.isVisible()) {
            int posX = this.pointer.getX();
            int posY = this.pointer.getY();
            switch (this.getGameAction(key)) {
                case 2: {
                    posX = posX - this.keyWidth < leftLimit ? rightLimit : posX - this.keyWidth;
                    break;
                }
                case 5: {
                    posX = posX + this.keyWidth > rightLimit ? leftLimit : posX + this.keyWidth;
                    break;
                }
                case 1: {
                    posY = posY - this.keyHeight < upLimit ? downLimit : posY - this.keyHeight;
                    break;
                }
                case 6: {
                    posY = posY + this.keyHeight > downLimit ? upLimit : posY + this.keyHeight;
                    break;
                }
                case 8: {
                    this.pointerPressed(posX, posY);
                    return;
                }
            }
            this.pointer.setPosition(posX, posY);
            this.paintKeyBoard();
        }
    }

    protected void keyReleased(int key) {
        if (this.pointer.isVisible() && this.getGameAction(key) == 8) {
            this.pointerReleased(this.pointer.getX(), this.pointer.getY());
        }
    }

    protected void keyRepeated(int key) {
        this.keyPressed(key);
    }

    private void buttonPressed(int x, int y) {
        int newHash = -1;
        Button selectedButton = null;
        int i = 0;
        while (i < this.allButtons.length) {
            if (this.allButtons[i].isSelected(x, y)) {
                newHash = this.allButtons[i].hashCode();
                selectedButton = this.allButtons[i];
                break;
            }
            ++i;
        }
        if (newHash != this.lastSelectedHashCode) {
            if (this.lastSelectedHashCode != -1) {
                if (this.lastSelectedButton != null && this.lastSelectedButton instanceof MatrixButton) {
                    ((MatrixButton)this.lastSelectedButton).unSelect(this.lastSelectedHashCode);
                } else {
                    this.lastSelectedButton.unSelect();
                }
            }
            if (newHash != -1) {
                selectedButton.press();
            }
            this.lastSelectedButton = selectedButton;
            this.lastSelectedHashCode = newHash;
        }
    }

    private void buttonReleased() {
        if (this.lastSelectedButton != null) {
            this.lastSelectedButton.release();
            this.lastSelectedButton = null;
            this.lastSelectedHashCode = -1;
        }
    }

    private void charactersAreaActions() {
        char letter = this.charactersArea.getSelectedChar();
        if (this.abc.indexOf(letter) == -1) {
            return;
        }
        this.textField.insertCharacterInCursorPosition(letter);
    }

    private void shiftButtonActions() {
        int frame = this.modeCharactersButton.getFrame();
        if (frame == 1) {
            this.modeCharactersButton.setFrame(2);
            this.charactersArea.setCurrentKeys(this.upperCaseAlphabeticalKeys);
        } else {
            this.modeCharactersButton.setFrame(1);
            this.charactersArea.setCurrentKeys(this.lowerCaseAlphabeticalKeys);
        }
        this.modeNumbersButton.unSelect();
        this.modeSpecialCharactersButton.unSelect();
    }

    private void modeCharactersButtonActions() {
        this.charactersArea.setCurrentKeys(this.lowerCaseAlphabeticalKeys);
        this.modeNumbersButton.unSelect();
        this.modeSpecialCharactersButton.unSelect();
    }

    private void modeNumbersButtonActions() {
        this.charactersArea.setCurrentKeys(this.numberKyes);
        this.modeCharactersButton.unSelect();
        this.modeSpecialCharactersButton.unSelect();
    }

    private void modeSpecialCharacterButtonActions() {
        this.charactersArea.setCurrentKeys(this.specialCharacterKeys);
        this.modeCharactersButton.unSelect();
        this.modeNumbersButton.unSelect();
    }

    private void spaceButtonActions() {
        char letter = ' ';
        if (this.abc.indexOf(letter) == -1) {
            return;
        }
        this.textField.insertCharacterInCursorPosition(letter);
    }

    private void enterButtonActions() {
        char letter = '\n';
        if (this.abc.indexOf(letter) == -1) {
            return;
        }
        this.textField.insertCharacterInCursorPosition(letter);
    }

    private void okButtonActions() {
        if (this.invoker != null) {
            this.invoker.okPressed(this.transactionId, this.textField.getText());
        }
    }

    private void backspaceButtonActions() {
        this.textField.deleteLastCharBeforeCursor();
    }

    private void moveLeftButtonActions() {
        this.textField.moveCursorLeft();
    }

    private void moveRightButtonActions() {
        this.textField.moveCursorRight();
    }

    private void modePointerButtonActions() {
        if (this.pointer.isVisible()) {
            this.pointer.setVisible(false);
            this.modePointerButton.unSelect();
        } else {
            this.pointer.setPosition(this.TOP_LEFT_X + this.keyWidth / 2 - this.pointer.getWidth() / 2, this.TOP_LEFT_Y + this.keyHeight / 2 - this.pointer.getHeight() / 2);
            this.pointer.setVisible(true);
        }
    }

    private Image createImage(String path) {
        Image image = null;
        try {
            image = Image.createImage((String)(String.valueOf(this.imagesPath) + path));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return image;
    }

    public void setCharactersAreaFont(Font charactersAreaFont) {
        this.charactersArea.setFont(charactersAreaFont);
    }

    public void setCharactersAreaFontColor(int charactersAreaFontColor) {
        this.charactersArea.setFontColor(charactersAreaFontColor);
    }

    public void setCharactersAreaPreviewFontColor(int charactersAreaPreviewFontColor) {
        this.charactersArea.setPreviewFontColor(charactersAreaPreviewFontColor);
    }

    public void setTextFieldFont(Font textFieldFont) {
        this.textField.setTextFieldFont(textFieldFont);
    }

    public void setTextFieldBkgColor(int textFieldBkgColor) {
        this.textField.setTextFieldBkgColor(textFieldBkgColor);
    }

    public void setTextFieldBorderColor(int textFieldBorderColor) {
        this.textField.setTextFieldBorderColor(textFieldBorderColor);
    }

    public void setCursorColor(int cursorColor) {
        this.textField.setCursorColor(cursorColor);
    }

    public void setTextFieldFontColor(int textFieldFontColor) {
        this.textField.setTextFieldFontColor(textFieldFontColor);
    }

    public void setText(String text) {
        this.textField.setText(text);
        this.paintKeyBoard();
    }

    public void setPosition(int topLeftX, int topLeftY) {
        int deltaX = topLeftX - this.TOP_LEFT_X;
        int deltaY = topLeftY - this.TOP_LEFT_Y;
        this.TOP_LEFT_X = topLeftX;
        this.TOP_LEFT_Y = topLeftY;
        int i = 0;
        while (i < this.allButtons.length) {
            this.allButtons[i].getLayer().move(deltaX, deltaY);
            ++i;
        }
        this.paintKeyBoard();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setMaxSize(int maxSize) {
        this.textField.setMaxSize(maxSize);
    }

    public void setVirtualKeyboardListener(VirtualKeyboardListener invoker) {
        this.invoker = invoker;
    }

    public void togglePointer() {
        if (this.modePointerButton.getLayer().isVisible()) {
            this.modePointerButton.press();
        }
    }
}

