/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.ui;

import tv.ingames.j2dm.display.IEndAnimationCallback;
import tv.ingames.j2dm.display.J2DM_AnimatedSprite;
import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_SpriteAnimation;
import tv.ingames.j2dm.display.ui.IButtonCallBack;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Point;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_GenericButton
extends J2DM_AnimatedSprite {
    protected static final String ANIMATION_NAME = "buttonAnim";
    public static final int ROLLOUT_STATE = 0;
    public static final int ROLLOVER_STATE = 1;
    protected J2DM_SpriteAnimation _animation;
    protected J2DM_Image _image;
    protected int _typeButton;
    protected int _state;
    protected IButtonCallBack _buttonCallback;
    protected J2DM_Rect[] _rectArray;

    public J2DM_GenericButton(J2DM_Image image, int typeButton, IButtonCallBack buttonCallback, String name) {
        super(null, name);
        this.init(image, typeButton, buttonCallback);
    }

    public J2DM_GenericButton(J2DM_Image image, int typeButton, IButtonCallBack buttonCallback) {
        super((IEndAnimationCallback)null);
        this.init(image, typeButton, buttonCallback);
    }

    protected void init(J2DM_Image image, int typeButton, IButtonCallBack buttonCallback) {
        this._image = image;
        this._typeButton = typeButton;
        this._buttonCallback = buttonCallback;
        this.createZoneImages();
        this.setRollOut();
        J2DM_Stage.getInstance().suscribeMouseElement(this);
    }

    protected void createZoneImages() {
        this._rectArray = new J2DM_Rect[2];
        this._rectArray[0] = new J2DM_Rect(0, 0, this._image.getWidth(), this._image.getHeight() / 2);
        this._rectArray[1] = new J2DM_Rect(0, this._image.getHeight() / 2, this._image.getWidth(), this._image.getHeight() / 2);
        this.setZonesImages(this._rectArray, new J2DM_Point(this._image.getWidth() / 2, this._image.getHeight() / 4));
        this.playAnimation(ANIMATION_NAME, false);
    }

    public void setNewRegpoints(J2DM_Point point) {
        this.setZonesImages(this._rectArray, point);
    }

    public void setZonesImages(J2DM_Rect[] rectArray, J2DM_Point point) {
        if (rectArray != null && point != null && rectArray.length >= 2) {
            this._animation = new J2DM_SpriteAnimation(ANIMATION_NAME, this._image, rectArray, point);
            if (this._buffer.containsKey(ANIMATION_NAME)) {
                this.replaceAnimation(ANIMATION_NAME, this._animation);
                this.playAnimation(ANIMATION_NAME, false);
                this.gotoAndStop(0);
            } else {
                this.addAnimation(ANIMATION_NAME, this._animation);
            }
        } else {
            J2DM_Console.getInstance().addLog("J2DM_GenericButton::setZonesImages", "Invalid Parameters, rectArray=" + rectArray + " point=" + point, J2DM_ConsoleMessageTypes.ERROR);
        }
    }

    public void setZonesImages(J2DM_Rect[] rectArray, J2DM_Point[] point) {
        if (rectArray != null && point != null && rectArray.length >= 2 && rectArray.length == point.length) {
            this._animation = new J2DM_SpriteAnimation(ANIMATION_NAME, this._image, rectArray, point);
            this.replaceAnimation(ANIMATION_NAME, this._animation);
            this.playAnimation(ANIMATION_NAME, false);
            this.gotoAndStop(0);
        } else {
            J2DM_Console.getInstance().addLog("J2DM_GenericButton::setZonesImages", "Invalid Parameters, rectArray=" + rectArray + " point=" + point, J2DM_ConsoleMessageTypes.ERROR);
        }
    }

    public void setRollOver() {
        this._state = 1;
        this.gotoAndStop(1);
        if (this._buttonCallback != null) {
            this._buttonCallback.buttonEvent(2, this);
        }
    }

    public void setRollOut() {
        this._state = 0;
        this.gotoAndStop(0);
        if (this._buttonCallback != null) {
            this._buttonCallback.buttonEvent(3, this);
        }
    }

    public void setPressed() {
        this.onMouseDown(0, 0);
    }

    public int getState() {
        return this._state;
    }

    public int getTypeButton() {
        return this._typeButton;
    }

    public void destroy() {
        super.destroy();
        J2DM_Stage.getInstance().unsuscribeMouseElement(this);
        this._image = null;
        this._rectArray = null;
        this._buttonCallback = null;
        if (this._animation != null) {
            this._animation.destroy();
            this._animation = null;
        }
    }

    public void onMouseDown(int x, int y) {
        this.gotoAndStop(1);
        this._pressed = true;
        if (this._buttonCallback != null) {
            this._buttonCallback.buttonEvent(0, this);
        }
    }

    public void onMouseUp(int x, int y) {
        this.gotoAndStop(0);
        this._pressed = false;
        if (this._buttonCallback != null) {
            this._buttonCallback.buttonEvent(1, this);
        }
    }
}

