/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.platform;

import javax.microedition.lcdui.Image;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_Image {
    private Image _image;
    private J2DM_Graphics _graphics;

    public J2DM_Image(int type, int width, int height) {
        this._image = Image.createImage((int)width, (int)height);
    }

    private J2DM_Image(Image image) {
        this._image = image;
    }

    public static int getDefaultType() {
        return 0;
    }

    public static J2DM_Image loadImage(String imageName) {
        Image im = null;
        J2DM_Console.getInstance().addLog("J2DM_Image::loadImage", "Loading image in " + imageName, J2DM_ConsoleMessageTypes.LOG);
        try {
            im = Image.createImage((String)imageName);
        }
        catch (Exception e) {
            J2DM_Console.getInstance().addLog("J2DM_Image::loadImage", "Error Loading Image:" + imageName + " " + e, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        if (im == null) {
            J2DM_Console.getInstance().addLog("J2DM_Image::loadImage", "Image is empty Image:" + imageName, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return null;
        }
        J2DM_Image image = new J2DM_Image(im);
        return image;
    }

    public static J2DM_Image createImage(byte[] data, int init, int length) {
        Image newImage = Image.createImage((byte[])data, (int)init, (int)length);
        J2DM_Image image = new J2DM_Image(newImage);
        return image;
    }

    public J2DM_Graphics getGraphics() {
        if (this._graphics == null) {
            this._graphics = new J2DM_Graphics(this);
        }
        return this._graphics;
    }

    public int getWidth() {
        return this._image.getWidth();
    }

    public int getHeight() {
        return this._image.getHeight();
    }

    public Image getImage() {
        return this._image;
    }

    public void destroy() {
        this._image = null;
    }

    public J2DM_Image duplicate() {
        J2DM_Image duplicateImage = new J2DM_Image(J2DM_Image.getDefaultType(), this.getWidth(), this.getHeight());
        J2DM_Graphics g = new J2DM_Graphics(duplicateImage);
        J2DM_Image.drawImageOverGraphics(g, this, 0, 0, 0, 0);
        return duplicateImage;
    }

    public static void drawImageOverGraphics(J2DM_Graphics g, J2DM_Image image, int x, int y, int anclaX, int anclaY) {
        if (image == null) {
            return;
        }
        int regx = J2DM_Image.getXRegpoint(image, anclaX);
        int regy = J2DM_Image.getYRegpoint(image, anclaY);
        g.drawImage(x - regx, y - regy, image.getWidth(), image.getHeight(), image, 0, 0);
    }

    public static void drawImageOverGraphicsClip(J2DM_Graphics g, J2DM_Image image, int x, int y, int width, int height, int regx, int regy) {
        if (image == null) {
            return;
        }
        g.drawImage(x, y, width, height, image, -regx, -regy);
    }

    public static int getXRegpoint(J2DM_Image image, int ancalX) {
        int regx = 0;
        switch (ancalX) {
            case 1: {
                regx = image.getWidth() / 2;
                break;
            }
            case 8: {
                regx = image.getWidth();
                break;
            }
            case 4: {
                regx = 0;
            }
        }
        return regx;
    }

    public static int getYRegpoint(J2DM_Image image, int anclaY) {
        int regy = 0;
        switch (anclaY) {
            case 2: {
                regy = image.getHeight() / 2;
                break;
            }
            case 32: {
                regy = image.getHeight();
                break;
            }
            case 16: {
                regy = 0;
            }
        }
        return regy;
    }

    public static int getXRegpoint(J2DM_Rect rect, int anchorX) {
        int regx = 0;
        switch (anchorX) {
            case 1: {
                regx = rect._width / 2;
                break;
            }
            case 8: {
                regx = rect._width;
                break;
            }
            case 4: {
                regx = 0;
            }
        }
        return regx;
    }

    public static int getYRegpoint(J2DM_Rect rect, int anchorY) {
        int regy = 0;
        switch (anchorY) {
            case 2: {
                regy = rect._height / 2;
                break;
            }
            case 32: {
                regy = rect._height;
                break;
            }
            case 16: {
                regy = 0;
            }
        }
        return regy;
    }
}

