/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.matchLibrary.misc;

import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.display.sprite.bitmapRender.J2DM_SpriteAnimation;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_AbstractMatrixData;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataBloqued;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.utils.J2DM_Point;

public class J2DM_CursorInMatrix
extends J2DM_Sprite {
    protected J2DM_AbstractMatrixData[][] _matrix;
    protected int _gridx;
    protected int _gridy;
    protected int _widthGrid;
    protected int _heightGrid;
    protected int _offsetx;
    protected int _offsety;
    protected int _limitXInit;
    protected int _limitXFinal;
    protected int _limitYInit;
    protected int _limitYFinal;
    protected int _newGridx;
    protected int _newGridy;

    public J2DM_CursorInMatrix(String name, J2DM_SpriteAnimation currentAnimation) {
        super(name, currentAnimation);
    }

    public J2DM_CursorInMatrix(J2DM_SpriteAnimation currentAnimation) {
        super(currentAnimation);
    }

    public J2DM_CursorInMatrix(J2DM_Image image, int anchorX, int anchorY) {
        super(image, anchorX, anchorY);
    }

    public J2DM_CursorInMatrix(J2DM_Image image, int anchorX, int anchorY, String name) {
        super(image, anchorX, anchorY, name);
    }

    public J2DM_CursorInMatrix(J2DM_Image image, J2DM_Point point) {
        super(image, point);
    }

    public J2DM_CursorInMatrix(J2DM_Image image, J2DM_Point point, String name) {
        super(image, point, name);
    }

    public J2DM_CursorInMatrix(J2DM_Image image) {
        super(image);
    }

    public void init(J2DM_AbstractMatrixData[][] matrix, int gridx, int gridy, int widthGrid, int heightGrid, int offsetx, int offsety) {
        this._matrix = matrix;
        this._gridx = gridx;
        this._gridy = gridy;
        this._widthGrid = widthGrid;
        this._heightGrid = heightGrid;
        this._offsetx = offsetx;
        this._offsety = offsety;
        if (matrix != null) {
            this._limitXInit = 0;
            this._limitXFinal = matrix[0].length - 1;
            this._limitYInit = 0;
            this._limitYFinal = matrix.length - 1;
        }
        this.refreshCoordinatesFromGridXY();
    }

    public boolean keyPressedUp() {
        this._newGridy = this._gridy - 1;
        if (this._newGridy < this._limitYInit || this._newGridy < 0) {
            return false;
        }
        if (!(this._matrix[this._newGridy][this._gridx] instanceof J2DM_MatrixDataBloqued)) {
            this.setGridy(this._newGridy);
            this.refreshCoordinatesFromGridXY();
            return true;
        }
        return false;
    }

    public boolean keyPressedDown() {
        this._newGridy = this._gridy + 1;
        if (this._newGridy > this._limitYFinal) {
            return false;
        }
        if (!(this._matrix[this._newGridy][this._gridx] instanceof J2DM_MatrixDataBloqued)) {
            this.setGridy(this._newGridy);
            this.refreshCoordinatesFromGridXY();
            return true;
        }
        return false;
    }

    public boolean keyPressedRight() {
        this._newGridx = this._gridx + 1;
        if (this._newGridx > this._limitXFinal) {
            return false;
        }
        if (!(this._matrix[this._gridy][this._newGridx] instanceof J2DM_MatrixDataBloqued)) {
            this.setGridx(this._newGridx);
            this.refreshCoordinatesFromGridXY();
            return true;
        }
        return false;
    }

    public boolean keyPressedLeft() {
        this._newGridx = this._gridx - 1;
        if (this._newGridx < this._limitXInit) {
            return false;
        }
        if (!(this._matrix[this._gridy][this._newGridx] instanceof J2DM_MatrixDataBloqued)) {
            this.setGridx(this._newGridx);
            this.refreshCoordinatesFromGridXY();
            return true;
        }
        return false;
    }

    public void refreshCoordinatesFromGridXY() {
        this.setX(this._widthGrid * this._gridx + this._offsetx);
        this.setY(this._heightGrid * this._gridy + this._offsety);
    }

    public boolean setGridXYFromPlotXY(int x, int y) {
        int tempGridx = (x - this._offsetx) / this._widthGrid;
        int tempGridy = (y - this._offsety) / this._heightGrid;
        if (tempGridx >= this._limitXInit && tempGridy >= this._limitYInit && tempGridy <= this._limitYFinal && tempGridx < this._limitXFinal && !(this._matrix[tempGridy][tempGridx] instanceof J2DM_MatrixDataBloqued)) {
            this.setGridx(tempGridx);
            this.setGridy(tempGridy);
            this.refreshCoordinatesFromGridXY();
            return true;
        }
        return false;
    }

    public int getLimitYFinal() {
        return this._limitYFinal;
    }

    public void setLimitYFinal(int value) {
        this._limitYFinal = value;
    }

    public int getLimitXFinal() {
        return this._limitXFinal;
    }

    public void setLimitXFinal(int value) {
        this._limitXFinal = value;
    }

    public int getLimitYInit() {
        return this._limitYInit;
    }

    public void setLimitYInit(int value) {
        this._limitYInit = value;
    }

    public int getLimitXInit() {
        return this._limitXInit;
    }

    public void setLimitXInit(int value) {
        this._limitXInit = value;
    }

    public int getOffsetx() {
        return this._offsetx;
    }

    public void setOffsetx(int value) {
        this._offsetx = value;
    }

    public int getHeightGrid() {
        return this._heightGrid;
    }

    public void setHeightGrid(int value) {
        this._heightGrid = value;
    }

    public int getWidthGrid() {
        return this._widthGrid;
    }

    public void setWidthGrid(int value) {
        this._widthGrid = value;
    }

    public int getGridy() {
        return this._gridy;
    }

    public void setGridy(int value) {
        this._gridy = value;
    }

    public int getGridx() {
        return this._gridx;
    }

    public void setGridx(int value) {
        this._gridx = value;
    }
}

