/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.matchLibrary.matrixData;

import tv.ingames.j2dm.display.IEndAnimationCallback;
import tv.ingames.j2dm.matchLibrary.J2DM_MatrixManager;
import tv.ingames.j2dm.matchLibrary.ballType.J2DM_AbstractTypeBall;
import tv.ingames.j2dm.matchLibrary.ballType.J2DM_TypeColorBall;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_AbstractMatrixData;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataBloqued;
import tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataEmpty;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;

public class J2DM_Ball
extends J2DM_AbstractMatrixData {
    protected static J2DM_MatrixDataEmpty _dataEmpty = new J2DM_MatrixDataEmpty(null);
    public boolean checkFlag;
    public J2DM_AbstractTypeBall _typeBall;
    protected int _gridx;
    protected int _gridy;
    protected int _widthSlot;
    protected int _heightSlot;
    protected int _cantColors;
    protected int _state;
    protected int _direction;
    protected float _velx;
    protected float _vely;
    protected float _limitVelx;
    protected float _limitVely;
    protected float _acelerationx;
    protected float _acelerationy;
    protected int _maxx;
    protected int _maxy;
    protected int _offsetYFromMovingBall;
    protected int _framesToShift;
    protected int _contFramesToShift;
    private float _newX;
    private float _newY;
    private int _newGridx;
    private int _newGridy;
    protected J2DM_MatrixManager _matrixManager;
    protected J2DM_AbstractMatrixData[][] _matrix;
    static /* synthetic */ Class class$0;

    public J2DM_Ball(J2DM_MatrixManager matrixManager, int widthSlot, int heightSlot, int cantColors, IEndAnimationCallback endAnimationCallBack) {
        super(endAnimationCallBack);
        this.init(matrixManager, widthSlot, heightSlot, cantColors, 1, 1, 1.0f, 1.0f);
    }

    public J2DM_Ball(J2DM_MatrixManager matrixManager, int widthSlot, int heightSlot, int cantColors, int gridx, int gridy, float velx, float vely, IEndAnimationCallback endAnimationCallBack) {
        super(endAnimationCallBack);
        this.init(matrixManager, widthSlot, heightSlot, cantColors, gridx, gridy, velx, vely);
    }

    private void init(J2DM_MatrixManager matrixManager, int widthSlot, int heightSlot, int cantColors, int gridx, int gridy, float velx, float vely) {
        this._matrixManager = matrixManager;
        this._matrix = this._matrixManager.getMatrix();
        this._maxx = this._matrix[0].length;
        this._maxy = this._matrix.length;
        this._widthSlot = widthSlot;
        this._heightSlot = heightSlot;
        this._cantColors = cantColors;
        this._gridx = gridx;
        this._gridy = gridy;
        this._velx = velx;
        this._vely = vely;
        this._acelerationx = this._velx;
        this._acelerationy = this._vely;
        this._state = 0;
        this._direction = -1;
        this._framesToShift = 5;
        this._limitVely = (int)((double)heightSlot * 0.8);
    }

    public int getFramesToShift() {
        return this._framesToShift;
    }

    public void setFramesToShift(int value) {
        this._framesToShift = value;
    }

    public int getCantColors() {
        return this._cantColors;
    }

    public float getAcelerationy() {
        return this._acelerationy;
    }

    public void setAcelerationy(float value) {
        this._acelerationy = value;
    }

    public float getAcelerationx() {
        return this._acelerationx;
    }

    public void setAcelerationx(float value) {
        this._acelerationx = value;
    }

    public float getVely() {
        return this._vely;
    }

    public void setVely(float value) {
        this._vely = value;
    }

    public float getVelx() {
        return this._velx;
    }

    public void setVelx(float value) {
        this._velx = value;
    }

    public float getLimitVelx() {
        return this._limitVelx;
    }

    public void setLimitVelx(float value) {
        this._limitVelx = value;
    }

    public float getLimitVely() {
        return this._limitVely;
    }

    public void setLimitVely(float value) {
        this._limitVely = value;
    }

    public int getGridx() {
        return this._gridx;
    }

    public void setGridx(int value) {
        this._gridx = value;
    }

    public int getGridy() {
        return this._gridy;
    }

    public void setGridy(int value) {
        this._gridy = value;
    }

    public int getColor() {
        if (this._typeBall instanceof J2DM_TypeColorBall) {
            return ((J2DM_TypeColorBall)this._typeBall)._color;
        }
        J2DM_Console.getInstance().addLog("J2DM_Ball::getColor", "The Type Ball is not Color Ball", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return -1;
    }

    public J2DM_AbstractTypeBall getTypeBall() {
        return this._typeBall;
    }

    public void setTypeBall(J2DM_AbstractTypeBall typeBall, boolean flagRefreshAnimation) {
        if (this._typeBall != null) {
            this._typeBall.destroy();
            this._typeBall = null;
        }
        this._typeBall = typeBall;
        if (flagRefreshAnimation) {
            this._typeBall.refreshAnimation();
        }
    }

    public void setTypeBall(J2DM_AbstractTypeBall typeBall) {
        this.setTypeBall(typeBall, true);
    }

    public void refreshCoordinatesFromGridXY() {
        this.setX(this._widthSlot * this._gridx + this._widthSlot / 2);
        this.setY(this._heightSlot * this._gridy + this._heightSlot / 2);
    }

    public void refreshCoordinatesFromOffsetYMovingBall() {
        this.setX(this._widthSlot * this._gridx + this._widthSlot / 2);
        this.setY(this._heightSlot * this._gridy + this._heightSlot / 2 + this._offsetYFromMovingBall);
    }

    public void refreshGridXYFromCoordinates() {
        this._gridx = this._x / this._widthSlot;
        this._gridy = this._y / this._heightSlot;
    }

    public void changeColor() {
        if (this._typeBall instanceof J2DM_TypeColorBall) {
            ((J2DM_TypeColorBall)this._typeBall).changeColor();
        }
    }

    public boolean isColorBall() {
        return this._typeBall instanceof J2DM_TypeColorBall;
    }

    public void reset() {
    }

    public void setColor(int color) {
        if (this._typeBall instanceof J2DM_TypeColorBall) {
            ((J2DM_TypeColorBall)this._typeBall).setColor(color);
        }
    }

    public J2DM_Ball duplicate() {
        J2DM_Ball ball = new J2DM_Ball(this._matrixManager, this._widthSlot, this._heightSlot, this._cantColors, this._endAnimationCallBack);
        ball._typeBall = this._typeBall.duplicate(ball);
        return ball;
    }

    public int getState() {
        return this._state;
    }

    public int getOffsetYFromMovingBall() {
        return this._offsetYFromMovingBall;
    }

    public void setOffsetYFromMovingBall(int value) {
        this._offsetYFromMovingBall = value;
    }

    public int getDirection() {
        return this._direction;
    }

    public void setDirection(int value) {
        this._direction = value;
    }

    public int loop() {
        this._state = 0;
        switch (this._direction) {
            case -1: {
                if (!(this._matrix[this._gridy + 1][this._gridx] instanceof J2DM_MatrixDataEmpty)) break;
                this._vely = this._acelerationy;
                this._direction = 4;
                this._state = 1;
                break;
            }
            case 4: {
                this.loopMovingDown();
                break;
            }
            case 1: {
                this._newX = (float)this._x - this._velx;
                this._newGridx = (int)((this._newX - (float)(this._widthSlot / 2)) / (float)this._widthSlot);
                this._newGridy = this._y / this._heightSlot;
                if (this._newGridx < 0) {
                    this._newGridx = 0;
                }
                if (!(this._matrix[this._newGridy][this._newGridx] instanceof J2DM_MatrixDataBloqued)) {
                    this._state = 3;
                    this._x = (int)this._newX;
                    this._y = this.getCoorYFromMovingBall();
                    this.refreshGridXYFromCoordinates();
                    break;
                }
                this._state = 7;
                this._direction = 2;
                break;
            }
            case 2: {
                this._newX = (float)this._x + this._velx;
                this._newGridx = (int)((this._newX + (float)(this._widthSlot / 2)) / (float)this._widthSlot);
                this._newGridy = this._y / this._heightSlot;
                if (this._newGridx >= this._maxx) {
                    this._newGridx = this._maxx - 1;
                }
                if (!(this._matrix[this._newGridy][this._newGridx] instanceof J2DM_MatrixDataBloqued)) {
                    this._state = 2;
                    this._x = (int)this._newX;
                    this._y = this.getCoorYFromMovingBall();
                    this.refreshGridXYFromCoordinates();
                    break;
                }
                this._state = 6;
                this._direction = 1;
                break;
            }
            case 3: {
                this._state = 5;
                --this._contFramesToShift;
                if (this._contFramesToShift >= 0) {
                    this._y = this._heightSlot * (this._gridy + 1) + this._heightSlot / 2 - this._heightSlot / this._framesToShift * (this._framesToShift - this._contFramesToShift);
                    break;
                }
                this._state = 11;
                this.refreshCoordinatesFromGridXY();
                this._direction = -1;
                break;
            }
            case 6: {
                this.loopShiftRight();
                break;
            }
            case 7: {
                this.loopShiftLeft();
            }
        }
        return this._state;
    }

    private void loopMovingDown() {
        this._newY = (float)this._y + this._vely;
        this._vely += this._acelerationy;
        if (this._vely > this._limitVely) {
            this._vely = this._limitVely;
        }
        this._newGridy = (int)(this._newY + (float)(this._heightSlot / 2)) / this._heightSlot;
        if (this._newGridy >= this._maxy) {
            this._newGridy = this._maxy - 1;
        }
        this._state = 4;
        if (this._newGridy != this._gridy) {
            Class<?> clazz = this._matrix[this._newGridy][this._gridx].getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("tv.ingames.j2dm.matchLibrary.matrixData.J2DM_MatrixDataEmpty");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                this._matrixManager.moveBall(this, this._newGridy, this._gridx);
                this._y = (int)this._newY;
            } else {
                this.refreshCoordinatesFromGridXY();
                this._direction = -1;
                this._state = 10;
            }
        } else {
            this._y = (int)this._newY;
        }
    }

    private int getCoorYFromMovingBall() {
        int pointY = this._heightSlot * this._gridy + this._heightSlot / 2 + this._offsetYFromMovingBall;
        return pointY;
    }

    public boolean startFall() {
        if (this._direction == 4) {
            return false;
        }
        this._vely = this._acelerationy;
        this.refreshCoordinatesFromGridXY();
        this._direction = 4;
        return true;
    }

    public void animateShiftUp() {
        this._direction = 3;
        this._contFramesToShift = this._framesToShift;
        this._y = this._heightSlot * (this._gridy + 1) + this._heightSlot / 2;
    }

    public boolean tryMoveRight() {
        boolean flagMove = false;
        if (this._matrix[this._gridy][this._gridx + 1] instanceof J2DM_MatrixDataEmpty) {
            ++this._gridx;
            flagMove = true;
            this.refreshCoordinatesFromGridXY();
        }
        return flagMove;
    }

    public boolean tryMoveLeft() {
        boolean flagMove = false;
        if (this._matrix[this._gridy][this._gridx - 1] instanceof J2DM_MatrixDataEmpty) {
            --this._gridx;
            flagMove = true;
            this.refreshCoordinatesFromGridXY();
        }
        return flagMove;
    }

    public void destroy() {
        super.destroy();
        this._typeBall.destroy();
        this._matrixManager = null;
        this._matrix = null;
    }

    public void shiftRight(int framesToShift) {
        this._framesToShift = framesToShift;
        this._contFramesToShift = 0;
        this._direction = 6;
    }

    public void loopShiftRight() {
        this._state = 12;
        ++this._contFramesToShift;
        if (this._contFramesToShift > this._framesToShift) {
            this.refreshCoordinatesFromGridXY();
            this._direction = -1;
            this._state = 16;
        } else {
            this._x += this._widthSlot / this._framesToShift;
        }
    }

    public void shiftLeft(int framesToShift) {
        this._framesToShift = framesToShift;
        this._contFramesToShift = 0;
        this._direction = 7;
    }

    public void loopShiftLeft() {
        this._state = 13;
        ++this._contFramesToShift;
        if (this._contFramesToShift > this._framesToShift) {
            this.refreshCoordinatesFromGridXY();
            this._direction = -1;
            this._state = 17;
        } else {
            this._x -= this._widthSlot / this._framesToShift;
        }
    }
}

