/*
 * Decompiled with CFR 0.152.
 */
package com.asao.smsgame.main;

import java.util.Stack;

class BigInteger {
    private static final int[][] a = new int[][]{{3, 5, 7, 11, 13, 17, 19, 23}, {29, 31, 37, 41, 43}, {47, 53, 59, 61, 67}, {71, 73, 79, 83}, {89, 97, 101, 103}, {107, 109, 113, 127}, {131, 137, 139, 149}, {151, 157, 163, 167}, {173, 179, 181, 191}, {193, 197, 199, 211}, {223, 227, 229}, {233, 239, 241}, {251, 257, 263}, {269, 271, 277}, {281, 283, 293}, {307, 311, 313}, {317, 331, 337}, {347, 349, 353}, {359, 367, 373}, {379, 383, 389}, {397, 401, 409}, {419, 421, 431}, {433, 439, 443}, {449, 457, 461}, {463, 467, 479}, {487, 491, 499}, {503, 509, 521}, {523, 541, 547}, {557, 563, 569}, {571, 577, 587}, {593, 599, 601}, {607, 613, 617}, {619, 631, 641}, {643, 647, 653}, {659, 661, 673}, {677, 683, 691}, {701, 709, 719}, {727, 733, 739}, {743, 751, 757}, {761, 769, 773}, {787, 797, 809}, {811, 821, 823}, {827, 829, 839}, {853, 857, 859}, {863, 877, 881}, {883, 887, 907}, {911, 919, 929}, {937, 941, 947}, {953, 967, 971}, {977, 983, 991}, {997, 1009, 1013}, {1019, 1021, 1031}};
    private static int[] b;
    private static final int[] c;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger d;
    private int e;
    private int[] f;
    private int g = -1;
    private int h = -1;
    private long i = -1L;
    private static final byte[] j;

    private BigInteger() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private BigInteger(int n2, int[] nArray) {
        if (nArray.length <= 0) {
            this.f = nArray;
            this.e = 0;
            return;
        }
        this.e = n2;
        for (n2 = 0; n2 < nArray.length && nArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            this.f = nArray;
            return;
        }
        int[] nArray2 = new int[nArray.length - n2];
        System.arraycopy(nArray, n2, nArray2, 0, nArray2.length);
        this.f = nArray2;
        if (nArray2.length != 0) return;
        this.e = 0;
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(String string, int n2) {
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length com/asao/smsgame/main/BigInteger");
        }
        if (n2 < 2 || n2 > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        int n3 = 0;
        this.e = 1;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw new NumberFormatException("Zero length com/asao/smsgame/main/BigInteger");
            }
            this.e = -1;
            n3 = 1;
        }
        while (n3 < string.length() && Character.digit(string.charAt(n3), n2) == 0) {
            ++n3;
        }
        if (n3 >= string.length()) {
            this.e = 0;
            this.f = new int[0];
            return;
        }
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = BigInteger.valueOf(n2);
        while (n3 < string.length()) {
            bigInteger = bigInteger.multiply(bigInteger2).add(BigInteger.valueOf(Character.digit(string.charAt(n3), n2)));
            ++n3;
        }
        this.f = bigInteger.f;
    }

    public BigInteger(byte[] byArray) {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length com/asao/smsgame/main/BigInteger");
        }
        this.e = 1;
        if (byArray[0] < 0) {
            this.e = -1;
        }
        this.f = this.a(byArray, this.e);
        if (this.f.length == 0) {
            this.e = 0;
        }
    }

    private int[] a(byte[] objectArray, int n2) {
        int n3;
        if (n2 >= 0) {
            int n4;
            for (n4 = 0; n4 < objectArray.length && objectArray[n4] == 0; ++n4) {
            }
            if (n4 >= objectArray.length) {
                return new int[0];
            }
            int n5 = (objectArray.length - n4 + 3) / 4;
            int n6 = (objectArray.length - n4) % 4;
            if (n6 == 0) {
                n6 = 4;
            }
            int[] nArray = new int[n5];
            int n7 = 0;
            int n8 = 0;
            for (n2 = n4; n2 < objectArray.length; ++n2) {
                n7 <<= 8;
                n7 |= objectArray[n2] & 0xFF;
                if (--n6 > 0) continue;
                nArray[n8] = n7;
                ++n8;
                n6 = 4;
                n7 = 0;
            }
            return nArray;
        }
        for (n3 = 0; n3 < objectArray.length - 1 && objectArray[n3] == 255; ++n3) {
        }
        int n9 = objectArray.length;
        boolean bl2 = false;
        if (objectArray[n3] == 128) {
            for (n2 = n3 + 1; n2 < objectArray.length && objectArray[n2] == 0; ++n2) {
            }
            if (n2 == objectArray.length) {
                ++n9;
                bl2 = true;
            }
        }
        int n10 = (n9 - n3 + 3) / 4;
        int n11 = (n9 - n3) % 4;
        if (n11 == 0) {
            n11 = 4;
        }
        Object[] objectArray2 = new int[n10];
        n10 = 0;
        int n12 = 0;
        if (bl2 && --n11 <= 0) {
            ++n12;
            n11 = 4;
        }
        for (n2 = n3; n2 < objectArray.length; ++n2) {
            n10 <<= 8;
            n10 |= ~objectArray[n2] & 0xFF;
            if (--n11 > 0) continue;
            objectArray2[n12] = n10;
            ++n12;
            n11 = 4;
            n10 = 0;
        }
        objectArray = objectArray2;
        n2 = objectArray2.length - 1;
        long l2 = ((long)objectArray[n2] & 0xFFFFFFFFL) + 1L;
        objectArray[n2--] = (int)l2;
        l2 >>>= 32;
        while (n2 >= 0 && l2 != 0L) {
            objectArray[n2--] = (int)(l2 += (long)objectArray[n2] & 0xFFFFFFFFL);
            l2 >>>= 32;
        }
        objectArray2 = objectArray;
        if (objectArray[0] == 0) {
            objectArray = new int[objectArray2.length - 1];
            System.arraycopy(objectArray2, 1, objectArray, 0, objectArray.length);
            objectArray2 = objectArray;
        }
        return objectArray2;
    }

    public BigInteger(int n2, byte[] byArray) {
        if (n2 < -1 || n2 > 1) {
            throw new NumberFormatException("Invalid sign value");
        }
        if (n2 == 0) {
            this.e = 0;
            this.f = new int[0];
            return;
        }
        this.f = this.a(byArray, 1);
        this.e = n2;
    }

    public BigInteger abs() {
        if (this.e >= 0) {
            return this;
        }
        return this.negate();
    }

    private static int[] a(int[] nArray, int[] nArray2) {
        int n2 = nArray.length - 1;
        int n3 = nArray2.length - 1;
        long l2 = 0L;
        while (n3 >= 0) {
            nArray[n2--] = (int)(l2 += ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)nArray2[n3--] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        while (n2 >= 0 && l2 != 0L) {
            nArray[n2--] = (int)(l2 += (long)nArray[n2] & 0xFFFFFFFFL);
            l2 >>>= 32;
        }
        return nArray;
    }

    public BigInteger add(BigInteger bigInteger) {
        int[] nArray;
        if (bigInteger.e == 0 || bigInteger.f.length == 0) {
            return this;
        }
        if (this.e == 0 || this.f.length == 0) {
            return bigInteger;
        }
        if (bigInteger.e < 0) {
            if (this.e > 0) {
                return this.subtract(bigInteger.negate());
            }
        } else if (this.e < 0) {
            return bigInteger.subtract(this.negate());
        }
        int[] nArray2 = bigInteger.f;
        bigInteger = this;
        if (bigInteger.f.length < nArray2.length) {
            nArray = nArray2;
            nArray2 = bigInteger.f;
        } else {
            nArray = bigInteger.f;
        }
        int n2 = Integer.MAX_VALUE;
        if (nArray.length == nArray2.length) {
            n2 = Integer.MAX_VALUE - nArray2[0];
        }
        n2 = (nArray[0] ^ Integer.MIN_VALUE) >= n2 ? 1 : 0;
        n2 = n2 != 0 ? 1 : 0;
        int[] nArray3 = new int[nArray.length + n2];
        System.arraycopy(nArray, 0, nArray3, n2, nArray.length);
        nArray3 = BigInteger.a(nArray3, nArray2);
        return new BigInteger(bigInteger.e, nArray3);
    }

    public BigInteger and(BigInteger bigInteger) {
        if (this.e == 0 || bigInteger.e == 0) {
            return ZERO;
        }
        int[] nArray = this.e > 0 ? this.f : this.add((BigInteger)BigInteger.ONE).f;
        int[] nArray2 = bigInteger.e > 0 ? bigInteger.f : bigInteger.add((BigInteger)BigInteger.ONE).f;
        boolean bl2 = this.e < 0 && bigInteger.e < 0;
        int n2 = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n2];
        int n3 = nArray3.length - nArray.length;
        int n4 = nArray3.length - nArray2.length;
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            int n5;
            int n6 = i2 >= n3 ? nArray[i2 - n3] : 0;
            int n7 = n5 = i2 >= n4 ? nArray2[i2 - n4] : 0;
            if (this.e < 0) {
                n6 ^= 0xFFFFFFFF;
            }
            if (bigInteger.e < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            nArray3[i2] = n6 & n5;
            if (!bl2) continue;
            nArray3[i2] = ~nArray3[i2];
        }
        BigInteger bigInteger2 = new BigInteger(1, nArray3);
        if (bl2) {
            bigInteger2 = bigInteger2.not();
        }
        return bigInteger2;
    }

    public BigInteger andNot(BigInteger bigInteger) {
        return this.and(bigInteger.not());
    }

    public int bitCount() {
        if (this.g == -1) {
            if (this.e < 0) {
                this.g = this.not().bitCount();
            } else {
                int n2 = 0;
                for (int i2 = 0; i2 < this.f.length; ++i2) {
                    n2 += j[this.f[i2] & 0xFF];
                    n2 += j[this.f[i2] >> 8 & 0xFF];
                    n2 += j[this.f[i2] >> 16 & 0xFF];
                    n2 += j[this.f[i2] >>> 24];
                }
                this.g = n2;
            }
        }
        return this.g;
    }

    private int a(int n2, int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        while (n2 != nArray.length && nArray[n2] == 0) {
            ++n2;
        }
        if (n2 == nArray.length) {
            return 0;
        }
        int n3 = 32 * (nArray.length - n2 - 1);
        n3 += BigInteger.bitLen(nArray[n2]);
        if (this.e < 0) {
            boolean bl2 = j[nArray[n2] & 0xFF] + j[nArray[n2] >> 8 & 0xFF] + j[nArray[n2] >> 16 & 0xFF] + j[nArray[n2] >>> 24] == 1;
            ++n2;
            while (n2 < nArray.length && bl2) {
                bl2 = nArray[n2] == 0;
                ++n2;
            }
            n3 -= bl2 ? 1 : 0;
        }
        return n3;
    }

    public int bitLength() {
        if (this.h == -1) {
            this.h = this.e == 0 ? 0 : this.a(0, this.f);
        }
        return this.h;
    }

    static int bitLen(int n2) {
        if (n2 < 32768) {
            if (n2 < 128) {
                if (n2 < 8) {
                    if (n2 < 2) {
                        if (n2 <= 0) {
                            if (n2 < 0) {
                                return 32;
                            }
                            return 0;
                        }
                        return 1;
                    }
                    if (n2 < 4) {
                        return 2;
                    }
                    return 3;
                }
                if (n2 < 32) {
                    if (n2 < 16) {
                        return 4;
                    }
                    return 5;
                }
                if (n2 < 64) {
                    return 6;
                }
                return 7;
            }
            if (n2 < 2048) {
                if (n2 < 512) {
                    if (n2 < 256) {
                        return 8;
                    }
                    return 9;
                }
                if (n2 < 1024) {
                    return 10;
                }
                return 11;
            }
            if (n2 < 8192) {
                if (n2 < 4096) {
                    return 12;
                }
                return 13;
            }
            if (n2 < 16384) {
                return 14;
            }
            return 15;
        }
        if (n2 < 0x800000) {
            if (n2 < 524288) {
                if (n2 < 131072) {
                    if (n2 < 65536) {
                        return 16;
                    }
                    return 17;
                }
                if (n2 < 262144) {
                    return 18;
                }
                return 19;
            }
            if (n2 < 0x200000) {
                if (n2 < 0x100000) {
                    return 20;
                }
                return 21;
            }
            if (n2 < 0x400000) {
                return 22;
            }
            return 23;
        }
        if (n2 < 0x8000000) {
            if (n2 < 0x2000000) {
                if (n2 < 0x1000000) {
                    return 24;
                }
                return 25;
            }
            if (n2 < 0x4000000) {
                return 26;
            }
            return 27;
        }
        if (n2 < 0x20000000) {
            if (n2 < 0x10000000) {
                return 28;
            }
            return 29;
        }
        if (n2 < 0x40000000) {
            return 30;
        }
        return 31;
    }

    public int compareTo(Object object) {
        return this.compareTo((BigInteger)object);
    }

    private int a(int n2, int[] nArray, int n3, int[] nArray2) {
        while (n2 != nArray.length && nArray[n2] == 0) {
            ++n2;
        }
        while (n3 != nArray2.length && nArray2[n3] == 0) {
            ++n3;
        }
        return BigInteger.b(n2, nArray, n3, nArray2);
    }

    private static int b(int n2, int[] nArray, int n3, int[] nArray2) {
        int n4 = nArray.length - nArray2.length - (n2 - n3);
        if (n4 != 0) {
            if (n4 < 0) {
                return -1;
            }
            return 1;
        }
        while (n2 < nArray.length) {
            int n5;
            if ((n4 = nArray[n2++]) == (n5 = nArray2[n3++])) continue;
            if ((n4 ^ Integer.MIN_VALUE) < (n5 ^ Integer.MIN_VALUE)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int compareTo(BigInteger bigInteger) {
        if (this.e < bigInteger.e) {
            return -1;
        }
        if (this.e > bigInteger.e) {
            return 1;
        }
        if (this.e == 0) {
            return 0;
        }
        return this.e * this.a(0, this.f, 0, bigInteger.f);
    }

    private int[] b(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n2 = this.a(0, nArray, 0, nArray2);
        if (n2 > 0) {
            int[] nArray4;
            int[] nArray5;
            n2 = this.a(0, nArray) - this.a(0, nArray2);
            if (n2 > 1) {
                nArray5 = BigInteger.a(nArray2, n2 - 1);
                nArray3 = BigInteger.a(BigInteger.ONE.f, n2 - 1);
                if (n2 % 32 == 0) {
                    nArray4 = new int[n2 / 32 + 1];
                    System.arraycopy(nArray3, 0, nArray4, 1, nArray4.length - 1);
                    nArray4[0] = 0;
                    nArray3 = nArray4;
                }
            } else {
                nArray5 = new int[nArray.length];
                nArray3 = new int[1];
                System.arraycopy(nArray2, 0, nArray5, nArray5.length - nArray2.length, nArray2.length);
                nArray3[0] = 1;
            }
            nArray4 = new int[nArray3.length];
            BigInteger.a(nArray, 0, nArray5);
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                if ((n2 = this.a(n3, nArray, n4, nArray5)) >= 0) {
                    BigInteger.a(nArray, n4, nArray5);
                    BigInteger.a(nArray3, nArray4);
                    continue;
                }
                n2 = this.a(n3, nArray, 0, nArray2);
                if (n2 <= 0) break;
                if (nArray[n3] == 0) {
                    ++n3;
                }
                if ((n2 = this.a(n4, nArray5) - this.a(n3, nArray)) == 0) {
                    BigInteger.b(n4, nArray5);
                    BigInteger.b(n5, nArray4);
                } else {
                    BigInteger.a(n4, nArray5, n2);
                    BigInteger.a(n5, nArray4, n2);
                }
                if (nArray5[n4] == 0) {
                    ++n4;
                }
                if (nArray4[n5] != 0) continue;
                ++n5;
            }
            if (n2 == 0) {
                BigInteger.a(nArray3, BigInteger.ONE.f);
                for (int i2 = n3; i2 != nArray.length; ++i2) {
                    nArray[i2] = 0;
                }
            }
        } else if (n2 == 0) {
            int[] nArray6 = new int[1];
            nArray3 = nArray6;
            nArray6[0] = 1;
        } else {
            int[] nArray7 = new int[1];
            nArray3 = nArray7;
            nArray7[0] = 0;
        }
        return nArray3;
    }

    public BigInteger divide(BigInteger bigInteger) {
        if (bigInteger.e == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.e == 0) {
            return ZERO;
        }
        if (bigInteger.compareTo(ONE) == 0) {
            return this;
        }
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        return new BigInteger(this.e * bigInteger.e, this.b(nArray, bigInteger.f));
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        if (bigInteger.e == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (this.e == 0) {
            bigIntegerArray[0] = bigIntegerArray[1] = ZERO;
            return bigIntegerArray;
        }
        if (bigInteger.compareTo(ONE) == 0) {
            bigIntegerArray[0] = this;
            bigIntegerArray[1] = ZERO;
            return bigIntegerArray;
        }
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        int[] nArray2 = this.b(nArray, bigInteger.f);
        bigIntegerArray[0] = new BigInteger(this.e * bigInteger.e, nArray2);
        bigIntegerArray[1] = new BigInteger(this.e, nArray);
        return bigIntegerArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigInteger)) {
            return false;
        }
        object = (BigInteger)object;
        if (((BigInteger)object).e != this.e || ((BigInteger)object).f.length != this.f.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            if (((BigInteger)object).f[i2] == this.f[i2]) continue;
            return false;
        }
        return true;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (bigInteger.e == 0) {
            return this.abs();
        }
        if (this.e == 0) {
            return bigInteger.abs();
        }
        BigInteger bigInteger2 = this;
        BigInteger bigInteger3 = bigInteger;
        while (bigInteger3.e != 0) {
            bigInteger = bigInteger2.mod(bigInteger3);
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger;
        }
        return bigInteger2;
    }

    public int hashCode() {
        int n2 = this.f.length;
        if (this.f.length > 0) {
            n2 ^= this.f[0];
            if (this.f.length > 1) {
                n2 ^= this.f[this.f.length - 1];
            }
        }
        if (this.e < 0) {
            return ~n2;
        }
        return n2;
    }

    public int intValue() {
        if (this.f.length == 0) {
            return 0;
        }
        if (this.e < 0) {
            return -this.f[this.f.length - 1];
        }
        return this.f[this.f.length - 1];
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public long longValue() {
        if (this.f.length == 0) {
            return 0L;
        }
        long l2 = this.f.length > 1 ? (long)this.f[this.f.length - 2] << 32 | (long)this.f[this.f.length - 1] & 0xFFFFFFFFL : (long)this.f[this.f.length - 1] & 0xFFFFFFFFL;
        if (this.e < 0) {
            return -l2;
        }
        return l2;
    }

    public BigInteger max(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) > 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger min(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) < 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.e <= 0) {
            throw new ArithmeticException("com/asao/smsgame/main/BigInteger: modulus is not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        if (bigInteger2.e >= 0) {
            return bigInteger2;
        }
        return bigInteger2.add(bigInteger);
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (bigInteger.e != 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger bigInteger3 = BigInteger.a(this, bigInteger, bigInteger2, null);
        if (!bigInteger3.equals(ONE)) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (bigInteger2.compareTo(ZERO) < 0) {
            bigInteger2 = bigInteger2.add(bigInteger);
        }
        return bigInteger2;
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        bigInteger4 = ONE;
        BigInteger bigInteger5 = ZERO;
        while (bigInteger2.e > 0) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            bigInteger = bigInteger4.subtract(bigInteger5.multiply(bigIntegerArray[0]));
            bigInteger4 = bigInteger5;
            bigInteger5 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigIntegerArray[1];
        }
        if (bigInteger3 != null) {
            bigInteger3.e = bigInteger4.e;
            bigInteger3.f = bigInteger4.f;
        }
        return bigInteger;
    }

    private static void a(int[] nArray) {
        for (int i2 = 0; i2 != nArray.length; ++i2) {
            nArray[i2] = 0;
        }
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        Object object;
        if (bigInteger2.e <= 0) {
            throw new ArithmeticException("Modulus must be positive");
        }
        if (bigInteger2.equals(ONE)) {
            return ZERO;
        }
        if (bigInteger.e == 0) {
            return ONE;
        }
        if (this.e == 0) {
            return ZERO;
        }
        Object object2 = null;
        int[] nArray = null;
        boolean bl2 = (bigInteger2.f[bigInteger2.f.length - 1] & 1) == 1;
        long l2 = 0L;
        if (bl2) {
            long l3;
            object2 = bigInteger2;
            if (((BigInteger)object2).i != -1L) {
                l3 = ((BigInteger)object2).i;
            } else if ((((BigInteger)object2).f[((BigInteger)object2).f.length - 1] & 1) == 0) {
                l3 = -1L;
            } else {
                long l4 = (long)(~((BigInteger)object2).f[((BigInteger)object2).f.length - 1] | 1) & 0xFFFFFFFFL;
                long l5 = 0x100000000L;
                long l6 = l4;
                object = object2;
                if (0x100000000L < 0L) {
                    throw new ArithmeticException("Modulus must be positive");
                }
                object = new long[2];
                long l7 = BigInteger.a(l6, 0x100000000L, (long[])object);
                if (l7 != 1L) {
                    throw new ArithmeticException("Numbers not relatively prime.");
                }
                if (object[0] < 0L) {
                    object[0] = object[0] + 0x100000000L;
                }
                l3 = ((BigInteger)object2).i = (long)object[0];
            }
            l2 = l3;
            bigInteger3 = this.shiftLeft(32 * bigInteger2.f.length).mod(bigInteger2);
            object2 = bigInteger3.f;
            bl2 = bigInteger3.f.length <= bigInteger2.f.length;
            if (bl2) {
                nArray = new int[bigInteger2.f.length + 1];
                if (((Object)object2).length < bigInteger2.f.length) {
                    int[] nArray2 = new int[bigInteger2.f.length];
                    System.arraycopy(object2, 0, nArray2, nArray2.length - ((Object)object2).length, ((Object)object2).length);
                    object2 = nArray2;
                }
            }
        }
        if (!bl2) {
            if (this.f.length <= bigInteger2.f.length) {
                object2 = new int[bigInteger2.f.length];
                System.arraycopy(this.f, 0, object2, ((Object)object2).length - this.f.length, this.f.length);
            } else {
                bigInteger3 = this.remainder(bigInteger2);
                object2 = new int[bigInteger2.f.length];
                System.arraycopy(bigInteger3.f, 0, object2, ((Object)object2).length - bigInteger3.f.length, bigInteger3.f.length);
            }
            nArray = new int[bigInteger2.f.length << 1];
        }
        object = new int[bigInteger2.f.length];
        for (int i2 = 0; i2 < bigInteger.f.length; ++i2) {
            int n2 = bigInteger.f[i2];
            int n3 = 0;
            if (i2 == 0) {
                while (n2 > 0) {
                    n2 <<= 1;
                    ++n3;
                }
                System.arraycopy(object2, 0, object, 0, ((Object)object2).length);
                n2 <<= 1;
                ++n3;
            }
            while (n2 != 0) {
                if (bl2) {
                    this.a(nArray, (int[])object, (int[])object, bigInteger2.f, l2);
                } else {
                    BigInteger.c(nArray, object);
                    this.d(nArray, bigInteger2.f);
                    System.arraycopy(nArray, nArray.length - ((int[])object).length, object, 0, ((int[])object).length);
                    BigInteger.a(nArray);
                }
                ++n3;
                if (n2 < 0) {
                    if (bl2) {
                        this.a(nArray, (int[])object, (int[])object2, bigInteger2.f, l2);
                    } else {
                        BigInteger.a(nArray, object, (int[])object2);
                        this.d(nArray, bigInteger2.f);
                        System.arraycopy(nArray, nArray.length - ((int[])object).length, object, 0, ((int[])object).length);
                        BigInteger.a(nArray);
                    }
                }
                n2 <<= 1;
            }
            while (n3 < 32) {
                if (bl2) {
                    this.a(nArray, (int[])object, (int[])object, bigInteger2.f, l2);
                } else {
                    BigInteger.c(nArray, object);
                    this.d(nArray, bigInteger2.f);
                    System.arraycopy(nArray, nArray.length - ((int[])object).length, object, 0, ((int[])object).length);
                    BigInteger.a(nArray);
                }
                ++n3;
            }
        }
        if (bl2) {
            BigInteger.a((int[])object2);
            object2[((Object)object2).length - 1] = true;
            this.a(nArray, (int[])object, (int[])object2, bigInteger2.f, l2);
        }
        BigInteger bigInteger4 = new BigInteger(1, (int[])object);
        if (bigInteger.e > 0) {
            return bigInteger4;
        }
        return bigInteger4.modInverse(bigInteger2);
    }

    private static int[] c(int[] nArray, int[] nArray2) {
        long l2;
        long l3;
        int n2 = nArray.length - 1;
        for (int i2 = nArray2.length - 1; i2 != 0; --i2) {
            long l4 = (long)nArray2[i2] & 0xFFFFFFFFL;
            l3 = l4 * l4;
            l2 = l3 >>> 32;
            l3 &= 0xFFFFFFFFL;
            nArray[n2] = (int)(l3 += (long)nArray[n2] & 0xFFFFFFFFL);
            long l5 = l2 + (l3 >> 32);
            for (int i3 = i2 - 1; i3 >= 0; --i3) {
                l3 = ((long)nArray2[i3] & 0xFFFFFFFFL) * l4;
                l2 = l3 >>> 31;
                l3 = (l3 & Integer.MAX_VALUE) << 1;
                nArray[n2] = (int)(l3 += ((long)nArray[--n2] & 0xFFFFFFFFL) + l5);
                l5 = l2 + (l3 >>> 32);
            }
            nArray[n2] = (int)(l5 += (long)nArray[--n2] & 0xFFFFFFFFL);
            if (--n2 >= 0) {
                nArray[n2] = (int)(l5 >> 32);
            }
            n2 += i2;
        }
        l3 = (long)nArray2[0] & 0xFFFFFFFFL;
        l3 *= l3;
        l2 = l3 >>> 32;
        l3 &= 0xFFFFFFFFL;
        nArray[n2] = (int)(l3 += (long)nArray[n2] & 0xFFFFFFFFL);
        if (--n2 >= 0) {
            nArray[n2] = (int)(l2 + (l3 >> 32) + (long)nArray[n2]);
        }
        return nArray;
    }

    private static int[] a(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = nArray3.length;
        if (n2 <= 0) {
            return nArray;
        }
        int n3 = nArray.length - nArray2.length;
        while (true) {
            long l2 = (long)nArray3[--n2] & 0xFFFFFFFFL;
            long l3 = 0L;
            for (int i2 = nArray2.length - 1; i2 >= 0; --i2) {
                nArray[n3 + i2] = (int)(l3 += l2 * ((long)nArray2[i2] & 0xFFFFFFFFL) + ((long)nArray[n3 + i2] & 0xFFFFFFFFL));
                l3 >>>= 32;
            }
            --n3;
            if (n2 <= 0) {
                if (n3 < 0) break;
                nArray[n3] = (int)l3;
                break;
            }
            nArray[n3] = (int)l3;
        }
        return nArray;
    }

    private static long a(long l2, long l3, long[] lArray) {
        long l4;
        long l5 = 1L;
        long l6 = l2;
        long l7 = 0L;
        long l8 = l3;
        while (l8 > 0L) {
            long l9 = l6 / l8;
            long l10 = l5 - l7 * l9;
            l5 = l7;
            l7 = l10;
            l10 = l6 - l8 * l9;
            l6 = l8;
            l8 = l10;
        }
        lArray[0] = l5;
        lArray[1] = l4 = (l6 - l5 * l2) / l3;
        return l6;
    }

    private void a(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l2) {
        int n2;
        int n3 = nArray4.length;
        int n4 = n3 - 1;
        long l3 = (long)nArray3[n4] & 0xFFFFFFFFL;
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = n3; n2 > 0; --n2) {
            long l4 = (long)nArray2[n2 - 1] & 0xFFFFFFFFL;
            long l5 = (((long)nArray[n3] & 0xFFFFFFFFL) + (l4 * l3 & 0xFFFFFFFFL) & 0xFFFFFFFFL) * l2 & 0xFFFFFFFFL;
            long l6 = l4 * l3;
            long l7 = l5 * ((long)nArray4[n4] & 0xFFFFFFFFL);
            long l8 = ((long)nArray[n3] & 0xFFFFFFFFL) + (l6 & 0xFFFFFFFFL) + (l7 & 0xFFFFFFFFL);
            long l9 = (l6 >>> 32) + (l7 >>> 32) + (l8 >>> 32);
            for (int i2 = n4; i2 > 0; --i2) {
                l6 = l4 * ((long)nArray3[i2 - 1] & 0xFFFFFFFFL);
                l7 = l5 * ((long)nArray4[i2 - 1] & 0xFFFFFFFFL);
                l8 = ((long)nArray[i2] & 0xFFFFFFFFL) + (l6 & 0xFFFFFFFFL) + (l7 & 0xFFFFFFFFL) + (l9 & 0xFFFFFFFFL);
                l9 = (l9 >>> 32) + (l6 >>> 32) + (l7 >>> 32) + (l8 >>> 32);
                nArray[i2 + 1] = (int)l8;
            }
            nArray[1] = (int)(l9 += (long)nArray[0] & 0xFFFFFFFFL);
            nArray[0] = (int)(l9 >>> 32);
        }
        if (this.a(0, nArray, 0, nArray4) >= 0) {
            BigInteger.a(nArray, 0, nArray4);
        }
        System.arraycopy(nArray, 1, nArray2, 0, n3);
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (this.e == 0 || bigInteger.e == 0) {
            return ZERO;
        }
        int n2 = (this.bitLength() + bigInteger.bitLength()) / 32 + 1;
        int[] nArray = new int[n2];
        if (bigInteger == this) {
            BigInteger.c(nArray, this.f);
        } else {
            BigInteger.a(nArray, this.f, bigInteger.f);
        }
        return new BigInteger(this.e * bigInteger.e, nArray);
    }

    public BigInteger negate() {
        if (this.e == 0) {
            return this;
        }
        return new BigInteger(-this.e, this.f);
    }

    public BigInteger not() {
        return this.add(ONE).negate();
    }

    public BigInteger pow(int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.e == 0) {
            if (n2 == 0) {
                return ONE;
            }
            return this;
        }
        BigInteger bigInteger = ONE;
        BigInteger bigInteger2 = this;
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                bigInteger = bigInteger.multiply(bigInteger2);
            }
            if ((n2 >>= 1) == 0) continue;
            bigInteger2 = bigInteger2.multiply(bigInteger2);
        }
        return bigInteger;
    }

    private int a(int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.f.length; ++i2) {
            l2 = (l2 << 32 | (long)this.f[i2] & 0xFFFFFFFFL) % (long)n2;
        }
        return (int)l2;
    }

    private int[] d(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        for (n3 = 0; n3 < nArray.length && nArray[n3] == 0; ++n3) {
        }
        for (n2 = 0; n2 < nArray2.length && nArray2[n2] == 0; ++n2) {
        }
        int n4 = BigInteger.b(n3, nArray, n2, nArray2);
        if (n4 > 0) {
            int[] nArray3;
            n4 = this.a(n2, nArray2);
            int n5 = this.a(n3, nArray);
            int n6 = n5 - n4;
            int n7 = 0;
            int n8 = n4;
            if (n6 > 0) {
                nArray3 = BigInteger.a(nArray2, n6);
                n8 += n6;
            } else {
                n4 = nArray2.length - n2;
                nArray3 = new int[n4];
                System.arraycopy(nArray2, n2, nArray3, 0, n4);
            }
            block2: while (true) {
                if (n8 < n5 || BigInteger.b(n3, nArray, n7, nArray3) >= 0) {
                    BigInteger.a(nArray, n7, nArray3);
                    while (nArray[n3] == 0) {
                        if (++n3 != nArray.length) continue;
                        return nArray;
                    }
                    n4 = BigInteger.b(n3, nArray, n2, nArray2);
                    if (n4 <= 0) break;
                    n5 = 32 * (nArray.length - n3 - 1) + BigInteger.bitLen(nArray[n3]);
                }
                if ((n6 = n8 - n5) < 2) {
                    BigInteger.b(n7, nArray3);
                    --n8;
                } else {
                    BigInteger.a(n7, nArray3, n6);
                    n8 -= n6;
                }
                while (true) {
                    if (nArray3[n7] != 0) continue block2;
                    ++n7;
                }
                break;
            }
        }
        if (n4 == 0) {
            for (n4 = n3; n4 < nArray.length; ++n4) {
                nArray[n4] = 0;
            }
        }
        return nArray;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        int n2;
        if (bigInteger.e == 0) {
            throw new ArithmeticException("com/asao/smsgame/main/BigInteger: Divide by zero");
        }
        if (this.e == 0) {
            return ZERO;
        }
        if (bigInteger.f.length == 1 && (n2 = bigInteger.f[0]) > 0) {
            if (n2 == 1) {
                return ZERO;
            }
            int n3 = this.a(n2);
            if (n3 == 0) {
                return ZERO;
            }
            return new BigInteger(this.e, new int[]{n3});
        }
        if (this.a(0, this.f, 0, bigInteger.f) < 0) {
            return this;
        }
        Object object = bigInteger;
        if (((BigInteger)object).e > 0 && ((BigInteger)object).g == 1) {
            int[] nArray;
            int n4 = bigInteger.abs().bitLength() - 1;
            object = this;
            if (n4 <= 0) {
                nArray = c;
            } else {
                int n5 = (n4 + 31) / 32;
                n5 = Math.min(n5, ((BigInteger)object).f.length);
                int[] nArray2 = new int[n5];
                System.arraycopy(((BigInteger)object).f, ((BigInteger)object).f.length - n5, nArray2, 0, n5);
                if ((n4 %= 32) != 0) {
                    nArray2[0] = nArray2[0] & ~(-1 << n4);
                }
                nArray = nArray2;
            }
            object = nArray;
        } else {
            object = new int[this.f.length];
            System.arraycopy(this.f, 0, object, 0, ((Object)object).length);
            object = this.d((int[])object, bigInteger.f);
        }
        return new BigInteger(this.e, (int[])object);
    }

    private static int[] a(int[] nArray, int n2) {
        int[] nArray2;
        int n3 = n2 >>> 5;
        int n4 = nArray.length;
        if ((n2 &= 0x1F) == 0) {
            nArray2 = new int[n4 + n3];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
        } else {
            int n5 = 0;
            int n6 = 32 - n2;
            int n7 = nArray[0] >>> n6;
            if (n7 != 0) {
                int[] nArray3 = new int[n4 + n3 + 1];
                nArray2 = nArray3;
                ++n5;
                nArray3[0] = n7;
            } else {
                nArray2 = new int[n4 + n3];
            }
            n7 = nArray[0];
            for (int i2 = 0; i2 < n4 - 1; ++i2) {
                int n8 = nArray[i2 + 1];
                nArray2[n5++] = n7 << n2 | n8 >>> n6;
                n7 = n8;
            }
            nArray2[n5] = nArray[n4 - 1] << n2;
        }
        return nArray2;
    }

    public BigInteger shiftLeft(int n2) {
        if (this.e == 0 || this.f.length == 0) {
            return ZERO;
        }
        if (n2 == 0) {
            return this;
        }
        if (n2 < 0) {
            return this.shiftRight(-n2);
        }
        BigInteger bigInteger = new BigInteger(this.e, BigInteger.a(this.f, n2));
        if (this.g != -1) {
            int n3 = bigInteger.g = this.e > 0 ? this.g : this.g + n2;
        }
        if (this.h != -1) {
            bigInteger.h = this.h + n2;
        }
        return bigInteger;
    }

    private static void a(int n2, int[] nArray, int n3) {
        int n4;
        int n5;
        int n6 = (n3 >>> 5) + n2;
        n3 &= 0x1F;
        int n7 = nArray.length - 1;
        if (n6 != n2) {
            n5 = n6 - n2;
            for (n4 = n7; n4 >= n6; --n4) {
                nArray[n4] = nArray[n4 - n5];
            }
            for (n4 = n6 - 1; n4 >= n2; --n4) {
                nArray[n4] = 0;
            }
        }
        if (n3 != 0) {
            n5 = 32 - n3;
            n4 = nArray[n7];
            for (n2 = n7; n2 >= n6 + 1; --n2) {
                n7 = nArray[n2 - 1];
                nArray[n2] = n4 >>> n3 | n7 << n5;
                n4 = n7;
            }
            int n8 = n6;
            nArray[n8] = nArray[n8] >>> n3;
        }
    }

    private static void b(int n2, int[] nArray) {
        int n3 = nArray.length - 1;
        int n4 = nArray[n3];
        while (n3 > n2) {
            int n5 = nArray[n3 - 1];
            nArray[n3] = n4 >>> 1 | n5 << 31;
            n4 = n5;
            --n3;
        }
        int n6 = n2;
        nArray[n6] = nArray[n6] >>> 1;
    }

    public BigInteger shiftRight(int n2) {
        if (n2 == 0) {
            return this;
        }
        if (n2 < 0) {
            return this.shiftLeft(-n2);
        }
        if (n2 >= this.bitLength()) {
            if (this.e < 0) {
                return BigInteger.valueOf(-1L);
            }
            return ZERO;
        }
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        BigInteger.a(0, nArray, n2);
        return new BigInteger(this.e, nArray);
    }

    public int signum() {
        return this.e;
    }

    private static int[] a(int[] nArray, int n2, int[] nArray2) {
        int n3 = nArray.length;
        int n4 = nArray2.length;
        int n5 = 0;
        do {
            long l2 = ((long)nArray[--n3] & 0xFFFFFFFFL) - ((long)nArray2[--n4] & 0xFFFFFFFFL) + (long)n5;
            nArray[n3] = (int)l2;
            n5 = (int)(l2 >> 63);
        } while (n4 > n2);
        if (n5 != 0) {
            int n6;
            do {
                n6 = --n3;
            } while ((nArray[n6] = nArray[n6] - 1) == -1);
        }
        return nArray;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger.e == 0 || bigInteger.f.length == 0) {
            return this;
        }
        if (this.e == 0 || this.f.length == 0) {
            return bigInteger.negate();
        }
        if (this.e != bigInteger.e) {
            return this.add(bigInteger.negate());
        }
        int n2 = this.a(0, this.f, 0, bigInteger.f);
        if (n2 == 0) {
            return ZERO;
        }
        if (n2 < 0) {
            bigInteger2 = bigInteger;
            bigInteger = this;
        } else {
            bigInteger2 = this;
        }
        int[] nArray = new int[bigInteger2.f.length];
        System.arraycopy(bigInteger2.f, 0, nArray, 0, nArray.length);
        return new BigInteger(this.e * n2, BigInteger.a(nArray, 0, bigInteger.f));
    }

    public byte[] toByteArray() {
        if (this.e == 0) {
            return new byte[1];
        }
        int n2 = this.bitLength();
        byte[] byArray = new byte[n2 / 8 + 1];
        int n3 = this.f.length;
        int n4 = byArray.length;
        if (this.e > 0) {
            int n5;
            while (n3 > 1) {
                n5 = this.f[--n3];
                byArray[--n4] = (byte)n5;
                byArray[--n4] = (byte)(n5 >>> 8);
                byArray[--n4] = (byte)(n5 >>> 16);
                byArray[--n4] = n5 >> 24;
            }
            n5 = this.f[0];
            while ((n5 & 0xFFFFFF00) != 0) {
                byArray[--n4] = (byte)n5;
                n5 >>>= 8;
            }
            byArray[--n4] = (byte)n5;
        } else {
            int n6;
            boolean bl2 = true;
            while (n3 > 1) {
                n6 = ~this.f[--n3];
                if (bl2) {
                    bl2 = ++n6 == 0;
                }
                byArray[--n4] = (byte)n6;
                byArray[--n4] = (byte)(n6 >>> 8);
                byArray[--n4] = (byte)(n6 >>> 16);
                byArray[--n4] = n6 >> 24;
            }
            n6 = this.f[0];
            if (bl2) {
                --n6;
            }
            while ((n6 & 0xFFFFFF00) != 0) {
                byArray[--n4] = (byte)(~n6);
                n6 >>>= 8;
            }
            byArray[--n4] = (byte)(~n6);
            if (n4 > 0) {
                byArray[--n4] = -1;
            }
        }
        return byArray;
    }

    public BigInteger xor(BigInteger bigInteger) {
        if (this.e == 0) {
            return bigInteger;
        }
        if (bigInteger.e == 0) {
            return this;
        }
        int[] nArray = this.e > 0 ? this.f : this.add((BigInteger)BigInteger.ONE).f;
        int[] nArray2 = bigInteger.e > 0 ? bigInteger.f : bigInteger.add((BigInteger)BigInteger.ONE).f;
        boolean bl2 = this.e < 0 && bigInteger.e >= 0 || this.e >= 0 && bigInteger.e < 0;
        int n2 = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n2];
        int n3 = nArray3.length - nArray.length;
        int n4 = nArray3.length - nArray2.length;
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            int n5;
            int n6 = i2 >= n3 ? nArray[i2 - n3] : 0;
            int n7 = n5 = i2 >= n4 ? nArray2[i2 - n4] : 0;
            if (this.e < 0) {
                n6 ^= 0xFFFFFFFF;
            }
            if (bigInteger.e < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            nArray3[i2] = n6 ^ n5;
            if (!bl2) continue;
            nArray3[i2] = ~nArray3[i2];
        }
        BigInteger bigInteger2 = new BigInteger(1, nArray3);
        if (bl2) {
            bigInteger2 = bigInteger2.not();
        }
        return bigInteger2;
    }

    public BigInteger or(BigInteger bigInteger) {
        if (this.e == 0) {
            return bigInteger;
        }
        if (bigInteger.e == 0) {
            return this;
        }
        int[] nArray = this.e > 0 ? this.f : this.add((BigInteger)BigInteger.ONE).f;
        int[] nArray2 = bigInteger.e > 0 ? bigInteger.f : bigInteger.add((BigInteger)BigInteger.ONE).f;
        boolean bl2 = this.e < 0 || bigInteger.e < 0;
        int n2 = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n2];
        int n3 = nArray3.length - nArray.length;
        int n4 = nArray3.length - nArray2.length;
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            int n5;
            int n6 = i2 >= n3 ? nArray[i2 - n3] : 0;
            int n7 = n5 = i2 >= n4 ? nArray2[i2 - n4] : 0;
            if (this.e < 0) {
                n6 ^= 0xFFFFFFFF;
            }
            if (bigInteger.e < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            nArray3[i2] = n6 | n5;
            if (!bl2) continue;
            nArray3[i2] = ~nArray3[i2];
        }
        BigInteger bigInteger2 = new BigInteger(1, nArray3);
        if (bl2) {
            bigInteger2 = bigInteger2.not();
        }
        return bigInteger2;
    }

    public BigInteger setBit(int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.testBit(n2)) {
            return this;
        }
        if (this.e > 0 && n2 < this.bitLength() - 1) {
            return this.b(n2);
        }
        return this.or(ONE.shiftLeft(n2));
    }

    public BigInteger clearBit(int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (!this.testBit(n2)) {
            return this;
        }
        if (this.e > 0 && n2 < this.bitLength() - 1) {
            return this.b(n2);
        }
        return this.andNot(ONE.shiftLeft(n2));
    }

    public BigInteger flipBit(int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.e > 0 && n2 < this.bitLength() - 1) {
            return this.b(n2);
        }
        return this.xor(ONE.shiftLeft(n2));
    }

    private BigInteger b(int n2) {
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        int n3 = nArray.length - 1 - (n2 >>> 5);
        nArray[n3] = nArray[n3] ^ 1 << (n2 & 0x1F);
        return new BigInteger(this.e, nArray);
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int n2) {
        if (this.f == null) {
            return "null";
        }
        if (this.e == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 16) {
            for (int i2 = 0; i2 < this.f.length; ++i2) {
                String string = "0000000" + Integer.toHexString(this.f[i2]);
                string = string.substring(string.length() - 8);
                stringBuffer.append(string);
            }
        } else if (n2 == 2) {
            stringBuffer.append('1');
            for (int i3 = this.bitLength() - 2; i3 >= 0; --i3) {
                stringBuffer.append(this.testBit(i3) ? (char)'1' : '0');
            }
        } else {
            Stack<String> stack = new Stack<String>();
            BigInteger bigInteger = new BigInteger(Integer.toString(n2, n2), n2);
            BigInteger bigInteger2 = this.abs();
            while (!bigInteger2.equals(ZERO)) {
                BigInteger bigInteger3 = bigInteger2.mod(bigInteger);
                if (bigInteger3.equals(ZERO)) {
                    stack.push("0");
                } else {
                    stack.push(Integer.toString(bigInteger3.f[0], n2));
                }
                bigInteger2 = bigInteger2.divide(bigInteger);
            }
            while (!stack.empty()) {
                stringBuffer.append((String)stack.pop());
            }
        }
        String string = stringBuffer.toString();
        while (string.length() > 1 && string.charAt(0) == '0') {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            string = "0";
        } else if (this.e == -1) {
            string = "-" + string;
        }
        return string;
    }

    public static BigInteger valueOf(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        if (l2 < 0L) {
            if (l2 == Long.MIN_VALUE) {
                return BigInteger.valueOf(l2 ^ 0xFFFFFFFFFFFFFFFFL).not();
            }
            return BigInteger.valueOf(-l2).negate();
        }
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[7 - i2] = (byte)l2;
            l2 >>= 8;
        }
        return new BigInteger(byArray);
    }

    public int getLowestSetBit() {
        int n2;
        if (this.e == 0) {
            return -1;
        }
        int n3 = this.f.length;
        while (--n3 > 0 && this.f[n3] == 0) {
        }
        int n4 = this.f[n3];
        int n5 = (n4 & 0xFFFF) == 0 ? ((n4 & 0xFF0000) == 0 ? 7 : 15) : (n2 = (n4 & 0xFF) == 0 ? 23 : 31);
        while (n2 > 0 && n4 << n2 != Integer.MIN_VALUE) {
            --n2;
        }
        return (this.f.length - n3 << 5) - (n2 + 1);
    }

    public boolean testBit(int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Bit position must not be negative");
        }
        if (this.e < 0) {
            return !this.not().testBit(n2);
        }
        int n3 = n2 / 32;
        if (n3 >= this.f.length) {
            return false;
        }
        return ((n3 = this.f[this.f.length - 1 - n3]) >> n2 % 32 & 1) > 0;
    }

    static {
        c = new int[0];
        ZERO = new BigInteger(0, c);
        ONE = BigInteger.valueOf(1L);
        d = BigInteger.valueOf(2L);
        BigInteger.valueOf(3L);
        BigInteger.ZERO.g = 0;
        BigInteger.ZERO.h = 0;
        BigInteger.ONE.g = 1;
        BigInteger.ONE.h = 1;
        BigInteger.d.g = 1;
        BigInteger.d.h = 2;
        b = new int[a.length];
        for (int i2 = 0; i2 < a.length; ++i2) {
            int[] nArray = a[i2];
            int n2 = 1;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                n2 *= nArray[i3];
            }
            BigInteger.b[i2] = n2;
        }
        byte[] byArray = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
        j = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }
}

