/*
 * Decompiled with CFR 0.152.
 */
package CoreGame;

import CoreGame.Control;
import CoreGame.GUIManager;

public class ScrollScreen {
    public int x_page;
    public int y_page;
    public int width_page;
    public int height_page;
    public int dx;
    public int dy;
    public int x_lim_trai;
    public int x_lim_phai;
    public int y_lim_tren;
    public int y_lim_duoi;
    public int y_top;
    public int y_bottom;
    public int x_left;
    public int x_right;

    public ScrollScreen() {
        this.resetCamera();
    }

    public void resetCamera() {
        this.dy = 0;
        this.y_page = 0;
        this.height_page = 0;
        this.y_lim_tren = -1;
        this.y_lim_duoi = -1;
        this.dx = 0;
        this.x_page = 0;
        this.x_lim_trai = -1;
        this.x_lim_phai = -1;
        this.x_right = 0;
        this.x_left = 0;
        this.y_bottom = 0;
        this.y_top = 0;
    }

    public void setWidthScrollScreen(int _xLimLeft, int _xLimRight, int _xL, int _xR, int _WScreen) {
        if (_xLimLeft == -1 || _xLimRight == -1) {
            return;
        }
        if (_xL == -1 && _xR == -1) {
            return;
        }
        this.width_page = _WScreen;
        this.x_lim_trai = _xLimLeft;
        this.x_lim_phai = _xLimRight;
        if (_xL == -1) {
            _xL = _xR - _WScreen;
        }
        if (_xR == -1) {
            _xR = _xL + _WScreen;
        }
        this.x_left = _xL;
        this.x_right = _xR;
    }

    public void setHeightScrollScreen(int _yLimTop, int _yLimBottom, int _yT, int _yBT, int _HScreen) {
        if (_yLimTop == -1 || _yLimBottom == -1) {
            return;
        }
        if (_yT == -1 && _yBT == -1) {
            return;
        }
        this.height_page = _HScreen;
        this.y_lim_tren = _yLimTop;
        this.y_lim_duoi = _yLimBottom;
        if (_yT == -1) {
            _yT = _yBT - _HScreen;
        }
        if (_yBT == -1) {
            _yBT = _yT + _HScreen;
        }
        this.y_top = _yT;
        this.y_bottom = _yBT;
    }

    public void sizeChanged() {
        this.setCorrectPosition();
    }

    public void setCorrectPosition() {
        int _dx = 0;
        int _dy = 0;
        if (this.x_lim_trai != -1 && this.x_lim_phai != -1) {
            if (this.x_right < this.x_lim_phai) {
                _dx = this.x_right - this.x_lim_phai;
            } else if (this.x_left > this.x_lim_trai) {
                _dx = this.x_left - this.x_lim_trai;
            }
        }
        if (this.y_lim_tren != -1 && this.y_lim_duoi != -1) {
            if (this.y_bottom < this.y_lim_duoi) {
                _dy = this.y_bottom - this.y_lim_duoi;
            } else if (this.y_top > this.y_lim_tren) {
                _dy = this.y_top - this.y_lim_tren;
            }
        }
        this.setScrool(_dx, _dy);
    }

    public void setCorrectPosition(int _xItem, int _yItem, int _xCorrect, int _yCorrect) {
        int _dx = 0;
        int _dy = 0;
        if (this.x_lim_trai != -1 && this.x_lim_phai != -1 && _xItem != -1) {
            _dx = _xItem + this.x_page - _xCorrect;
        }
        if (this.y_lim_tren != -1 && this.y_lim_duoi != -1 && _yItem != -1) {
            _dy = _yItem + this.y_page - _yCorrect;
        }
        this.setScrool(_dx, _dy);
    }

    public void updateCamera() {
        int _tmp;
        if (this.x_lim_trai != -1 && this.x_lim_phai != -1 && this.dx != 0) {
            _tmp = Math.abs(this.dx) / 2;
            if (this.dx > 0) {
                if (_tmp <= 0) {
                    _tmp = 1;
                    this.dx -= _tmp;
                    this.x_page -= _tmp;
                    this.x_left -= _tmp;
                    this.x_right -= _tmp;
                    GUIManager.x_start -= _tmp;
                } else {
                    this.dx -= _tmp;
                    this.x_page -= _tmp;
                    this.x_left -= _tmp;
                    this.x_right -= _tmp;
                    GUIManager.x_start -= _tmp;
                }
            } else if (this.dx < 0) {
                if (_tmp <= 0) {
                    _tmp = 1;
                    this.dx += _tmp;
                    this.x_page += _tmp;
                    this.x_left += _tmp;
                    this.x_right += _tmp;
                    GUIManager.x_start += _tmp;
                } else {
                    this.dx += _tmp;
                    this.x_page += _tmp;
                    this.x_left += _tmp;
                    this.x_right += _tmp;
                    GUIManager.x_start += _tmp;
                }
            }
        }
        if (this.y_lim_tren != -1 && this.y_lim_duoi != -1 && this.dy != 0) {
            _tmp = Math.abs(this.dy) / 2;
            if (this.dy > 0) {
                if (_tmp <= 0) {
                    _tmp = 1;
                    this.dy -= _tmp;
                    this.y_page -= _tmp;
                    this.y_top -= _tmp;
                    this.y_bottom -= _tmp;
                    GUIManager.y_start -= _tmp;
                } else {
                    this.dy -= _tmp;
                    this.y_page -= _tmp;
                    this.y_top -= _tmp;
                    this.y_bottom -= _tmp;
                    GUIManager.y_start -= _tmp;
                }
            } else if (this.dy < 0) {
                if (_tmp <= 0) {
                    _tmp = 1;
                    this.dy += _tmp;
                    this.y_page += _tmp;
                    this.y_top += _tmp;
                    this.y_bottom += _tmp;
                    GUIManager.y_start += _tmp;
                } else {
                    this.dy += _tmp;
                    this.y_page += _tmp;
                    this.y_top += _tmp;
                    this.y_bottom += _tmp;
                    GUIManager.y_start += _tmp;
                }
            }
        }
    }

    public void setScrool(int _dx, int _dy) {
        if (this.x_lim_trai != -1 && this.x_lim_phai != -1 && _dx != 0) {
            if (_dx > 0) {
                this.dx = this.x_right <= this.x_lim_phai ? 0 : (this.x_right > this.x_lim_phai && _dx > this.x_right - this.x_lim_phai ? this.x_right - this.x_lim_phai : _dx);
            } else if (_dx < 0) {
                this.dx = this.x_left >= this.x_lim_trai ? 0 : (this.x_left < this.x_lim_trai && _dx < this.x_left - this.x_lim_trai ? this.x_left - this.x_lim_trai : _dx);
            }
        }
        if (this.y_lim_tren != -1 && this.y_lim_duoi != -1 && _dy != 0) {
            if (_dy > 0) {
                this.dy = this.y_bottom <= this.y_lim_duoi ? 0 : (this.y_bottom > this.y_lim_duoi && _dy > this.y_bottom - this.y_lim_duoi ? this.y_bottom - this.y_lim_duoi : _dy);
            } else if (_dy < 0) {
                this.dy = this.y_top >= this.y_lim_tren ? 0 : (this.y_top < this.y_lim_tren && _dy < this.y_top - this.y_lim_tren ? this.y_top - this.y_lim_tren : _dy);
            }
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
        if (!Control.paintMenu && !Control.paintDlg) {
            int _dx = 0;
            int _dy = 0;
            if (this.y_lim_tren != -1 && this.y_lim_duoi != -1) {
                _dy = GUIManager.y_start - GUIManager.y_end;
            }
            if (this.x_lim_trai != -1 && this.x_lim_phai != -1) {
                _dx = GUIManager.x_start - GUIManager.x_end;
            }
            if (_dx != 0 || _dy != 0) {
                this.setScrool(_dx, _dy);
            }
        }
    }

    public void pointerRelease(int x, int y) {
        if (!Control.paintMenu && !Control.paintDlg && GUIManager.isPointerDragged) {
            int _dx = 0;
            int _dy = 0;
            if (this.y_lim_tren != -1 && this.y_lim_duoi != -1 && GUIManager.dy != 0.0) {
                _dy = (int)GUIManager.dy;
            }
            if (this.x_lim_trai != -1 && this.x_lim_phai != -1 && GUIManager.dx != 0.0) {
                _dx = (int)GUIManager.dx;
            }
            if (_dx != 0 || _dy != 0) {
                this.setScrool(_dx, _dy);
            }
        }
    }
}

