/*
 * Decompiled with CFR 0.152.
 */
package GamePages;

import Core.SMSSender;
import CoreGame.Action;
import CoreGame.Command;
import CoreGame.Control;
import CoreGame.GUIManager;
import CoreGame.GameMain;
import GamePages.Loading;
import GamePages.Page;
import Util.Crypto;
import Util.Data;
import Util.Database;
import Util.IconToolBar;
import Util.StaticMessage;
import Util.StaticObj;
import Util.staticImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreen
extends Page {
    public Image imgLogo;
    public int TimeShowLogo = 20;
    public boolean isAskPlaySound;
    public int Command = 0;
    public int Command_ChangePage_MainMenu = 1;

    public SplashScreen() {
        try {
            Data.Magame = new String(new Crypto().decrypt("AAAABtPtvy8DJm28".getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public void init() {
        super.init();
        this.initServer();
    }

    public void initServer() {
        block10: {
            try {
                this.loadSMSinfo();
                GUIManager.flagOtherGame = true;
                HttpConnection conn = null;
                String url = "http://" + Data.domain + "/highscore/?ctrl=gameinfo";
                try {
                    conn = (HttpConnection)Connector.open((String)url, (int)1);
                    conn.setRequestProperty("User-Agent", "J2ME;" + Data.Magame + "-" + Data.Version + ";" + Data.Partner);
                    if (conn.getResponseCode() == 200) {
                        int ch;
                        InputStream iStrm = conn.openInputStream();
                        ByteArrayOutputStream bStrm = new ByteArrayOutputStream();
                        while ((ch = iStrm.read()) != -1) {
                            bStrm.write(ch);
                        }
                        byte[] data = bStrm.toByteArray();
                        bStrm.close();
                        String str = new String(data);
                        StaticObj.PrintOut("Page SplashScreen data - " + str);
                        if (str.startsWith("R:") || str.equals("")) {
                            GUIManager.flagOtherGame = false;
                        } else {
                            this.getInfoSMS(str);
                        }
                        break block10;
                    }
                    GUIManager.flagOtherGame = false;
                }
                catch (SecurityException se) {
                    GUIManager.flagOtherGame = false;
                }
                catch (IOException ioex) {
                    GUIManager.flagOtherGame = false;
                }
                catch (Exception e) {
                    GUIManager.flagOtherGame = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadSMSinfo() {
        this.getInfoSMS(this.readDatConfig());
    }

    private String readDatConfig() {
        String str = "";
        try {
            InputStream is = this.getClass().getResourceAsStream("/code.dat");
            byte[] data = new byte[is.available()];
            is.read(data, 0, data.length);
            str = new String(data);
            str = str.trim();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    private void getInfoSMS(String str) {
        if (str.equals("") || str == null) {
            return;
        }
        try {
            String[] arr = StaticObj.split(str, ":");
            block7: for (int i = 0; i < arr.length; ++i) {
                String[] item = StaticObj.split(arr[i], "#");
                switch (i) {
                    case 0: {
                        SMSSender.CUPHAP = item[0];
                        SMSSender.DAUSO_LUUDIEM = item[1];
                        SMSSender.TIEN_LUU_DIEM = item[2];
                        continue block7;
                    }
                    case 1: {
                        Data.Partner = item[0];
                        continue block7;
                    }
                    case 2: {
                        SMSSender.DAUSO_MUA_HUONGDAN = item[0];
                        SMSSender.TIEN_MUA_HUONGDAN = item[1];
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadImg() {
        try {
            this.imgLogo = Image.createImage((String)"/others/logo_jamo.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sizeChanged() {
    }

    public void update() {
        if (this.TimeShowLogo > 0) {
            --this.TimeShowLogo;
            if (this.TimeShowLogo <= 0) {
                this.TimeShowLogo = 0;
                this.load();
                this.isAskPlaySound = true;
                Loading.getInstance().showChangePage();
                Loading.getInstance().isPaintCommand = true;
            }
        } else if (this.isAskPlaySound) {
            if (Loading.Ins != null && Loading.getInstance().isLoad) {
                Control.showDlg(StaticMessage.ASK_TO_PLAY_SOUND[StaticMessage.langue], new Command("", IconToolBar.imgIcon[IconToolBar.AGREE + IconToolBar.distance], GUIManager.Style_Screen, new Action(){

                    public void perform() {
                        GUIManager.isPlaySound = true;
                        Control.resetCommand();
                        SplashScreen.this.Command = SplashScreen.this.Command_ChangePage_MainMenu;
                        Loading.getInstance().isPaintCommand = false;
                    }
                }), new Command("", IconToolBar.imgIcon[IconToolBar.DO_NOT_AGREE + IconToolBar.distance], GUIManager.Style_Screen, new Action(){

                    public void perform() {
                        GUIManager.isPlaySound = false;
                        Control.resetCommand();
                        SplashScreen.this.Command = SplashScreen.this.Command_ChangePage_MainMenu;
                        Loading.getInstance().isPaintCommand = false;
                    }
                }), null);
                Control.DlgLeftCommand.RegisTouch(-1, -1, -1, -1);
                Control.DlgRightCommand.RegisTouch(-3, -1, -1, -1);
                this.isAskPlaySound = false;
            }
        } else if (Loading.Ins != null && Loading.getInstance().isLoad && this.Command == this.Command_ChangePage_MainMenu) {
            GameMain.getInstance().changePage(2);
        }
    }

    public void load() {
        staticImage.loadImg();
        Database.loadDataBase();
    }

    public void paintBackground(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
    }

    public void paintMain(Graphics g) {
        if (this.TimeShowLogo > 0) {
            g.drawImage(this.imgLogo, GUIManager.WIDTH >> 1, GUIManager.HEIGHT >> 1, 3);
        }
    }

    public void destroy() {
        this.imgLogo = null;
    }
}

