/*
 * Decompiled with CFR 0.152.
 */
package Core;

import Core.KEY;
import Core.RGBFont;
import Core.Slide;
import Core.Touch;
import GMain.GCanvas;
import IGP_Page.Mask;
import javax.microedition.lcdui.Graphics;

public class GLives {
    public GCanvas canvas;
    public static int vendorDevice = 0;
    public static int ScreenWidth;
    public static int ScreenHeight;
    public static boolean isTouchable;
    public static boolean isQwerty;
    public static GLives ins;
    public boolean isGameKey = true;
    public Slide currSlide = null;
    public RGBFont bmf_normal = null;
    public RGBFont bmf_bold = null;
    private boolean isFrozen = false;
    private long ltimeStart = 0L;

    public GLives(GCanvas gameCanvas) {
        this.canvas = gameCanvas;
        ins = this;
    }

    public void destroy() {
        this.isFrozen = true;
        Touch.destroy();
        this.freeMem();
    }

    public void InitializeIGP() {
        this.isFrozen = true;
        if (this.currSlide == null) {
            this.bmf_normal = new RGBFont("/font/medium.pak");
            this.bmf_bold = new RGBFont("/font/big.pak");
            this.bmf_bold.m_hasBorder = true;
        }
        this.currSlide = new Mask();
        this.initState();
        this.currSlide.init();
        this.currSlide.registerTouch();
        this.isFrozen = false;
    }

    private void freeMem() {
        if (ins != null && GLives.ins.currSlide != null) {
            GLives.ins.currSlide.destroy();
            System.gc();
        }
    }

    private void initState() {
        KEY.resetKeys();
        Touch.releaseTouchArea();
        this.currSlide.executeInnerSize();
        this.isGameKey = true;
    }

    public void init(boolean B, String S, int F, boolean Q) {
        isTouchable = B;
        isQwerty = Q;
        String s = S;
        int kind = F;
        if (kind == -20) {
            vendorDevice = 5;
        }
        if (s == null || s.length() == 0) {
            vendorDevice = 0;
        } else if (s.indexOf("Nokia") != -1) {
            vendorDevice = 1;
        } else if (s.indexOf("Samsung") != -1) {
            vendorDevice = 7;
        } else if (s.indexOf("Sony") != -1) {
            vendorDevice = 2;
        } else if (s.indexOf("RIM") != -1) {
            vendorDevice = 3;
        } else if (s.indexOf("SIE-EL71") != -1) {
            vendorDevice = 6;
        } else if (s.indexOf("MAUI") != -1) {
            vendorDevice = 4;
            isQwerty = true;
        }
        if (s.indexOf("NokiaE61") != -1) {
            isQwerty = true;
        }
    }

    public void init(int W, int H) {
        ScreenWidth = W;
        ScreenHeight = H;
    }

    public void startTextInput() {
        this.isGameKey = false;
    }

    public void onkeyDown(int keyCode) {
        this.currSlide.onkeyDown(KEY.getKey(keyCode, (short)-2));
    }

    public void onkeyUp(int keyCode) {
        this.currSlide.onkeyUp(KEY.getKey(keyCode, (short)-3));
    }

    public void touchDown(int x, int y) {
        Touch.isPressed = true;
        this.ltimeStart = System.currentTimeMillis();
        Touch.x = Touch.xDown = x;
        Touch.y = Touch.yDown = y;
        Touch.IDdown = Touch.click(x, y);
        this.currSlide.touchDown(Touch.IDdown, x, y);
    }

    public void touchDrag(int x, int y) {
        Touch.x = x;
        Touch.y = y;
        this.currSlide.touchDrag(x, y);
    }

    public void touchUp(int x, int y) {
        int dy;
        Touch.isPressed = false;
        Touch.x = Touch.xUp = x;
        Touch.y = Touch.yUp = y;
        Touch.IDcurr = Touch.click(x, y);
        int dx = x - Touch.xDown;
        if (dx < 0) {
            dx = -dx;
        }
        if ((dy = y - Touch.yDown) < 0) {
            dy = -dy;
        }
        Touch.holdTime = (int)(System.currentTimeMillis() - this.ltimeStart);
        if (Touch.IDcurr == Touch.IDdown && (Touch.IDcurr != -1 || Touch.IDcurr == -1 && dx <= 1 && dy <= 1)) {
            this.currSlide.Click(Touch.IDcurr, x, y);
            Touch.IDprev = Touch.IDcurr;
        } else if (dx > 1 || dy > 1) {
            this.currSlide.touchUp(Touch.IDcurr, x, y, Touch.holdTime, Touch.xDown, Touch.yDown);
        }
        this.currSlide.touchUp(Touch.IDcurr, x, y);
    }

    public void onResize(int width, int height) {
        ScreenWidth = width;
        ScreenHeight = height;
        if (this.currSlide != null) {
            Touch.releaseTouchArea();
            this.currSlide.executeInnerSize();
            this.currSlide.onResize();
            Touch.releaseTouchArea();
            this.currSlide.registerTouch();
        }
    }

    public void paint(Graphics g) {
        if (this.isFrozen) {
            return;
        }
        this.currSlide.paint(g);
    }

    public void update() {
        if (this.isFrozen) {
            return;
        }
        KEY.update();
        this.currSlide.update();
    }

    static {
        isTouchable = false;
        isQwerty = false;
        ins = null;
    }

    public static interface VENDOR {
        public static final int UNKNOWN = 0;
        public static final int NOKIA = 1;
        public static final int SONY = 2;
        public static final int BLACKBERRY = 3;
        public static final int FPT = 4;
        public static final int MOTOROLA = 5;
        public static final int BENQ = 6;
        public static final int SAMSUNG = 7;
        public static final int F99 = 41;
    }
}

