/*
 * Decompiled with CFR 0.152.
 */
package Core;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class RGBFont {
    public int m_iFontHeight = 0;
    public int m_iFontColor = -16777216;
    public int m_iBorderColor = -1118482;
    public boolean m_hasBorder = false;
    private int m_iTotalChars = 0;
    private char[] m_aEnumChars = null;
    private int[] m_aiFontImageData = null;
    private byte[] m_bFontWidth = null;
    private byte[][] m_abFontPackData = null;
    private int m_iBitPerPixel = 1;
    private int m_iBitToShift = 0;
    private int m_iBitAND = 0;
    private int m_iBitToCheckBorder = 0;
    private int m_iScale = 0;

    public void destroy() {
    }

    public RGBFont(String strPackageName) {
        this.LoadFont(strPackageName);
    }

    public boolean LoadFont(String strPackageName) {
        if (strPackageName.charAt(0) != '/') {
            strPackageName = "/" + strPackageName;
        }
        try {
            InputStream packStream = "".getClass().getResourceAsStream(strPackageName);
            if (packStream == null) {
                return false;
            }
            int iCurrValue = 0;
            this.m_iTotalChars = packStream.read();
            if (this.m_iTotalChars == -1) {
                return false;
            }
            iCurrValue = packStream.read();
            if (iCurrValue == -1) {
                return false;
            }
            this.m_iTotalChars |= iCurrValue << 8;
            this.m_aEnumChars = new char[this.m_iTotalChars];
            this.m_bFontWidth = new byte[this.m_iTotalChars];
            this.m_abFontPackData = new byte[this.m_iTotalChars][];
            this.m_iFontHeight = packStream.read();
            if (this.m_iFontHeight == -1) {
                return false;
            }
            this.m_aiFontImageData = new int[this.m_iFontHeight * this.m_iFontHeight * 2];
            this.m_iBitPerPixel = packStream.read();
            this.m_iBitToShift = 4 - this.m_iBitPerPixel;
            if (this.m_iBitPerPixel == 1) {
                this.m_iBitAND = 7;
                this.m_iBitToCheckBorder = 1;
                this.m_iScale = 0;
            } else {
                this.m_iBitAND = 3;
                this.m_iBitToCheckBorder = 3;
                this.m_iScale = 1;
            }
            byte[] abUnicodeBuffer = new byte[2];
            int iDataSize = 0;
            for (int i = 0; i < this.m_iTotalChars; ++i) {
                iCurrValue = packStream.read(abUnicodeBuffer, 0, 2);
                if (iCurrValue == -1) {
                    return false;
                }
                this.m_aEnumChars[i] = (char)(abUnicodeBuffer[0] & 0xFF | (abUnicodeBuffer[1] & 0xFF) << 8);
                iCurrValue = packStream.read();
                if (iCurrValue == -1) {
                    return false;
                }
                this.m_bFontWidth[i] = (byte)iCurrValue;
                iDataSize = 1 + (this.m_bFontWidth[i] * this.m_iFontHeight >> this.m_iBitToShift);
                this.m_abFontPackData[i] = new byte[iDataSize];
                iCurrValue = packStream.read(this.m_abFontPackData[i], 0, iDataSize);
                if (iCurrValue != -1) continue;
                return false;
            }
            packStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void SetColor(int iNewColor) {
        this.m_iFontColor = iNewColor | 0xFF000000;
    }

    public void SetBorderColor(int iNewColor) {
        this.m_hasBorder = true;
        this.m_iBorderColor = iNewColor | 0xFF000000;
    }

    public void SetBorderHidden() {
        this.m_hasBorder = false;
    }

    public int GetColor() {
        return this.m_iFontColor;
    }

    public int DrawChar(Graphics g, char ch, int x, int y) {
        int iCharIndex = this.MapChar(ch);
        if (iCharIndex == -1) {
            return 0;
        }
        this.DecodeFont(iCharIndex, this.m_aiFontImageData);
        byte iCharWidth = this.m_bFontWidth[iCharIndex];
        g.drawRGB(this.m_aiFontImageData, 0, (int)iCharWidth, x, y, (int)iCharWidth, this.m_iFontHeight, true);
        return iCharWidth;
    }

    public int DrawCharPixel(Graphics g, char ch, int x, int y) {
        int iCharIndex = this.MapChar(ch);
        if (iCharIndex == -1) {
            return 0;
        }
        byte iCharWidth = this.m_bFontWidth[iCharIndex];
        int iCharSize = this.m_iFontHeight * iCharWidth;
        int iByteOfPixel = 0;
        int iBitIndex = 0;
        int iDrawingX = x;
        g.setColor(this.m_iFontColor);
        for (int i = 0; i < iCharSize; ++i) {
            iByteOfPixel = i >> this.m_iBitToShift;
            iBitIndex = (i & this.m_iBitAND) << this.m_iScale;
            if ((this.m_abFontPackData[iCharIndex][iByteOfPixel] >> iBitIndex & this.m_iBitToCheckBorder) == 1) {
                g.drawLine(iDrawingX, y, iDrawingX, y);
            } else if (this.m_hasBorder && (this.m_abFontPackData[iCharIndex][iByteOfPixel] >> iBitIndex & this.m_iBitToCheckBorder) == 2) {
                g.setColor(this.m_iBorderColor);
                g.drawLine(iDrawingX, y, iDrawingX, y);
                g.setColor(this.m_iFontColor);
            }
            if (++iDrawingX - x < iCharWidth) continue;
            iDrawingX = x;
            ++y;
        }
        return iCharWidth;
    }

    public int getHeight() {
        return this.m_iFontHeight;
    }

    public int GetCharWidth(char ch) {
        int iCharIndex = this.MapChar(ch);
        if (iCharIndex == -1) {
            return 0;
        }
        return this.m_bFontWidth[iCharIndex];
    }

    private int MapChar(char ch) {
        int iLeftIndex = 0;
        int iRightIndex = this.m_iTotalChars - 1;
        int iMiddleIndex = 0;
        while (iLeftIndex <= iRightIndex) {
            iMiddleIndex = iLeftIndex + iRightIndex >> 1;
            if (this.m_aEnumChars[iMiddleIndex] == ch) {
                return iMiddleIndex;
            }
            if (this.m_aEnumChars[iMiddleIndex] < ch) {
                iLeftIndex = iMiddleIndex + 1;
                continue;
            }
            iRightIndex = iMiddleIndex - 1;
        }
        return -1;
    }

    private void DecodeFont(int iCharID, int[] aiRGB) {
        int iCharSize = this.m_iFontHeight * this.m_bFontWidth[iCharID];
        int iByteOfPixel = 0;
        int iBitIndex = 0;
        if (aiRGB == null) {
            aiRGB = new int[iCharSize];
        }
        for (int i = 0; i < iCharSize; ++i) {
            iByteOfPixel = i >> this.m_iBitToShift;
            iBitIndex = (i & this.m_iBitAND) << this.m_iScale;
            aiRGB[i] = (this.m_abFontPackData[iCharID][iByteOfPixel] >> iBitIndex & this.m_iBitToCheckBorder) == 1 ? this.m_iFontColor | 0xF000000 : (this.m_hasBorder && (this.m_abFontPackData[iCharID][iByteOfPixel] >> iBitIndex & this.m_iBitToCheckBorder) == 2 ? this.m_iBorderColor | 0xF000000 : 0);
        }
    }

    public void drawString(Graphics g, String st, int x, int y, int align, int color) {
        if (st == null || st.length() == 0) {
            return;
        }
        if (align == 1) {
            x -= this.stringWidth(st);
        } else if (align == 2) {
            x -= this.stringWidth(st) >> 1;
        }
        this.SetColor(color);
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            char ch = c;
            this.DrawChar(g, ch, x, y);
            x += this.GetCharWidth(ch);
            if (ch != ' ') continue;
            x += 3;
        }
    }

    public void drawString(Graphics g, String string, int startX, int startY, int width, int align, int color) {
        this.SetColor(0xFFFFFF);
        String[] stringArray = this.splitStrInLine(string, width);
        int x = startX;
        int y = startY;
        for (int k = 0; k < stringArray.length; ++k) {
            this.SetColor(0xFFFFFF);
            if (k % 2 == 0) {
                this.SetColor(0xFF0000);
            }
            for (int i = 0; i < stringArray[k].length(); ++i) {
                char c = stringArray[k].charAt(i);
                char ch = c;
                this.DrawChar(g, ch, x, y);
                x = x + this.GetCharWidth(ch) + 1;
                if (ch != ' ') continue;
                x += 3;
            }
            x = startX;
            y += 13;
        }
    }

    public int stringWidth(String st) {
        int len = 0;
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            char ch = c;
            len += this.GetCharWidth(ch);
            if (ch != ' ') continue;
            len += 3;
        }
        return len;
    }

    public String stringFix(String st, int width) {
        int i = this.stringPosFix(st, width);
        if (i == 0) {
            return "0";
        }
        return (i < st.length() ? "1" : "0") + st.substring(0, i);
    }

    public String stringFixEtc(String st, int width) {
        int i = this.stringPosFix(st, width);
        if (i == 0) {
            return "";
        }
        return i < st.length() ? (i > 3 ? st.substring(0, i - 3) + "..." : st.substring(0, i)) : st;
    }

    public int stringPosFix(String st, int width) {
        int i;
        int len = 0;
        for (i = 0; i < st.length() && len < width; ++i) {
            char c = st.charAt(i);
            len += this.GetCharWidth(c);
            if (c != ' ') continue;
            len += 3;
        }
        return i;
    }

    public String[] splitStrInLine(String src, int lineWidth) {
        if (src == null || src.length() == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        int srclen = src.length();
        String tem = "";
        int start = 0;
        int end = 0;
        while (true) {
            if (this.stringWidth(tem) < lineWidth && src.charAt(end) != '\n') {
                tem = tem + src.charAt(end);
                if (++end != srclen) continue;
            }
            if (end < srclen && src.charAt(end) != ' ' && src.charAt(end) != '\n') {
                int endAnyway = end;
                while (end != start && (src.charAt(end - 1) == ' ' || src.charAt(end) != ' ')) {
                    --end;
                }
                if (end == start) {
                    end = endAnyway;
                }
            }
            list.addElement(src.substring(start, end));
            if (end == srclen) break;
            for (start = end + 1; start < srclen && src.charAt(start) == ' '; ++start) {
            }
            if (start == srclen) break;
            end = start;
            tem = "";
        }
        String[] strs = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            strs[i] = (String)list.elementAt(i);
        }
        return strs;
    }
}

