/*
 * Decompiled with CFR 0.152.
 */
package Core;

import Core.Event;
import Core.Touch;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScrollMe {
    private int GAP_MOVE = 50;
    private int SPEED_FA = 3;
    private int SPEED_Fx = 1 << this.SPEED_FA;
    public int HLOADING = 30;
    public int viewW = 0;
    public int viewH = 0;
    public boolean isAsList = false;
    public boolean isActive = false;
    public boolean isLoading = false;
    private int cmx = 0;
    private int cmy = 0;
    private int viewX = 0;
    private int viewY = 0;
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;
    private int xstart = 0;
    private int ystart = 0;
    private Event e = null;
    private Image currImg = null;
    private boolean isFixHor = false;
    private boolean isFixVer = false;

    public int getCmy() {
        return this.cmy;
    }

    public ScrollMe(Image img, int speed) {
        this(img.getWidth(), img.getHeight(), speed);
        this.currImg = img;
    }

    public ScrollMe(int width, int height, int speed) {
        this.viewW = width;
        this.viewH = height;
        this.SPEED_FA = speed > 0 ? speed : 3;
        this.SPEED_Fx = 1 << this.SPEED_FA;
    }

    public void setList(Event endOfList) {
        this.isAsList = true;
        this.e = endOfList;
    }

    public void setViewer(int left, int top, int width, int height) {
        if (width <= 0) {
            width = this.w;
        }
        if (height <= 0) {
            height = this.h;
        }
        if (this.viewW <= width) {
            this.viewX = this.cmx = width - this.viewW >> 1;
        } else if (this.w != 0) {
            this.w = width;
            this.fixX(0);
        }
        if (this.viewH <= height) {
            this.cmy = this.isAsList ? 0 : height - this.viewH >> 1;
            this.viewY = this.cmy;
        } else if (this.h != 0) {
            this.h = height;
            this.fixY(0);
        }
        this.isFixHor = this.viewW <= width;
        this.isFixVer = !this.isAsList && this.viewH <= height;
        this.x = left;
        this.y = top;
        this.w = width;
        this.h = height;
    }

    public void getTo(int x, int y) {
        this._goTo(x, y);
        this.cmx = this.viewX;
        this.cmy = this.viewY;
    }

    public void goTo(int x, int y) {
        x = (x -= this.w >> 1) <= 0 ? 0 : -x;
        y = (y -= this.h >> 1) <= 0 ? 0 : -y;
        this._goTo(x, y);
    }

    private void _goTo(int x, int y) {
        if (!this.isFixHor) {
            this.fixX(-this.viewX + x);
        } else {
            this.viewX = this.w - this.viewW >> 1;
        }
        if (!this.isFixVer) {
            this.fixY(-this.viewY + y);
        } else {
            this.viewY = this.isAsList ? 0 : this.h - this.viewH >> 1;
        }
    }

    public void select(int Y, int H) {
        if (this.viewH > this.h) {
            int heiU = -this.viewY - Y;
            if (heiU > 0) {
                this.viewY += heiU;
            } else {
                int heiD = Y + H - (this.h - this.viewY);
                if (heiD > 0) {
                    this.viewY -= heiD;
                }
            }
        }
        if (!this.isLoading && this.e != null && Y + H >= this.viewH) {
            this.e.action();
        }
    }

    public void scrollLeft() {
        if (this.isFixHor) {
            return;
        }
        this.fixX(this.GAP_MOVE);
    }

    public void scrollRight() {
        if (this.isFixHor) {
            return;
        }
        this.fixX(-this.GAP_MOVE);
    }

    public void scrollUp() {
        if (this.isFixVer) {
            return;
        }
        this.fixY(this.GAP_MOVE);
    }

    public void scrollDown() {
        if (this.isFixVer) {
            return;
        }
        this.fixY(-this.GAP_MOVE);
    }

    public void update() {
        if (Touch.isPressed) {
            return;
        }
        if (!this.isFixHor) {
            if (this.cmx < this.viewX) {
                this.cmx += this.viewX - this.cmx + this.SPEED_Fx >> this.SPEED_FA;
            } else if (this.cmx > this.viewX) {
                this.cmx -= this.cmx - this.viewX + this.SPEED_Fx >> this.SPEED_FA;
            }
        }
        if (!this.isFixVer) {
            if (this.cmy < this.viewY) {
                this.cmy += this.viewY - this.cmy + this.SPEED_Fx >> this.SPEED_FA;
            } else if (this.cmy > this.viewY) {
                this.cmy -= this.cmy - this.viewY + this.SPEED_Fx >> this.SPEED_FA;
            }
        }
    }

    public int getX() {
        return this.cmx + this.x;
    }

    public int getY() {
        return this.cmy + this.y;
    }

    public void setY(int yR) {
        this.viewY = yR - this.y;
        this.fixY(0);
        this.cmy = this.viewY;
    }

    public int gotYin(int yReal) {
        return yReal - (this.cmy + this.y);
    }

    public int getTop() {
        return this.y;
    }

    public void destroy() {
        this.e = null;
        this.currImg = null;
    }

    public void moveStart(int x, int y) {
        boolean bl = this.isActive = this.isFixHor && this.isFixVer || x >= this.x && x <= this.x + this.w && y >= this.y && y <= this.y + this.h;
        if (!this.isActive) {
            return;
        }
        this.xstart = x;
        this.ystart = y;
        if (this.isAsList && (this.cmy > 0 || this.cmy < -(this.viewH - this.h))) {
            return;
        }
        this.viewX = this.cmx;
        this.viewY = this.cmy;
    }

    public void moveFinish(int ID, int x, int y, int dragTime, int xBegin, int yBegin) {
        if (!this.isActive) {
            return;
        }
        int dx = x - xBegin;
        int dy = y - yBegin;
        if (dragTime > 0 && dragTime < 250 && (Math.abs(dx) > 1 || Math.abs(dy) > 1)) {
            if (!this.isFixHor) {
                this.fixX((x - xBegin) * (500 / dragTime));
            }
            if (!this.isFixVer) {
                this.fixY((y - yBegin) * (500 / dragTime));
            }
        }
    }

    public void move(int x, int y) {
        if (!this.isActive) {
            return;
        }
        if (!this.isFixHor) {
            this.fixX(x - this.xstart);
            this.cmx = this.viewX;
        }
        if (!this.isFixVer) {
            if (this.isAsList) {
                this.cmy += y - this.ystart;
                this.fixY(this.cmy - this.viewY);
            } else {
                this.fixY(y - this.ystart);
                this.cmy = this.viewY;
            }
        }
        this.xstart = x;
        this.ystart = y;
    }

    private void fixY(int value) {
        int yy = this.viewY + value;
        if (yy > 0) {
            this.viewY = 0;
        } else if (yy < -(this.viewH - this.h)) {
            this.viewY = -(this.viewH - this.h);
            if (this.isAsList) {
                if (this.viewY > 0) {
                    this.viewY = 0;
                }
                if (!this.isLoading && this.e != null && this.viewH > 0) {
                    this.e.action();
                }
            }
        } else {
            this.viewY = yy;
        }
    }

    private void fixX(int value) {
        int xx = this.viewX + value;
        if (xx > 0) {
            xx = 0;
        } else if (xx < -(this.viewW - this.w)) {
            xx = -(this.viewW - this.w);
        }
        this.viewX = xx;
    }

    public boolean isInner(int yReal, int hTest) {
        return yReal + hTest > this.y && yReal < this.y + this.h;
    }

    public void showLoading() {
        this.isLoading = true;
        if (this.viewH > this.h && this.viewY <= -(this.viewH - this.h)) {
            this.viewY -= this.HLOADING;
        }
        this.viewH += this.HLOADING;
    }

    public void hideLoading() {
        this.isLoading = false;
        if (this.viewH > this.h && this.viewY <= -(this.viewH - this.h)) {
            this.viewY += this.HLOADING;
        }
        this.viewH -= this.HLOADING;
    }

    public void setClip(Graphics g) {
        g.setClip(this.x, this.y, this.w, this.h);
    }

    public void setClip(Graphics g, int xf, int yf, int wf, int hf) {
        int xnew = this.x < xf ? xf : this.x;
        int ynew = this.y < yf ? yf : this.y;
        g.setClip(xnew, ynew, this.x + this.w < xf + wf ? this.x + this.w - xf : xf + wf - xnew, this.y + this.h < yf + hf ? this.y + this.h - yf : yf + hf - ynew);
    }

    public void drawMap(Graphics g) {
        g.setClip(this.x, this.y, this.w, this.h);
        g.drawImage(this.currImg, this.cmx + this.x, this.cmy + this.y, 20);
    }

    public void drawDebug(Graphics g) {
        g.setColor(0xFF0000);
        g.drawRect(this.x, this.y, this.w - 1, this.h - 1);
        g.setColor(255);
        g.drawRect(this.getX(), this.getY(), this.viewW - 1, this.viewH - 1);
    }
}

