/*
 * Decompiled with CFR 0.152.
 */
package CoreGame;

import CoreGame.STATE;
import GamePages.ChoiceLevel;
import GamePages.Demo;
import GamePages.GamePlay;
import GamePages.GioiThieu;
import GamePages.HighScore;
import GamePages.InEndGame;
import GamePages.InPause;
import GamePages.MainMenu;
import GamePages.Page;
import GamePages.SaveScore;
import GamePages.Shop;
import GamePages.SplashScreen;
import IGP_Page.IGP;

public class GameMain {
    public static GameMain instance = null;
    public Page currenPage;

    public static GameMain getInstance() {
        if (instance == null) {
            instance = new GameMain();
        }
        return instance;
    }

    public void changePrePage() {
        try {
            STATE.currentState = this.currenPage.prePage.state;
            Page tmp_page = this.currenPage;
            this.currenPage = this.currenPage.prePage;
            this.currenPage.init();
            this.currenPage.sizeChanged();
            tmp_page.destroy();
            tmp_page = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changeSubPage(int state, boolean isInitPrePage) {
        try {
            Page tmp_page = this.currenPage;
            int tmp_state = this.currenPage.state;
            this.changePage(state);
            this.currenPage.prePage = tmp_page;
            this.currenPage.prePage.state = tmp_state;
            if (isInitPrePage) {
                this.currenPage.initBgPrePage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changePage(int state) {
        try {
            STATE.currentState = state;
            switch (state) {
                case 1: {
                    this.currenPage = new SplashScreen();
                    break;
                }
                case 2: {
                    this.currenPage = new MainMenu();
                    break;
                }
                case 3: {
                    this.currenPage = new GioiThieu();
                    break;
                }
                case 4: {
                    this.currenPage = new ChoiceLevel();
                    break;
                }
                case 5: {
                    this.currenPage = new GamePlay();
                    break;
                }
                case 6: {
                    this.currenPage = new IGP();
                    break;
                }
                case 7: {
                    this.currenPage = new InPause();
                    break;
                }
                case 9: {
                    this.currenPage = new SaveScore();
                    break;
                }
                case 8: {
                    this.currenPage = new InEndGame();
                    break;
                }
                case 10: {
                    this.currenPage = new HighScore();
                    break;
                }
                case 11: {
                    this.currenPage = new Demo();
                    break;
                }
                case 12: {
                    this.currenPage = new Shop();
                }
            }
            if (this.currenPage != null) {
                this.currenPage.state = STATE.currentState;
            }
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

