/*
 * Decompiled with CFR 0.152.
 */
package GamePages;

import CoreGame.Action;
import CoreGame.Command;
import CoreGame.Control;
import CoreGame.GUIManager;
import CoreGame.GameMain;
import GamePages.Loading;
import GamePages.Page;
import Util.Data;
import Util.IconToolBar;
import Util.StaticObj;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HighScore
extends Page {
    public Image imgbg;
    public Image imgNamePage;
    public Image imgKhung;
    public Vector topName;
    public Vector topScore;
    public int maxList = 5;
    public int xInfo;
    public int yInfo;
    public int wInfo;
    public int hInfo;
    public int dy;
    public int Command_Unknown = 0;
    public int Command_ChangePage_MainMenu = 1;
    public int Command = this.Command_Unknown;

    public HighScore() {
        this.init();
    }

    public void init() {
        super.init();
        this.wInfo = this.imgKhung.getWidth();
        this.hInfo = this.imgKhung.getHeight();
        this.dy = 5;
        this.xInfo = GUIManager.WIDTH >> 1;
        this.yInfo = GUIManager.HEIGHT / 2 - ((this.hInfo + this.dy) * this.maxList - this.dy) / 2;
        this.topName = new Vector();
        this.topScore = new Vector();
        for (int i = 0; i < Data.top_names.length; ++i) {
            if (Data.top_names[i].equals("")) continue;
            String _tmp_name = StaticObj.cutString(StaticObj.bmf_bold, Data.top_names[i], this.wInfo / 2 - 15);
            this.topName.addElement(_tmp_name);
            String _tmp_score = StaticObj.cutString(StaticObj.bmf_bold, "" + (int)Data.top_scores[i], this.wInfo / 2 - 15);
            this.topScore.addElement(_tmp_score);
        }
    }

    public void loadImg() {
        try {
            this.imgNamePage = Image.createImage((String)"/menu/nameHighScore.png");
            this.imgKhung = Image.createImage((String)"/menu/HighScoreToolBar.png");
            Image tmp = Image.createImage((String)"/menu/bgMainMenu.png");
            this.imgbg = Image.createImage((int)GUIManager.WIDTH, (int)GUIManager.HEIGHT);
            Graphics gg = this.imgbg.getGraphics();
            gg.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
            gg.setColor(0);
            gg.fillRect(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
            Image[] imgbgBonus = new Image[]{Image.createImage((String)"/menu/bgMainMenu_bonus_0.png"), Image.createImage((String)"/menu/bgMainMenu_bonus_1.png")};
            int size = GUIManager.WIDTH / imgbgBonus[1].getWidth();
            for (int i = 0; i < size; ++i) {
                gg.drawImage(imgbgBonus[1], i * imgbgBonus[1].getWidth(), 0, 20);
            }
            gg.drawImage(imgbgBonus[0], 0, 0, 20);
            gg.drawImage(tmp, GUIManager.WIDTH, 0, 24);
            tmp = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sizeChanged() {
    }

    public void initCommand() {
        Control.leftSoftKey = new Command("", IconToolBar.imgIcon[IconToolBar.BACK + IconToolBar.distance], GUIManager.Style_Screen, new Action(){

            public void perform() {
                if (HighScore.this.Command == HighScore.this.Command_Unknown) {
                    Loading.getInstance().showChangePage();
                    HighScore.this.Command = HighScore.this.Command_ChangePage_MainMenu;
                }
            }
        });
        Control.leftSoftKey.RegisTouch(-1, -1, -1, -1);
    }

    public void update() {
        if (Loading.Ins != null && Loading.getInstance().isLoad && this.Command == this.Command_ChangePage_MainMenu) {
            GameMain.getInstance().changePage(2);
            this.Command = this.Command_Unknown;
        }
    }

    public void updateKeyPressed(boolean[] keypressed, boolean[] keyHold, int currencurrentAscii) {
        if (!Control.updateKey()) {
            // empty if block
        }
    }

    public void pointerPressed(int x, int y) {
        if (!Control.pointPressed(x, y)) {
            // empty if block
        }
    }

    public void pointerRelease(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void paintBackground(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
        g.drawImage(this.imgbg, GUIManager.WIDTH, 0, 24);
        g.drawImage(this.imgNamePage, GUIManager.WIDTH >> 1, 5, 17);
    }

    public void paintMain(Graphics g) {
        int i;
        for (i = 0; i < this.maxList; ++i) {
            g.drawImage(this.imgKhung, this.xInfo, this.yInfo + i * (this.hInfo + this.dy), 17);
        }
        for (i = 0; i < this.topName.size(); ++i) {
            StaticObj.drawStringBold(g, " - ", this.xInfo, this.yInfo + i * (this.hInfo + this.dy) + 5, 2, 26316, 0xFFFFFF);
            StaticObj.drawStringBold(g, (String)this.topName.elementAt(i), this.xInfo - this.wInfo / 2 + 5, this.yInfo + i * (this.hInfo + this.dy) + 5, 0, 26316, 0xFFFFFF);
            StaticObj.drawStringBold(g, (String)this.topScore.elementAt(i), this.xInfo + this.wInfo / 2 - 5, this.yInfo + i * (this.hInfo + this.dy) + 5, 1, 26316, 0xFFFFFF);
        }
        Control.paintCommand(g);
    }

    public void destroy() {
        this.imgKhung = null;
        this.imgNamePage = null;
        this.imgbg = null;
        this.topName.removeAllElements();
        this.topName = null;
        this.topScore.removeAllElements();
        this.topScore = null;
    }
}

