/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.StaticObj;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class CSound {
    public static final byte LOOP_FOREVER = -1;
    private Player p;
    private String u;
    private short l;
    private byte v;

    public CSound(String path, int loop, int volume) {
        this.u = path;
        short s = this.l = (short)(loop < -1 ? -1 : (short)loop);
        this.v = (byte)(volume < 0 ? 0 : (byte)(volume > 100 ? 100 : (byte)volume));
    }

    public CSound(String path, int loop, int volume, boolean load) {
        this(path, loop, volume);
        if (load) {
            this.load();
        }
    }

    public final void play() {
        if (this.p == null) {
            this.load();
        }
        try {
            this.p.start();
        }
        catch (MediaException e) {
            StaticObj.PrintOut("Loi play am thanh!");
        }
    }

    public final void load() {
        if (this.p != null) {
            this.stop();
        }
        try {
            InputStream in = this.getClass().getResourceAsStream(this.u);
            String sEx = this.u.substring(this.u.lastIndexOf(46) + 1, this.u.length());
            String sTypeSound = "";
            if (sEx.equals("wav")) {
                sTypeSound = "audio/X-wav";
            } else if (sEx.equals("mp3")) {
                sTypeSound = "audio/mpeg";
            } else if (sEx.equals("mid")) {
                sTypeSound = "audio/midi";
            }
            this.p = Manager.createPlayer((InputStream)in, (String)sTypeSound);
            if (this.p.getState() != 200) {
                this.p.realize();
            }
            if (this.p.getState() != 300) {
                this.p.prefetch();
            }
            VolumeControl volume = (VolumeControl)this.p.getControl("VolumeControl");
            volume.setLevel((int)this.v);
            this.p.setLoopCount((int)this.l);
        }
        catch (Exception e) {
            StaticObj.PrintOut("Loi load am thanh!");
        }
    }

    public final void stop() {
        try {
            if (this.p != null) {
                this.p.stop();
                this.p.close();
                this.p = null;
                System.gc();
            }
        }
        catch (Exception e) {
            StaticObj.PrintOut("Loi stop am thanh!");
        }
    }

    public final void destroy() {
        this.stop();
        this.u = null;
    }
}

