/*
 * Decompiled with CFR 0.152.
 */
package Util;

import CoreGame.GUIManager;
import Util.StaticObj;
import Util.SystemFont;
import Util.VirtualKEY;
import javax.microedition.lcdui.Graphics;

public class TextField {
    public int x;
    public int y;
    public boolean isFocus;
    public int height;
    public int width;
    public int holdKey = 0;
    private static final int[] MAX_TIME_TO_CONFIRM_KEY = new int[]{12, 12, 12, 12, 12, 12, 12};
    private static final int CARET_HEIGHT = 16;
    private static final int CARET_WIDTH = 1;
    private static final int CARET_SHOWING_TIME = 3;
    private static final int TEXT_GAP_X = 3;
    private static final int MAX_SHOW_CARET_COUNER = 10;
    public static final int INPUT_TYPE_ANY = 0;
    public static final int INPUT_TYPE_NUMERIC = 1;
    public static final int INPUT_TYPE_PASSWORD = 2;
    public boolean isGame;
    public static final String[] modeNotify = new String[]{"abc", "Abc", "ABC", "123"};
    private static String[] print = new String[]{" 0", ".,?!_1\"/@$-():*+<=>;%&~#%^&*{}[];'/1", "abc2", "def3", "ghi4", "jkl5", "mno6", "pqrs7", "tuv8", "wxyz9", "*", "#"};
    public static final int NOKIA = 0;
    public static final int MOTO = 1;
    public static final int ORTHER = 2;
    public static final int FPT = 3;
    private static int vendorDevice = 2;
    private String text = "";
    private String passwordText = "";
    private String paintedText = "";
    public int caretPos = 0;
    private int counter = 0;
    private int maxTextLenght = 255;
    private int offsetX = 0;
    private int lastKey = -1983;
    private int keyInActiveState = 0;
    private int indexOfActiveChar = 0;
    private int showCaretCounter = 10;
    public static int inputType = 0;
    public static int changeModeKey = 11;
    public static int mode = 0;
    public boolean changTextBox = true;
    public static boolean isqwerty;
    public boolean isMove = true;
    int typeXpeed = 0;
    int typingModeAreaWidth = 0;

    private void init() {
        this.height = 20;
    }

    public TextField(int x, int y, int h, int w, boolean focus) {
        this.x = x;
        this.y = y;
        this.height = h;
        this.width = w;
        this.isFocus = focus;
        TextField.setVendorTypeMode(GUIManager.vendorDevice);
    }

    public void setBound(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int[] getPosition() {
        int[] temp = new int[]{this.x, this.y};
        return temp;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static void setVendorTypeMode(int mode) {
        if (mode == 2) {
            TextField.print[0] = "0";
            TextField.print[10] = " *";
            TextField.print[11] = "#";
            changeModeKey = 35;
        } else if (mode == 0) {
            TextField.print[0] = " 0";
            TextField.print[10] = "*";
            TextField.print[11] = "#";
            changeModeKey = 35;
        } else {
            TextField.print[0] = "0";
            TextField.print[10] = "*";
            TextField.print[11] = " #";
            changeModeKey = 42;
        }
        vendorDevice = mode;
    }

    public void updateTouch(int x, int y) {
        if (this.paintedText == null) {
            return;
        }
        if (x < this.x || x > this.x + this.width || y < this.y || y > this.y + this.height) {
            return;
        }
        int wT = x - this.x - 3 - this.offsetX;
        int i = StaticObj.bmf_normal.stringPosFix(this.paintedText, wT);
        this.caretPos = i < 0 ? 0 : (i >= this.paintedText.length() ? this.paintedText.length() : i);
        this.setOffset();
    }

    public TextField() {
        this.text = "";
        this.init();
    }

    public TextField(String text, int maxLen, int _inputType) {
        this.text = text;
        this.maxTextLenght = maxLen;
        inputType = _inputType;
        if (inputType == 1) {
            mode = 3;
        }
        this.setPasswordTest();
        this.init();
        this.setOffset();
        this.caretPos = text.length();
    }

    public void clear() {
        if (this.caretPos > 0 && this.text.length() > 0) {
            this.text = this.text.substring(0, this.caretPos - 1) + this.text.substring(this.caretPos, this.text.length());
            --this.caretPos;
            this.setOffset();
            this.setPasswordTest();
            this.holdKey = 0;
        }
    }

    public void setOffset() {
        this.paintedText = inputType == 2 ? this.passwordText : this.text;
        if (this.offsetX < 0 && SystemFont.getWidth(this.paintedText) + this.offsetX < this.width - 3 - 3) {
            this.offsetX = this.width - SystemFont.getWidth(this.paintedText);
        }
        if (this.offsetX + SystemFont.getWidth(this.paintedText.substring(0, this.caretPos)) <= 0) {
            this.offsetX = -SystemFont.getWidth(this.paintedText.substring(0, this.caretPos));
            this.offsetX += 40;
        } else if (this.offsetX + SystemFont.getWidth(this.paintedText.substring(0, this.caretPos)) >= this.width - SystemFont.getWidth(modeNotify[mode]) - 2) {
            this.offsetX = this.width - 2 - SystemFont.getWidth(modeNotify[mode]) - SystemFont.getWidth(this.paintedText.substring(0, this.caretPos)) - 6;
        }
        if (this.offsetX > 0) {
            this.offsetX = 0;
        }
    }

    private void keyPressedAscii(int keyCode) {
        if (this.text.length() < this.maxTextLenght) {
            if (keyCode == 35) {
                return;
            }
            String ttext = this.text.substring(0, this.caretPos) + (char)keyCode;
            if (this.caretPos < this.text.length()) {
                ttext = ttext + this.text.substring(this.caretPos, this.text.length());
            }
            this.text = ttext;
            ++this.caretPos;
            this.setPasswordTest();
            this.setOffset();
        }
    }

    private void keyPressedAny(int keyCode) {
        if (keyCode == this.lastKey) {
            this.indexOfActiveChar = (this.indexOfActiveChar + 1) % print[keyCode - 48].length();
            char c = print[keyCode - 48].charAt(this.indexOfActiveChar);
            c = mode == 0 ? Character.toLowerCase(c) : (mode == 1 ? Character.toUpperCase(c) : (mode == 2 ? Character.toUpperCase(c) : print[keyCode - 48].charAt(print[keyCode - 48].length() - 1)));
            String ttext = this.text.substring(0, this.caretPos - 1) + c;
            if (this.caretPos < this.text.length()) {
                ttext = ttext + this.text.substring(this.caretPos, this.text.length());
            }
            this.text = ttext;
            this.keyInActiveState = MAX_TIME_TO_CONFIRM_KEY[this.typeXpeed];
            this.setPasswordTest();
        } else if (this.text.length() < this.maxTextLenght) {
            if (mode == 1 && this.lastKey != -1984) {
                mode = 0;
            }
            this.indexOfActiveChar = 0;
            char c = print[keyCode - 48].charAt(this.indexOfActiveChar);
            c = mode == 0 ? Character.toLowerCase(c) : (mode == 1 ? Character.toUpperCase(c) : (mode == 2 ? Character.toUpperCase(c) : print[keyCode - 48].charAt(print[keyCode - 48].length() - 1)));
            String ttext = this.text.substring(0, this.caretPos) + c;
            if (this.caretPos < this.text.length()) {
                ttext = ttext + this.text.substring(this.caretPos, this.text.length());
            }
            this.text = ttext;
            this.keyInActiveState = MAX_TIME_TO_CONFIRM_KEY[this.typeXpeed];
            ++this.caretPos;
            this.setPasswordTest();
            this.setOffset();
        }
        this.lastKey = keyCode;
    }

    public boolean updateKeyPressed(int keyCode) {
        try {
            StaticObj.PrintOut("" + keyCode);
            this.holdKey = 0;
            if (keyCode >= 65 && keyCode <= 122 && !VirtualKEY.isVSendKey && !VirtualKEY.isVirtualKeyBoard) {
                isqwerty = true;
                this.typingModeAreaWidth = 0;
            }
            if (isqwerty || VirtualKEY.isVSendKey && VirtualKEY.style == 1) {
                if (!VirtualKEY.isVSendKey && keyCode == 45) {
                    if (keyCode == this.lastKey && this.keyInActiveState < MAX_TIME_TO_CONFIRM_KEY[this.typeXpeed]) {
                        this.paintedText = this.text = this.text.substring(0, this.caretPos - 1) + '_';
                        this.setPasswordTest();
                        this.setOffset();
                        this.lastKey = -1984;
                        return false;
                    }
                    this.lastKey = 45;
                }
                VirtualKEY.isVSendKey = false;
                if (keyCode >= 32) {
                    if (inputType == 1) {
                        if (vendorDevice == 3) {
                            switch (keyCode) {
                                case 87: 
                                case 119: {
                                    keyCode = 49;
                                    break;
                                }
                                case 69: 
                                case 101: {
                                    keyCode = 50;
                                    break;
                                }
                                case 82: 
                                case 114: {
                                    keyCode = 51;
                                    break;
                                }
                                case 83: 
                                case 115: {
                                    keyCode = 52;
                                    break;
                                }
                                case 68: 
                                case 100: {
                                    keyCode = 53;
                                    break;
                                }
                                case 70: 
                                case 102: {
                                    keyCode = 54;
                                    break;
                                }
                                case 90: 
                                case 122: {
                                    keyCode = 55;
                                    break;
                                }
                                case 88: 
                                case 120: {
                                    keyCode = 56;
                                    break;
                                }
                                case 67: 
                                case 99: {
                                    keyCode = 57;
                                }
                            }
                        }
                        if (keyCode >= 48 && keyCode <= 57) {
                            this.keyPressedAscii(keyCode);
                        }
                        return false;
                    }
                    if (inputType == 2) {
                        this.keyInActiveState = MAX_TIME_TO_CONFIRM_KEY[this.typeXpeed];
                    }
                    this.keyPressedAscii(keyCode);
                    return false;
                }
            }
            if (keyCode == changeModeKey) {
                if (++mode > 3) {
                    mode = 0;
                }
                if (inputType == 1) {
                    mode = 3;
                }
                this.keyInActiveState = 1;
                this.lastKey = keyCode;
                return false;
            }
            if (keyCode == 42) {
                keyCode = 58;
            }
            if (keyCode == 35) {
                return false;
            }
            if (keyCode == 32) {
                this.keyPressedAscii(keyCode);
                return false;
            }
            if (keyCode >= 48 && keyCode <= 59) {
                if (inputType == 0 || inputType == 2) {
                    this.keyPressedAny(keyCode);
                } else if (inputType == 1) {
                    this.keyPressedAscii(keyCode);
                    this.keyInActiveState = 1;
                }
            } else {
                this.indexOfActiveChar = 0;
                this.lastKey = -1984;
                if (keyCode == 14) {
                    if (this.caretPos > 0) {
                        --this.caretPos;
                        this.setOffset();
                        this.showCaretCounter = 10;
                        return false;
                    }
                } else if (keyCode == 15) {
                    if (this.caretPos < this.text.length()) {
                        ++this.caretPos;
                        this.setOffset();
                        this.showCaretCounter = 10;
                        return false;
                    }
                } else {
                    if (keyCode == 19) {
                        this.clear();
                        return false;
                    }
                    this.lastKey = keyCode;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void changeMode(int _m) {
        mode = _m;
        if (inputType == 1) {
            mode = 3;
        }
    }

    public void paint(Graphics g) {
        this.update();
        this.paintedText = inputType == 2 ? this.passwordText : this.text;
        g.setColor(0);
        g.fillRect(this.x, this.y, this.width, this.height);
        g.setColor(0xFFFFFF);
        SystemFont.drawString(g, modeNotify[mode], this.x + this.width - 1, this.y + 2, 2);
        g.setColor(0xFFFFFF);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.setClip(this.x, this.y > StaticObj.HIGHT_TEXT_FIELD + 1 ? this.y : StaticObj.HIGHT_TEXT_FIELD + 1, this.width - SystemFont.getWidth(modeNotify[mode]) - 3, this.height);
        g.setColor(0xFFFFFF);
        if (this.paintedText == null) {
            this.paintedText = "";
        }
        SystemFont.drawString(g, this.paintedText, 3 + this.offsetX + this.x, this.y + (this.height - SystemFont.getHeight()) / 2, 0);
        if (this.keyInActiveState > 0 || this.showCaretCounter > 0 || this.counter / 3 % 2 == 0) {
            g.setColor(255);
            g.fillRect(3 + this.offsetX + this.x + SystemFont.getWidth(this.paintedText.substring(0, this.caretPos)) - 1, this.y + (this.height - 16) / 2, 1, 16);
        }
        g.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
    }

    public void keyHold(int keyCode) {
        ++this.holdKey;
        if (keyCode == 19 || keyCode == 18) {
            if (this.holdKey % 21 == 16) {
                // empty if block
            }
        } else if ((keyCode == 15 || keyCode == 14) && this.holdKey % 4 == 0) {
            this.updateKeyPressed(keyCode);
        }
    }

    private void setPasswordTest() {
        if (inputType == 2) {
            this.passwordText = "";
            for (int i = 0; i < this.text.length(); ++i) {
                this.passwordText = this.passwordText + "*";
            }
            if (this.keyInActiveState > 0 && this.caretPos > 0) {
                this.passwordText = this.passwordText.substring(0, this.caretPos - 1) + this.text.charAt(this.caretPos - 1) + this.passwordText.substring(this.caretPos, this.passwordText.length());
            }
        }
    }

    public void update() {
        ++this.counter;
        if (this.keyInActiveState > 0) {
            --this.keyInActiveState;
            if (this.keyInActiveState == 0) {
                this.indexOfActiveChar = 0;
                this.lastKey = -1983;
                this.setPasswordTest();
            }
        }
        if (this.showCaretCounter > 0) {
            --this.showCaretCounter;
        }
    }

    public void clearText() {
        this.text = "";
        this.caretPos = 0;
    }

    public String getText() {
        String txtTemp = this.text;
        return txtTemp;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getMaxTextLenght() {
        return this.maxTextLenght;
    }

    public void setMaxTextLenght(int maxTextLenght) {
        this.maxTextLenght = maxTextLenght;
    }

    public int getIputType() {
        return inputType;
    }

    public void setIputType(int iputType) {
        inputType = iputType;
    }

    public int getHeight() {
        return StaticObj.HIGHT_TEXT_FIELD;
    }

    public void paintFocus(Graphics g) {
    }
}

