/*
 * Decompiled with CFR 0.152.
 */
package GMain;

import Core.GLives;
import CoreGame.Control;
import CoreGame.GUIManager;
import CoreGame.GameMain;
import CoreGame.STATE;
import CoreOniline.OnlineManager;
import CoreOniline.Socket;
import GamePages.Loading;
import IGP_Page.IGP;
import Util.DEBUG;
import Util.Database;
import Util.StaticObj;
import Util.staticImage;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class GCanvas
extends Canvas
implements Runnable {
    public long limitTime = 50L;
    public static GCanvas instance;
    public boolean isrun;
    public boolean isClose = false;
    public Thread mainThread = null;
    public GLives glives;
    Sprite sprite;
    Graphics gSprite;
    private Thread thread_2 = null;

    public GCanvas() {
        this.setFullScreenMode(true);
        GUIManager.beginW = this.getWidth();
        GUIManager.beginH = this.getHeight();
        GUIManager.WIDTH = GUIManager.beginW;
        GUIManager.HEIGHT = GUIManager.beginH;
        switch (1) {
            case 0: {
                break;
            }
            case 1: {
                this.updateScreenLandscrape();
                break;
            }
            case 2: {
                this.updateScreenPortrait();
            }
        }
        if (GUIManager.GAMEMODE == 2) {
            try {
                Socket.Partner = this.readDatConfig();
            }
            catch (Exception exception) {
                // empty catch block
            }
            OnlineManager.initConnect();
        }
        instance = this;
        GameMain.getInstance().changePage(1);
    }

    private String readDatConfig() throws IOException {
        String str = "";
        try {
            InputStream is = this.getClass().getResourceAsStream("/code.dat");
            byte[] data = new byte[is.available()];
            is.read(data, 0, data.length);
            str = new String(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public void init() {
    }

    public static GCanvas getInstance() {
        if (instance == null) {
            instance = new GCanvas();
        }
        return instance;
    }

    public void start() {
        try {
            this.isrun = true;
            if (this.mainThread == null) {
                this.mainThread = new Thread(instance);
                this.mainThread.start();
            }
            this.RunThread_2();
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi start Canvas " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void onResize(int ww, int hh) {
        if (!this.isClose) {
            this.setFullScreenMode(true);
            if (GUIManager.beginW == 0 || GUIManager.beginH == 0) {
                GUIManager.beginW = this.getWidth();
                GUIManager.beginH = this.getWidth();
                GUIManager.isRotate = false;
            } else if (GUIManager.isRotate) {
                GUIManager.WIDTH = ww;
                GUIManager.HEIGHT = hh;
                GUIManager.isRotate = false;
            } else if (ww != GUIManager.beginW || hh != GUIManager.beginH) {
                GUIManager.WIDTH = ww;
                GUIManager.HEIGHT = hh;
                GUIManager.isRotate = true;
            }
            if (GameMain.getInstance().currenPage != null) {
                GameMain.getInstance().currenPage.sizeChanged();
                Control.sizeChanged();
            }
        }
    }

    public void sizeChanged(int ww, int hh) {
        try {
            switch (1) {
                case 0: {
                    this.onResize(ww, hh);
                    break;
                }
                case 1: {
                    this.updateScreenLandscrape();
                    break;
                }
                case 2: {
                    this.updateScreenPortrait();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Change Size " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    private void updateScreenLandscrape() {
        int w = Math.max(super.getWidth(), super.getHeight());
        int h = Math.min(super.getWidth(), super.getHeight());
        if (super.getWidth() < super.getHeight()) {
            Image imgCan = Image.createImage((int)w, (int)h);
            this.gSprite = imgCan.getGraphics();
            this.sprite = new Sprite(imgCan, w, h);
            this.sprite.setTransform(5);
            this.sprite.setPosition(0, 0);
            GUIManager.screenOrientationReal = 1;
        } else {
            GUIManager.screenOrientationReal = 0;
            this.gSprite = null;
            this.sprite = null;
        }
        this.onResize(w, h);
    }

    private void updateScreenPortrait() {
        int w = Math.min(super.getWidth(), super.getHeight());
        int h = Math.max(super.getWidth(), super.getHeight());
        if (super.getWidth() > super.getHeight()) {
            Image imgCan = Image.createImage((int)w, (int)h);
            this.gSprite = imgCan.getGraphics();
            this.sprite = new Sprite(imgCan, w, h);
            this.sprite.setTransform(5);
            this.sprite.setPosition(0, 0);
            GUIManager.screenOrientationReal = (short)2;
        } else {
            GUIManager.screenOrientationReal = 0;
            this.gSprite = null;
            this.sprite = null;
        }
        this.onResize(w, h);
    }

    private int getScreenLandscrapeX(int x, int y) {
        return y;
    }

    private int getScreenLandscrapeY(int x, int y) {
        return GUIManager.HEIGHT - x - 1;
    }

    private int getScreenPortraitX(int x, int y) {
        return y;
    }

    private int getScreenPortraitY(int x, int y) {
        return GUIManager.HEIGHT - x - 1;
    }

    public void close() {
        this.isClose = true;
        this.isrun = false;
        this.mainThread = null;
        this.thread_2 = null;
    }

    public void destroy() {
        staticImage.destroy();
        Database.saveDatabase();
    }

    public void update() {
        try {
            if (GUIManager.ptime >= 0L) {
                ++GUIManager.ptime;
            }
            if (STATE.currentState == 6) {
                ((IGP)GameMain.getInstance().currenPage).update();
                return;
            }
            if (GameMain.getInstance().currenPage != null && GameMain.getInstance().currenPage.isLoadFinish) {
                GameMain.getInstance().currenPage.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Update " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void paint(Graphics g) {
        try {
            g.translate(0, 0);
            if (GUIManager.screenOrientationReal == 0) {
                g.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
                if (GameMain.getInstance().currenPage != null) {
                    GameMain.getInstance().currenPage.paint(g);
                }
            } else {
                this.gSprite.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
                if (GameMain.getInstance().currenPage != null) {
                    GameMain.getInstance().currenPage.paint(this.gSprite);
                }
                this.sprite.paint(g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Paint " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void openIGP() {
        if (this.glives == null) {
            this.glives = new GLives(this);
            this.glives.init(this.hasPointerEvents(), System.getProperty("microedition.platform"), this.getKeyCode(8), this.isQwertyKeyPad());
            this.glives.init(this.getWidth(), this.getHeight());
        }
        this.glives.InitializeIGP();
    }

    public boolean isQwertyKeyPad() {
        try {
            for (int i = 65; i < 91; ++i) {
                this.getKeyName(i);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void paintGlives(Graphics g) {
        if (STATE.currentState == 6) {
            this.glives.paint(g);
        }
    }

    public void keyPressed(int keyCode) {
        try {
            GUIManager.Can_press_key = true;
            if (STATE.currentState == 6) {
                this.glives.onkeyDown(keyCode);
                return;
            }
            GUIManager.keyPressed(keyCode);
            if (GUIManager.TestMode && GUIManager.can_debug && GUIManager.keyPressed[0]) {
                GUIManager.debug = !GUIManager.debug;
                GUIManager.keyPressed[0] = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Keypress " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void keyReleased(int keyCode) {
        try {
            if (STATE.currentState == 6) {
                this.glives.onkeyUp(keyCode);
                return;
            }
            GUIManager.keyReleased(keyCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi KeyReleased " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    protected void keyRepeated(int keyCode) {
    }

    public void touchDown(int x, int y) {
        try {
            StaticObj.PrintOut("Pressed x: " + x + " - y: " + y);
            if (STATE.currentState == 6) {
                this.glives.touchDown(x, y);
                return;
            }
            GUIManager.pointerPressed(x, y);
            if (GUIManager.TestMode && GUIManager.can_debug && x >= 0 && x <= 50 && y >= 0 && y <= 50) {
                GUIManager.debug = !GUIManager.debug;
                GUIManager.keyPressed[0] = false;
            }
            if (Loading.Ins != null && Loading.Ins.StepPaintPage == 1) {
                Loading.getInstance().pointerPressed(x, y);
                return;
            }
            GameMain.getInstance().currenPage.pointerPressed(x, y);
            if (GameMain.getInstance().currenPage != null) {
                GameMain.getInstance().currenPage.updateKeyPressed(GUIManager.keyPressed, GUIManager.keyHold, GUIManager.currentAsciiKeyPressed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Touch Down " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    protected void pointerPressed(int x, int y) {
        try {
            switch (GUIManager.screenOrientationReal) {
                case 0: {
                    this.touchDown(x, y);
                    break;
                }
                case 1: {
                    this.touchDown(this.getScreenLandscrapeX(x, y), this.getScreenLandscrapeY(x, y));
                    break;
                }
                case 2: {
                    this.touchDown(this.getScreenPortraitX(x, y), this.getScreenPortraitY(x, y));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Pointer Pressed " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void touchDrag(int x, int y) {
        StaticObj.PrintOut("Dragged x: " + x + " - y: " + y);
        try {
            if (STATE.currentState == 6) {
                this.glives.touchDrag(x, y);
                return;
            }
            GUIManager.pointerDragged(x, y);
            if (Loading.Ins != null && Loading.Ins.StepPaintPage == 1) {
                Loading.getInstance().pointerDragged(x, y);
                return;
            }
            GameMain.getInstance().currenPage.pointerDragged(x, y);
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Touch Drag " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    protected void pointerDragged(int x, int y) {
        try {
            switch (GUIManager.screenOrientationReal) {
                case 0: {
                    this.touchDrag(x, y);
                    break;
                }
                case 1: {
                    this.touchDrag(this.getScreenLandscrapeX(x, y), this.getScreenLandscrapeY(x, y));
                    break;
                }
                case 2: {
                    this.touchDrag(this.getScreenPortraitX(x, y), this.getScreenPortraitY(x, y));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Pointer Dragged " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void touchUp(int x, int y) {
        try {
            StaticObj.PrintOut("Released x: " + x + " - y: " + y);
            if (STATE.currentState == 6) {
                if (this.glives.currSlide == null) {
                    GameMain.getInstance().currenPage = new IGP();
                }
                this.glives.touchUp(x, y);
                return;
            }
            GUIManager.pointerReleased(x, y);
            if (Loading.Ins != null && Loading.Ins.StepPaintPage == 1) {
                Loading.getInstance().pointerRelease(x, y);
                return;
            }
            GameMain.getInstance().currenPage.pointerRelease(x, y);
            if (GameMain.getInstance().currenPage != null && !GUIManager.isPointerDragged) {
                GameMain.getInstance().currenPage.updateKeyPressed(GUIManager.keyPressed, GUIManager.keyHold, GUIManager.currentAsciiKeyPressed);
            }
            GUIManager.resetPointer();
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Touch UP " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    protected void pointerReleased(int x, int y) {
        try {
            switch (GUIManager.screenOrientationReal) {
                case 0: {
                    this.touchUp(x, y);
                    break;
                }
                case 1: {
                    this.touchUp(this.getScreenLandscrapeX(x, y), this.getScreenLandscrapeY(x, y));
                    break;
                }
                case 2: {
                    this.touchUp(this.getScreenPortraitX(x, y), this.getScreenPortraitY(x, y));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi Pointer Released " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void RunThread_2() {
        if (this.isrun && this.thread_2 == null) {
            this.thread_2 = new Thread(){

                public void run() {
                    while (GCanvas.this.isrun) {
                        try {
                            long time_2 = System.currentTimeMillis();
                            try {
                                if (Loading.Ins != null && Loading.Ins.StepPaintPage == 1) {
                                    Loading.getInstance().update();
                                    GCanvas.this.repaint();
                                    GCanvas.this.serviceRepaints();
                                } else if (Control.isWait) {
                                    Control.imgLoading.tick();
                                    GCanvas.this.repaint();
                                    GCanvas.this.serviceRepaints();
                                } else if (Control.paintDlg && Control.timeshowDlg >= 0) {
                                    Control.updateShowDialog();
                                    GCanvas.this.repaint();
                                    GCanvas.this.serviceRepaints();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (System.currentTimeMillis() - time_2 >= GCanvas.this.limitTime) continue;
                            try {
                                Thread.sleep(GCanvas.this.limitTime - (System.currentTimeMillis() - time_2));
                                Thread.yield();
                            }
                            catch (Exception exception) {
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            this.thread_2.start();
        }
    }

    protected void showNotify() {
        try {
            StaticObj.PrintOut("showNotify-------------------------------------");
            while (this.mainThread == null) {
                try {
                    this.start();
                }
                catch (Exception e) {
                    // empty catch block
                }
                StaticObj.PrintOut("showNotify null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi showNotify " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    protected void hideNotify() {
        try {
            StaticObj.PrintOut("hideNotify------------------------------------");
            this.isrun = false;
            this.mainThread = null;
            this.thread_2 = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            DEBUG.addBug("--- Loi hideNotify " + DEBUG.mode + " ---");
            DEBUG.addBug(e.toString());
        }
    }

    public void run() {
        while (this.isrun) {
            try {
                long time = System.currentTimeMillis();
                if (GUIManager.isHoldKey && GameMain.getInstance().currenPage != null) {
                    if (Loading.Ins != null && Loading.Ins.StepPaintPage == 1) {
                        Loading.getInstance().updateKeyPressed(GUIManager.keyPressed, GUIManager.keyHold, GUIManager.currentAsciiKeyPressed);
                    } else {
                        GameMain.getInstance().currenPage.updateKeyPressed(GUIManager.keyPressed, GUIManager.keyHold, GUIManager.currentAsciiKeyPressed);
                    }
                } else {
                    GUIManager.resetKeyHold();
                    GUIManager.resetKeyPressed();
                }
                this.update();
                if (Loading.Ins == null || Loading.Ins != null && Loading.Ins.StepPaintPage == 3) {
                    this.repaint();
                    this.serviceRepaints();
                }
                if (System.currentTimeMillis() - time >= this.limitTime) continue;
                try {
                    Thread.sleep(this.limitTime - (System.currentTimeMillis() - time));
                    Thread.yield();
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

