/*
 * Decompiled with CFR 0.152.
 */
package GamePages;

import CoreGame.Action;
import CoreGame.Command;
import CoreGame.Control;
import CoreGame.GUIManager;
import CoreGame.GameMain;
import CoreGame.ScrollScreen;
import GMain.GMidlet;
import GamePages.Loading;
import GamePages.Page;
import Util.Data;
import Util.IconToolBar;
import Util.StaticMessage;
import Util.StaticObj;
import Util.StaticSound;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu
extends Page {
    public Image imgbg;
    public Image imgGameName;
    public Image imgBarMenu;
    public Image imgFocusBarMenu;
    public Image[] imgstMenu;
    public Image imgArray;
    public Image imgBear;
    public boolean hasContinue;
    public boolean hasOtherGames;
    public Vector optionMenu;
    public int distance_menu;
    public int index_menu;
    public int x_start_menu;
    public int y_start_menu;
    public ScrollScreen scroll;
    public boolean isfocusMenu;
    public int dy_Array;
    public int count_Array;
    public int Command_Unknown = 0;
    public int Command_ChoiTiep = 1;
    public int Command_ChoiMoi = 2;
    public int Command_GioiThieu = 3;
    public int Command_DiemCao = 4;
    public int Command_Thoat = 5;
    public int Command = this.Command_Unknown;

    public MainMenu() {
        this.hasContinue = Data.hasContinue == 1;
        this.hasOtherGames = GUIManager.flagOtherGame;
        this.init();
    }

    public void init() {
        if (GUIManager.isPlaySound) {
            StaticSound.Sou_bg.play();
        } else {
            StaticSound.Sou_bg.stop();
        }
        this.Command = this.Command_Unknown;
        this.optionMenu = new Vector();
        if (this.hasContinue) {
            this.optionMenu.addElement("mChoiTiep");
        }
        this.optionMenu.addElement("mChoiMoi");
        this.optionMenu.addElement("mGioiThieu");
        if (this.hasOtherGames) {
            this.optionMenu.addElement("mGameKhac");
        }
        this.optionMenu.addElement("mDiemCao");
        this.optionMenu.addElement("mThoat");
        super.init();
        this.distance_menu = this.imgBarMenu.getHeight() + 3;
        this.index_menu = 0;
        this.x_start_menu = 30 + this.imgBarMenu.getWidth() / 2;
        if (GUIManager.HEIGHT <= 240) {
            this.y_start_menu = 225 - (this.distance_menu * 3 - 3);
            this.scroll = new ScrollScreen();
            this.scroll.setHeightScrollScreen(this.y_start_menu, 225, this.y_start_menu, -1, this.distance_menu * this.optionMenu.size() - 3);
        } else {
            this.y_start_menu = GUIManager.HEIGHT / 3;
        }
    }

    public void loadImg() {
        try {
            this.imgBarMenu = Image.createImage((String)"/menu/BarMenu.png");
            this.imgFocusBarMenu = Image.createImage((String)"/menu/FocusBarMenu.png");
            this.imgArray = Image.createImage((String)"/menu/array.png");
            this.imgBear = Image.createImage((String)"/menu/bear.png");
            this.imgGameName = Image.createImage((String)"/menu/gameName.png");
            this.imgstMenu = new Image[this.optionMenu.size()];
            for (int i = 0; i < this.imgstMenu.length; ++i) {
                this.imgstMenu[i] = Image.createImage((String)("/menu/" + (String)this.optionMenu.elementAt(i) + ".png"));
            }
            if (this.imgbg == null) {
                Image tmp = Image.createImage((String)"/menu/bgMainMenu.png");
                this.imgbg = Image.createImage((int)GUIManager.WIDTH, (int)GUIManager.HEIGHT);
                Graphics gg = this.imgbg.getGraphics();
                gg.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
                gg.setColor(0);
                gg.fillRect(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
                Image[] imgbgBonus = new Image[]{Image.createImage((String)"/menu/bgMainMenu_bonus_0.png"), Image.createImage((String)"/menu/bgMainMenu_bonus_1.png")};
                int size = GUIManager.WIDTH / imgbgBonus[1].getWidth();
                for (int i = 0; i < size; ++i) {
                    gg.drawImage(imgbgBonus[1], i * imgbgBonus[1].getWidth(), 0, 20);
                }
                gg.drawImage(imgbgBonus[0], 0, 0, 20);
                gg.drawImage(tmp, GUIManager.WIDTH, 0, 24);
                tmp = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sizeChanged() {
    }

    public void initCommand() {
        Control.centerSoftKey = new Command("", new Action(){

            public void perform() {
                StaticObj.PrintOut("Select Menu");
                MainMenu.this.selectMenu(MainMenu.this.index_menu);
            }
        });
        Control.rightSoftKey = new Command("", IconToolBar.imgIcon[(GUIManager.isPlaySound ? IconToolBar.SOUND_ON : IconToolBar.SOUND_OFF) + IconToolBar.distance], GUIManager.Style_Screen, new Action(){

            public void perform() {
                StaticObj.PrintOut("Sound");
                StaticSound.Switch_ON_OFF_SoundBG();
                Control.rightSoftKey.imgIcon = IconToolBar.imgIcon[(GUIManager.isPlaySound ? IconToolBar.SOUND_ON : IconToolBar.SOUND_OFF) + IconToolBar.distance];
            }
        });
        Control.rightSoftKey.RegisTouch(-3, -1, -1, -1);
    }

    public void update() {
        if (this.scroll != null) {
            this.scroll.updateCamera();
            ++this.count_Array;
            if (this.count_Array > 3) {
                this.count_Array = 0;
                if (this.dy_Array >= 0) {
                    this.dy_Array = -1;
                } else if (this.dy_Array < 0) {
                    this.dy_Array = 1;
                }
            }
        }
        if (Loading.Ins != null && Loading.getInstance().isLoad) {
            if (this.Command == this.Command_ChoiTiep) {
                GUIManager.startTime = System.currentTimeMillis();
                GameMain.getInstance().changePage(4);
                this.Command = this.Command_Unknown;
            } else if (this.Command == this.Command_ChoiMoi) {
                GUIManager.startTime = System.currentTimeMillis();
                GameMain.getInstance().changePage(4);
                this.Command = this.Command_Unknown;
            } else if (this.Command == this.Command_GioiThieu) {
                GameMain.getInstance().changePage(3);
                this.Command = this.Command_Unknown;
            } else if (this.Command == this.Command_DiemCao) {
                GameMain.getInstance().changePage(10);
                this.Command = this.Command_Unknown;
            } else if (this.Command == this.Command_Thoat) {
                GMidlet.getInstance().exit();
                this.Command = this.Command_Unknown;
            }
        }
    }

    public void updateKeyPressed(boolean[] keypressed, boolean[] keyHold, int currencurrentAscii) {
        if (!Control.updateKey()) {
            if (keypressed[12] || keypressed[2]) {
                --this.index_menu;
                if (this.index_menu < 0) {
                    this.index_menu = 0;
                }
                if (this.scroll != null) {
                    this.scroll.setCorrectPosition(-1, this.y_start_menu + this.distance_menu * this.index_menu + this.imgBarMenu.getHeight() / 2, -1, this.scroll.y_lim_tren + (this.scroll.y_lim_duoi - this.scroll.y_lim_tren) / 2);
                }
                keypressed[12] = false;
                keypressed[2] = false;
            } else if (keypressed[13] || keypressed[8]) {
                ++this.index_menu;
                if (this.index_menu >= this.optionMenu.size()) {
                    this.index_menu = this.optionMenu.size() - 1;
                }
                if (this.scroll != null) {
                    this.scroll.setCorrectPosition(-1, this.y_start_menu + this.distance_menu * this.index_menu + this.imgBarMenu.getHeight() / 2, -1, this.scroll.y_lim_tren + (this.scroll.y_lim_duoi - this.scroll.y_lim_tren) / 2);
                }
                keypressed[13] = false;
                keypressed[8] = false;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (!Control.pointPressed(x, y)) {
            if (this.scroll != null) {
                if (y >= this.scroll.y_lim_tren && y <= this.scroll.y_lim_duoi) {
                    this.isfocusMenu = x >= this.x_start_menu - this.imgBarMenu.getWidth() / 2 - 20 && x <= this.x_start_menu + this.imgBarMenu.getWidth() / 2 + 20;
                }
            } else if (y >= this.y_start_menu && y <= this.y_start_menu - 3 + this.optionMenu.size() * this.distance_menu) {
                this.isfocusMenu = x >= this.x_start_menu - this.imgBarMenu.getWidth() / 2 - 20 && x <= this.x_start_menu + this.imgBarMenu.getWidth() / 2 + 20;
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.isfocusMenu && this.scroll != null) {
            this.scroll.pointerDragged(x, y);
        }
    }

    public void pointerRelease(int x, int y) {
        if (this.isfocusMenu) {
            if (!GUIManager.isPointerDragged) {
                if (this.scroll != null) {
                    if (y >= this.scroll.y_lim_tren && y <= this.scroll.y_lim_duoi && x >= this.x_start_menu - this.imgBarMenu.getWidth() / 2 - 20 && x <= this.x_start_menu + this.imgBarMenu.getWidth() / 2 + 20) {
                        int _index = (y - this.y_start_menu - this.scroll.y_page) / this.distance_menu;
                        if (this.index_menu != _index) {
                            this.index_menu = _index;
                        } else {
                            this.selectMenu(this.index_menu);
                        }
                    }
                } else if (y >= this.y_start_menu && y <= this.y_start_menu - 3 + this.optionMenu.size() * this.distance_menu && x >= this.x_start_menu - this.imgBarMenu.getWidth() / 2 - 20 && x <= this.x_start_menu + this.imgBarMenu.getWidth() / 2 + 20) {
                    int _index = (y - this.y_start_menu) / this.distance_menu;
                    if (this.index_menu != _index) {
                        this.index_menu = _index;
                    } else {
                        this.selectMenu(this.index_menu);
                    }
                }
            } else if (this.scroll != null) {
                this.scroll.pointerRelease(x, y);
            }
        }
        this.isfocusMenu = false;
    }

    public void selectMenu(int i) {
        if (this.Command == this.Command_Unknown) {
            if (((String)this.optionMenu.elementAt(i)).equals("mChoiTiep")) {
                StaticObj.PrintOut("Choi Tiep");
                this.Command = this.Command_ChoiTiep;
                Loading.getInstance().showChangePage();
            } else if (((String)this.optionMenu.elementAt(i)).equals("mChoiMoi")) {
                StaticObj.PrintOut("Choi Moi");
                if (this.hasContinue) {
                    Control.showDlg(StaticMessage.ASK_TO_PLAY_NEW_GAME[StaticMessage.langue], new Command("", IconToolBar.imgIcon[IconToolBar.AGREE + IconToolBar.distance], GUIManager.Style_Screen, new Action(){

                        public void perform() {
                            Control.resetDlg();
                            MainMenu.this.resetDataBase();
                            MainMenu.this.Command = MainMenu.this.Command_ChoiMoi;
                            Loading.getInstance().showChangePage();
                        }
                    }), new Command("", IconToolBar.imgIcon[IconToolBar.DO_NOT_AGREE + IconToolBar.distance], GUIManager.Style_Screen, new Action(){

                        public void perform() {
                            Control.resetDlg();
                        }
                    }), null);
                    Control.DlgLeftCommand.RegisTouch(-1, -1, -1, -1);
                    Control.DlgRightCommand.RegisTouch(-3, -1, -1, -1);
                } else {
                    this.Command = this.Command_ChoiMoi;
                    Loading.getInstance().showChangePage();
                }
            } else if (((String)this.optionMenu.elementAt(i)).equals("mGioiThieu")) {
                StaticObj.PrintOut("Huong Dan");
                this.Command = this.Command_GioiThieu;
                Loading.getInstance().showChangePage();
            } else if (((String)this.optionMenu.elementAt(i)).equals("mGameKhac")) {
                StaticObj.PrintOut("Game Khac");
                GameMain.getInstance().changePage(6);
                if (GUIManager.isPlaySound) {
                    StaticSound.Sou_bg.stop();
                }
            } else if (((String)this.optionMenu.elementAt(i)).equals("mDiemCao")) {
                StaticObj.PrintOut("Diem Cao");
                this.Command = this.Command_DiemCao;
                Loading.getInstance().showChangePage();
            } else if (((String)this.optionMenu.elementAt(i)).equals("mThoat")) {
                StaticObj.PrintOut("Thoat");
                this.Command = this.Command_Thoat;
                Loading.getInstance().showChangePage();
            }
        }
    }

    public void resetDataBase() {
        int i;
        Data.hasContinue = 0;
        Data.level = 1;
        Data.total_score = 0.0;
        Data.Status_Level = new short[72];
        Data.Status_Level[0] = 1;
        for (i = 1; i < 72; ++i) {
            Data.Status_Level[i] = 0;
        }
        Data.scores = new double[72];
        Data.stars = new short[72];
        Data.scores[0] = 0.0;
        Data.stars[0] = 0;
        for (i = 1; i < 72; ++i) {
            Data.scores[i] = -1.0;
            Data.stars[i] = -1;
        }
        Data.Status_Stages = new short[3];
        Data.Status_Stages[0] = 1;
        for (i = 1; i < Data.Status_Stages.length; ++i) {
            Data.Status_Stages[i] = 0;
        }
        Data.bonus_stars = 0;
    }

    public void paintBackground(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
        g.drawImage(this.imgbg, GUIManager.WIDTH, 0, 24);
        g.drawImage(this.imgGameName, GUIManager.WIDTH - 45, 0, 24);
        if (GUIManager.HEIGHT <= 240) {
            g.drawImage(this.imgBear, 240, 120, 17);
        } else {
            g.drawImage(this.imgBear, GUIManager.WIDTH - 170, 130, 17);
        }
    }

    public void paintMain(Graphics g) {
        if (this.scroll != null) {
            if (this.scroll.y_top < this.scroll.y_lim_tren) {
                g.drawRegion(this.imgArray, 0, 0, this.imgArray.getWidth(), this.imgArray.getHeight(), 3, this.x_start_menu, this.scroll.y_lim_tren - 2 + this.dy_Array, 33);
            }
            g.setClip(0, this.scroll.y_lim_tren, GUIManager.WIDTH, this.scroll.y_lim_duoi - this.scroll.y_lim_tren);
            g.translate(this.scroll.x_page, this.scroll.y_page);
        }
        g.drawImage(this.imgFocusBarMenu, this.x_start_menu, this.y_start_menu + this.distance_menu * this.index_menu, 17);
        for (int i = 0; i < this.optionMenu.size(); ++i) {
            if (i != this.index_menu) {
                g.drawImage(this.imgBarMenu, this.x_start_menu, this.y_start_menu + this.distance_menu * i, 17);
            }
            g.drawImage(this.imgstMenu[i], this.x_start_menu, this.y_start_menu + this.imgBarMenu.getHeight() / 2 + this.distance_menu * i, 3);
        }
        if (this.scroll != null) {
            g.translate(-this.scroll.x_page, -this.scroll.y_page);
            g.setClip(0, 0, GUIManager.WIDTH, GUIManager.HEIGHT);
            if (this.scroll.y_bottom > this.scroll.y_lim_duoi) {
                g.drawImage(this.imgArray, this.x_start_menu, this.scroll.y_lim_duoi + 2 - this.dy_Array, 17);
            }
        }
        Control.paintCommand(g);
    }

    public void destroy() {
        this.imgBear = null;
        this.imgArray = null;
        this.imgFocusBarMenu = null;
        this.imgBarMenu = null;
        this.imgGameName = null;
        this.imgbg = null;
        this.imgstMenu = null;
        this.optionMenu.removeAllElements();
        this.optionMenu = null;
        this.scroll = null;
    }
}

