/*
 * Decompiled with CFR 0.152.
 */
package com.danhhuynh.donttapthewhitetile.view;

import com.danhhuynh.donttapthewhitetile.Midlet;
import com.danhhuynh.donttapthewhitetile.view.MyCanvas;
import com.danhhuynh.donttapthewhitetile.widget.Button;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MenuCanvas
extends Canvas {
    private Midlet midlet;
    private int width;
    private int height;
    private Button button;
    private Button[] buttons;
    private Button btnBack;
    private boolean isHelpShow;
    private boolean isAboutShow;
    public static final String URL_APP = "http://store.ovi.mobi/content/520436/comments/add";

    public MenuCanvas(Midlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.init();
    }

    private void init() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.initButtons();
        this.isHelpShow = false;
        this.isAboutShow = false;
    }

    private void initButtons() {
        this.buttons = new Button[7];
        this.button = new Button();
        this.button.str = "Classic";
        this.button.width = this.width / 2;
        this.button.height = this.height / 2;
        this.button.x = 0;
        this.button.y = 0;
        this.button.color = 0;
        this.button.bg = 0xFFFFFF;
        this.button.font = Font.getFont((int)0, (int)1, (int)16);
        this.buttons[0] = this.button;
        this.button = new Button();
        this.button.str = "Arcade";
        this.button.width = this.width / 2;
        this.button.height = this.height / 2;
        this.button.x = this.width / 2;
        this.button.y = 0;
        this.button.color = 0xFFFFFF;
        this.button.bg = 0;
        this.button.font = Font.getFont((int)0, (int)1, (int)16);
        this.buttons[1] = this.button;
        this.button = new Button();
        this.button.str = "Zen";
        this.button.width = this.width / 2;
        this.button.height = this.height / 2;
        this.button.x = 0;
        this.button.y = this.height / 2;
        this.button.color = 0xFFFFFF;
        this.button.bg = 0;
        this.button.font = Font.getFont((int)0, (int)1, (int)16);
        this.buttons[2] = this.button;
        String[] str = new String[]{"Rate", "Help", "About", "Exit"};
        int i = 3;
        while (i < this.buttons.length) {
            this.button = new Button();
            this.button.str = str[i - 3];
            this.button.width = this.width / 2;
            this.button.height = this.height / 8;
            this.button.x = this.width / 2;
            this.button.y = this.height / 2 + (i - 3) * this.button.height;
            if (i % 2 != 0) {
                this.button.color = 0;
                this.button.bg = 0xFFFFFF;
            } else {
                this.button.color = 0xFFFFFF;
                this.button.bg = 0;
            }
            this.button.font = Font.getFont((int)0, (int)0, (int)8);
            this.buttons[i] = this.button;
            ++i;
        }
        this.btnBack = this.buttons[this.buttons.length - 1];
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.width, this.height);
        int i = 0;
        while (i < this.buttons.length) {
            this.button = this.buttons[i];
            this.buttons[i].draw(g);
            ++i;
        }
        this.drawHelpScreen(g);
        this.drawAboutScreen(g);
    }

    public void drawHelpScreen(Graphics g) {
        if (this.isHelpShow) {
            g.setColor(0);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(0xFFFFFF);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.drawString("Don't Tap The White Tile", this.width - 5, 5, 24);
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            g.drawString("HOW TO PLAY", this.width / 2, 50, 17);
            MenuCanvas.drawMultilineString(g, Font.getFont((int)0, (int)0, (int)8), "There are 3 modes in the game:\n- Classic mode, reach the target as soon as possible.\n- Arcade mode, try your best to tap the black tiles as many as you can, no time limited.\n- Zen mode, try your best to tap the black tiles as many as you can in 30 seconds.", this.width / 2, 100, 17, this.width);
            this.btnBack.draw(g);
        }
    }

    public void drawAboutScreen(Graphics g) {
        if (this.isAboutShow) {
            g.setColor(0);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(0xFFFFFF);
            g.setFont(Font.getFont((int)0, (int)0, (int)8));
            g.drawString("Don't Tap The White Tile", this.width - 5, 5, 24);
            g.setFont(Font.getFont((int)0, (int)1, (int)16));
            g.drawString("ABOUT", this.width / 2, 50, 17);
            MenuCanvas.drawMultilineString(g, Font.getFont((int)0, (int)0, (int)8), "Version:  v" + this.midlet.getAppProperty("MIDlet-Version") + "\nPublished by " + this.midlet.getAppProperty("MIDlet-Vendor") + "\nSupport e-mail: danh.huynh297@gmail.com", this.width / 2, 100, 17, this.width);
            this.btnBack.draw(g);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!this.isHelpShow && !this.isAboutShow) {
            int i = 0;
            while (i < this.buttons.length) {
                this.button = this.buttons[i];
                if (this.button.isPressed(x, y)) {
                    this.showScreen(i);
                    break;
                }
                ++i;
            }
        } else if (this.btnBack.isPressed(x, y)) {
            this.isHelpShow = false;
            this.isAboutShow = false;
        }
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
    }

    private void showScreen(int i) {
        switch (i) {
            case 0: {
                this.midlet.showDisplayable((Displayable)new MyCanvas(this.midlet, 0));
                break;
            }
            case 1: {
                this.midlet.showDisplayable((Displayable)new MyCanvas(this.midlet, 2));
                break;
            }
            case 2: {
                this.midlet.showDisplayable((Displayable)new MyCanvas(this.midlet, 1));
                break;
            }
            case 3: {
                try {
                    this.midlet.platformRequest(URL_APP);
                }
                catch (ConnectionNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                this.isHelpShow = true;
                break;
            }
            case 5: {
                this.isAboutShow = true;
                break;
            }
            case 6: {
                this.midlet.notifyDestroyed();
            }
        }
    }

    public static Vector wrap(String text, Font font, int width, char ch) {
        Vector<String> result = new Vector<String>();
        if (text == null) {
            return result;
        }
        boolean hasMore = true;
        int current = 0;
        int lineBreak = -1;
        int nextSpace = -1;
        while (hasMore) {
            int linewidth;
            do {
                if ((lineBreak = nextSpace) == text.length() - 1) {
                    hasMore = false;
                    break;
                }
                nextSpace = text.indexOf(ch, lineBreak + 1);
                if (nextSpace != -1) continue;
                nextSpace = text.length() - 1;
            } while ((linewidth = font.substringWidth(text, current, nextSpace - current)) <= width);
            String line = text.substring(current, lineBreak + 1);
            if (!line.equals("")) {
                result.addElement(line);
            }
            current = lineBreak + 1;
        }
        return result;
    }

    public static int drawMultilineString(Graphics g, Font font, String str, int x, int y, int anchor, int width) {
        g.setFont(font);
        Vector lines = MenuCanvas.wrap(str, font, width, '\n');
        Vector vector = new Vector();
        int j = 0;
        while (j < lines.size()) {
            Vector v = MenuCanvas.wrap((String)lines.elementAt(j), font, width, ' ');
            int k = 0;
            while (k < v.size()) {
                vector.addElement(v.elementAt(k));
                ++k;
            }
            ++j;
        }
        int i = 0;
        while (i < vector.size()) {
            int liney = y + i * font.getHeight();
            g.drawString((String)vector.elementAt(i), x, liney, anchor);
            ++i;
        }
        return y + lines.size() * font.getHeight();
    }
}

