/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.graphics;

import com.rocktasticgames.farmmatch.graphics.AssetLoader;
import com.rocktasticgames.farmmatch.utils.ColorMatrixColorFilter;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.XMath;
import javax.microedition.lcdui.Image;

public class BackgroundElement {
    protected Image bitmap;
    protected AssetLoader assetloader;
    private String assetid;
    protected float x;
    protected float y;
    protected float z;
    private boolean load = false;
    protected int blur;
    private boolean repeat;
    private float width;
    protected long time_internal = 0L;
    private boolean isanimation = false;

    public BackgroundElement(AssetLoader assetLoader, String string, float f, float f2, float f3, int n, float f4, boolean bl) {
        this.assetloader = assetLoader;
        this.assetid = string;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.blur = n;
        this.width = f4;
        this.repeat = bl;
        this.load();
    }

    public BackgroundElement(AssetLoader assetLoader, String string, float f, float f2, int n, float f3) {
        this.assetloader = assetLoader;
        this.assetid = string;
        this.x = f;
        this.y = f2;
        this.z = 1.0f;
        this.blur = n;
        this.width = f3;
        this.repeat = false;
        this.load();
    }

    public boolean inRange(float f, float f2) {
        Image image = this.assetloader.get(this.assetid);
        if (image == null) {
            return false;
        }
        return XMath.abs(f - this.x) < (float)(image.getWidth() / 2) && XMath.abs(f2 - this.y) < (float)(image.getHeight() / 2);
    }

    public String getResource() {
        return this.assetid;
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void makeAnimation() {
        this.isanimation = true;
    }

    public boolean isAnimation() {
        return this.isanimation;
    }

    public void setResource(String string) {
        this.unload();
        this.assetid = string;
        this.load();
    }

    public void unload() {
        if (!this.load) {
            return;
        }
        this.load = false;
        this.assetloader.unload(this.assetid);
    }

    public void load() {
        if (this.load) {
            return;
        }
        this.load = true;
        this.assetloader.load(this.assetid, this.blur);
    }

    public void stampTime(long l) {
        this.time_internal = l;
    }

    public long getTimeStamp() {
        return this.time_internal;
    }

    public float getSliceWidth() {
        return BackgroundElement.getSliceWidth(this.width, this.blur);
    }

    public static float getSliceWidth(float f, int n) {
        return (int)(f / (float)n / 1.0f + 1.0E-4f) * n * 1;
    }

    public float getDepth() {
        return this.z;
    }

    public float getPosition() {
        return this.x;
    }

    public float getHeight() {
        return this.y;
    }

    public Image getBitmap() {
        return this.bitmap;
    }

    public void moveRight(float f) {
        this.x += f;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public boolean renderAtPosition(GraphicsContainer graphicsContainer, int n, float f, float f2) {
        if (!this.prepare(graphicsContainer, n, f, f2)) {
            return false;
        }
        graphicsContainer.drawImage(this.bitmap, -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        graphicsContainer.restore();
        return true;
    }

    public boolean renderWithFilter(GraphicsContainer graphicsContainer, int n, ColorMatrixColorFilter colorMatrixColorFilter) {
        if (!this.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
            return false;
        }
        graphicsContainer.drawImage(colorMatrixColorFilter.applyTo(this.bitmap), -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        graphicsContainer.restore();
        return true;
    }

    public boolean renderScaled(GraphicsContainer graphicsContainer, int n, float f) {
        if (!this.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
            return false;
        }
        graphicsContainer.drawImage(this.bitmap, -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        graphicsContainer.restore();
        return true;
    }

    public boolean renderWithBackdrop(GraphicsContainer graphicsContainer, int n, String string, int n2) {
        if (!this.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
            return false;
        }
        Image image = this.assetloader.get(string);
        graphicsContainer.drawImage(this.bitmap, -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        if (image != null) {
            graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() / 2, n);
        }
        graphicsContainer.restore();
        return image != null;
    }

    public boolean render(GraphicsContainer graphicsContainer, int n) {
        if (!this.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
            return false;
        }
        graphicsContainer.drawImage(this.bitmap, -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        graphicsContainer.restore();
        return true;
    }

    protected boolean prepare(GraphicsContainer graphicsContainer, int n, float f, float f2) {
        this.bitmap = this.assetloader.get(this.assetid);
        if (this.bitmap == null) {
            return false;
        }
        graphicsContainer.save();
        graphicsContainer.translate((int)((this.x - f) / this.z), (int)((this.y - f2) / this.z));
        return true;
    }
}

