/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Animation {
    public int Counter;
    public int Frame;
    public int FrameQty;
    public static Animation[] LoadedAnimations = new Animation[37];
    public static String[] LoadedAnimationsNames = new String[37];
    public static int LoadedAniomationsQty = 0;
    public boolean ani = true;
    public int delay = 2;
    public boolean flip;
    public int h;
    public Sprite sprite;
    public int w;

    public Animation(String ImageName) {
        Game.UpdateStatus();
        if (LoadedAniomationsQty < LoadedAnimations.length) {
            Animation.LoadedAnimations[Animation.LoadedAniomationsQty] = this;
            Animation.LoadedAnimationsNames[Animation.LoadedAniomationsQty] = ImageName;
            ++LoadedAniomationsQty;
        }
        this.FrameQty = 1;
        this.ani = false;
        try {
            Image image = Image.createImage((String)("/data/" + ImageName + ".png"));
            this.w = image.getWidth();
            this.h = image.getHeight();
            this.sprite = new Sprite(image);
        }
        catch (Exception ex) {
            // empty catch block
        }
        System.gc();
    }

    public Animation(String ImageName, int Qty) {
        Game.UpdateStatus();
        if (LoadedAniomationsQty < LoadedAnimations.length) {
            Animation.LoadedAnimations[Animation.LoadedAniomationsQty] = this;
            Animation.LoadedAnimationsNames[Animation.LoadedAniomationsQty] = ImageName;
            ++LoadedAniomationsQty;
        }
        this.ani = true;
        this.FrameQty = Qty;
        try {
            Image image = Image.createImage((String)("/data/" + ImageName + ".png"));
            this.w = image.getWidth();
            this.h = image.getHeight() / this.FrameQty;
            this.sprite = new Sprite(image, this.w, this.h);
        }
        catch (Exception ex) {
            // empty catch block
        }
        System.gc();
    }

    public Animation(Animation a) {
        this.sprite = a.sprite;
        this.FrameQty = a.FrameQty;
        this.ani = a.ani;
        this.delay = a.delay;
        this.w = a.w;
        this.h = a.h;
        this.flip = a.flip;
    }

    public Animation(Animation a, boolean isFlip) {
        this.sprite = a.sprite;
        this.FrameQty = a.FrameQty;
        this.ani = a.ani;
        this.delay = a.delay;
        this.w = a.w;
        this.h = a.h;
        this.flip = isFlip ? !a.flip : a.flip;
    }

    public void Draw(int x, int y) {
        this.Draw(Game.Gfx, x, y);
    }

    public void Draw(Graphics g, int x, int y) {
        this.sprite.setFrame(this.Frame);
        if (this.flip) {
            this.sprite.setTransform(2);
        } else {
            this.sprite.setTransform(0);
        }
        this.sprite.setPosition(x, y);
        this.sprite.paint(g);
        if (this.ani && ++this.Counter == this.delay) {
            ++this.Frame;
            if (this.Frame == this.FrameQty) {
                this.Frame = 0;
            }
            this.Counter = 0;
        }
    }

    public void DrawWithOutClipMirrored(int x, int y) {
        this.sprite.setFrame(this.Frame);
        if (!this.flip) {
            this.sprite.setTransform(2);
        } else {
            this.sprite.setTransform(0);
        }
        this.sprite.setPosition(x, y);
        this.sprite.paint(Game.Gfx);
    }

    public void setFrameSequence(byte[] b) {
        this.FrameQty = b.length;
        int[] t = new int[this.FrameQty];
        int i = 0;
        while (i < this.FrameQty) {
            t[i] = b[i];
            ++i;
        }
        this.sprite.setFrameSequence(t);
    }

    public String toString() {
        return null;
    }
}

