/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

public class Flame {
    private static int[] flames = new int[64];
    private static final int[] RESFLAMEFRAMESEQUENCE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};

    public static void reset() {
        for (int i = 0; i < 64; ++i) {
            Flame.flames[i] = -1;
        }
    }

    public static void update() {
        for (int i = 0; i < 64; ++i) {
            if (flames[i] < 0) continue;
            if (flames[i] < RESFLAMEFRAMESEQUENCE.length - 1) {
                int n = i;
                flames[n] = flames[n] + 1;
                continue;
            }
            Flame.flames[i] = -1;
        }
    }

    public static void setFlame(int pos) {
        Flame.flames[pos] = 0;
    }

    public static int getFrame(int pos) {
        if (flames[pos] < 0) {
            return -1;
        }
        return RESFLAMEFRAMESEQUENCE[flames[pos]];
    }
}

