/*
 * Decompiled with CFR 0.152.
 */
package Sparkygtantra;

import Sparkygtantra.GAnimListener;
import Sparkygtantra.GTantra;
import javax.microedition.lcdui.Graphics;

public class GAnim {
    private int currentFrame;
    private int timer;
    private GTantra gTantra;
    private int animId;
    private GAnimListener animListener;
    private int animUID;
    private Object userData;

    public GAnim(GTantra gTantra, int animId) {
        this.gTantra = gTantra;
        this.animId = animId;
    }

    public GAnim(GTantra gTantra, int animId, int UID) {
        this(gTantra, animId);
        this.animUID = UID;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setAnimUID(int animUID) {
        this.animUID = animUID;
    }

    public int getAnimUID() {
        return this.animUID;
    }

    public void setAnimListener(GAnimListener animListener) {
        this.animListener = animListener;
    }

    public boolean isAnimationOver() {
        return this.gTantra._iAnimFrameCnt[this.animId] - 1 == this.currentFrame;
    }

    public void reset() {
        this.currentFrame = 0;
    }

    public int getCurrentFrame() {
        return this.gTantra._iAnimFrames[this.animId][this.currentFrame];
    }

    public int getAnimationFrameX(int frameLocation) {
        return this.gTantra._iAnimFrameX[this.animId][frameLocation];
    }

    public int getAnimationFrameY(int frameLocation) {
        return this.gTantra._iAnimFrameY[this.animId][frameLocation];
    }

    public int getAnimationCurrentCycle(int animation) {
        return this.currentFrame;
    }

    public int getNumberOfFrames() {
        return this.gTantra._iAnimFrameCnt[this.animId];
    }

    public void render(Graphics g, int posX, int posY, int flags, boolean loop) {
        byte currentFrameTime = this.gTantra.frameTimer[this.animId][this.currentFrame];
        this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
        this.updateFrame(loop);
    }

    private void updateFrame(boolean loop) {
        byte currentTimer = this.gTantra.frameTimer[this.animId][this.currentFrame];
        if (this.timer + 1 >= currentTimer) {
            this.timer = 0;
            ++this.currentFrame;
            if (this.currentFrame >= this.gTantra._iAnimFrameCnt[this.animId]) {
                this.currentFrame = loop ? 0 : this.gTantra._iAnimFrameCnt[this.animId] - 1;
                if (this.animListener != null) {
                    this.animListener.animationOver(this);
                }
            }
            if (this.animListener != null) {
                this.animListener.frameChanged(this);
            }
        } else {
            ++this.timer;
        }
    }
}

