/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Contact;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Body {
    protected FXVector mPositionFX = new FXVector();
    protected FXVector mVelocityFX = new FXVector();
    protected FXVector mVirtualVelocityFX = new FXVector();
    protected int mRotation2FX = 0;
    protected int mAngularVelocity2FX = 0;
    protected int mVirtualAngularVelocity2FX = 0;
    private FXMatrix j = FXMatrix.createRotationMatrix(0);
    private boolean k = true;
    boolean a = true;
    boolean b = true;
    boolean c = true;
    protected Shape mShape;
    private FXVector[] l;
    FXVector[] d;
    private boolean m = false;
    private FXVector[] n;
    private boolean o = false;
    int e = 0;
    int f = 0;
    int g = 0;
    int h = 0;
    int i = 0;
    private int p = 0;
    private Contact[] q = new Contact[8];
    private boolean r = false;
    protected int mId = -1;
    protected UserData mUserData = null;
    private static FXVector s = new FXVector();
    private static FXMatrix t = new FXMatrix();

    public Body(int n, int n2, Shape shape, boolean bl) {
        this.mPositionFX = new FXVector(n << 12, n2 << 12);
        this.mShape = shape;
        this.initShapeInternals();
        this.a = bl;
        this.r = !bl;
    }

    public Body(FXVector fXVector, Shape shape, boolean bl) {
        this.mPositionFX = new FXVector(fXVector);
        this.mShape = shape;
        this.initShapeInternals();
        this.a = bl;
        this.r = !bl;
    }

    public Body(Body body) {
        this.mShape = body.mShape;
        this.initShapeInternals();
        this.mPositionFX = new FXVector(body.mPositionFX);
        this.mVelocityFX = new FXVector(body.mVelocityFX);
        this.setRotation2FX(body.mRotation2FX);
        this.mAngularVelocity2FX = body.mAngularVelocity2FX;
        this.i = body.i;
        this.a = body.a;
        this.k = body.k;
        this.c = body.c;
        this.b = body.b;
        if (body.mUserData != null) {
            this.mUserData = body.mUserData.copy();
        }
    }

    private Body() {
    }

    public Body copy() {
        return new Body(this);
    }

    public static Body loadBody(PhysicsFileReader object, Vector vector, UserData userData) {
        Body body = new Body();
        if (((PhysicsFileReader)object).getVersion() < 1280) {
            ((PhysicsFileReader)object).nextIntFX();
        }
        body.mPositionFX = ((PhysicsFileReader)object).nextVector();
        body.mVelocityFX = ((PhysicsFileReader)object).nextVector();
        body.setRotation2FX(((PhysicsFileReader)object).nextInt2FX());
        body.mAngularVelocity2FX = ((PhysicsFileReader)object).nextInt2FX();
        body.mShape = (Shape)vector.elementAt(((PhysicsFileReader)object).next());
        int n = ((PhysicsFileReader)object).next();
        body.a = (n & 1) != 0;
        body.k = (n & 2) != 0;
        body.b = (n & 4) == 0;
        body.c = (n & 8) == 0;
        body.i = ((PhysicsFileReader)object).nextInt();
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                body.mUserData = userData.createNewUserData((String)object, 1);
            }
        }
        body.initShapeInternals();
        return body;
    }

    public boolean equals(Body body) {
        return body.mId == this.mId && this.mId != -1;
    }

    protected void initShapeInternals() {
        int n;
        this.l = new FXVector[this.mShape.mVertices.length];
        this.d = new FXVector[this.mShape.mVertices.length];
        for (n = 0; n < this.l.length; ++n) {
            this.l[n] = new FXVector();
            this.d[n] = new FXVector();
        }
        this.n = new FXVector[this.mShape.b / 2];
        for (n = 0; n < this.n.length; ++n) {
            this.n[n] = new FXVector();
        }
        this.m = false;
        this.o = false;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isDynamic() {
        return this.a;
    }

    public boolean isResting() {
        return this.r;
    }

    public boolean canRotate() {
        return this.k;
    }

    public void setRotatable(boolean bl) {
        this.k = bl;
    }

    public boolean isInteracting() {
        return this.b;
    }

    public void setInteracting(boolean bl) {
        this.b = bl;
    }

    public boolean isAffectedByGravity() {
        return this.c;
    }

    public void setGravityAffected(boolean bl) {
        this.c = bl;
    }

    public void addCollisionLayer(int n) {
        this.i |= 1 << n;
    }

    public void removeCollisionLayer(int n) {
        this.i &= ~(1 << n);
    }

    public final long getInvMass2FX() {
        if (this.a) {
            return this.mShape.g;
        }
        return 0L;
    }

    public final long getInvInertia2FX() {
        if (this.a) {
            return this.mShape.i;
        }
        return 0L;
    }

    public void translate(FXVector fXVector) {
        this.mPositionFX.xFX += fXVector.xFX;
        this.mPositionFX.yFX += fXVector.yFX;
        this.m = false;
        this.o = false;
        this.calculateAABB(World.a);
    }

    public void forceUpdate() {
        this.m = false;
        this.o = false;
        this.calculateAABB(World.a);
    }

    public final FXVector getAbsoluePoint(FXVector fXVector) {
        fXVector = this.j.mult(fXVector);
        fXVector.xFX += this.mPositionFX.xFX;
        fXVector.yFX += this.mPositionFX.yFX;
        return fXVector;
    }

    public final void getAbsoluePoint(FXVector fXVector, FXVector fXVector2) {
        this.j.mult(fXVector, fXVector2);
        fXVector2.xFX += this.mPositionFX.xFX;
        fXVector2.yFX += this.mPositionFX.yFX;
    }

    public final FXVector getRelativePoint(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.subtract(this.mPositionFX);
        FXMatrix fXMatrix = FXMatrix.createRotationMatrix(this.mRotation2FX);
        fXMatrix.invert();
        return fXMatrix.mult(fXVector);
    }

    public final FXVector getVelocity(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.crossScalar2FX(this.mAngularVelocity2FX);
        fXVector.xFX += this.mVelocityFX.xFX;
        fXVector.yFX += this.mVelocityFX.yFX;
        return fXVector;
    }

    protected final FXVector getVirtualVelocity(FXVector fXVector) {
        fXVector = new FXVector(fXVector);
        fXVector.crossScalar2FX(this.mVirtualAngularVelocity2FX);
        fXVector.xFX += this.mVirtualVelocityFX.xFX;
        fXVector.yFX += this.mVirtualVelocityFX.yFX;
        return fXVector;
    }

    public final void getVelocity(FXVector fXVector, FXVector fXVector2) {
        fXVector2.xFX = fXVector.xFX;
        fXVector2.yFX = fXVector.yFX;
        fXVector2.crossScalar2FX(this.mAngularVelocity2FX);
        fXVector2.xFX += this.mVelocityFX.xFX;
        fXVector2.yFX += this.mVelocityFX.yFX;
    }

    protected final void getVirtualVelocity(FXVector fXVector, FXVector fXVector2) {
        fXVector2.xFX = fXVector.xFX;
        fXVector2.yFX = fXVector.yFX;
        fXVector2.crossScalar2FX(this.mVirtualAngularVelocity2FX);
        fXVector2.xFX += this.mVirtualVelocityFX.xFX;
        fXVector2.yFX += this.mVirtualVelocityFX.yFX;
    }

    public Shape shape() {
        return this.mShape;
    }

    public void setShape(Shape shape) {
        this.mShape = shape;
        this.initShapeInternals();
    }

    public final FXVector[] getVertices() {
        if (!this.m) {
            this.mShape.getVerticesFX(this.mPositionFX, this.j, this.l);
            this.m = true;
        }
        return this.l;
    }

    public final FXVector[] getAxes() {
        if (!this.o) {
            if (!this.m) {
                this.getVertices();
            }
            for (int i = 0; i < this.n.length && this.mShape.a[i << 1] >= 0; ++i) {
                this.n[i].assignDiff(this.l[this.mShape.a[i << 1]], this.l[this.mShape.a[(i << 1) + 1]]);
                this.n[i].normalize();
                this.n[i].turnRight();
            }
            this.o = true;
        }
        return this.n;
    }

    public int rotation2FX() {
        return this.mRotation2FX;
    }

    public int angularVelocity2FX() {
        return this.mAngularVelocity2FX;
    }

    public FXMatrix getRotationMatrix() {
        return this.j;
    }

    public FXVector positionFX() {
        return this.mPositionFX;
    }

    public FXVector velocityFX() {
        return this.mVelocityFX;
    }

    public int rotationVelocity2FX() {
        return this.mAngularVelocity2FX;
    }

    public void setRotation2FX(int n) {
        this.mRotation2FX = FXUtil.wrapAngleFX(n);
        this.j.setRotationMatrix(this.mRotation2FX);
        this.m = false;
        this.o = false;
        this.r = false;
    }

    public void setRotationDeg(int n) {
        this.mRotation2FX = (int)((long)n * 52707178L / 180L);
        while (this.mRotation2FX < 0) {
            this.mRotation2FX += 105414356;
        }
        while (this.mRotation2FX > 105414356) {
            this.mRotation2FX -= 105414356;
        }
        this.j.setRotationMatrix(this.mRotation2FX);
        this.m = false;
        this.o = false;
    }

    public void setPositionFX(FXVector fXVector) {
        this.mPositionFX = fXVector;
    }

    public void angularVelocity2FX(int n) {
        this.mAngularVelocity2FX = n;
    }

    public void applyAcceleration(FXVector fXVector) {
        if (this.a && !this.r) {
            this.mVelocityFX.add(fXVector, World.a);
        }
    }

    public void applyForce(FXVector fXVector) {
        if (this.a && !this.r) {
            this.mVelocityFX.xFX += (int)(this.mShape.g * (long)World.a >> (int)(12L * (long)fXVector.xFX) >> 24);
            this.mVelocityFX.yFX += (int)(this.mShape.g * (long)World.a >> (int)(12L * (long)fXVector.yFX) >> 24);
        }
    }

    public final void applyMomentumAt(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mAngularVelocity2FX -= (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            this.mVelocityFX.xFX += (int)(this.mShape.g * (long)fXVector.xFX >> 24);
            this.mVelocityFX.yFX += (int)(this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    final void a(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mAngularVelocity2FX += (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            this.mVelocityFX.xFX += (int)(-this.mShape.g * (long)fXVector.xFX >> 24);
            this.mVelocityFX.yFX += (int)(-this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyVirtualMomentumAt(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mVirtualAngularVelocity2FX -= (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            this.mVirtualVelocityFX.xFX += (int)(this.mShape.g * (long)fXVector.xFX >> 24);
            this.mVirtualVelocityFX.yFX += (int)(this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    final void b(FXVector fXVector, FXVector fXVector2) {
        if (this.a && !this.r) {
            if (this.k) {
                this.mVirtualAngularVelocity2FX += (int)(((long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12) * this.mShape.i >> 12);
            }
            this.mVirtualVelocityFX.xFX += (int)(-this.mShape.g * (long)fXVector.xFX >> 24);
            this.mVirtualVelocityFX.yFX += (int)(-this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyMomentum(FXVector fXVector) {
        if (this.a && !this.r) {
            this.mVelocityFX.xFX += (int)(this.mShape.g * (long)fXVector.xFX >> 24);
            this.mVelocityFX.yFX += (int)(this.mShape.g * (long)fXVector.yFX >> 24);
        }
    }

    public final void applyTorque(int n) {
        if (this.a && this.k && !this.r) {
            this.mAngularVelocity2FX -= (int)(this.mShape.i * (long)n >> 12);
        }
    }

    public final void integrateVelocity(int n) {
        if (!this.a || this.r) {
            return;
        }
        this.mPositionFX.add(this.mVelocityFX, n);
        this.setRotation2FX(this.mRotation2FX - (int)((long)this.mAngularVelocity2FX * (long)n >> 12));
    }

    public final void integrateVirtualVelocity(int n, FXVector fXVector) {
        if (!this.a || this.r) {
            return;
        }
        Body.s.xFX = this.mVirtualVelocityFX.xFX;
        Body.s.yFX = this.mVirtualVelocityFX.yFX;
        s.multFX(n);
        this.mPositionFX.xFX += Body.s.xFX;
        this.mPositionFX.yFX += Body.s.yFX;
        this.setRotation2FX(this.mRotation2FX - (int)((long)this.mVirtualAngularVelocity2FX * (long)n >> 12));
        this.mVirtualAngularVelocity2FX = 0;
        this.mVirtualVelocityFX.assignFX(0, 0);
    }

    protected final void calculateAABB(int n) {
        Object object = this.getVertices();
        this.e = this.f = object[0].xFX;
        this.g = this.h = object[0].yFX;
        if (this.mShape instanceof MultiShape) {
            object = (MultiShape)this.mShape;
            for (int i = 0; i < object.mShapes.length; ++i) {
                this.a(object.mShapes[i], object.mVertexStartIndices[i], n);
            }
            return;
        }
        this.a(this.mShape, 0, n);
    }

    private final void a(Shape shape, int n, int n2) {
        FXVector[] fXVectorArray = this.getVertices();
        if (shape.mVertices.length > 1) {
            int n3 = FXUtil.wrapAngleFX(this.mRotation2FX - (int)((long)this.mAngularVelocity2FX * (long)n2 >> 12));
            t.setRotationMatrix(n3);
            FXVector[] fXVectorArray2 = shape.mVertices;
            FXVector fXVector = s;
            s.xFX = this.mPositionFX.xFX;
            fXVector.yFX = this.mPositionFX.yFX;
            fXVector.add(this.mVelocityFX, n2);
            for (n2 = 0; n2 < shape.mVertices.length; ++n2) {
                t.mult(fXVectorArray2[n2], this.d[n + n2]);
                this.d[n + n2].xFX += fXVector.xFX;
                this.d[n + n2].yFX += fXVector.yFX;
                this.d[n + n2].subtract(fXVectorArray[n + n2]);
            }
            n2 = n + shape.mVertices.length;
            for (int i = n; i < n2; ++i) {
                if (this.e > fXVectorArray[i].xFX) {
                    this.e = fXVectorArray[i].xFX;
                }
                if (this.f < fXVectorArray[i].xFX) {
                    this.f = fXVectorArray[i].xFX;
                }
                if (this.g > fXVectorArray[i].yFX) {
                    this.g = fXVectorArray[i].yFX;
                }
                if (this.h < fXVectorArray[i].yFX) {
                    this.h = fXVectorArray[i].yFX;
                }
                if (this.e > fXVectorArray[i].xFX + this.d[i].xFX) {
                    this.e = fXVectorArray[i].xFX + this.d[i].xFX;
                }
                if (this.f < fXVectorArray[i].xFX + this.d[i].xFX) {
                    this.f = fXVectorArray[i].xFX + this.d[i].xFX;
                }
                if (this.g > fXVectorArray[i].yFX + this.d[i].yFX) {
                    this.g = fXVectorArray[i].yFX + this.d[i].yFX;
                }
                if (this.h >= fXVectorArray[i].yFX + this.d[i].yFX) continue;
                this.h = fXVectorArray[i].yFX + this.d[i].yFX;
            }
            return;
        }
        int n4 = (int)((long)this.mVelocityFX.xFX * (long)n2) >> 12;
        int n5 = (int)((long)this.mVelocityFX.yFX * (long)n2) >> 12;
        if (this.e > this.mPositionFX.xFX - shape.c) {
            this.e = this.mPositionFX.xFX - shape.c;
        }
        if (this.f < this.mPositionFX.xFX + shape.c) {
            this.f = this.mPositionFX.xFX + shape.c;
        }
        if (this.g > this.mPositionFX.yFX - shape.c) {
            this.g = this.mPositionFX.yFX - shape.c;
        }
        if (this.h < this.mPositionFX.yFX + shape.c) {
            this.h = this.mPositionFX.yFX + shape.c;
        }
        if (this.e > this.mPositionFX.xFX - shape.c + n4) {
            this.e = this.mPositionFX.xFX - shape.c + n4;
        }
        if (this.f < this.mPositionFX.xFX + shape.c + n4) {
            this.f = this.mPositionFX.xFX + shape.c + n4;
        }
        if (this.g > this.mPositionFX.yFX - shape.c + n5) {
            this.g = this.mPositionFX.yFX - shape.c + n5;
        }
        if (this.h < this.mPositionFX.yFX + shape.c + n5) {
            this.h = this.mPositionFX.yFX + shape.c + n5;
        }
        this.d[n].xFX = this.mVelocityFX.xFX;
        this.d[n].yFX = this.mVelocityFX.yFX;
        this.d[n].multFX(n2);
    }

    protected final void updateVelocity(int n, int n2) {
        if (n < 4096) {
            this.mVelocityFX.multFX(n);
        }
        if (n2 < 4096) {
            this.mAngularVelocity2FX = (int)((long)this.mAngularVelocity2FX * (long)n2) >> 12;
        }
    }

    protected void resetContacts() {
        for (int i = 0; i < this.p; ++i) {
            if (!this.q[i].g && World.g < World.h.length) {
                World.h[World.g++] = this.q[i];
                this.q[i].g = true;
            }
            this.q[i] = null;
        }
        this.p = 0;
    }

    protected void addContact(Contact contact) {
        if (this.p < 8) {
            this.q[this.p] = contact;
            ++this.p;
        }
    }

    public Contact[] getContacts() {
        return this.q;
    }

    protected Contact getContact(Body body) {
        for (int i = 0; i < this.q.length && this.q[i] != null; ++i) {
            if (this.q[i].c != body && this.q[i].a != body) continue;
            return this.q[i];
        }
        return null;
    }

    protected Contact getContact(int n, Body body, int n2) {
        for (int i = 0; i < this.q.length && this.q[i] != null; ++i) {
            if ((this.q[i].c != body || this.q[i].d != n2 || this.q[i].b != n) && (this.q[i].a != body || this.q[i].b != n2 || this.q[i].d != n)) continue;
            return this.q[i];
        }
        return null;
    }

    public void setDynamic(boolean bl) {
        this.a = bl;
    }

    public int getAABBMinXFX() {
        return this.e;
    }

    public int getAABBMaxXFX() {
        return this.f;
    }

    public int getAABBMinYFX() {
        return this.g;
    }

    public int getAABBMaxYFX() {
        return this.h;
    }

    public int getColissionBitFlag() {
        return this.i;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

