/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.UserData;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Random;

public class ParticleEmitter {
    private int b = 4096;
    private int c = 0;
    private int d = (int)((long)World.getTimestepFX() * (long)this.b) >> 12;
    private int e = (int)((long)World.getTimestepFX() * (long)this.c) >> 12;
    private int f = 0;
    private int g = 0;
    private int h = 0;
    protected int mMaxParticleCount = 0;
    private int i = 2048;
    private int j = 4096;
    private int k = 0;
    private Body l;
    private FXVector m;
    private FXVector n;
    private boolean o;
    private int p = 4096;
    private int q = 0;
    private int r = 0;
    private int s = 0;
    boolean a = true;
    protected int[] mXFX;
    protected int[] mYFX;
    protected int[] mXPrevFX;
    protected int[] mYPrevFX;
    protected short[] mLife;
    private Random t = new Random();
    private static FXMatrix u = new FXMatrix();
    private static FXVector v = new FXVector();
    private static FXVector w = new FXVector();
    protected UserData mUserData = null;

    private ParticleEmitter(int n) {
        this.setMaxParticleCount(n);
    }

    public ParticleEmitter(int n, int n2, int n3, int n4, int n5, Body body, FXVector fXVector, FXVector fXVector2, int n6, int n7, int n8, int n9, boolean bl, int n10, int n11, int n12) {
        this(n);
        this.b = n2;
        this.c = n3;
        this.d = (int)((long)World.getTimestepFX() * (long)n2) >> 12;
        this.e = (int)((long)World.getTimestepFX() * (long)n3) >> 12;
        this.g = n4;
        this.h = n5;
        this.l = body;
        this.m = fXVector;
        this.n = fXVector2;
        this.o = bl;
        this.p = n6;
        this.q = n7;
        this.r = n8;
        this.s = n9;
        this.i = n10;
        this.j = n11;
        this.k = n12;
    }

    public ParticleEmitter(ParticleEmitter particleEmitter) {
        this(particleEmitter.mMaxParticleCount);
        this.b = particleEmitter.b;
        this.d = particleEmitter.d;
        this.c = particleEmitter.c;
        this.e = particleEmitter.e;
        this.g = particleEmitter.g;
        this.h = particleEmitter.h;
        this.l = particleEmitter.l;
        this.m = particleEmitter.m;
        this.n = particleEmitter.n;
        this.o = particleEmitter.o;
        this.p = particleEmitter.p;
        this.q = particleEmitter.q;
        this.r = particleEmitter.r;
        this.s = particleEmitter.s;
        this.i = particleEmitter.i;
        this.j = particleEmitter.j;
        this.k = particleEmitter.k;
        if (particleEmitter.mUserData != null) {
            this.mUserData = particleEmitter.mUserData.copy();
        }
    }

    private ParticleEmitter() {
    }

    public ParticleEmitter copy(Body[] bodyArray) {
        ParticleEmitter particleEmitter = new ParticleEmitter(this);
        if (this.l != null) {
            particleEmitter.l = bodyArray == null ? this.l : bodyArray[this.l.mId];
        }
        return particleEmitter;
    }

    protected final void createParticle(int n) {
        long l = this.t.nextInt() & 0xFFF;
        if (this.l == null) {
            this.mXFX[n] = this.m.xFX + (int)(l * (long)(this.n.xFX - this.m.xFX) >> 12);
            this.mYFX[n] = this.m.yFX + (int)(l * (long)(this.n.yFX - this.m.yFX) >> 12);
        } else if (this.o) {
            this.mXFX[n] = this.l.mPositionFX.xFX + this.m.xFX + ((int)(l * (long)(this.n.xFX - this.m.xFX)) >> 12);
            this.mYFX[n] = this.l.mPositionFX.yFX + this.m.yFX + ((int)(l * (long)(this.n.yFX - this.m.yFX)) >> 12);
        } else {
            v.assignFX(this.m.xFX + (int)(l * (long)(this.n.xFX - this.m.xFX) >> 12), this.m.yFX + (int)(l * (long)(this.n.yFX - this.m.yFX) >> 12));
            this.l.getRotationMatrix().mult(v, w);
            this.mXFX[n] = ParticleEmitter.w.xFX + this.l.mPositionFX.xFX;
            this.mYFX[n] = ParticleEmitter.w.yFX + this.l.mPositionFX.yFX;
        }
        int n2 = (this.t.nextInt() & 0xFFF) - 2048;
        n2 = this.r + (int)((long)this.s * (long)n2 >> 12);
        if (!this.o && this.l != null) {
            n2 += this.l.mRotation2FX;
        }
        n2 = FXUtil.wrapAngleFX(n2);
        u.setRotationMatrix(n2);
        long l2 = (this.t.nextInt() & 0xFFF) - 2048;
        u.mult(this.p + (int)((long)this.q * l2 >> 12), 0, v);
        FXVector fXVector = v;
        if (this.l != null) {
            fXVector.xFX += this.l.mVelocityFX.xFX;
            fXVector.yFX += this.l.mVelocityFX.yFX;
        }
        fXVector.multFX(World.a);
        this.mXPrevFX[n] = this.mXFX[n] - fXVector.xFX;
        this.mYPrevFX[n] = this.mYFX[n] - fXVector.yFX;
    }

    protected void createParticles() {
        int n = this.a(0);
        while (this.f < this.d && n != -1) {
            int n2 = this.g + ((int)((long)((this.t.nextInt() & 0xFFF) - 2048) * (long)this.h) >> 12);
            this.mLife[n] = (short)((int)((long)n2 * (long)((int)World.b)) >> 12 >> 12);
            this.createParticle(n);
            this.f += 4096;
            n = this.a(n);
        }
        n = (this.t.nextInt() & 0xFFF) - 2048;
        this.f = Math.max(0, this.f - this.d - (int)((long)n * (long)this.e) >> 12);
    }

    private final int a(int n) {
        while (n < this.mMaxParticleCount) {
            if (this.mLife[n] <= 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void integrateParticles() {
        int n;
        int n2;
        int n3;
        this.createParticles();
        int n4 = 4096 - this.k;
        for (n3 = 0; n3 < this.mMaxParticleCount; ++n3) {
            if (this.mLife[n3] <= 0) continue;
            n2 = this.mXFX[n3];
            n = this.mYFX[n3];
            if (n4 != 4096) {
                int n5 = n3;
                this.mXFX[n5] = this.mXFX[n5] + ((int)((long)n4 * (long)(this.mXFX[n3] - this.mXPrevFX[n3])) >> 12);
                int n6 = n3;
                this.mYFX[n6] = this.mYFX[n6] + ((int)((long)n4 * (long)(this.mYFX[n3] - this.mYPrevFX[n3])) >> 12);
            } else {
                int n7 = n3;
                this.mXFX[n7] = this.mXFX[n7] + (this.mXFX[n3] - this.mXPrevFX[n3]);
                int n8 = n3;
                this.mYFX[n8] = this.mYFX[n8] + (this.mYFX[n3] - this.mYPrevFX[n3]);
            }
            this.mXPrevFX[n3] = n2;
            this.mYPrevFX[n3] = n;
            int n9 = n3;
            this.mLife[n9] = (short)(this.mLife[n9] - 1);
        }
        ParticleEmitter particleEmitter = this;
        n2 = 0;
        n = 0;
        n3 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        for (int i = 1; i < particleEmitter.mMaxParticleCount; ++i) {
            if (particleEmitter.mLife[i] <= 0) continue;
            n2 = particleEmitter.mXFX[i];
            n = particleEmitter.mYFX[i];
            n3 = particleEmitter.mLife[i];
            n10 = particleEmitter.mXPrevFX[i];
            n11 = particleEmitter.mYPrevFX[i];
            for (n12 = i - 1; n12 >= 0 && (particleEmitter.mXFX[n12] > n2 || particleEmitter.mLife[n12] <= 0); --n12) {
                particleEmitter.mXFX[n12 + 1] = particleEmitter.mXFX[n12];
                particleEmitter.mYFX[n12 + 1] = particleEmitter.mYFX[n12];
                particleEmitter.mLife[n12 + 1] = particleEmitter.mLife[n12];
                particleEmitter.mXPrevFX[n12 + 1] = particleEmitter.mXPrevFX[n12];
                particleEmitter.mYPrevFX[n12 + 1] = particleEmitter.mYPrevFX[n12];
            }
            particleEmitter.mXFX[n12 + 1] = n2;
            particleEmitter.mYFX[n12 + 1] = n;
            particleEmitter.mLife[n12 + 1] = n3;
            particleEmitter.mXPrevFX[n12 + 1] = n10;
            particleEmitter.mYPrevFX[n12 + 1] = n11;
        }
    }

    public void applyAcceleration(FXVector fXVector, int n) {
        n = (int)((long)n * (long)n * (long)this.j >> 24);
        for (int i = 0; i < this.mMaxParticleCount; ++i) {
            if (this.mLife[i] <= 0) continue;
            int n2 = i;
            this.mXFX[n2] = this.mXFX[n2] + ((int)((long)n * (long)fXVector.xFX) >> 12);
            int n3 = i;
            this.mYFX[n3] = this.mYFX[n3] + ((int)((long)n * (long)fXVector.yFX) >> 12);
        }
    }

    protected void collide(FXVector fXVector, int n) {
        int n2 = n;
        this.mXFX[n2] = this.mXFX[n2] - fXVector.xFX;
        int n3 = n;
        this.mYFX[n3] = this.mYFX[n3] - fXVector.yFX;
        int n4 = n;
        this.mXPrevFX[n4] = this.mXPrevFX[n4] - fXVector.xFX;
        int n5 = n;
        this.mYPrevFX[n5] = this.mYPrevFX[n5] - fXVector.yFX;
        fXVector.normalizeFast();
        w.assignFX(this.mXFX[n] - this.mXPrevFX[n], this.mYFX[n] - this.mYPrevFX[n]);
        v.assign(fXVector);
        v.multFX((long)ParticleEmitter.w.xFX * (long)fXVector.xFX + (long)ParticleEmitter.w.yFX * (long)fXVector.yFX >> 12);
        int n6 = n;
        this.mXPrevFX[n6] = this.mXPrevFX[n6] + ParticleEmitter.v.xFX;
        int n7 = n;
        this.mYPrevFX[n7] = this.mYPrevFX[n7] + ParticleEmitter.v.yFX;
        v.multFX(this.i);
        int n8 = n;
        this.mXFX[n8] = this.mXFX[n8] - ParticleEmitter.v.xFX;
        int n9 = n;
        this.mYFX[n9] = this.mYFX[n9] - ParticleEmitter.v.yFX;
    }

    public int getCreationRateFX() {
        return this.b;
    }

    public int getCreationRateDeviationFX() {
        return this.c;
    }

    public int getAvgLifeTimeFX() {
        return this.g;
    }

    public int getAvgLifeTimeDeviationFX() {
        return this.h;
    }

    public int getMaxParticleCount() {
        return this.mMaxParticleCount;
    }

    public int getElasticityFX() {
        return this.i;
    }

    public int getGravityEffectFX() {
        return this.j;
    }

    public Body getEmitter() {
        return this.l;
    }

    public FXVector getRelEmitterPos1() {
        return this.m;
    }

    public FXVector getRelEmitterPos2() {
        return this.n;
    }

    public boolean emitAxesFixed() {
        return this.o;
    }

    public int getEmitSpeedFX() {
        return this.p;
    }

    public int getEmitSpeedDeviationFX() {
        return this.q;
    }

    public int getEmitAngle2FX() {
        return this.r;
    }

    public int getEmitAngleDeviation2FX() {
        return this.s;
    }

    public int getDampingFX() {
        return this.k;
    }

    public boolean canCollide() {
        return this.a;
    }

    public void setCreationRateFX(int n, int n2) {
        this.b = n;
        this.d = (int)((long)World.getTimestepFX() * (long)n) >> 12;
        this.c = n2;
        this.e = (int)((long)World.getTimestepFX() * (long)n2) >> 12;
    }

    public void setAvgLifeTime(int n, int n2) {
        this.g = n;
        this.h = n2;
    }

    public void setElasticityFX(int n) {
        this.i = n;
    }

    public void setGravityEffectFX(int n) {
        this.j = n;
    }

    public void setEmitter(Body body) {
        this.l = body;
    }

    public void setRelEmitterPos1(FXVector fXVector) {
        this.m = fXVector;
    }

    public void setRelEmitterPos2(FXVector fXVector) {
        this.n = fXVector;
    }

    public void setEmitAxesFixed(boolean bl) {
        this.o = bl;
    }

    public void setEmitSpeedFX(int n, int n2) {
        this.p = n;
        this.q = n2;
    }

    public void setEmitAngle2FX(int n, int n2) {
        this.r = n;
        this.s = n2;
    }

    public void setMaxParticleCount(int n) {
        if (this.mMaxParticleCount != n) {
            this.mMaxParticleCount = n;
            this.mXFX = new int[n];
            this.mYFX = new int[n];
            this.mXPrevFX = new int[n];
            this.mYPrevFX = new int[n];
            this.mLife = new short[n];
        }
    }

    public void setDampingFX(int n) {
        this.k = n;
    }

    public void setCanCollide(boolean bl) {
        this.a = bl;
    }

    public int[] getXPosFX() {
        return this.mXFX;
    }

    public int[] getYPosFX() {
        return this.mYFX;
    }

    public int[] getXPrevPosFX() {
        return this.mXPrevFX;
    }

    public int[] getYPrevPosFX() {
        return this.mYPrevFX;
    }

    public short[] getLifeTimes() {
        return this.mLife;
    }

    public static ParticleEmitter loadParticleEmitter(PhysicsFileReader object, World world, UserData userData) {
        ParticleEmitter particleEmitter = new ParticleEmitter();
        new ParticleEmitter().l = world.findBodyById(((PhysicsFileReader)object).next());
        particleEmitter.o = ((PhysicsFileReader)object).next() != 0;
        particleEmitter.m = ((PhysicsFileReader)object).nextVector();
        particleEmitter.n = ((PhysicsFileReader)object).nextVector();
        particleEmitter.setEmitAngle2FX(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setEmitSpeedFX(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setCreationRateFX(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setAvgLifeTime(((PhysicsFileReader)object).nextIntFX(), ((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setMaxParticleCount(((PhysicsFileReader)object).nextInt());
        particleEmitter.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setGravityEffectFX(((PhysicsFileReader)object).nextIntFX());
        particleEmitter.setDampingFX(((PhysicsFileReader)object).nextIntFX());
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                particleEmitter.mUserData = userData.createNewUserData((String)object, 5);
            }
        }
        return particleEmitter;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

