/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Script$ScriptElement;
import at.emini.physics2D.World;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Script {
    public static final int NONE = 0;
    public static final int POSITION = 1;
    public static final int VELOCITY = 2;
    public static final int ACCELERATION = 3;
    public static final int ANGLE = 4;
    public static final int ROTATIONAL_VELOCITY = 5;
    public static final int ROTATIONAL_ACCELERATION = 6;
    protected Vector mElements = new Vector();
    protected boolean mRestart = false;

    public Script(boolean bl) {
        this.mRestart = bl;
    }

    public Script(Script script) {
        this.mRestart = script.mRestart;
        for (int i = 0; i < script.mElements.size(); ++i) {
            this.addElement((Script$ScriptElement)script.mElements.elementAt(i));
        }
    }

    public Script copy() {
        Script script = new Script(this);
        return script;
    }

    public void applyToBody(Body body, World world) {
        world.m[world.q] = body;
        for (int i = 0; i < world.l; ++i) {
            if (world.k[i] != this) continue;
            world.n[world.q] = i;
            break;
        }
        world.o[world.q] = 0;
        world.p[world.q] = 0;
        ++world.q;
    }

    public void addElement(int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.mElements.addElement(new Script$ScriptElement(this, n, n2 << 12, n3 << 12, n4));
                return;
            }
            case 4: 
            case 5: 
            case 6: {
                this.mElements.addElement(new Script$ScriptElement(this, n, (n2 << 1) * 52707178 / 360, 0, n4));
            }
        }
    }

    public void addElement(int n, int n2, int n3) {
        this.addElement(n, n2, 0, n3);
    }

    public void addElement(Script$ScriptElement script$ScriptElement) {
        this.mElements.addElement(new Script$ScriptElement(this, script$ScriptElement));
    }

    protected void executeScript(int n, World world) {
        Script$ScriptElement script$ScriptElement;
        if (world.o[n] < this.mElements.size()) {
            script$ScriptElement = (Script$ScriptElement)this.mElements.elementAt(world.o[n]);
            if (script$ScriptElement.mTimeSteps > 0) {
                int n2 = n;
                world.p[n2] = world.p[n2] + 1;
                if (world.p[n] > script$ScriptElement.mTimeSteps) {
                    int n3 = n;
                    world.o[n3] = world.o[n3] + 1;
                    world.p[n] = 0;
                }
            }
        } else if (this.mRestart) {
            world.o[n] = 0;
        } else {
            world.m[n] = null;
            return;
        }
        if (world.o[n] < this.mElements.size()) {
            script$ScriptElement = (Script$ScriptElement)this.mElements.elementAt(world.o[n]);
            Body body = world.m[n];
            switch (script$ScriptElement.mType) {
                case 1: {
                    body.mPositionFX.xFX = script$ScriptElement.mTargetAFX;
                    body.mPositionFX.yFX = script$ScriptElement.mTargetBFX;
                    return;
                }
                case 2: {
                    body.mVelocityFX.assignFX(script$ScriptElement.mTargetAFX, script$ScriptElement.mTargetBFX);
                    return;
                }
                case 3: {
                    body.mVelocityFX.addFX(script$ScriptElement.mTargetAFX, script$ScriptElement.mTargetBFX, World.a);
                    return;
                }
                case 4: {
                    body.setRotation2FX(script$ScriptElement.mTargetAFX);
                    return;
                }
                case 5: {
                    body.mAngularVelocity2FX = script$ScriptElement.mTargetAFX;
                    return;
                }
                case 6: {
                    body.mAngularVelocity2FX += (int)((long)script$ScriptElement.mTargetAFX * (long)World.a >> 12);
                }
            }
        }
    }

    public static Script loadScript(PhysicsFileReader physicsFileReader) {
        boolean bl = physicsFileReader.next() > 0;
        Script script = new Script(bl);
        int n = physicsFileReader.next();
        for (int i = 0; i < n; ++i) {
            Script script2 = script;
            script2.getClass();
            Script$ScriptElement script$ScriptElement = new Script$ScriptElement(script2, physicsFileReader.next(), physicsFileReader.nextIntFX(), physicsFileReader.nextIntFX(), physicsFileReader.next());
            script.mElements.addElement(script$ScriptElement);
        }
        return script;
    }
}

