/*
 * Decompiled with CFR 0.152.
 */
package com.thinkink.Game;

import com.thinkink.Apps.TwistMidlet;
import com.thinkink.Game.LevelCanvas;
import com.thinkink.Game.LineManager;
import com.thinkink.Game.MainCanvas;
import com.thinkink.app.GeneralFunction;
import com.thinkink.app.GeneralInfo;
import com.thinkink.utility.Button;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ScoreCanvas
extends Canvas
implements Button.ButtonCallback,
TwistMidlet.Callback {
    private int bestScore;
    private final int score;
    private RecordStore recordStore;
    private final Button tryAgain;
    private final Button home;
    private final Image bg;
    Font f = Font.getFont((int)0, (int)1, (int)0);
    Font sf = Font.getFont((int)0, (int)0, (int)8);

    public ScoreCanvas(int score) {
        this.setFullScreenMode(true);
        this.score = LineManager.score;
        this.openRecordStore();
        this.setRecord();
        this.bg = GeneralFunction.createImage("scorecanvas/gameover.png");
        this.tryAgain = new Button(GeneralFunction.createImage("scorecanvas/try.png"), GeneralFunction.createImage("scorecanvas/try_press.png"), 12, 330, 0, this);
        if (!GeneralInfo.IS_ASHA) {
            this.home = new Button(GeneralFunction.createImage("scorecanvas/home.png"), GeneralFunction.createImage("scorecanvas/home_press.png"), 132, 330, 1, this);
        } else {
            this.home = null;
            this.addCommand(new Command("back", 2, 0));
            this.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    ScoreCanvas.this.buttonClicked(1);
                }
            });
        }
    }

    protected void showNotify() {
        TwistMidlet.mMidlet.registerForUP(this);
        TwistMidlet.mMidlet.registerForDown(this);
    }

    private void openRecordStore() {
        try {
            this.recordStore = RecordStore.openRecordStore((String)"Line", (boolean)true);
            String str = String.valueOf(this.bestScore);
            byte[] b = str.getBytes();
            if (this.recordStore.getNumRecords() <= 0) {
                this.recordStore.addRecord(b, 0, b.length);
                this.recordStore.addRecord(b, 0, b.length);
                this.recordStore.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void setRecord() {
        this.getRecord();
        if (this.score > this.bestScore) {
            this.bestScore = this.score;
            System.out.println("bestScore  " + this.bestScore);
            String str = String.valueOf(this.score);
            byte[] b = str.getBytes();
            try {
                this.recordStore.setRecord(LevelCanvas.currentMode + 1, b, 0, b.length);
            }
            catch (InvalidRecordIDException ex) {
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    private void getRecord() {
        try {
            byte[] b = this.recordStore.getRecord(LevelCanvas.currentMode + 1);
            String str = new String(b);
            this.bestScore = Integer.parseInt(str);
        }
        catch (InvalidRecordIDException ex) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        this.tryAgain.paint(g);
        if (!GeneralInfo.ASHA_501) {
            this.home.paint(g);
        }
        g.setFont(this.f);
        g.setColor(0xFFFFFF);
        g.drawString("" + LineManager.score, 120 - this.sf.stringWidth("" + LineManager.score) / 2, 218, 0);
        g.drawString("" + this.bestScore, 120 - this.sf.stringWidth("" + this.bestScore) / 2, 285, 0);
        TwistMidlet.mMidlet.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        this.tryAgain.pointerPressed(x, y);
        if (!GeneralInfo.ASHA_501) {
            this.home.pointerPressed(x, y);
        }
        TwistMidlet.mMidlet.adClicked(x, y);
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new MainCanvas(LevelCanvas.currentMode));
                break;
            }
            case 1: {
                TwistMidlet.mMidlet.startMainMenu();
            }
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }
}

