/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.utility;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class PlayAudioSound
implements PlayerListener {
    public static final String Format_Type_MP3 = "audio/mpeg";
    private int mAudio_File_Id;
    private final CallBack mCallBack;
    private Player mPlayer = null;

    public PlayAudioSound(CallBack callback) {
        this.mCallBack = callback;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia") && this.mCallBack != null) {
            this.mCallBack.FileEndReachOfMedia(this.mAudio_File_Id);
        }
    }

    public void PlaySample(String filename, boolean aIsLoopingOn, int PlayerNumber, String fileformat) {
        this.stopAll();
        this.mAudio_File_Id = PlayerNumber;
        InputStream stream = this.getClass().getResourceAsStream("/" + filename);
        try {
            this.mPlayer = Manager.createPlayer((InputStream)stream, (String)Format_Type_MP3);
            if (aIsLoopingOn) {
                this.mPlayer.setLoopCount(100);
            }
            this.mPlayer.realize();
            this.mPlayer.addPlayerListener((PlayerListener)this);
            this.mPlayer.start();
        }
        catch (Exception ex) {
            System.out.println("e  " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static synchronized void stop(Player player) {
        if (player.getState() == 400) {
            try {
                player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        player.deallocate();
        player.close();
        player = null;
    }

    public void stopAll() {
        if (this.mPlayer != null) {
            PlayAudioSound.stop(this.mPlayer);
            this.mPlayer = null;
        }
    }

    public static interface CallBack {
        public void FileEndReachOfMedia(int var1);
    }
}

