/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.gen;

import buzzcity.Buzzcity;
import com.twistfuture.app.App;
import com.twistfuture.gen.AboutORHelp;
import com.twistfuture.gen.PrivacyPolicyForm;
import com.twistfuture.main.TwistMidlet;
import com.twistfuture.utill.Button;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu
extends Canvas
implements Button.callBack,
Buzzcity.Callback {
    private Image mBg;
    private final String[] mButtonName = new String[]{"play", "about", "help", "moreapps", "privacy", "exit"};
    private final Button[] mButton = new Button[this.mButtonName.length];
    private final int mMargin;
    private AboutORHelp mAboutORHelp;
    public static boolean IsSound;

    public MainMenu() {
        this.mMargin = 15;
        this.setFullScreenMode(true);
    }

    protected void showNotify() {
        super.showNotify();
        this.mBg = App.createImage("menu/bg.png");
        for (int i = 0; i < this.mButton.length; ++i) {
            this.mButton[i] = new Button("menu/" + this.mButtonName[i] + ".png", "menu/press.png", 10, 10, i, this);
        }
        this.mButton[0].SetCordinate(99, 80);
        this.mButton[1].SetCordinate(50, 180);
        this.mButton[2].SetCordinate(149, 180);
        this.mButton[3].SetCordinate(33, 230);
        this.mButton[4].SetCordinate(99, 230);
        this.mButton[5].SetCordinate(170, 230);
        if (TwistMidlet.IsAsha) {
            Command mBack = new Command("Back", 2, 0);
            this.addCommand(mBack);
            this.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    if (c.getLabel() == "Back") {
                        MainMenu.this.buttonClicked(5);
                    }
                }
            });
        }
        TwistMidlet.buzzcity.registerForUP(this);
        TwistMidlet.buzzcity.registerForDown(this);
    }

    protected void hideNotify() {
        for (int i = 0; i < this.mButtonName.length; ++i) {
            this.mButton[i] = null;
        }
    }

    protected void paint(Graphics g) {
        g.drawImage(this.mBg, 0, 0, 0);
        for (int i = 0; i < this.mButtonName.length; ++i) {
            this.mButton[i].paint(g);
        }
        TwistMidlet.buzzcity.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        for (int i = 0; i < this.mButtonName.length; ++i) {
            this.mButton[i].pointerPressed(x, y);
        }
        TwistMidlet.buzzcity.adClicked(x, y);
    }

    public void buttonClicked(int buttonId) {
        switch (buttonId) {
            case 0: {
                TwistMidlet.mMidlet.callTwistCanvas();
                break;
            }
            case 1: {
                this.mAboutORHelp = new AboutORHelp(AboutORHelp.ABOUT);
                TwistMidlet.mMidlet.getDisplay().setCurrent((Displayable)this.mAboutORHelp);
                break;
            }
            case 2: {
                this.mAboutORHelp = new AboutORHelp(AboutORHelp.HELP);
                TwistMidlet.mMidlet.getDisplay().setCurrent((Displayable)this.mAboutORHelp);
                break;
            }
            case 3: {
                try {
                    TwistMidlet.mMidlet.platformRequest("http://store.ovi.com/publisher/Twistfuture/");
                }
                catch (ConnectionNotFoundException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 4: {
                new PrivacyPolicyForm().displayPrivacyPolicyForm();
                break;
            }
            case 5: {
                TwistMidlet.mMidlet.exitMidlet();
            }
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint(xcordi, ycordi, width, height);
    }
}

