/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import com.twistfuture.app.App;
import com.twistfuture.main.BoxContainer;
import com.twistfuture.main.Fall;
import com.twistfuture.main.Glass;
import com.twistfuture.main.GlassBall;
import com.twistfuture.main.TwistCanvas;
import com.twistfuture.utill.DataStore;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GlassContainer {
    public final Vector vector_Glass = new Vector();
    private final BoxContainer boxContainer;
    static int GLASS_SPEED = 2;
    private int mLevel = 0;
    private int mScore;
    public boolean checkGlass;
    private String RMS_SCORE = "score";
    private String RMS_LEVEL = "level";
    private String mBestScore;
    private String mBestLevel = "0";

    public GlassContainer(BoxContainer boxContainer) {
        this.boxContainer = boxContainer;
        this.mBestScore = DataStore.readData(this.RMS_SCORE, "0");
        this.mBestLevel = DataStore.readData(this.RMS_LEVEL, "0");
    }

    public void moveGlass() {
        for (int i = 0; i < this.vector_Glass.size(); ++i) {
            Glass glass = (Glass)this.vector_Glass.elementAt(i);
            glass.move_GlassBall();
            if (glass.getY() <= 5 && glass.getX() < 190) {
                glass.setX(glass.getX() + GLASS_SPEED);
                glass.setRotateValue(glass.getRotateValue() + GLASS_SPEED * 2);
                if (glass.getRotateValue() >= 360) continue;
                for (int j = 0; j < glass.ballVector.size(); ++j) {
                    GlassBall glassBall = (GlassBall)glass.ballVector.elementAt(j);
                    if (!this.boxContainer.checkCollisionWithGlassBall(glassBall)) continue;
                    glass.ballVector.removeElement(glassBall);
                }
                if (glass.getRotateValue() > 130 && glass.getRotateValue() < 190) {
                    glass.setImage(App.createImage("glass/" + glass.getColor() + "1" + ".png"));
                }
                if (glass.getRotateValue() < 210) continue;
                glass.setImage(App.createImage("glass/" + glass.getColor() + ".png"));
                continue;
            }
            if (glass.getX() >= 190 && glass.getY() < 320 - glass.getHeight()) {
                glass.setY(glass.getY() + GLASS_SPEED);
                glass.setRotateValue(0);
                glass.setRound(glass.getRound() + 1);
                this.setLevel();
                glass.setStatus(false);
                continue;
            }
            if (glass.getY() >= 320 - glass.getHeight() && glass.getX() >= -10) {
                glass.setX(glass.getX() - GLASS_SPEED);
                glass.setStatus(true);
                continue;
            }
            if (glass.getX() >= 0 || glass.getY() <= 0) continue;
            glass.setY(glass.getY() - GLASS_SPEED);
            if (glass.getNoOfBalls() != 0) continue;
            this.vector_Glass.removeElement(glass);
        }
    }

    private void setScore(String ballcolor) {
        this.mScore = ballcolor.equalsIgnoreCase("red") || ballcolor.equalsIgnoreCase("green") ? (this.mScore += 2) : ++this.mScore;
    }

    private void setLevel() {
        Glass glass = (Glass)this.vector_Glass.lastElement();
        if (glass.getRound() >= 1 && glass.getStatus()) {
            glass.setRound(0);
            if (this.mLevel++ % 5 == 0 && GLASS_SPEED < 7) {
                ++GLASS_SPEED;
            }
        }
    }

    public void setScoreAndLevel() {
        int level = Integer.parseInt(this.mBestLevel);
        int score = Integer.parseInt(this.mBestScore);
        if (this.mLevel > level) {
            DataStore.writeData(this.RMS_LEVEL, String.valueOf(this.mLevel));
        }
        if (this.mScore > score) {
            DataStore.writeData(this.RMS_SCORE, String.valueOf(this.mScore));
        }
    }

    public boolean checkCollisionWithBoxBall(Fall fall) {
        for (int i = 0; i < this.vector_Glass.size(); ++i) {
            Glass glass = (Glass)this.vector_Glass.elementAt(i);
            if (fall.getX() <= glass.getX() + 10 || fall.getY() <= glass.getY() || fall.getX() >= glass.getX() + glass.getWidth() - 10 || fall.getY() >= glass.getY() + 20) continue;
            if (!fall.getisCollideWithGlass()) {
                GlassBall glassBall = new GlassBall(fall.getImage(), fall.getColor(), glass.getX(), glass.getY(), glass.getId());
                fall.setCollideWithGlassStatus(true);
                glass.addBallinGlass(glassBall);
                this.setScore(glassBall.getColor());
                if (glass.getColor().equalsIgnoreCase("red")) {
                    glassBall.setImage(TwistCanvas.ball_Red);
                    glassBall.setColor("red");
                } else if (glass.getColor().equalsIgnoreCase("green")) {
                    glassBall.setImage(TwistCanvas.ball_Green);
                    glassBall.setColor("green");
                }
            }
            return true;
        }
        return false;
    }

    public void addElement(Glass glass) {
        this.vector_Glass.addElement(glass);
        this.checkGlass = true;
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        for (int i = 0; i < this.vector_Glass.size(); ++i) {
            Glass glass = (Glass)this.vector_Glass.elementAt(i);
            glass.paint(g);
        }
        g.setFont(App.medium);
        g.setColor(65280);
        g.drawString("Score", 30, 192, 0);
        g.drawString("Best", 165, 192, 0);
        g.setColor(0xFFFFFF);
        g.drawString("" + this.mScore, 43, 208, 0);
        g.drawString("" + this.mBestScore, 172, 208, 0);
        g.setFont(App.small);
        g.setColor(131071);
        g.drawString("Level: " + this.mLevel, 30, 224, 0);
        g.drawString("Level: " + this.mBestLevel, 160, 224, 0);
    }
}

