/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import buzzcity.Buzzcity;
import com.twistfuture.app.App;
import com.twistfuture.main.Ball;
import com.twistfuture.main.BallContainer;
import com.twistfuture.main.BoxContainer;
import com.twistfuture.main.TwistMidlet;
import com.twistfuture.utill.Button;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;

public class TwistCanvas
extends GameCanvas
implements Runnable,
Button.callBack,
Buzzcity.Callback {
    private Image img_bg = null;
    private Image img_outline = null;
    static Sprite sprite_Angle_Left = null;
    static Sprite sprite_Angle_Right = null;
    static Sprite sprite_CloseLine = null;
    private Image img_OpenLine = null;
    private Image img_CloseLine = null;
    private Image img_GameOver = null;
    public static Image ball_Red = null;
    public static Image ball_Green = null;
    public static Image ball_Yellow = null;
    private final int[] row = new int[]{4, 5, 4};
    private final int[] col = new int[]{7, 9, 7};
    private final int[] temp = new int[]{0, 2, 1};
    private int countId;
    private Thread thread;
    private Ball ball;
    public BallContainer ballContainer = null;
    private BoxContainer boxContainer = null;
    private Button button_Back = null;
    private Button button_Restart = null;

    public TwistCanvas() {
        super(true);
        this.setFullScreenMode(true);
        this.img_bg = App.createImage("main/bg.png");
        this.img_outline = App.createImage("main/outline.png");
        this.img_OpenLine = App.createImage("main/line_open.png");
        this.img_CloseLine = App.createImage("main/line_close.png");
        this.img_GameOver = App.createImage("gameover.png");
        sprite_Angle_Left = new Sprite(App.createImage("main/left.png"));
        sprite_Angle_Left.setPosition(22, 60);
        sprite_Angle_Right = new Sprite(App.createImage("main/right.png"));
        sprite_Angle_Right.setPosition(130, 60);
        sprite_CloseLine = new Sprite(this.img_CloseLine);
        sprite_CloseLine.setPosition(100, 200);
        ball_Green = App.createImage("main/green.png");
        ball_Red = App.createImage("main/red.png");
        ball_Yellow = App.createImage("main/yellow.png");
        this.boxContainer = new BoxContainer();
        this.ballContainer = new BallContainer(this.boxContainer);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.col[this.temp[i]]; ++j) {
                for (int k = 0; k < this.row[this.temp[i]]; ++k) {
                    int x = 30 + 68 * this.temp[i] + ball_Red.getWidth() * k;
                    int y = 68 + ball_Red.getWidth() * j;
                    if (this.temp[i] == 1) {
                        x = 30 + 68 * this.temp[i] + ball_Red.getWidth() * k - 5;
                    }
                    this.ball = new Ball(ball_Yellow, x, y, this.countId);
                    this.ballContainer.addElement(this.ball);
                    ++this.countId;
                }
            }
        }
        this.button_Back = new Button("button/back.png", "button/backp.png", this.getWidth() - 40, this.getHeight() - 40, 0, this);
        this.button_Restart = new Button("button/restart.png", "menu/press.png", (this.getWidth() - 45) / 2, 240, 1, this);
        if (TwistMidlet.IsAsha) {
            Command mBack = new Command("Back", 2, 0);
            this.addCommand(mBack);
            this.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    if (c.getLabel() == "Back") {
                        TwistMidlet.mMidlet.callMainMenu();
                    }
                }
            });
        }
        App.THREAD_STATUS = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void showNotify() {
        TwistMidlet.buzzcity.registerForUP(this);
        TwistMidlet.buzzcity.unregisterDown();
    }

    public void paint(Graphics g) {
        g.drawImage(this.img_bg, 0, 0, 0);
        g.drawImage(this.img_outline, (this.getWidth() - this.img_outline.getWidth()) / 2, (this.getHeight() - this.img_outline.getHeight()) / 2, 0);
        sprite_Angle_Left.paint(g);
        sprite_Angle_Right.paint(g);
        sprite_CloseLine.paint(g);
        this.ballContainer.paint(g);
        this.boxContainer.paint(g);
        this.button_Back.paint(g);
        if (this.boxContainer.isGameOver) {
            g.drawImage(this.img_GameOver, (240 - this.img_GameOver.getWidth()) / 2, 38, 0);
            this.button_Restart.paint(g);
        }
        TwistMidlet.buzzcity.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        this.boxContainer.pointerPressed(x, y);
        sprite_CloseLine.setImage(this.img_OpenLine, this.img_OpenLine.getWidth(), this.img_OpenLine.getHeight());
        sprite_CloseLine.setPosition(98, 200);
        this.button_Back.pointerPressed(x, y);
        if (this.boxContainer.isGameOver) {
            this.button_Restart.pointerPressed(x, y);
        }
        TwistMidlet.buzzcity.adClicked(x, y);
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        sprite_CloseLine.setImage(this.img_CloseLine, this.img_CloseLine.getWidth(), this.img_CloseLine.getHeight());
        sprite_CloseLine.setPosition(100, 200);
    }

    private void stopGame() {
        App.THREAD_STATUS = false;
        if (this.thread != null) {
            this.thread = null;
        }
    }

    public void run() {
        while (App.THREAD_STATUS) {
            if (this.boxContainer.isGameOver) {
                App.THREAD_STATUS = true;
            } else {
                this.ballContainer.update();
                this.boxContainer.update();
                App.sleepThread(App.SLEEP_TIME);
            }
            this.repaint();
        }
    }

    public void buttonClicked(int buttonId) {
        this.stopGame();
        switch (buttonId) {
            case 0: {
                TwistMidlet.mMidlet.callMainMenu();
                break;
            }
            case 1: {
                TwistMidlet.mMidlet.callTwistCanvas();
            }
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint(xcordi, ycordi, width, height);
    }
}

